/*
 * Decompiled with CFR 0.152.
 */
package settings;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import math.ChromosomeData;
import math.ExperimentResults;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import settings.ExperimentSettings;

public class ExperimentSettingsReader {
    public ExperimentSettings readExperimentSettings(String settingsFileName) throws ParserConfigurationException, SAXException, IOException {
        Node experiment;
        ExperimentSettings expSettings = new ExperimentSettings();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        File f = new File(settingsFileName);
        FileInputStream in = new FileInputStream(f);
        Document doc = builder.parse(in);
        Element root = doc.getDocumentElement();
        NodeList children = root.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            experiment = children.item(i);
            if (experiment instanceof Element) {
                expSettings.setName(((Element)experiment).getAttribute("name"));
                expSettings.setPath(((Element)experiment).getAttribute("path"));
                children = experiment.getChildNodes();
                break;
            }
            ++i;
        }
        i = 0;
        while (i < children.getLength()) {
            experiment = children.item(i);
            if (experiment instanceof Element) {
                Element result;
                int j;
                String tag = ((Element)experiment).getTagName();
                String content = ((Element)experiment).getTextContent();
                if (tag.equals("resultList")) {
                    NodeList results = experiment.getChildNodes();
                    j = 0;
                    while (j < results.getLength()) {
                        if (results.item(j) instanceof Element) {
                            result = (Element)results.item(j);
                            ExperimentResults expResults = new ExperimentResults(result.getAttribute("name"), Integer.parseInt(result.getAttribute("locus_length")), Integer.parseInt(result.getAttribute("locus_offset")), result.getAttribute("filename"));
                            NodeList chromosomes = result.getChildNodes();
                            int k = 0;
                            while (k < chromosomes.getLength()) {
                                if (chromosomes.item(k) instanceof Element) {
                                    Element chromosome = (Element)chromosomes.item(k);
                                    String posFile = String.valueOf(expSettings.getPath()) + new File(chromosome.getAttribute("positions_file")).getName();
                                    String tagFile = String.valueOf(expSettings.getPath()) + new File(chromosome.getAttribute("tag_file")).getName();
                                    ChromosomeData chData = new ChromosomeData(chromosome.getAttribute("name"), posFile, tagFile, Integer.parseInt(chromosome.getAttribute("number")));
                                    expResults.addChromosomeData(chData);
                                }
                                ++k;
                            }
                            expSettings.addResults(expResults);
                        }
                        ++j;
                    }
                }
                if (tag.equals("assignmentFilesList")) {
                    NodeList files = experiment.getChildNodes();
                    j = 0;
                    while (j < files.getLength()) {
                        if (files.item(j) instanceof Element) {
                            result = (Element)files.item(j);
                            String filepath = result.getAttribute("path");
                            expSettings.addAssignmentFile(filepath);
                        }
                        ++j;
                    }
                } else if (tag.equals("filteredLociTypes")) {
                    NodeList types = experiment.getChildNodes();
                    j = 0;
                    while (j < types.getLength()) {
                        if (types.item(j) instanceof Element) {
                            result = (Element)types.item(j);
                            String type = result.getAttribute("type");
                            expSettings.getParams().addLociTypes(type);
                        }
                        ++j;
                    }
                } else if (tag.equals("filterGOTerms")) {
                    expSettings.getParams().setFilterGOTerm(content.equals("true"));
                } else if (tag.equals("GOTermsFile")) {
                    expSettings.getParams().setGOTermsFile(content);
                } else if (tag.equals("positionLength")) {
                    expSettings.getParams().setLocusLength(Integer.parseInt(content));
                } else if (tag.equals("locusOffset")) {
                    expSettings.getParams().setLocusOffset(Integer.parseInt(content));
                } else if (tag.equals("dataBaseIndex")) {
                    expSettings.setDataBaseIndex(Integer.parseInt(content));
                } else if (tag.equals("speciesId")) {
                    expSettings.getParams().setSpeciesId(content);
                } else if (tag.equals("mainAttribute")) {
                    expSettings.getParams().setMainAttribute(content);
                } else if (tag.equals("secondaryAttribute")) {
                    expSettings.getParams().setSecondaryAttribute(content);
                } else if (tag.equals("checkStrand")) {
                    expSettings.getParams().setCheckStrand(content.equals("true"));
                } else if (tag.equals("filterMultipleAssignments")) {
                    expSettings.getParams().setFilterMultipleAssignments(content.equals("true"));
                } else if (tag.equals("filterShortLoci")) {
                    expSettings.getParams().setFilterShortLoci(content.equals("true"));
                } else if (tag.equals("minLociLength")) {
                    expSettings.getParams().setMinLociLength(Integer.parseInt(content));
                } else if (tag.equals("filterLociTypes")) {
                    expSettings.getParams().setFilterLociTypes(content.equals("true"));
                } else if (tag.equals("minPositionDistance")) {
                    expSettings.getParams().setMinLociDistance(Integer.parseInt(content));
                } else if (tag.equals("leaveNoNearPositions")) {
                    expSettings.getParams().setLeaveNoNearLoci(content.equals("true"));
                } else if (tag.equals("leaveRandomNearPositions")) {
                    expSettings.getParams().setLeaveRandomNearLoci(content.equals("true"));
                } else if (tag.equals("leaveMiddleNearPositions")) {
                    expSettings.getParams().setLeaveMiddleNearLoci(content.equals("true"));
                } else if (tag.equals("prefilterLoci")) {
                    expSettings.getParams().setPrefilterLoci(content.equals("true"));
                } else if (tag.equals("prefilterLociLength")) {
                    expSettings.getParams().setPrefilterLociLength(Integer.parseInt(content));
                } else if (tag.equals("prefilterLociOffset")) {
                    expSettings.getParams().setPrefilterLociOffset(Integer.parseInt(content));
                } else if (tag.equals("prefilterLociTags")) {
                    expSettings.getParams().setPrefilterLociTags(Integer.parseInt(content));
                } else if (tag.equals("filterLowTagLoci")) {
                    expSettings.getParams().setFilterLowTagLoci(content.equals("true"));
                } else if (tag.equals("minLociTagCount")) {
                    expSettings.getParams().setMinLociTagCount(Integer.parseInt(content));
                } else if (tag.equals("filterLowTagPositions")) {
                    expSettings.getParams().setFilterLowTagPositions(content.equals("true"));
                } else if (tag.equals("minPositionsTagCount")) {
                    expSettings.getParams().setMinPositionTagCount(Integer.parseInt(content));
                } else if (tag.equals("filterMultiTagLoci")) {
                    expSettings.getParams().setFilterMultiTagLoci(content.equals("true"));
                } else if (tag.equals("maxLociTagCount")) {
                    expSettings.getParams().setMaxLociTagCount(Integer.parseInt(content));
                } else if (tag.equals("filterMultiTagPositions")) {
                    expSettings.getParams().setFilterMultiTagPositions(content.equals("true"));
                } else if (tag.equals("maxPositionsTagCount")) {
                    expSettings.getParams().setMaxPositionTagCount(Integer.parseInt(content));
                } else if (tag.equals("assignmentsCountNormalisation")) {
                    expSettings.getParams().setAssignmentsCountNormalisation(content.equals("true"));
                } else if (tag.equals("scalePositionHistogram")) {
                    expSettings.setScalePositionHistogram(content.equals("true"));
                } else if (tag.equals("scaleLociHistogram")) {
                    expSettings.setScaleLociHistogram(content.equals("true"));
                } else if (tag.equals("setPositionHistogramRange")) {
                    expSettings.setSetPositionHistogramRange(content.equals("true"));
                } else if (tag.equals("positionHistogramRangeMin")) {
                    expSettings.setPositionHistogramRangeMin(Integer.parseInt(content));
                } else if (tag.equals("positionHistogramRangeMax")) {
                    expSettings.setPositionHistogramRangeMax(Integer.parseInt(content));
                } else if (tag.equals("setLociHistogramRange")) {
                    expSettings.setSetLociHistogramRange(content.equals("true"));
                } else if (tag.equals("lociHistogramRangeMin")) {
                    expSettings.setLociHistogramRangeMin(Integer.parseInt(content));
                } else if (tag.equals("lociHistogramRangeMax")) {
                    expSettings.setLociHistogramRangeMax(Integer.parseInt(content));
                } else if (tag.equals("lociLoad")) {
                    expSettings.getParams().setLociLoad(content.equals("true"));
                } else if (tag.equals("lociLoadFile")) {
                    expSettings.getParams().setLociLoadFile(content);
                } else if (tag.equals("lociSave")) {
                    expSettings.getParams().setLociSave(content.equals("true"));
                } else if (tag.equals("lociSaveFile")) {
                    expSettings.getParams().setLociSaveFile(content);
                }
            }
            ++i;
        }
        in.close();
        return expSettings;
    }
}

