/*
 * Decompiled with CFR 0.152.
 */
package settings;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import settings.ExperimentParams;

public class ExperimentParamsWriter {
    public static void writeExperimentParams(ExperimentParams params, String filePath) throws ParserConfigurationException, TransformerException, IOException {
        File f = new File(filePath);
        if (f.exists()) {
            f.delete();
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element rootElement = doc.createElement("settings");
        doc.appendChild(rootElement);
        Element tag = doc.createElement("positionLength");
        Text text = doc.createTextNode(String.valueOf(params.getLocusLength()));
        tag.appendChild(text);
        rootElement.appendChild(tag);
        tag = doc.createElement("locusOffset");
        text = doc.createTextNode(String.valueOf(params.getLocusOffset()));
        tag.appendChild(text);
        rootElement.appendChild(tag);
        tag = doc.createElement("speciesId");
        text = doc.createTextNode(String.valueOf(params.getSpeciesId()));
        tag.appendChild(text);
        rootElement.appendChild(tag);
        tag = doc.createElement("mainAttribute");
        text = doc.createTextNode(params.getMainAttribute());
        tag.appendChild(text);
        rootElement.appendChild(tag);
        tag = doc.createElement("secondaryAttribute");
        text = doc.createTextNode(params.getSecondaryAttribute());
        tag.appendChild(text);
        rootElement.appendChild(tag);
        tag = doc.createElement("checkStrand");
        text = doc.createTextNode(String.valueOf(params.isCheckStrand()));
        tag.appendChild(text);
        rootElement.appendChild(tag);
        tag = doc.createElement("filterMultipleAssignments");
        text = doc.createTextNode(String.valueOf(params.isFilterMultipleAssignments()));
        tag.appendChild(text);
        rootElement.appendChild(tag);
        tag = doc.createElement("filterShortLoci");
        text = doc.createTextNode(String.valueOf(params.isFilterShortLoci()));
        tag.appendChild(text);
        rootElement.appendChild(tag);
        tag = doc.createElement("minLociLength");
        text = doc.createTextNode(String.valueOf(params.getMinLociLength()));
        tag.appendChild(text);
        rootElement.appendChild(tag);
        tag = doc.createElement("filterLociTypes");
        text = doc.createTextNode(String.valueOf(params.isFilterLociTypes()));
        tag.appendChild(text);
        rootElement.appendChild(tag);
        Element lociTypes = doc.createElement("filteredLociTypes");
        int i = 0;
        while (i < params.getLociTypesCount()) {
            Element lociEntry = doc.createElement("filteredLoci");
            lociEntry.setAttribute("type", params.getLociTypes(i));
            lociTypes.appendChild(lociEntry);
            ++i;
        }
        rootElement.appendChild(lociTypes);
        tag = doc.createElement("filterGOTerms");
        text = doc.createTextNode(String.valueOf(params.isFilterGOTerm()));
        tag.appendChild(text);
        rootElement.appendChild(tag);
        tag = doc.createElement("GOTermsFile");
        text = doc.createTextNode(String.valueOf(params.getGOTermsFile()));
        tag.appendChild(text);
        rootElement.appendChild(tag);
        tag = doc.createElement("minPositionDistance");
        text = doc.createTextNode(String.valueOf(params.getMinLociDistance()));
        tag.appendChild(text);
        rootElement.appendChild(tag);
        tag = doc.createElement("leaveNoNearPositions");
        text = doc.createTextNode(String.valueOf(params.isLeaveNoNearLoci()));
        tag.appendChild(text);
        rootElement.appendChild(tag);
        tag = doc.createElement("leaveRandomNearPositions");
        text = doc.createTextNode(String.valueOf(params.isLeaveRandomNearLoci()));
        tag.appendChild(text);
        rootElement.appendChild(tag);
        tag = doc.createElement("leaveMiddleNearPositions");
        text = doc.createTextNode(String.valueOf(params.isLeaveMiddleNearLoci()));
        tag.appendChild(text);
        rootElement.appendChild(tag);
        tag = doc.createElement("prefilterLoci");
        text = doc.createTextNode(String.valueOf(params.isPrefilterLoci()));
        tag.appendChild(text);
        rootElement.appendChild(tag);
        tag = doc.createElement("prefilterLociLength");
        text = doc.createTextNode(String.valueOf(params.getPrefilterLociLength()));
        tag.appendChild(text);
        rootElement.appendChild(tag);
        tag = doc.createElement("prefilterLociOffset");
        text = doc.createTextNode(String.valueOf(params.getPrefilterLociOffset()));
        tag.appendChild(text);
        rootElement.appendChild(tag);
        tag = doc.createElement("prefilterLociTags");
        text = doc.createTextNode(String.valueOf(params.getPrefilterLociTags()));
        tag.appendChild(text);
        rootElement.appendChild(tag);
        tag = doc.createElement("filterLowTagLoci");
        text = doc.createTextNode(String.valueOf(params.isFilterLowTagLoci()));
        tag.appendChild(text);
        rootElement.appendChild(tag);
        tag = doc.createElement("minLociTagCount");
        text = doc.createTextNode(String.valueOf(params.getMinLociTagCount()));
        tag.appendChild(text);
        rootElement.appendChild(tag);
        tag = doc.createElement("filterLowTagPositions");
        text = doc.createTextNode(String.valueOf(params.isFilterLowTagPositions()));
        tag.appendChild(text);
        rootElement.appendChild(tag);
        tag = doc.createElement("minPositionsTagCount");
        text = doc.createTextNode(String.valueOf(params.getMinPositionTagCount()));
        tag.appendChild(text);
        rootElement.appendChild(tag);
        tag = doc.createElement("filterMultiTagLoci");
        text = doc.createTextNode(String.valueOf(params.isFilterMultiTagLoci()));
        tag.appendChild(text);
        rootElement.appendChild(tag);
        tag = doc.createElement("maxLociTagCount");
        text = doc.createTextNode(String.valueOf(params.getMaxLociTagCount()));
        tag.appendChild(text);
        rootElement.appendChild(tag);
        tag = doc.createElement("filterMultiTagPositions");
        text = doc.createTextNode(String.valueOf(params.isFilterMultiTagPositions()));
        tag.appendChild(text);
        rootElement.appendChild(tag);
        tag = doc.createElement("maxPositionsTagCount");
        text = doc.createTextNode(String.valueOf(params.getMaxPositionTagCount()));
        tag.appendChild(text);
        rootElement.appendChild(tag);
        tag = doc.createElement("assignmentsCountNormalisation");
        text = doc.createTextNode(String.valueOf(params.isAssignmentsCountNormalisation()));
        tag.appendChild(text);
        rootElement.appendChild(tag);
        tag = doc.createElement("lociLoadFile");
        text = doc.createTextNode(String.valueOf(params.getLociLoadFile()));
        tag.appendChild(text);
        rootElement.appendChild(tag);
        tag = doc.createElement("lociLoad");
        text = doc.createTextNode(String.valueOf(params.isLociLoad()));
        tag.appendChild(text);
        rootElement.appendChild(tag);
        tag = doc.createElement("lociSaveFile");
        text = doc.createTextNode(String.valueOf(params.getLociSaveFile()));
        tag.appendChild(text);
        rootElement.appendChild(tag);
        tag = doc.createElement("lociSave");
        text = doc.createTextNode(String.valueOf(params.isLociSave()));
        tag.appendChild(text);
        rootElement.appendChild(tag);
        Transformer t = TransformerFactory.newInstance().newTransformer();
        t.setOutputProperty("indent", "yes");
        t.setOutputProperty("method", "xml");
        FileOutputStream out = new FileOutputStream(f);
        t.transform(new DOMSource(doc), new StreamResult(out));
        out.close();
    }
}

