/*
 * Decompiled with CFR 0.152.
 */
package settings;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import settings.ExperimentParams;

public class ExperimentParamsReader {
    public static ExperimentParams readExperimentParams(String settingsFileName) throws ParserConfigurationException, SAXException, IOException {
        ExperimentParams params = new ExperimentParams();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        File f = new File(settingsFileName);
        FileInputStream in = new FileInputStream(f);
        Document doc = builder.parse(in);
        Element root = doc.getDocumentElement();
        NodeList children = root.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node experiment = children.item(i);
            if (experiment instanceof Element) {
                String tag = ((Element)experiment).getTagName();
                String content = ((Element)experiment).getTextContent();
                if (tag.equals("filteredLociTypes")) {
                    NodeList types = experiment.getChildNodes();
                    int j = 0;
                    while (j < types.getLength()) {
                        if (types.item(j) instanceof Element) {
                            Element result = (Element)types.item(j);
                            String type = result.getAttribute("type");
                            params.addLociTypes(type);
                        }
                        ++j;
                    }
                } else if (tag.equals("filterGOTerms")) {
                    params.setFilterGOTerm(content.equals("true"));
                } else if (tag.equals("GOTermsFile")) {
                    params.setGOTermsFile(content);
                } else if (tag.equals("positionLength")) {
                    params.setLocusLength(Integer.parseInt(content));
                } else if (tag.equals("locusOffset")) {
                    params.setLocusOffset(Integer.parseInt(content));
                } else if (tag.equals("speciesId")) {
                    params.setSpeciesId(content);
                } else if (tag.equals("mainAttribute")) {
                    params.setMainAttribute(content);
                } else if (tag.equals("secondaryAttribute")) {
                    params.setSecondaryAttribute(content);
                } else if (tag.equals("checkStrand")) {
                    params.setCheckStrand(content.equals("true"));
                } else if (tag.equals("filterMultipleAssignments")) {
                    params.setFilterMultipleAssignments(content.equals("true"));
                } else if (tag.equals("filterShortLoci")) {
                    params.setFilterShortLoci(content.equals("true"));
                } else if (tag.equals("minLociLength")) {
                    params.setMinLociLength(Integer.parseInt(content));
                } else if (tag.equals("filterLociTypes")) {
                    params.setFilterLociTypes(content.equals("true"));
                } else if (tag.equals("minPositionDistance")) {
                    params.setMinLociDistance(Integer.parseInt(content));
                } else if (tag.equals("leaveNoNearPositions")) {
                    params.setLeaveNoNearLoci(content.equals("true"));
                } else if (tag.equals("leaveRandomNearPositions")) {
                    params.setLeaveRandomNearLoci(content.equals("true"));
                } else if (tag.equals("leaveMiddleNearPositions")) {
                    params.setLeaveMiddleNearLoci(content.equals("true"));
                } else if (tag.equals("prefilterLoci")) {
                    params.setPrefilterLoci(content.equals("true"));
                } else if (tag.equals("prefilterLociLength")) {
                    params.setPrefilterLociLength(Integer.parseInt(content));
                } else if (tag.equals("prefilterLociOffset")) {
                    params.setPrefilterLociOffset(Integer.parseInt(content));
                } else if (tag.equals("prefilterLociTags")) {
                    params.setPrefilterLociTags(Integer.parseInt(content));
                } else if (tag.equals("filterLowTagLoci")) {
                    params.setFilterLowTagLoci(content.equals("true"));
                } else if (tag.equals("minLociTagCount")) {
                    params.setMinLociTagCount(Integer.parseInt(content));
                } else if (tag.equals("filterLowTagPositions")) {
                    params.setFilterLowTagPositions(content.equals("true"));
                } else if (tag.equals("minPositionsTagCount")) {
                    params.setMinPositionTagCount(Integer.parseInt(content));
                } else if (tag.equals("filterMultiTagLoci")) {
                    params.setFilterMultiTagLoci(content.equals("true"));
                } else if (tag.equals("maxLociTagCount")) {
                    params.setMaxLociTagCount(Integer.parseInt(content));
                } else if (tag.equals("filterMultiTagPositions")) {
                    params.setFilterMultiTagPositions(content.equals("true"));
                } else if (tag.equals("maxPositionsTagCount")) {
                    params.setMaxPositionTagCount(Integer.parseInt(content));
                } else if (tag.equals("assignmentsCountNormalisation")) {
                    params.setAssignmentsCountNormalisation(content.equals("true"));
                } else if (tag.equals("lociLoad")) {
                    params.setLociLoad(content.equals("true"));
                } else if (tag.equals("lociLoadFile")) {
                    params.setLociLoadFile(content);
                } else if (tag.equals("lociSave")) {
                    params.setLociSave(content.equals("true"));
                } else if (tag.equals("lociSaveFile")) {
                    params.setLociSaveFile(content);
                }
            }
            ++i;
        }
        in.close();
        return params;
    }
}

