/*
 * Decompiled with CFR 0.152.
 */
package settings;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import settings.AppSettings;

public class AppSettingsWriter {
    private String settingsFileName;

    public AppSettingsWriter(String settingsFileName) {
        this.settingsFileName = settingsFileName;
    }

    public void writeAppSettings(AppSettings settings) throws ParserConfigurationException, FileNotFoundException, TransformerException {
        File f = new File(this.settingsFileName);
        if (f.exists()) {
            f.delete();
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element rootElement = doc.createElement("settings");
        doc.appendChild(rootElement);
        Element bowtie = doc.createElement("bowtie_settings");
        bowtie.setAttribute("bowtie_path", settings.getBowtieExecutablePath());
        bowtie.setAttribute("bowtie_index_path", settings.getBowtieIndexPath());
        rootElement.appendChild(bowtie);
        int i = 0;
        while (i < settings.getExperiments().size()) {
            Element experiment = doc.createElement("experiment");
            experiment.setAttribute("name", settings.getExperiments().get(i).getName());
            experiment.setAttribute("path", settings.getExperiments().get(i).getPath());
            rootElement.appendChild(experiment);
            ++i;
        }
        Transformer t = TransformerFactory.newInstance().newTransformer();
        t.setOutputProperty("indent", "yes");
        t.setOutputProperty("method", "xml");
        t.transform(new DOMSource(doc), new StreamResult(new FileOutputStream(f)));
    }
}

