/*
 * Decompiled with CFR 0.152.
 */
package settings;

import java.io.File;
import java.util.ArrayList;
import settings.ExperimentSettings;
import settings.MScanSystemTools;

public class AppSettings {
    private ArrayList<ExperimentSettings> experiments = new ArrayList();
    public static final String appSettingsXML = "jChIPAppSettings.xml";
    private String bowtieExecutablePath;
    private String bowtieIndexPath;

    public void addExperiment(ExperimentSettings e) {
        this.experiments.add(e);
    }

    public ArrayList<ExperimentSettings> getExperiments() {
        return this.experiments;
    }

    public ExperimentSettings getExperimentByIndex(int index) {
        if (index >= this.experiments.size()) {
            return null;
        }
        return this.experiments.get(index);
    }

    public ExperimentSettings getExperimentByName(String name) {
        int i = 0;
        while (i < this.experiments.size()) {
            if (this.experiments.get(i).getName().equals(name)) {
                return this.experiments.get(i);
            }
            ++i;
        }
        return null;
    }

    public void removeExperiment(ExperimentSettings experiment) {
        this.experiments.remove(experiment);
    }

    public String getBowtieExecutablePath() {
        return this.bowtieExecutablePath;
    }

    public void setBowtieExecutablePath(String bowtieExecutablePath) {
        this.bowtieExecutablePath = bowtieExecutablePath;
    }

    public String getBowtieIndexPath() {
        return this.bowtieIndexPath;
    }

    public void setBowtieIndexPath(String bowtieIndexPath) {
        this.bowtieIndexPath = bowtieIndexPath;
    }

    public static String getSettingsFilePath() {
        return String.valueOf(MScanSystemTools.getUserHome()) + File.separator + appSettingsXML;
    }
}

