/*
 * Decompiled with CFR 0.152.
 */
package mscanlib.plots.ui;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public final class MScanPlotFileFilter
extends FileFilter {
    public static final int TYPE_END = 0;
    public static final int TYPE_START = 1;
    public static final int TYPE_CONTAINS = 2;
    protected String[] mExtensions = null;
    protected String mDescription = null;
    protected boolean mShowDirectories = true;
    protected int mType = 0;

    public MScanPlotFileFilter(String extension, String description, boolean showDirectories) {
        if (extension != null) {
            this.mExtensions = new String[1];
            this.mExtensions[0] = extension;
            this.mDescription = description;
            this.mShowDirectories = showDirectories;
            this.mType = 0;
        }
    }

    public MScanPlotFileFilter(String extension, String description, boolean showDirectories, int type) {
        if (extension != null) {
            this.mExtensions = new String[1];
            this.mExtensions[0] = extension;
            this.mDescription = description;
            this.mShowDirectories = showDirectories;
            this.mType = type;
        }
    }

    public MScanPlotFileFilter(String[] extensions, String description, boolean showDirectories) {
        if (extensions != null && extensions.length != 0) {
            this.mExtensions = new String[extensions.length];
            int i = 0;
            while (i < extensions.length) {
                this.mExtensions[i] = extensions[i];
                ++i;
            }
            this.mDescription = description;
            this.mShowDirectories = showDirectories;
        }
    }

    @Override
    public boolean accept(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                return this.mShowDirectories;
            }
            int i = 0;
            while (i < this.mExtensions.length) {
                switch (this.mType) {
                    case 0: {
                        if (!file.getName().toUpperCase().endsWith(this.mExtensions[i].toUpperCase())) break;
                        return true;
                    }
                    case 1: {
                        if (!file.getName().toUpperCase().startsWith(this.mExtensions[i].toUpperCase())) break;
                        return true;
                    }
                    case 2: {
                        if (file.getName().toUpperCase().indexOf(this.mExtensions[i].toUpperCase()) == -1) break;
                        return true;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    public String getDescription() {
        return new String(this.mDescription);
    }
}

