/*
 * Decompiled with CFR 0.152.
 */
package mscanlib.plots.ui;

import java.awt.Dimension;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import mscanlib.plots.ui.MScanPlotFileFilter;

public final class MScanPlotFileChooser
extends JFileChooser {
    private static int mSizeX = -1;
    private static int mSizeY = -1;
    private File mSelectedFile = null;
    private boolean mAppendOption = false;
    private boolean mAppend = false;
    private MScanPlotFileFilter[] mFileFilters = null;

    public MScanPlotFileChooser(String currentDir) {
        this(currentDir, false);
    }

    public MScanPlotFileChooser(String currentDir, String fileName) {
        this(currentDir, false);
        this.setSelectedFile(new File(fileName));
    }

    public MScanPlotFileChooser(String currentDir, boolean appendOption) {
        super(currentDir);
        this.mAppendOption = appendOption;
        if (mSizeX != -1 && mSizeY != -1) {
            this.setPreferredSize(new Dimension(mSizeX, mSizeY));
        }
    }

    public void setAppendOption(boolean appendOption) {
        this.mAppendOption = appendOption;
    }

    public boolean getAppend() {
        return this.mAppend;
    }

    public File getSelectedFileWithExt() {
        return this.mSelectedFile;
    }

    public void setFileFilters(String[][] fileFormats) {
        this.mFileFilters = new MScanPlotFileFilter[fileFormats.length];
        int i = 0;
        while (i < this.mFileFilters.length) {
            this.mFileFilters[i] = new MScanPlotFileFilter(fileFormats[i][0], fileFormats[i][1], true);
            this.setFileFilter(this.mFileFilters[i]);
            ++i;
        }
    }

    public void setFileFilter(String[] fileFormat) {
        MScanPlotFileFilter[] fileFilters = null;
        if (this.mFileFilters != null) {
            fileFilters = new MScanPlotFileFilter[this.mFileFilters.length + 1];
            int i = 0;
            while (i < this.mFileFilters.length) {
                fileFilters[i] = this.mFileFilters[i];
                ++i;
            }
        } else {
            fileFilters = new MScanPlotFileFilter[1];
        }
        fileFilters[fileFilters.length - 1] = new MScanPlotFileFilter(fileFormat[0], fileFormat[1], true);
        this.setFileFilter(fileFilters[fileFilters.length - 1]);
        this.mFileFilters = fileFilters;
    }

    public void addFileFilter(String[] fileFormat) {
        int i;
        MScanPlotFileFilter[] fileFilters = null;
        if (this.mFileFilters != null) {
            i = 0;
            while (i < this.mFileFilters.length) {
                this.removeChoosableFileFilter(this.mFileFilters[i]);
                ++i;
            }
            fileFilters = new MScanPlotFileFilter[this.mFileFilters.length + 1];
            i = 0;
            while (i < this.mFileFilters.length) {
                fileFilters[i + 1] = this.mFileFilters[i];
                ++i;
            }
        } else {
            fileFilters = new MScanPlotFileFilter[]{new MScanPlotFileFilter(fileFormat[0], fileFormat[1], true)};
        }
        i = 0;
        while (i < fileFilters.length) {
            this.setFileFilter(fileFilters[i]);
            ++i;
        }
        this.mFileFilters = fileFilters;
    }

    public void setFileFormat(int fileFormat) {
        if (fileFormat < this.mFileFilters.length - 1) {
            this.setFileFilter(this.mFileFilters[this.mFileFilters.length - fileFormat - 1]);
        }
    }

    public int getFileFormat() {
        int fileFormat = -1;
        if (this.mFileFilters != null && !this.getFileFilter().getDescription().toLowerCase().equals("all files")) {
            int i = 0;
            while (i < this.mFileFilters.length) {
                if (((MScanPlotFileFilter)this.getFileFilter()).equals(this.mFileFilters[i])) {
                    fileFormat = this.mFileFilters.length - i - 1;
                    break;
                }
                ++i;
            }
        }
        return fileFormat;
    }

    @Override
    public void cancelSelection() {
        mSizeX = this.getSize().width;
        mSizeY = this.getSize().height;
        super.cancelSelection();
    }

    @Override
    public void approveSelection() {
        File file = null;
        MScanPlotFileFilter fileFilter = null;
        int selectedOption = 0;
        if (this.getDialogType() == 1) {
            file = super.getSelectedFile();
            if (this.getFileFilter() instanceof MScanPlotFileFilter) {
                fileFilter = (MScanPlotFileFilter)this.getFileFilter();
                if (!file.getPath().toUpperCase().endsWith(fileFilter.mExtensions[0].toUpperCase())) {
                    file = new File(String.valueOf(file.getPath()) + fileFilter.mExtensions[0]);
                }
            }
            if (this.getFileSelectionMode() != 1 && file.exists()) {
                if (!this.mAppendOption) {
                    if (JOptionPane.showConfirmDialog(this, "The file " + file.getName() + " already exists!\nDo you want to replace it?", this.getDialogTitle(), 0, 2) == 1) {
                        return;
                    }
                } else {
                    selectedOption = JOptionPane.showOptionDialog(this, "The file " + file.getName() + " already exists!", this.getDialogTitle(), 1, 2, null, new String[]{"Overwrite", "Append", "Cancel"}, "Cancel");
                    if (selectedOption == 2) {
                        return;
                    }
                    if (selectedOption == 1) {
                        this.mAppend = true;
                    }
                }
            }
            this.mSelectedFile = file;
        }
        mSizeX = this.getSize().width;
        mSizeY = this.getSize().height;
        super.approveSelection();
    }
}

