/*
 * Decompiled with CFR 0.152.
 */
package mscanlib.plots.math;

public final class MathFun {
    public static double toPrecision(double value, int digits) {
        double result = 0.0;
        double pow = 0.0;
        pow = Math.pow(10.0, digits);
        result = (double)Math.round(value * pow) / pow;
        return result;
    }

    public static float toPrecision(float value, int digits) {
        return (float)MathFun.toPrecision((double)value, digits);
    }

    public static void toPrecision(double[] array, int digits) {
        int i = 0;
        while (i < array.length) {
            array[i] = MathFun.toPrecision(array[i], digits);
            ++i;
        }
    }

    public static void toPrecision(float[] array, int digits) {
        int i = 0;
        while (i < array.length) {
            array[i] = MathFun.toPrecision(array[i], digits);
            ++i;
        }
    }

    public static String formatInt(int number, int length) {
        StringBuffer str = null;
        String numStr = null;
        int lenDiff = 0;
        str = new StringBuffer("");
        numStr = String.valueOf(number);
        lenDiff = length - numStr.length();
        int i = 0;
        while (i <= lenDiff) {
            str.append("0");
            ++i;
        }
        str.append(numStr);
        return str.toString();
    }

    public static int[] setRange(int minValue, int maxValue) {
        int[] range = null;
        int rangeLength = 0;
        rangeLength = maxValue - minValue;
        range = new int[rangeLength];
        int i = 0;
        while (i < rangeLength) {
            range[i] = i + minValue;
            ++i;
        }
        return range;
    }

    public static double[] reorder(double[] array, int[] index, boolean reversed) {
        double[] result = null;
        if (array.length == index.length) {
            result = new double[array.length];
            int i = 0;
            while (i < array.length) {
                result[i] = !reversed ? array[index[i]] : array[index[array.length - i - 1]];
                ++i;
            }
        }
        return result;
    }

    public static float[] reorder(float[] array, int[] index, boolean reversed) {
        float[] result = null;
        if (array.length == index.length) {
            result = new float[array.length];
            int i = 0;
            while (i < array.length) {
                result[i] = !reversed ? array[index[i]] : array[index[array.length - i - 1]];
                ++i;
            }
        }
        return result;
    }

    public static int[] reorder(int[] array, int[] index, boolean reversed) {
        int[] result = null;
        if (array.length == index.length) {
            result = new int[array.length];
            int i = 0;
            while (i < array.length) {
                result[i] = !reversed ? array[index[i]] : array[index[array.length - i - 1]];
                ++i;
            }
        }
        return result;
    }

    public static long[] reorder(long[] array, int[] index, boolean reversed) {
        long[] result = null;
        if (array.length == index.length) {
            result = new long[array.length];
            int i = 0;
            while (i < array.length) {
                result[i] = !reversed ? array[index[i]] : array[index[array.length - i - 1]];
                ++i;
            }
        }
        return result;
    }
}

