/*
 * Decompiled with CFR 0.152.
 */
package mscanlib.plots.io;

import java.awt.image.BufferedImage;
import mscanlib.plots.MScanPlotArea;
import mscanlib.plots.MScanPlotException;
import mscanlib.plots.io.MScanPlotBitmapFileWriter;
import mscanlib.plots.io.MScanPlotEPSFileWriter;
import mscanlib.plots.io.MScanPlotPDFFileWriter;
import mscanlib.plots.io.MScanPlotSVGFileWriter;
import mscanlib.plots.ui.MScanPlotFileChooser;

public abstract class MScanPlotFileWriter {
    public static final String[][] FORMAT_STR = new String[][]{{".eps", "EPS images (*.eps)"}, {".svg", "SVG images (*.svg)"}, {".pdf", "PDF images (*.pdf)"}, {".bmp", "BMP images (*.bmp)"}, {".jpg", "JPEG images (*.jpg)"}, {".png", "PNG images (*.png)"}};
    public static final int FORMAT_PNG = 0;
    public static final int FORMAT_JPEG = 1;
    public static final int FORMAT_BMP = 2;
    public static final int FORMAT_PDF = 3;
    public static final int FORMAT_SVG = 4;
    public static final int FORMAT_EPS = 5;
    protected String mFilename;

    public MScanPlotFileWriter(String filename) throws MScanPlotException {
        this.mFilename = filename;
    }

    public void saveImage(BufferedImage image) throws MScanPlotException {
        try {
            try {
                this.saveImageFile(image);
            }
            catch (Exception e) {
                throw new MScanPlotException("Error while writing file " + this.mFilename + " (" + e.getMessage() + ")");
            }
        }
        finally {
            try {
                this.closeImageFile();
            }
            catch (Exception e) {
                throw new MScanPlotException("Error while closing file " + this.mFilename + " (" + e.getMessage() + ")");
            }
        }
    }

    public void saveImage(MScanPlotArea plotArea) throws MScanPlotException {
        try {
            try {
                this.saveImageFile(plotArea);
            }
            catch (Exception e) {
                throw new MScanPlotException("Error while writing file " + this.mFilename + " (" + e.getMessage() + ")");
            }
        }
        finally {
            try {
                this.closeImageFile();
            }
            catch (Exception e) {
                throw new MScanPlotException("Error while closing file " + this.mFilename + " (" + e.getMessage() + ")");
            }
        }
    }

    protected abstract void openImageFile() throws Exception;

    protected abstract void closeImageFile() throws Exception;

    public abstract boolean isOpened();

    protected abstract void saveImageFile(BufferedImage var1) throws Exception;

    protected abstract void saveImageFile(MScanPlotArea var1) throws Exception;

    public static void saveImage(String filename, int fileFormat, MScanPlotArea plotArea) throws MScanPlotException {
        MScanPlotFileWriter writer = null;
        writer = fileFormat == 5 ? new MScanPlotEPSFileWriter(filename) : (fileFormat == 4 ? new MScanPlotSVGFileWriter(filename) : (fileFormat == 3 ? new MScanPlotPDFFileWriter(filename) : new MScanPlotBitmapFileWriter(filename)));
        writer.saveImage(plotArea);
    }

    public static String getFormatExtension(int format) {
        String extension = "png";
        switch (format) {
            case 5: {
                extension = "eps";
                break;
            }
            case 4: {
                extension = "svg";
                break;
            }
            case 3: {
                extension = "pdf";
                break;
            }
            case 2: {
                extension = "bmp";
                break;
            }
            case 1: {
                extension = "jpg";
                break;
            }
            case 0: {
                extension = "png";
            }
        }
        return extension;
    }

    public static int getFormat(String extension) {
        int format = 0;
        if (extension.toLowerCase().equals("eps")) {
            format = 5;
        } else if (extension.toLowerCase().equals("svg")) {
            format = 4;
        } else if (extension.toLowerCase().equals("pdf")) {
            format = 3;
        } else if (extension.toLowerCase().equals("bmp")) {
            format = 2;
        } else if (extension.toLowerCase().equals("jpg")) {
            format = 1;
        }
        return format;
    }

    public static MScanPlotFileChooser getFileChooser(String directory, int fileFormat) {
        MScanPlotFileChooser fileChooser = null;
        fileChooser = new MScanPlotFileChooser(directory);
        fileChooser.setFileFilters(FORMAT_STR);
        fileChooser.setFileFormat(fileFormat);
        return fileChooser;
    }

    public static MScanPlotFileChooser getFileChooser(String directory, String fileName, int fileFormat) {
        MScanPlotFileChooser fileChooser = null;
        fileChooser = new MScanPlotFileChooser(directory, fileName);
        fileChooser.setFileFilters(FORMAT_STR);
        fileChooser.setFileFormat(fileFormat);
        return fileChooser;
    }
}

