/*
 * Decompiled with CFR 0.152.
 */
package mscanlib.plots.io;

import java.awt.Color;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.FileWriter;
import mscanlib.plots.MScanPlotArea;
import mscanlib.plots.MScanPlotException;
import mscanlib.plots.io.MScanPlotFileWriter;
import mscanlib.plots.io.eps.EpsGraphics2D;

public class MScanPlotEPSFileWriter
extends MScanPlotFileWriter {
    private BufferedWriter mEpsWriter = null;

    public MScanPlotEPSFileWriter(String filename) throws MScanPlotException {
        super(filename);
        try {
            this.openImageFile();
        }
        catch (Exception e) {
            throw new MScanPlotException("Error while opening file " + this.mFilename + " (" + e.getMessage() + ")");
        }
    }

    @Override
    protected void openImageFile() throws Exception {
        this.mEpsWriter = new BufferedWriter(new FileWriter(this.mFilename));
    }

    @Override
    protected void closeImageFile() throws Exception {
        if (this.isOpened()) {
            this.mEpsWriter.close();
        }
    }

    @Override
    public boolean isOpened() {
        return this.mEpsWriter != null;
    }

    @Override
    protected void saveImageFile(BufferedImage image) throws Exception {
        EpsGraphics2D g2d = null;
        g2d = this.getG2D(image.getWidth(), image.getHeight(), null);
        g2d.drawImage(image, null, 0, 0);
        this.mEpsWriter.write(g2d.toString());
        g2d.dispose();
    }

    @Override
    protected void saveImageFile(MScanPlotArea plotArea) throws Exception {
        EpsGraphics2D g2d = null;
        g2d = this.getG2D(plotArea.getWidth(), plotArea.getHeight(), plotArea.getAxisFont());
        plotArea.plotImage(g2d);
        this.mEpsWriter.write(g2d.toString());
        g2d.dispose();
    }

    private EpsGraphics2D getG2D(int width, int height, Font font) {
        EpsGraphics2D g2d = null;
        g2d = new EpsGraphics2D();
        g2d.setColor(Color.white);
        g2d.fillRect(0, 0, width, height);
        if (font != null) {
            g2d.setFont(font);
        }
        return g2d;
    }
}

