/*
 * Decompiled with CFR 0.152.
 */
package mscanlib.plots;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import mscanlib.plots.MScanLinePlot;
import mscanlib.plots.MScanPlotArea;
import mscanlib.plots.MScanScatterPlot;
import mscanlib.plots.MScanTextLabel;
import mscanlib.plots.math.MathFun;

class ScatterPlotPanel
extends MScanPlotArea {
    private static final Color POINT_COLOR = Color.blue;
    private static final Color OUTLIER_COLOR = Color.red;
    private static final Color SELECTED_COLOR = Color.green;
    private MScanScatterPlot scatterPlot = null;

    public ScatterPlotPanel(int width, int height, boolean fixed) {
        super(width, height, fixed);
        this.setZoomable(true, true, true);
        this.setCursor(new Cursor(1));
        this.setCursorCoordinatesVisible(true);
        this.setImageDir(".");
        MScanLinePlot fitPlot = null;
        MScanTextLabel label = null;
        String labelText = null;
        this.resetPlottables();
        int n = 1000;
        double step = 10.0;
        double[] x = new double[(int)((double)n / step)];
        double[] y = new double[(int)((double)n / step)];
        double a = 2.0;
        double b = 4.0;
        double[] s = new double[(int)((double)n / step)];
        double value = 0.0;
        int i = 0;
        while ((double)i < (double)n / step) {
            x[i] = value;
            y[i] = -value * value;
            s[i] = value * value;
            value += 1.0E-6 * step;
            ++i;
        }
        int[] outliers = null;
        this.setPlotTitle("Plot title");
        this.xAxis.setmAxisMaxTickDigits(4);
        this.xAxis.setGrid(true);
        this.xAxis.setLabel("x axis label");
        this.xAxis.setBoxAxes(true);
        this.yAxis.setBoxAxes(true);
        this.yAxis.setGrid(true);
        this.yAxis.setLabel("y axis label");
        this.yAxis.setLabel(" ");
        this.scatterPlot = new MScanScatterPlot(this, 4);
        this.scatterPlot.setId("Points");
        this.scatterPlot.setSelectable(true);
        this.scatterPlot.setFaceColor(POINT_COLOR);
        this.scatterPlot.setEdgeColor(Color.black);
        this.scatterPlot.setOutliersColor(OUTLIER_COLOR);
        this.scatterPlot.setSelectedColor(SELECTED_COLOR);
        this.scatterPlot.setPoints(x, y, outliers);
        this.addPlottable(this.scatterPlot, true);
        fitPlot = new MScanLinePlot(this);
        fitPlot.setLineWidth(2.0f);
        fitPlot.setPoints(x, s);
        this.addPlottable(fitPlot, false);
        labelText = new String("a=" + String.valueOf(MathFun.toPrecision(a, 4)) + ", b=" + String.valueOf(MathFun.toPrecision(b, 4)));
        label = new MScanTextLabel(this, labelText, 0.0, 0.0, false, 2);
        label.setFaceColor(new Color(0.8f, 0.8f, 1.0f));
        label.setEdgeColor(new Color(0.8f, 0.8f, 1.0f));
        label.setAlpha(0.2f);
        label.setRound(true);
        label.setPosX(15.0);
        label.setPosY(45.0);
        this.addPlottable(label, false);
        this.resetZoomLevel();
        this.updatePlot();
    }

    @Override
    public void plotImage(Graphics2D g2d) {
        this.plotAxes(g2d);
        this.redrawPlottables(g2d);
    }
}

