/*
 * Decompiled with CFR 0.152.
 */
package mscanlib.plots;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.List;
import mscanlib.plots.MScanPlotArea;
import mscanlib.plots.MScanPlottable;

public final class MScanTextLabel
extends MScanPlottable {
    public static final int ANCHOR_NONE = 0;
    public static final int ANCHOR_TOP_RIGHT = 1;
    public static final int ANCHOR_BOTTOM_RIGHT = 2;
    public static final int ANCHOR_TOP = 3;
    public static final int ORIENTATION_HORIZONTAL = 0;
    public static final int ORIENTATION_VERTICAL = 1;
    public static final int ORIENTATION_DIAGONAL = 2;
    private ArrayList<String> mText = null;
    private Color mTextColor = null;
    private Font mTextFont = null;
    private int mOrientation = 0;
    private int mAnchor = 0;
    private int mLineSpacing = 3;
    private int mMarginX = 3;
    private int mMarginY = 3;
    private boolean mRound = false;
    private RectangularShape mLabelRectangle = null;

    public MScanTextLabel(MScanPlotArea plotArea, String labelText, double x, double y, boolean relative) {
        super(plotArea, 3);
        this.mX = x;
        this.mY = y;
        this.mRelativeCoords = relative;
        this.mLabelRectangle = new Rectangle2D.Double();
        this.mTextFont = this.mPlotArea.getTextFont();
        this.mTextColor = this.mPlotArea.getForegroundColor();
        this.mFaceColor = this.mPlotArea.getBackgroundColor();
        this.setText(labelText);
    }

    public MScanTextLabel(MScanPlotArea plotArea, String labelText, double x, double y, boolean relative, int anchor) {
        this(plotArea, labelText, x, y, relative);
        this.mAnchor = anchor;
    }

    @Override
    public void draw(Graphics2D g2d) {
        double x = -1.0;
        double y = -1.0;
        double w = -1.0;
        double h = -1.0;
        AffineTransform g2dTransform = null;
        if (this.mIsVisible) {
            w = this.mRelativeCoords ? this.mPlotArea.scaleX(this.getWidth()) : this.getWidth();
            h = this.mRelativeCoords ? this.mPlotArea.scaleY(this.getHeight()) : this.getHeight();
            x = this.mRelativeCoords ? this.mPlotArea.getX(this.mX) : this.getXPosition();
            y = (this.mRelativeCoords ? this.mPlotArea.getY(this.mY) : this.getYPosition()) - h;
            if (this.mOrientation == 1) {
                g2dTransform = g2d.getTransform();
                g2d.transform(this.getVerticalTransform(x, y, w, h));
            } else if (this.mOrientation == 2) {
                g2dTransform = g2d.getTransform();
                g2d.transform(this.getDiagonalTransform(x, y, w, h));
            }
            g2d.setColor(this.mFaceColor);
            if (this.mAlpha != 1.0f) {
                g2d.setComposite(AlphaComposite.getInstance(3, this.mAlpha));
            }
            if (this.mRound) {
                ((RoundRectangle2D.Double)this.mLabelRectangle).setRoundRect(x, y, w, h, 3.0, 3.0);
            } else {
                ((Rectangle2D.Double)this.mLabelRectangle).setRect(x, y, w, h);
            }
            g2d.fill(this.mLabelRectangle);
            if (this.mAlpha != 1.0f) {
                g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
            }
            if (this.mEdgeColor != null) {
                g2d.setStroke(new BasicStroke(this.mLineWidth, 1, 1));
                g2d.setColor(this.mEdgeColor);
                g2d.draw(this.mLabelRectangle);
            }
            g2d.setColor(this.mTextColor);
            g2d.setFont(this.mTextFont);
            x = this.mLabelRectangle.getMinX() + (double)this.mMarginX;
            y = this.mLabelRectangle.getMaxY() - (double)this.mMarginY;
            int i = this.mText.size() - 1;
            while (i >= 0) {
                g2d.drawString(this.mText.get(i), (float)x, (float)y);
                y -= this.mPlotArea.getTextHeight(this.mText.get(i), this.mTextFont) + (double)this.mLineSpacing;
                --i;
            }
            if (this.mOrientation != 0) {
                g2d.setTransform(g2dTransform);
            }
        }
    }

    @Override
    public boolean contains(double x, double y) {
        return false;
    }

    @Override
    public double getMinX() {
        return 0.0;
    }

    @Override
    public double getMaxX() {
        return 0.0;
    }

    @Override
    public double getMinY() {
        return 0.0;
    }

    @Override
    public double getMaxY() {
        return 0.0;
    }

    public void setText(String text) {
        this.clearText();
        this.addTextLine(text);
    }

    public void setText(List<String> text) {
        this.clearText();
        int i = 0;
        while (i < text.size()) {
            this.addTextLine(text.get(i));
            ++i;
        }
    }

    public void addTextLine(String line) {
        if (this.mText == null) {
            this.mText = new ArrayList();
        }
        this.mText.add(line);
    }

    public void clearText() {
        if (this.mText != null) {
            this.mText.clear();
        }
    }

    public void setTextFont(Font font) {
        this.mTextFont = font;
    }

    public void setTextColor(Color color) {
        this.mTextColor = color;
    }

    public void setRound(boolean round) {
        this.mRound = round;
        this.mLabelRectangle = this.mRound ? new RoundRectangle2D.Double() : new Rectangle2D.Double();
    }

    public void setOrientation(int orientation) {
        this.mOrientation = orientation;
    }

    public Color getTextColor() {
        return this.mTextColor;
    }

    public boolean isRound() {
        return this.mRound;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    @Override
    public double getWidth() {
        double w = -1.0;
        w = this.getTextWidth() + 2.0 * (double)this.mMarginX;
        if (this.mRelativeCoords) {
            w = this.mPlotArea.scaleValueX(w);
        }
        return w;
    }

    @Override
    public double getHeight() {
        double h = -1.0;
        h = this.getTextHeight() + 2.0 * (double)this.mMarginY;
        if (this.mRelativeCoords) {
            h = this.mPlotArea.scaleValueY(h);
        }
        return h;
    }

    private double getTextWidth() {
        double maxWidth = -1.0;
        double width = -1.0;
        int i = 0;
        while (i < this.mText.size()) {
            double d;
            width = this.mPlotArea.getTextWidth(this.mText.get(i), this.mTextFont);
            if (d > maxWidth) {
                maxWidth = width;
            }
            ++i;
        }
        return maxWidth;
    }

    private double getTextHeight() {
        int lineCount = 0;
        double height = 0.0;
        lineCount = this.mText.size();
        if (lineCount > 0) {
            height = (double)lineCount * this.mPlotArea.getTextHeight(this.mText.get(0), this.mTextFont) + (double)((lineCount - 1) * this.mLineSpacing);
        }
        return height;
    }

    private AffineTransform getVerticalTransform(double x, double y, double w, double h) {
        AffineTransform transform = null;
        double pWidth = 0.5 * (double)this.mPlotArea.getPanelWidth();
        double pHeight = 0.5 * (double)this.mPlotArea.getPanelHeight();
        transform = AffineTransform.getTranslateInstance(x - y + pHeight - pWidth, x + y - pWidth - pHeight + h);
        transform.rotate(-1.5707963267948966, pWidth, pHeight);
        return transform;
    }

    private AffineTransform getDiagonalTransform(double x, double y, double w, double h) {
        AffineTransform transform = null;
        double a = h / Math.sqrt(2.0);
        transform = AffineTransform.getTranslateInstance(-a, 0.0);
        transform.rotate(-0.7853981633974483, x + a, y);
        return transform;
    }

    public double getRealWidth() {
        if (this.mOrientation == 0) {
            return this.getWidth();
        }
        if (this.mOrientation == 1) {
            return this.getHeight();
        }
        if (this.mOrientation == 2) {
            return this.getWidth() * 0.7071;
        }
        return this.getWidth();
    }

    public double getRealHeight() {
        if (this.mOrientation == 0) {
            return this.getHeight();
        }
        if (this.mOrientation == 1) {
            return this.getWidth();
        }
        if (this.mOrientation == 2) {
            return this.getWidth() * 0.7071;
        }
        return this.getHeight();
    }

    protected double getXPosition() {
        if (this.mAnchor == 1) {
            return (double)this.mPlotArea.getWidth() - this.getRealWidth() - this.mX;
        }
        if (this.mAnchor == 2) {
            return (double)this.mPlotArea.getWidth() - this.getRealWidth() - this.mX;
        }
        if (this.mAnchor == 3) {
            return ((double)this.mPlotArea.getWidth() - this.getRealWidth()) / 2.0;
        }
        return this.mX;
    }

    protected double getYPosition() {
        if (this.mAnchor == 1) {
            return this.getRealHeight() + this.mY;
        }
        if (this.mAnchor == 2) {
            return (double)this.mPlotArea.getHeight() - this.mY;
        }
        if (this.mAnchor == 3) {
            return this.mY;
        }
        return this.mY;
    }
}

