/*
 * Decompiled with CFR 0.152.
 */
package mscanlib.plots;

import java.awt.Color;
import java.awt.Graphics2D;
import mscanlib.plots.MScanPlot;
import mscanlib.plots.MScanPlotArea;

public abstract class MScanPlottable {
    protected MScanPlotArea mPlotArea = null;
    protected MScanPlot mPlot = null;
    protected int mType = -1;
    protected String mId = null;
    protected int mIndex = -1;
    protected boolean mIsIndexable = true;
    protected float mLineWidth = 1.0f;
    protected Color mFaceColor = null;
    protected Color mEdgeColor = null;
    protected Color mSelectedColor = null;
    protected float mAlpha = 1.0f;
    protected double mX = -1.0;
    protected double mY = -1.0;
    protected double mW = -1.0;
    protected double mH = -1.0;
    protected boolean mRelativeCoords = true;
    protected boolean mIsVisible = true;
    protected boolean mIsSelected = false;
    protected boolean mIsSelectable = false;
    protected Object mUserData = null;

    public abstract void draw(Graphics2D var1);

    public abstract double getMinX();

    public abstract double getMaxX();

    public abstract double getMinY();

    public abstract double getMaxY();

    public abstract boolean contains(double var1, double var3);

    public MScanPlottable(MScanPlotArea plotArea, int type, boolean relative) {
        this.mPlotArea = plotArea;
        this.mType = type;
        this.mFaceColor = this.mPlotArea.getPlotColor();
        this.mSelectedColor = this.mPlotArea.getSelectedColor();
        this.mRelativeCoords = relative;
    }

    public MScanPlottable(MScanPlotArea plotArea, int type) {
        this(plotArea, type, true);
    }

    public void setPlotArea(MScanPlotArea mPlotArea) {
        this.mPlotArea = mPlotArea;
    }

    public void setPlot(MScanPlot plot) {
        this.mPlot = plot;
    }

    public void setType(int type) {
        this.mType = type;
    }

    public void setId(String id) {
        this.mId = id;
    }

    public void setIndex(int mIndex) {
        this.mIndex = mIndex;
    }

    public void setVisible(boolean visible) {
        this.mIsVisible = visible;
    }

    public void setSelected(boolean selected) {
        this.mIsSelected = this.mIsSelectable && selected;
    }

    public void setSelectable(boolean selectable) {
        this.mIsSelectable = selectable;
        if (!this.mIsSelectable) {
            this.mIsSelected = false;
        }
    }

    public void setLineWidth(float width) {
        this.mLineWidth = width;
    }

    public void setFaceColor(Color faceColor) {
        this.mFaceColor = faceColor;
    }

    public void setEdgeColor(Color edgeColor) {
        this.mEdgeColor = edgeColor;
    }

    public void setSelectedColor(Color selectedColor) {
        this.mSelectedColor = selectedColor;
    }

    public void setAlpha(float alpha) {
        this.mAlpha = alpha;
    }

    public void setPosX(double x) {
        this.mX = x;
    }

    public void setPosY(double y) {
        this.mY = y;
    }

    public void setWidth(double w) {
        this.mW = w;
    }

    public void setHeight(double h) {
        this.mH = h;
    }

    public void setUserData(Object userData) {
        this.mUserData = userData;
    }

    public void setProperties(MScanPlot plot) {
        this.setFaceColor(plot.mFaceColor);
        this.setEdgeColor(plot.mEdgeColor);
        this.setSelectedColor(plot.mSelectedColor);
        this.setAlpha(plot.mAlpha);
        this.setLineWidth(plot.mLineWidth);
        this.setSelectable(plot.mIsSelectable);
    }

    public MScanPlotArea getPlotArea() {
        return this.mPlotArea;
    }

    public MScanPlot getPlot() {
        return this.mPlot;
    }

    public int getType() {
        return this.mType;
    }

    public String getId() {
        return this.mId;
    }

    public int getIndex() {
        return this.mIndex;
    }

    public boolean isVisible() {
        return this.mIsVisible;
    }

    public boolean isSelected() {
        return this.mIsSelectable && this.mIsSelected;
    }

    public boolean isSelectable() {
        return this.mIsSelectable;
    }

    public Color getFaceColor() {
        return this.mFaceColor;
    }

    public Color getEdgeColor() {
        return this.mEdgeColor;
    }

    public Color getSelectedColor() {
        return this.mSelectedColor;
    }

    public float getLineWidth() {
        return this.mLineWidth;
    }

    public float getAlpha() {
        return this.mAlpha;
    }

    public double getPosX() {
        return this.mX;
    }

    public double getPosY() {
        return this.mY;
    }

    public double getWidth() {
        return this.mW;
    }

    public double getHeight() {
        return this.mH;
    }

    public Object getUserData() {
        return this.mUserData;
    }

    public MScanPlottable getClickedObject(double x, double y) {
        if (this.isVisible() && this.isSelectable() && this.contains(x, y)) {
            return this;
        }
        return null;
    }
}

