/*
 * Decompiled with CFR 0.152.
 */
package mscanlib.plots;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Line2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import mscanlib.plots.MScanAxis;
import mscanlib.plots.MScanPlot;
import mscanlib.plots.MScanPlotAreaDefaults;
import mscanlib.plots.MScanPlotException;
import mscanlib.plots.MScanPlotListener;
import mscanlib.plots.MScanPlottable;
import mscanlib.plots.MScanTextLabel;
import mscanlib.plots.io.ImageTools;
import mscanlib.plots.io.MScanPlotFileWriter;
import mscanlib.plots.math.MathFun;
import mscanlib.plots.ui.MScanPlotFileChooser;

public abstract class MScanPlotArea
extends JPanel
implements MouseMotionListener,
MouseListener,
ActionListener {
    protected BufferedImage mImage = null;
    protected Graphics2D mImageG2D = null;
    protected int mPanelWidth = -1;
    protected int mPanelHeight = -1;
    protected int mPlotWidth = -1;
    protected int mPlotHeight = -1;
    protected double mMinX = -1.0;
    protected double mMaxX = -1.0;
    protected double mStepX = -1.0;
    protected double mMinY = -1.0;
    protected double mMaxY = 1.0;
    protected double mStepY = -1.0;
    protected double mRangeMarginX = 0.05;
    protected double mRangeMarginY = 0.05;
    protected MScanAxis xAxis = null;
    protected MScanAxis yAxis = null;
    protected Color[] mPlotColors = MScanPlotAreaDefaults.PLOT_COLORS;
    protected int mPlotColorIndex = 0;
    protected Color mForegroundColor = MScanPlotAreaDefaults.FOREGROUND_COLOR;
    protected Color mBackgroundColor = MScanPlotAreaDefaults.BACKGROUND_COLOR;
    protected Color mSelectedColor = MScanPlotAreaDefaults.SELECTED_COLOR;
    protected int[] mScatterPlotTypes = MScanPlotAreaDefaults.POINT_TYPES;
    protected int mScatterPlotTypeIndex = 0;
    protected Line2D.Double mLine = null;
    protected boolean mDragging = false;
    protected boolean mMoving = true;
    protected float mDraggingXStart = -1.0f;
    protected float mDraggingXStop = -1.0f;
    protected float mDraggingYStart = -1.0f;
    protected float mDraggingYStop = -1.0f;
    protected float mMovingX = -1.0f;
    protected float mMovingY = -1.0f;
    protected float mPressedX = -1.0f;
    protected float mPressedY = -1.0f;
    protected boolean mZoomableX = false;
    protected boolean mZoomableY = false;
    protected boolean mSelfZoomable = true;
    protected Vector<double[][]> mZoomLevel = null;
    protected RoundRectangle2D.Double mZoomRectangle = null;
    protected Color mZoomColor = MScanPlotAreaDefaults.ZOOM_COLOR;
    protected float mZoomAlpha = 0.2f;
    protected boolean mCursorCoordinatesVisible = false;
    protected MScanTextLabel mCursorCoordinatesLabel = null;
    protected RoundRectangle2D.Double mCursorCoordinatesRectangle = null;
    protected Color mCursorCoordinatesColor = MScanPlotAreaDefaults.CURSOR_COORDINATES_COLOR;
    protected float mCursorCoordinatesAlpha = 0.2f;
    protected Font mCursorCoordinatesFont = null;
    protected int mCursorCoordinatesFontSize = 11;
    protected Font mTextFont = null;
    protected int mTextFontSize = 12;
    protected JPopupMenu mPopupMenu = null;
    protected boolean mIsDefaultPopupMenu = true;
    protected boolean mNotifyPopupMenuActions = false;
    protected String mImageDir = ".";
    protected String mImageFile = null;
    protected Vector<MScanPlotListener> mListeners = null;
    protected ArrayList<MScanPlottable> mPlottables = null;
    protected MScanTextLabel mPlotTitle = null;
    protected int mTitleFontSize = 18;

    public abstract void plotImage(Graphics2D var1);

    public MScanPlotArea(int width, int height, boolean fixed) {
        this.xAxis = new MScanAxis(this, 0);
        this.yAxis = new MScanAxis(this, 1);
        this.setPanelSize(width, height, fixed);
        this.mPlottables = new ArrayList();
        this.mLine = new Line2D.Double();
        this.mCursorCoordinatesFont = new Font(UIManager.getFont("Panel.font").getName(), 0, this.mCursorCoordinatesFontSize);
        this.mTextFont = new Font(this.mCursorCoordinatesFont.getName(), 1, this.mTextFontSize);
        this.mCursorCoordinatesRectangle = new RoundRectangle2D.Double();
        this.mZoomRectangle = new RoundRectangle2D.Double();
        this.mCursorCoordinatesLabel = new MScanTextLabel(this, "No text", 0.0, 0.0, false);
        this.mCursorCoordinatesLabel.setTextFont(this.mCursorCoordinatesFont);
        this.mCursorCoordinatesLabel.setFaceColor(this.mCursorCoordinatesColor);
        this.mCursorCoordinatesLabel.setEdgeColor(this.mCursorCoordinatesColor);
        this.mCursorCoordinatesLabel.setAlpha(this.mCursorCoordinatesAlpha);
        this.mCursorCoordinatesLabel.setRound(true);
        this.mListeners = new Vector();
        this.setPopupMenu();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public void repaint() {
        super.repaint();
        if (this.mPanelWidth != this.getWidth() || this.mPanelHeight != this.getHeight()) {
            this.mPanelWidth = this.getWidth();
            this.mPanelHeight = this.getHeight();
            this.updatePlotSize();
            this.updateRanges();
            this.updatePlot();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.mIsDefaultPopupMenu) {
            if (e.getActionCommand().equals("plot_save")) {
                this.saveImage();
            } else if (e.getActionCommand().equals("plot_zoom_in")) {
                this.zoomIn(null);
            } else if (e.getActionCommand().equals("plot_zoom_out")) {
                this.zoomOut(false);
            } else if (e.getActionCommand().equals("plot_zoom_reset")) {
                this.zoomOut(true);
            }
        }
        if (this.mNotifyPopupMenuActions) {
            this.notifyPopupAction(e);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.setMouseDragging(true, this.mPressedX, this.mPressedY, e.getX(), e.getY());
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.setMouseMoving(true, e.getX(), e.getY());
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        MScanPlottable clicked = null;
        double valueX = -1.0;
        double valueY = -1.0;
        if (e.getButton() == 1) {
            this.setMouseMoving(false, e.getX(), e.getY());
            valueX = this.getValueX(e.getX());
            valueY = this.getValueY(e.getY());
            if (this.checkVisible(valueX, valueY)) {
                int i = 0;
                while (i < this.mPlottables.size()) {
                    clicked = this.mPlottables.get(i).getClickedObject(valueX, valueY);
                    if (clicked != null) {
                        this.resetSelected();
                        clicked.setSelected(true);
                        this.updatePlot();
                        this.notifyClicked(clicked);
                        break;
                    }
                    ++i;
                }
            }
        }
        this.maybeShowPopup(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            this.mPressedX = e.getX();
            this.mPressedY = e.getY();
        }
        this.maybeShowPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        float releasedX = e.getX();
        float releasedY = e.getY();
        Object plotRange = null;
        this.setMouseMoving(false, releasedX, releasedY);
        if (e.getButton() == 1 && this.isZoomable()) {
            this.setMouseDragging(false, this.mPressedX, this.mPressedY, releasedX, releasedY);
            if (e.getButton() == 1 && e.getModifiersEx() != 64 && this.mPressedX != -1.0f && this.mPressedX != releasedX) {
                plotRange = new double[][]{{this.mMinX, this.mMaxX}, {this.mMinY, this.mMaxY}};
                if (this.mZoomableX) {
                    plotRange[0][0] = Math.max(this.getValueX(Math.min(this.mPressedX, releasedX)), this.mMinX);
                    plotRange[0][1] = Math.min(this.getValueX(Math.max(this.mPressedX, releasedX)), this.mMaxX);
                }
                if (this.mZoomableX) {
                    plotRange[1][0] = Math.max(this.getValueY(Math.max(this.mPressedY, releasedY)), this.mMinY);
                    plotRange[1][1] = Math.min(this.getValueY(Math.min(this.mPressedY, releasedY)), this.mMaxY);
                }
                this.zoomIn((double[][])plotRange);
            }
            if (e.getButton() == 1 && e.getModifiersEx() == 64) {
                this.zoomOut(false);
            }
            if (e.getButton() == 1 && e.getModifiersEx() == 192) {
                this.zoomOut(true);
            }
        }
        this.maybeShowPopup(e);
        this.mPressedX = -1.0f;
        this.mPressedY = -1.0f;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.mMoving = false;
        this.repaint();
    }

    public double getMinX() {
        return this.mMinX;
    }

    public double getMaxX() {
        return this.mMaxX;
    }

    public double getMinY() {
        return this.mMinY;
    }

    public double getMaxY() {
        return this.mMaxY;
    }

    public double getRangeMarginX() {
        return this.mRangeMarginX;
    }

    public double getRangeMarginY() {
        return this.mRangeMarginY;
    }

    public double[] getRangeX() {
        return new double[]{this.mMinX, this.mMaxX};
    }

    public double[] getRangeY() {
        return new double[]{this.mMinY, this.mMaxY};
    }

    public void setMinX(double minX) {
        this.setRangeX(minX, this.mMaxX);
    }

    public void setMaxX(double maxX) {
        this.setRangeX(this.mMinX, maxX);
    }

    public void setMinY(double minY) {
        this.setRangeY(minY, this.mMaxY);
    }

    public void setMaxY(double maxY) {
        this.setRangeY(this.mMinY, maxY);
    }

    public void setRangeX(double minX, double maxX) {
        this.mMinX = minX;
        this.mMaxX = maxX;
        this.mStepX = (double)this.mPlotWidth / (this.mMaxX - this.mMinX);
    }

    public void setRangeX(double[] rangeX) {
        this.setRangeX(rangeX[0], rangeX[1]);
    }

    public void setRangeY(double minY, double maxY) {
        this.mMinY = minY;
        this.mMaxY = maxY;
        this.mStepY = (double)this.mPlotHeight / (this.mMaxY - this.mMinY);
    }

    public void setRangeY(double[] rangeY) {
        this.setRangeY(rangeY[0], rangeY[1]);
    }

    public void setRange(double[] rangeX, double[] rangeY) {
        this.setRangeX(rangeX[0], rangeX[1]);
        this.setRangeY(rangeY[0], rangeY[1]);
    }

    public void setRange(double[][] range) {
        this.setRange(range[0], range[1]);
    }

    public void setRangeMarginX(double margin) {
        this.mRangeMarginX = margin;
    }

    public void setRangeMarginY(double margin) {
        this.mRangeMarginY = margin;
    }

    public void updateRanges() {
        MScanPlottable plottable = null;
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        double w = -1.0;
        double h = -1.0;
        int i = 0;
        while (i < this.mPlottables.size()) {
            plottable = this.mPlottables.get(i);
            if (plottable.isVisible()) {
                if (plottable.getMinX() < minX) {
                    minX = plottable.getMinX();
                }
                if (plottable.getMaxX() > maxX) {
                    maxX = plottable.getMaxX();
                }
                if (plottable.getMinY() < minY) {
                    minY = plottable.getMinY();
                }
                if (plottable.getMaxY() > maxY) {
                    maxY = plottable.getMaxY();
                }
            }
            ++i;
        }
        if (!(Double.isInfinite(minX) || Double.isInfinite(maxX) || Double.isInfinite(minY) || Double.isInfinite(maxY))) {
            if (maxX == minX) {
                maxX = minX + 1.0;
            } else {
                w = maxX - minX;
                maxX += this.mRangeMarginX * w;
                minX -= this.mRangeMarginX * w;
            }
            this.setRangeX(minX, maxX);
            if (maxY == minY) {
                maxY = minY + 1.0;
            } else {
                h = maxY - minY;
                maxY += this.mRangeMarginY * h;
                minY -= this.mRangeMarginY * h;
            }
            this.setRangeY(minY, maxY);
        } else {
            this.setRangeX(0.0, 100.0);
            this.setRangeY(0.0, 100.0);
        }
    }

    public int getPanelWidth() {
        return this.mPanelWidth;
    }

    public int getPanelHeight() {
        return this.mPanelHeight;
    }

    public int getPlotWidth() {
        return this.mPlotWidth;
    }

    public int getPlotHeight() {
        return this.mPlotHeight;
    }

    public int getXAxisOffset() {
        return this.xAxis.getmAxisOffset();
    }

    public int getYAxisOffset() {
        return this.yAxis.getmAxisOffset();
    }

    public int getXAxisMargin() {
        return this.xAxis.getmAxisMargin();
    }

    public int getYAxisMargin() {
        return this.yAxis.getmAxisMargin();
    }

    public void setPanelSize(int width, int height, boolean fixed) {
        this.mPanelWidth = width;
        this.mPanelHeight = height;
        this.mPlotWidth = this.mPanelWidth - this.yAxis.getmAxisOffset() - this.yAxis.getmAxisMargin();
        this.mPlotHeight = this.mPanelHeight - this.xAxis.getmAxisOffset() - this.xAxis.getmAxisMargin();
        this.setPreferredSize(new Dimension(this.mPanelWidth, this.mPanelHeight));
        if (fixed) {
            this.setMaximumSize(this.getPreferredSize());
            this.setMinimumSize(this.getPreferredSize());
        }
        this.setSize(this.getPreferredSize());
        this.initImage();
    }

    public void updatePlotSize() {
        this.mPlotWidth = this.mPanelWidth - this.yAxis.getmAxisOffset() - this.yAxis.getmAxisMargin();
        this.mPlotHeight = this.mPanelHeight - this.xAxis.getmAxisOffset() - this.xAxis.getmAxisMargin();
    }

    public void setPlotSize(int width, int height) {
        this.mPlotWidth = width;
        this.mPlotHeight = height;
        this.mStepX = (double)this.mPlotWidth / (this.mMaxX - this.mMinX);
        this.mStepY = (double)this.mPlotHeight / (this.mMaxY - this.mMinY);
    }

    public void setScaleSize(int width, int height) {
        this.xAxis.setOffset(height);
        this.yAxis.setOffset(width);
    }

    public void setScaleMargin(int margin) {
        this.xAxis.setMargin(margin);
        this.yAxis.setMargin(margin);
    }

    public void setGrid(boolean grid) {
        this.xAxis.setGrid(grid);
        this.yAxis.setGrid(grid);
    }

    public void setGridColor(Color color) {
        this.xAxis.setGridColor(color);
        this.yAxis.setGridColor(color);
    }

    public void setBox(boolean box) {
        this.xAxis.setBoxAxes(box);
        this.yAxis.setBoxAxes(box);
    }

    public void setLabelX(String label) {
        this.xAxis.setLabel(label);
    }

    public void setLabelY(String label) {
        this.yAxis.setLabel(label);
    }

    public void addPlottable(MScanPlottable plottable, boolean updateRanges) {
        this.mPlottables.add(plottable);
        if (plottable.getFaceColor().equals(this.mPlotColors[this.mPlotColorIndex]) && MScanPlot.class.isInstance(plottable)) {
            this.nextPlotColor();
        }
        if (updateRanges) {
            this.updateRanges();
        }
    }

    public void resetPlottables() {
        this.mPlottables = new ArrayList();
        this.updateRanges();
        this.resetPlotColor();
        this.resetScatterPlotType();
    }

    public void resetPlot() {
        this.resetPlottables();
        this.updatePlot();
    }

    public void redrawPlottables(ArrayList<MScanPlottable> plottables, Graphics2D g2d) {
        if (plottables != null) {
            int i = 0;
            while (i < plottables.size()) {
                plottables.get(i).draw(g2d);
                ++i;
            }
        }
    }

    public void redrawPlottables(Graphics2D g2d) {
        this.redrawPlottables(this.mPlottables, g2d);
    }

    public void resetSelected() {
        int i = 0;
        while (i < this.mPlottables.size()) {
            this.mPlottables.get(i).setSelected(false);
            ++i;
        }
    }

    public double getX(double valueX) {
        return (valueX - this.mMinX) * this.mStepX + (double)this.yAxis.getmAxisOffset();
    }

    public double getY(double valueY) {
        return (this.mMaxY - valueY) * this.mStepY + (double)this.xAxis.getmAxisMargin();
    }

    public double getValueX(double x) {
        return (x - (double)this.yAxis.getmAxisOffset()) / this.mStepX + this.mMinX;
    }

    public double getValueY(double y) {
        return this.mMaxY - (y - (double)this.xAxis.getmAxisMargin()) / this.mStepY;
    }

    public double scaleX(double value) {
        return value * this.mStepX;
    }

    public double scaleY(double value) {
        return value * this.mStepY;
    }

    public double getWidth(double width) {
        return this.scaleX(width);
    }

    public double getHeight(double height) {
        return this.scaleY(height);
    }

    public double scaleValueX(double value) {
        return value / this.mStepX;
    }

    public double scaleValueY(double value) {
        return value / this.mStepY;
    }

    public boolean checkVisible(double x, double y) {
        return x >= this.mMinX && x <= this.mMaxX && y >= this.mMinY && y <= this.mMaxY;
    }

    public boolean checkVisibleX(double x) {
        return x >= this.mMinX && x <= this.mMaxX;
    }

    public boolean checkVisibleRangeX(double[] x) {
        boolean result = true;
        if (x[1] < this.mMinX || x[0] > this.mMaxX) {
            result = false;
        } else if (x[0] < this.mMinX && x[1] > this.mMinX) {
            x[0] = this.mMinX;
        } else if (x[0] < this.mMaxX && x[1] > this.mMaxX) {
            x[1] = this.mMaxX;
        }
        return result;
    }

    public boolean checkVisibleY(double y) {
        return y >= this.mMinY && y <= this.mMaxY;
    }

    public boolean checkVisibleRangeY(double[] y) {
        boolean result = true;
        if (y[1] < this.mMinY || y[0] > this.mMaxY) {
            result = false;
        } else if (y[0] < this.mMinY && y[1] > this.mMinY) {
            y[0] = this.mMinY;
        } else if (y[0] < this.mMaxY && y[1] > this.mMaxY) {
            y[1] = this.mMaxY;
        }
        return result;
    }

    public boolean checkVisibleRange(double[] x, double[] y) {
        return this.checkVisibleRangeX(x) && this.checkVisibleRangeX(y);
    }

    public Font getAxisFont() {
        return this.xAxis.getmAxisFont();
    }

    public int getAxisFontSize() {
        return this.xAxis.getmAxisFontSize();
    }

    public Font getTextFont() {
        return this.mTextFont;
    }

    public int getTextFontSize() {
        return this.mTextFontSize;
    }

    public Rectangle getTextBounds(String str, FontRenderContext fontRenderContext, Font font) {
        TextLayout textLayout = null;
        Shape textOutline = null;
        Rectangle textBounds = null;
        textLayout = new TextLayout(str, font, fontRenderContext);
        textOutline = textLayout.getOutline(null);
        textBounds = textOutline.getBounds();
        return textBounds;
    }

    public Rectangle getTextBounds(String str, Font font) {
        return this.getTextBounds(str, this.mImageG2D.getFontRenderContext(), font);
    }

    public double getTextWidth(String str, FontRenderContext fontRenderContext, Font font) {
        return this.getTextBounds(str, fontRenderContext, font).getWidth();
    }

    public double getTextWidth(String str, Font font) {
        return this.getTextWidth(str, this.mImageG2D.getFontRenderContext(), font);
    }

    public double getTextHeight(String str, FontRenderContext fontRenderContext, Font font) {
        return this.getTextBounds(str, fontRenderContext, font).getHeight();
    }

    public double getTextHeight(String str, Font font) {
        return this.getTextHeight(str, this.mImageG2D.getFontRenderContext(), font);
    }

    public Color getForegroundColor() {
        return this.mForegroundColor;
    }

    public Color getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public Color getSelectedColor() {
        return this.mSelectedColor;
    }

    public void resetPlotColor() {
        this.mPlotColorIndex = 0;
    }

    public void resetScatterPlotType() {
        this.mScatterPlotTypeIndex = 0;
    }

    public Color getPlotColor() {
        return this.mPlotColors[this.mPlotColorIndex];
    }

    public void nextPlotColor() {
        ++this.mPlotColorIndex;
        this.mPlotColorIndex %= this.mPlotColors.length;
    }

    public Color[] getPlotColors() {
        return this.mPlotColors;
    }

    public void nextScatterPlotType() {
        ++this.mScatterPlotTypeIndex;
        this.mScatterPlotTypeIndex %= this.mScatterPlotTypes.length;
    }

    public int getScatterPlotType() {
        int index = this.mScatterPlotTypeIndex;
        this.nextScatterPlotType();
        return index;
    }

    public BufferedImage getImage() {
        return this.mImage;
    }

    protected void initImage() {
        this.mImage = new BufferedImage(this.mPanelWidth, this.mPanelHeight, 1);
        this.mImageG2D = this.mImage.createGraphics();
        this.mImageG2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.clearPlot(this.mImageG2D);
    }

    public Graphics2D getGraphics2D() {
        return this.mImageG2D;
    }

    protected void createImage() {
        this.initImage();
        this.plotImage(this.mImageG2D);
    }

    public void updatePlot() {
        this.updatePlot(false);
    }

    public void updatePlot(boolean resetZoomLevel) {
        if (resetZoomLevel) {
            this.resetZoomLevel();
        }
        this.createImage();
        this.repaint();
    }

    public void clearPlot(Graphics2D g2d) {
        g2d.setColor(this.mBackgroundColor);
        g2d.fillRect(0, 0, this.mImage.getWidth(), this.mImage.getHeight());
    }

    protected void plotAxes(Graphics2D g2d) {
        this.xAxis.draw(g2d);
        this.yAxis.draw(g2d);
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = null;
        double valueX = -1.0;
        double valueY = -1.0;
        g2d = (Graphics2D)g;
        super.paintComponent(g2d);
        if (this.mImage != null) {
            g2d.drawImage(this.mImage, null, 0, 0);
            if (this.isZoomable() && this.mDragging) {
                this.plotZoomRectangle(g2d);
            }
            if (this.cursorCoordinatesVisible() && this.mMoving) {
                double d;
                valueX = this.getValueX(this.mMovingX);
                if (d >= this.mMinX && valueX <= this.mMaxX) {
                    double d2;
                    valueY = this.getValueY(this.mMovingY);
                    if (d2 >= this.mMinY && valueY <= this.mMaxY) {
                        this.plotCoordinatesRectangle(g2d, valueX, valueY);
                    }
                }
            }
        }
    }

    private void plotZoomRectangle(Graphics2D g2d) {
        g2d.setColor(this.mZoomColor);
        g2d.setComposite(AlphaComposite.getInstance(3, this.mZoomAlpha));
        this.mZoomRectangle.setRoundRect(Math.min(this.mDraggingXStart, this.mDraggingXStop), Math.min(this.mDraggingYStart, this.mDraggingYStop), Math.abs(this.mDraggingXStart - this.mDraggingXStop), Math.abs(this.mDraggingYStart - this.mDraggingYStop), 10.0, 10.0);
        g2d.fill(this.mZoomRectangle);
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
    }

    public boolean isZoomable() {
        return this.mZoomableX || this.mZoomableY;
    }

    public boolean isZoomableX() {
        return this.mZoomableX;
    }

    public boolean isZoomableY() {
        return this.mZoomableY;
    }

    public boolean isSelfZoomable() {
        return this.mSelfZoomable;
    }

    public void setZoomable(boolean zoomableX, boolean zoomableY, boolean selfZoomable) {
        this.setZoomable(zoomableX, zoomableY);
        this.setSelfZoomable(selfZoomable);
    }

    public void setZoomable(boolean zoomableX, boolean zoomableY) {
        this.mZoomableX = zoomableX;
        this.mZoomableY = zoomableY;
    }

    public void setSelfZoomable(boolean selfZoomable) {
        this.mSelfZoomable = selfZoomable;
    }

    public void resetZoomLevel() {
        this.mZoomLevel = new Vector();
        this.mZoomLevel.add(new double[][]{{this.mMinX, this.mMaxX}, {this.mMinY, this.mMaxY}});
    }

    public void prevZoomLevel(boolean fullRange) {
        if (this.mZoomLevel.size() > 1) {
            this.mZoomLevel.remove(this.mZoomLevel.size() - 1);
        }
        if (fullRange) {
            int i = this.mZoomLevel.size() - 1;
            while (i > 0) {
                this.mZoomLevel.remove(this.mZoomLevel.size() - 1);
                --i;
            }
        }
        this.setRange(this.mZoomLevel.get(this.mZoomLevel.size() - 1));
    }

    public void nextZoomLevel(double[][] plotRange) {
        double w = this.mMaxX - this.mMinX;
        double h = this.mMaxY - this.mMinY;
        if (plotRange == null) {
            plotRange = new double[][]{{this.mMinX + 0.25 * w, this.mMinX + 0.75 * w}, {this.mMinY + 0.25 * h, this.mMinY + 0.75 * h}};
        }
        if (!this.mZoomableX) {
            plotRange[0] = new double[]{this.mMinX, this.mMaxX};
        }
        if (!this.mZoomableY) {
            plotRange[1] = new double[]{this.mMinY, this.mMaxY};
        }
        this.setRange((double[][])plotRange);
        this.mZoomLevel.add((double[][])plotRange);
    }

    public void zoomOut(boolean fullRange) {
        this.prevZoomLevel(fullRange);
        this.notifyZoomed();
        if (this.mSelfZoomable) {
            this.updatePlot();
        }
    }

    public void zoomIn(double[][] plotRange) {
        this.nextZoomLevel(plotRange);
        this.notifyZoomed();
        if (this.mSelfZoomable) {
            this.updatePlot();
        }
    }

    public boolean cursorCoordinatesVisible() {
        return this.mCursorCoordinatesVisible;
    }

    public void setCursorCoordinatesVisible(boolean visible) {
        this.mCursorCoordinatesVisible = visible;
    }

    public void plotCoordinatesRectangle(Graphics2D g2d, double valueX, double valueY) {
        this.mCursorCoordinatesLabel.setText(this.getCursorText(valueX, "X: ", 4));
        this.mCursorCoordinatesLabel.addTextLine(this.getCursorText(valueY, "Y: ", 4));
        this.mCursorCoordinatesLabel.setPosX(this.mMovingX + 4.0f);
        this.mCursorCoordinatesLabel.setPosY((double)this.mMovingY + this.mCursorCoordinatesLabel.getHeight() + 4.0);
        this.mCursorCoordinatesLabel.draw(g2d);
    }

    public String getCursorText(double value, String label, int precision) {
        StringBuffer str = null;
        str = label != null ? new StringBuffer(label) : new StringBuffer("");
        str.append(MathFun.toPrecision(value, precision));
        return str.toString();
    }

    public void setMouseMoving(boolean moving) {
        this.mMoving = moving;
    }

    public void setMouseMoving(boolean moving, float x, float y) {
        this.mMoving = moving;
        this.mMovingX = x;
        this.mMovingY = y;
        this.repaint();
    }

    public void setMouseDragging(boolean dragging, float xStart, float yStart, float xStop, float yStop) {
        if (xStart >= 0.0f && yStart >= 0.0f) {
            this.mDragging = dragging;
            this.mDraggingXStart = xStart;
            this.mDraggingXStop = xStop;
            this.mDraggingYStart = yStart;
            this.mDraggingYStop = yStop;
        } else {
            this.mDragging = false;
        }
        this.repaint();
    }

    public JPopupMenu getPopupMenu() {
        return this.mPopupMenu;
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        this.mPopupMenu = popupMenu;
        this.mIsDefaultPopupMenu = false;
        this.mNotifyPopupMenuActions = true;
    }

    public void setPopupMenu() {
        this.mPopupMenu = this.getDefaultPopupMenu();
        this.mIsDefaultPopupMenu = true;
        this.mNotifyPopupMenuActions = false;
    }

    private JPopupMenu getDefaultPopupMenu() {
        JPopupMenu popupMenu = null;
        JMenuItem menuItem = null;
        JMenu menu = null;
        popupMenu = new JPopupMenu();
        menu = new JMenu("Zoom...");
        popupMenu.add(menu);
        menuItem = new JMenuItem("Zoom in", ImageTools.getImageIcon("zoomin"));
        menuItem.setActionCommand("plot_zoom_in");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new JMenuItem("Zoom out", ImageTools.getImageIcon("zoomout"));
        menuItem.setActionCommand("plot_zoom_out");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Reset zoom", ImageTools.getImageIcon("zoomout_full"));
        menuItem.setActionCommand("plot_zoom_reset");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        popupMenu.addSeparator();
        menuItem = new JMenuItem("Save plot", ImageTools.getImageIcon("save"));
        menuItem.setActionCommand("plot_save");
        menuItem.addActionListener(this);
        popupMenu.add(menuItem);
        return popupMenu;
    }

    public void setNotifyPopupActions(boolean notify) {
        this.mNotifyPopupMenuActions = notify;
    }

    public boolean getNotifyPopupActions() {
        return this.mNotifyPopupMenuActions;
    }

    protected void maybeShowPopup(MouseEvent e) {
        if (this.mPopupMenu != null && e.isPopupTrigger()) {
            this.preparePopup();
            this.mPopupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    protected void preparePopup() {
        JMenu zoomMenu = null;
        if (this.mPopupMenu != null) {
            if (this.mIsDefaultPopupMenu) {
                zoomMenu = (JMenu)this.mPopupMenu.getComponent(0);
            } else {
                int i = 0;
                while (i < this.mPopupMenu.getComponentCount()) {
                    if (this.mPopupMenu.getComponent(i) instanceof JMenu && ((JMenu)this.mPopupMenu.getComponent(i)).getText().equals("Zoom...")) {
                        zoomMenu = (JMenu)this.mPopupMenu.getComponent(i);
                        break;
                    }
                    ++i;
                }
            }
            if (zoomMenu != null) {
                zoomMenu.setEnabled(this.isZoomable());
                if (this.isZoomable() && this.mZoomLevel != null && zoomMenu.getItemCount() == 4) {
                    zoomMenu.getMenuComponent(1).setEnabled(this.mZoomLevel.size() > 1);
                    zoomMenu.getMenuComponent(3).setEnabled(this.mZoomLevel.size() > 1);
                }
            }
        }
    }

    public Vector<MScanPlotListener> getPlotListeners() {
        return this.mListeners;
    }

    public void addPlotListeners(Vector<MScanPlotListener> listeners) {
        if (listeners != null) {
            int i = 0;
            while (i < listeners.size()) {
                this.mListeners.add(listeners.get(i));
                ++i;
            }
        }
    }

    public void addPlotListener(MScanPlotListener listener) {
        if (listener != null) {
            this.mListeners.add(listener);
        }
    }

    public void removePlotListener(MScanPlotListener listener) {
        if (this.mListeners.indexOf(listener) != -1) {
            this.mListeners.remove(listener);
        }
    }

    protected void notifyClicked(MScanPlottable plottable) {
        int i = 0;
        while (i < this.mListeners.size()) {
            this.mListeners.get(i).plotClicked(this, plottable.getPlot(), plottable);
            ++i;
        }
    }

    protected void notifyZoomed() {
        int i = 0;
        while (i < this.mListeners.size()) {
            this.mListeners.get(i).plotZoomed(this);
            ++i;
        }
    }

    protected void notifyResized() {
        int i = 0;
        while (i < this.mListeners.size()) {
            this.mListeners.get(i).plotResized(this);
            ++i;
        }
    }

    protected void notifyError(MScanPlotException mpe) {
        int i = 0;
        while (i < this.mListeners.size()) {
            this.mListeners.get(i).plotError(this, mpe);
            ++i;
        }
    }

    protected void notifyPopupAction(ActionEvent e) {
        int i = 0;
        while (i < this.mListeners.size()) {
            this.mListeners.get(i).plotPopupAction(this, e);
            ++i;
        }
    }

    public String getImageDir() {
        return this.mImageDir;
    }

    public void setImageDir(String imageDir) {
        this.mImageDir = imageDir;
    }

    public String getImageFile() {
        return this.mImageFile;
    }

    public void setImageFile(String imageFile) {
        this.mImageFile = imageFile;
    }

    public void saveImage() {
        MScanPlotFileChooser fileChooser = null;
        fileChooser = this.mImageFile == null ? MScanPlotFileWriter.getFileChooser(this.mImageDir, 0) : MScanPlotFileWriter.getFileChooser(this.mImageDir, this.mImageFile, 0);
        if (fileChooser.showSaveDialog(this) == 0) {
            try {
                MScanPlotFileWriter.saveImage(fileChooser.getSelectedFileWithExt().getPath(), fileChooser.getFileFormat(), this);
                this.mImageDir = fileChooser.getSelectedFileWithExt().getParent();
            }
            catch (MScanPlotException mse) {
                this.notifyError(mse);
            }
        }
    }

    public void setPlotTitle(String title) {
        if (title == null) {
            return;
        }
        this.mPlotTitle = new MScanTextLabel(this, title, 0.0, 0.0, false, 3);
        this.mPlotTitle.setTextFont(new Font(UIManager.getFont("Panel.font").getName(), 0, this.mTitleFontSize));
        this.mPlotTitle.setPosY(this.mPlotTitle.getRealHeight() + 5.0);
        this.addPlottable(this.mPlotTitle, true);
        if ((double)this.xAxis.getmAxisMargin() < this.mPlotTitle.getRealHeight()) {
            this.xAxis.setMargin(this.xAxis.getmAxisMargin() + (int)this.mPlotTitle.getRealHeight());
        }
    }
}

