/*
 * Decompiled with CFR 0.152.
 */
package mscanlib.plots;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.UIManager;
import mscanlib.plots.MScanAxisTick;
import mscanlib.plots.MScanPlotArea;
import mscanlib.plots.MScanPlotAreaDefaults;
import mscanlib.plots.MScanPlottable;
import mscanlib.plots.MScanTextLabel;
import mscanlib.plots.math.MathFun;

public class MScanAxis
extends MScanPlottable {
    public static final int ORIENTATION_HORIZONTAL = 0;
    public static final int ORIENTATION_VERTICAL = 1;
    private int mAxisOrientation;
    private int mAxisOffset;
    private int mAxisMargin = 10;
    private Font mAxisFont = null;
    private int mAxisFontSize = 10;
    private int mAxisTickSize = 5;
    private boolean mBoxAxes = false;
    private boolean mAutoUpdate = true;
    private Color mAxisColor = MScanPlotAreaDefaults.AXES_COLOR;
    private ArrayList<MScanAxisTick> mTickLabels;
    private HashMap<Integer, String> mTickLabelValues;
    private MScanTextLabel mAxisLabel = null;
    private double mAxisLabelSize = 0.0;
    private boolean mAxisMaxTickDigitsCheck = true;
    private int mAxisMaxTickDigits = 3;
    private boolean mGrid = false;
    private Color mGridColor = MScanPlotAreaDefaults.GRID_COLOR;

    public MScanAxis(MScanPlotArea plotArea, int axisOrientation) {
        super(plotArea, 4, false);
        this.mAxisOrientation = axisOrientation;
        this.mAxisOffset = this.mAxisOrientation == 0 ? 20 : 35;
        this.mAxisFont = new Font(UIManager.getFont("Panel.font").getName(), 0, this.mAxisFontSize);
        this.mTickLabels = new ArrayList();
        this.mTickLabelValues = new HashMap();
    }

    @Override
    public void draw(Graphics2D g2d) {
        this.generateAxisTicks();
        Line2D.Double axesLine = new Line2D.Double();
        g2d.setColor(this.mAxisColor);
        g2d.setStroke(new BasicStroke(1.0f, 1, 1));
        if (this.mAxisOrientation == 0) {
            axesLine.setLine(this.mPlotArea.getX(this.mPlotArea.getMinX()), this.mPlotArea.getY(this.mPlotArea.getMinY()), this.mPlotArea.getX(this.mPlotArea.getMaxX()), this.mPlotArea.getY(this.mPlotArea.getMinY()));
            g2d.draw(axesLine);
            if (this.mBoxAxes) {
                axesLine.setLine(this.mPlotArea.getX(this.mPlotArea.getMinX()), this.mPlotArea.getY(this.mPlotArea.getMaxY()), this.mPlotArea.getX(this.mPlotArea.getMaxX()), this.mPlotArea.getY(this.mPlotArea.getMaxY()));
                g2d.draw(axesLine);
            }
        } else {
            axesLine.setLine(this.mPlotArea.getX(this.mPlotArea.getMinX()), this.mPlotArea.getY(this.mPlotArea.getMinY()), this.mPlotArea.getX(this.mPlotArea.getMinX()), this.mPlotArea.getY(this.mPlotArea.getMaxY()));
            g2d.draw(axesLine);
            if (this.mBoxAxes) {
                axesLine.setLine(this.mPlotArea.getX(this.mPlotArea.getMaxX()), this.mPlotArea.getY(this.mPlotArea.getMinY()), this.mPlotArea.getX(this.mPlotArea.getMaxX()), this.mPlotArea.getY(this.mPlotArea.getMaxY()));
                g2d.draw(axesLine);
            }
        }
        if (this.mAxisLabel != null) {
            this.updateLabel();
            this.mAxisLabel.draw(g2d);
        }
        this.plotAxisTicks(g2d, axesLine);
        if (this.mGrid) {
            this.plotGrid(g2d, axesLine);
        }
    }

    @Override
    public double getMinX() {
        return 0.0;
    }

    @Override
    public double getMaxX() {
        return 0.0;
    }

    @Override
    public double getMinY() {
        return 0.0;
    }

    @Override
    public double getMaxY() {
        return 0.0;
    }

    @Override
    public boolean contains(double x, double y) {
        return false;
    }

    public int getmAxisOffset() {
        return this.mAxisOffset;
    }

    public int getmAxisMargin() {
        return this.mAxisMargin;
    }

    public Font getmAxisFont() {
        return this.mAxisFont;
    }

    public int getmAxisFontSize() {
        return this.mAxisFontSize;
    }

    public boolean ismAxisMaxTickDigitsCheck() {
        return this.mAxisMaxTickDigitsCheck;
    }

    public int getmAxisTickSize() {
        return this.mAxisTickSize;
    }

    public boolean ismBoxAxes() {
        return this.mBoxAxes;
    }

    public boolean ismAutoUpdate() {
        return this.mAutoUpdate;
    }

    public Color getmAxisColor() {
        return this.mAxisColor;
    }

    public ArrayList<MScanAxisTick> getmTickLabels() {
        return this.mTickLabels;
    }

    public HashMap<Integer, String> getmTickLabelValues() {
        return this.mTickLabelValues;
    }

    public MScanTextLabel getmAxisLabel() {
        return this.mAxisLabel;
    }

    public double getmAxisLabelSize() {
        return this.mAxisLabelSize;
    }

    public int getmAxisMaxTickDigits() {
        return this.mAxisMaxTickDigits;
    }

    public int getmAxisOrientation() {
        return this.mAxisOrientation;
    }

    public void addLabelValue(int coordinate, String value) {
        this.mTickLabelValues.put(coordinate, value);
    }

    public void setOffset(int offset) {
        this.mAxisOffset = offset;
    }

    public void setMargin(int margin) {
        this.mAxisMargin = margin;
    }

    public void setColor(Color color) {
        this.mAxisColor = color;
    }

    public void setGridColor(Color color) {
        this.mGridColor = color;
    }

    public void setGrid(boolean grid) {
        this.mGrid = grid;
    }

    public void setmAxisMaxTickDigits(int mAxisMaxTickDigits) {
        this.mAxisMaxTickDigits = mAxisMaxTickDigits;
    }

    public void setmAxisMaxTickDigitsCheck(boolean mAxisMaxTickDigitsCheck) {
        this.mAxisMaxTickDigitsCheck = mAxisMaxTickDigitsCheck;
    }

    public void setLabel(String label) {
        if (label != null && label.length() > 0) {
            if (this.mAxisOrientation == 0) {
                this.mAxisLabel = new MScanTextLabel(this.mPlotArea, label, 0.0, 0.0, false);
                this.updateLabel();
                this.mAxisLabelSize = this.mAxisLabel.getRealHeight();
            } else {
                this.mAxisLabel = new MScanTextLabel(this.mPlotArea, label, 0.0, 0.0, false);
                this.mAxisLabel.setOrientation(1);
                this.updateLabel();
                this.mAxisLabelSize = this.mAxisLabel.getRealWidth();
            }
            if ((double)this.mAxisOffset < 2.5 * this.mAxisLabelSize) {
                this.mAxisOffset = (int)(2.5 * this.mAxisLabelSize);
            }
            this.mPlotArea.updatePlotSize();
        } else {
            this.mAxisLabelSize = 0.0;
            this.mAxisLabel = null;
            this.mAxisOffset = this.mAxisOrientation == 0 ? 20 : 35;
            this.mPlotArea.updatePlotSize();
        }
    }

    protected void updateLabel() {
        if (this.mAxisOrientation == 0) {
            this.mAxisLabel.setPosY(this.mPlotArea.getHeight() - 5);
            this.mAxisLabel.setPosX(((double)(this.mPlotArea.getWidth() - this.mAxisOffset) - this.mAxisLabel.getRealWidth()) / 2.0 + (double)this.mAxisOffset);
        } else {
            this.mAxisLabel.setPosY(((double)(this.mPlotArea.getHeight() - this.mAxisOffset) + this.mAxisLabel.getRealHeight()) / 2.0);
            this.mAxisLabel.setPosX(0.0);
        }
    }

    public void setBoxAxes(boolean boxAxes) {
        this.mBoxAxes = boxAxes;
    }

    public void setAutoUpdate(boolean autoUpdate) {
        this.mAutoUpdate = autoUpdate;
    }

    protected void generateAxisTicks() {
        double exponentValue = -1.0;
        double maxValue = -1.0;
        double tickValue = -1.0;
        double tickPosition = -1.0;
        int exponent = -1;
        String labelText = null;
        MScanTextLabel label = null;
        this.mTickLabels.clear();
        if (this.mAxisOrientation == 0) {
            exponent = (int)Math.floor(Math.log((this.mPlotArea.getMaxX() - this.mPlotArea.getMinX()) / 2.0) / Math.log(10.0));
            exponentValue = Math.pow(10.0, exponent);
            tickValue = Math.ceil(this.mPlotArea.getMinX() / exponentValue) * exponentValue;
            maxValue = Math.floor(this.mPlotArea.getMaxX() / exponentValue) * exponentValue;
            while (tickValue <= maxValue) {
                tickPosition = this.mPlotArea.getX(tickValue);
                int posX = (int)tickPosition;
                int posY = (int)this.mPlotArea.getY(this.mPlotArea.getMinY()) + this.mAxisTickSize;
                MScanAxisTick tick = new MScanAxisTick();
                if (this.mTickLabelValues.size() == 0) {
                    if (this.mAxisMaxTickDigitsCheck) {
                        int digits = 1;
                        if (tickValue != 0.0) {
                            digits = (int)Math.abs(Math.log10(Math.abs(MathFun.toPrecision(tickValue, 1)))) + 1;
                        }
                        if (digits > this.mAxisMaxTickDigits) {
                            double man = MathFun.toPrecision(tickValue / Math.pow(10.0, digits - 1), 1);
                            labelText = String.valueOf(man) + "E" + (digits - 1);
                        } else {
                            labelText = exponent >= 0 ? String.valueOf((int)tickValue) : String.valueOf(MathFun.toPrecision(tickValue, -1 * exponent));
                        }
                    } else {
                        labelText = exponent >= 0 ? String.valueOf((int)tickValue) : String.valueOf(MathFun.toPrecision(tickValue, -1 * exponent));
                    }
                    label = new MScanTextLabel(this.mPlotArea, labelText, posX, posY, false);
                    label.setTextFont(this.mAxisFont);
                    posX = (int)((double)posX - label.getWidth() / 2.0);
                    posY = (int)((double)posY + ((double)this.mAxisFontSize + 5.0));
                    label.setPosX(posX);
                    label.setPosY(posY);
                    label.setAlpha(0.2f);
                    tick.setLabel(label);
                    tick.setTickPosition((int)tickPosition);
                    this.mTickLabels.add(tick);
                    tickValue += exponentValue;
                    continue;
                }
                maxValue = this.mPlotArea.getMaxX();
                tickValue = Math.rint(tickValue);
                tickPosition = this.mPlotArea.getX(tickValue);
                labelText = this.mTickLabelValues.get((int)tickValue);
                if (labelText == null) {
                    tickValue += 1.0;
                    continue;
                }
                label = new MScanTextLabel(this.mPlotArea, labelText, posX, posY, false);
                label.setOrientation(2);
                label.setTextFont(this.mAxisFont);
                posX = (int)(tickPosition - label.getWidth() * 0.7071);
                posY = (int)((double)posY + (label.getWidth() * 0.7071 + 5.0));
                label.setPosX(posX);
                label.setPosY(posY);
                label.setAlpha(0.2f);
                tick.setLabel(label);
                tick.setTickPosition((int)tickPosition);
                this.mTickLabels.add(tick);
                if (!(exponentValue < 1.0)) {
                    tickValue = Math.max(tickValue + 1.0, this.mPlotArea.getValueX(tickPosition + label.getWidth() * 0.7071));
                    continue;
                }
                break;
            }
        } else {
            exponent = (int)Math.floor(Math.log((this.mPlotArea.getMaxY() - this.mPlotArea.getMinY()) / 2.0) / Math.log(10.0));
            exponentValue = Math.pow(10.0, exponent);
            tickValue = Math.ceil(this.mPlotArea.getMinY() / exponentValue) * exponentValue;
            maxValue = Math.floor(this.mPlotArea.getMaxY() / exponentValue) * exponentValue;
            while (tickValue <= maxValue) {
                tickPosition = this.mPlotArea.getY(tickValue);
                int posX = (int)this.mPlotArea.getX(this.mPlotArea.getMinX()) - this.mAxisTickSize;
                int posY = (int)tickPosition;
                MScanAxisTick tick = new MScanAxisTick();
                if (this.mTickLabelValues.size() == 0) {
                    if (this.mAxisMaxTickDigitsCheck) {
                        int digits = 1;
                        if (tickValue != 0.0) {
                            digits = (int)Math.abs(Math.log10(Math.abs(MathFun.toPrecision(tickValue, 1)))) + 1;
                        }
                        if (digits > this.mAxisMaxTickDigits) {
                            double man = MathFun.toPrecision(tickValue / Math.pow(10.0, digits - 1), 1);
                            labelText = String.valueOf(man) + "E" + (digits - 1);
                        } else {
                            labelText = exponent >= 0 ? String.valueOf((int)tickValue) : String.valueOf(MathFun.toPrecision(tickValue, -1 * exponent));
                        }
                    } else {
                        labelText = exponent >= 0 ? String.valueOf((int)tickValue) : String.valueOf(MathFun.toPrecision(tickValue, -1 * exponent));
                    }
                    label = new MScanTextLabel(this.mPlotArea, labelText, posX, posY, false);
                    label.setTextFont(this.mAxisFont);
                    posX = (int)((double)posX - label.getWidth());
                    posY = (int)((double)posY + label.getHeight() / 2.0);
                    label.setPosX(posX);
                    label.setPosY(posY);
                    tick.setLabel(label);
                    tick.setTickPosition((int)tickPosition);
                    this.mTickLabels.add(tick);
                    tickValue += exponentValue;
                    continue;
                }
                maxValue = this.mPlotArea.getMaxY();
                tickValue = Math.rint(tickValue);
                tickPosition = this.mPlotArea.getY(tickValue);
                labelText = this.mTickLabelValues.get((int)tickValue);
                if (labelText == null) {
                    tickValue += 1.0;
                    continue;
                }
                label = new MScanTextLabel(this.mPlotArea, labelText, posX, posY, false);
                label.setTextFont(this.mAxisFont);
                posX = (int)((double)posX - label.getWidth());
                posY = (int)((double)posY + label.getHeight() / 2.0);
                label.setPosX(posX);
                label.setPosY(posY);
                tick.setLabel(label);
                tick.setTickPosition((int)tickPosition);
                this.mTickLabels.add(tick);
                if (!(exponentValue < 1.0)) {
                    tickValue = Math.max(tickValue + 1.0, this.mPlotArea.getValueY(tickPosition - label.getHeight() * 0.7071));
                    continue;
                }
                break;
            }
        }
    }

    protected void plotAxisTicks(Graphics2D g2d, Line2D.Double axesLine) {
        FontRenderContext fontRenderContext = null;
        g2d.setFont(this.mAxisFont);
        fontRenderContext = g2d.getFontRenderContext();
        int newOffset = 0;
        if (this.mAxisOrientation == 0) {
            int i = 0;
            while (i < this.mTickLabels.size()) {
                MScanTextLabel label = this.mTickLabels.get(i).getLabel();
                int position = this.mTickLabels.get(i).getTickPosition();
                newOffset = (int)Math.max(label.getRealHeight() + (double)this.mAxisTickSize + 10.0 + this.mAxisLabelSize, (double)this.mAxisOffset);
                label.draw(g2d);
                axesLine.setLine(position, this.mPlotArea.getY(this.mPlotArea.getMinY()), position, this.mPlotArea.getY(this.mPlotArea.getMinY()) + (double)this.mAxisTickSize);
                g2d.draw(axesLine);
                ++i;
            }
        } else if (this.mAxisOrientation == 1) {
            int i = 0;
            while (i < this.mTickLabels.size()) {
                MScanTextLabel label = this.mTickLabels.get(i).getLabel();
                int position = this.mTickLabels.get(i).getTickPosition();
                newOffset = (int)Math.max(label.getRealWidth() + (double)this.mAxisTickSize + 10.0 + this.mAxisLabelSize, (double)this.mAxisOffset);
                label.draw(g2d);
                axesLine.setLine(this.mPlotArea.getX(this.mPlotArea.getMinX()) - (double)this.mAxisTickSize - 1.0, position, this.mPlotArea.getX(this.mPlotArea.getMinX()) - 1.0, position);
                g2d.draw(axesLine);
                ++i;
            }
        }
        if (this.mAutoUpdate && newOffset > this.mAxisOffset) {
            this.mAxisOffset = newOffset;
            this.mPlotArea.updatePlotSize();
            this.mPlotArea.updateRanges();
            this.mPlotArea.updatePlot();
        }
    }

    protected void plotGrid(Graphics2D g2d, Line2D.Double axesLine) {
        block3: {
            block2: {
                BasicStroke s = (BasicStroke)g2d.getStroke();
                BasicStroke ns = new BasicStroke(s.getLineWidth(), s.getEndCap(), s.getLineJoin(), s.getMiterLimit(), new float[]{1.0f, 5.0f}, 0.0f);
                g2d.setStroke(ns);
                g2d.setColor(this.mGridColor);
                if (this.mAxisOrientation != 0) break block2;
                int i = 0;
                while (i < this.mTickLabels.size()) {
                    int position = this.mTickLabels.get(i).getTickPosition();
                    axesLine.setLine(position, this.mPlotArea.getY(this.mPlotArea.getMinY()), position, this.mPlotArea.getY(this.mPlotArea.getMaxY()));
                    g2d.draw(axesLine);
                    ++i;
                }
                break block3;
            }
            if (this.mAxisOrientation != 1) break block3;
            int i = 0;
            while (i < this.mTickLabels.size()) {
                int position = this.mTickLabels.get(i).getTickPosition();
                axesLine.setLine(this.mPlotArea.getX(this.mPlotArea.getMinX()) - 1.0, position, this.mPlotArea.getX(this.mPlotArea.getMaxX()) - 1.0, position);
                g2d.draw(axesLine);
                ++i;
            }
        }
    }
}

