/*
 * Decompiled with CFR 0.152.
 */
package math;

import gui.Logger;
import java.util.ArrayList;
import math.ResizableArrayList;
import math.ResizableIntArrayList;

public class Sort {
    public static void heapSort(ResizableIntArrayList T) {
        if (T.size() == 0) {
            return;
        }
        int n = T.size();
        int k = n / 2;
        while (k > 0) {
            Sort.heapRestore(T, k, n);
            --k;
        }
        do {
            int swap = T.get(0);
            T.set(0, T.get(n - 1));
            T.set(n - 1, swap);
            Sort.heapRestore(T, 1, --n);
        } while (n > 1);
    }

    private static void heapRestore(ResizableIntArrayList T, int k, int n) {
        int i = T.get(k - 1);
        while (k <= n / 2) {
            int j = 2 * k;
            if (j < n && T.get(j - 1) < T.get(j)) {
                ++j;
            }
            if (i >= T.get(j - 1)) break;
            T.set(k - 1, T.get(j - 1));
            k = j;
        }
        T.set(k - 1, i);
    }

    public static int[] indexedHeapSort(int[] T) {
        int n = T.length;
        int[] index = new int[n];
        int i = 0;
        while (i < n) {
            index[i] = i;
            ++i;
        }
        int k = n / 2;
        while (k > 0) {
            Sort.indexedHeapRestore(T, index, k, n);
            --k;
        }
        do {
            int swap = T[0];
            T[0] = T[n - 1];
            T[n - 1] = swap;
            swap = index[0];
            index[0] = index[n - 1];
            index[n - 1] = swap;
            Sort.indexedHeapRestore(T, index, 1, --n);
        } while (n > 1);
        return index;
    }

    private static void indexedHeapRestore(double[] T, int[] index, int k, int n) {
        double i = T[k - 1];
        int ind = index[k - 1];
        while (k <= n / 2) {
            int j = 2 * k;
            if (j < n && T[j - 1] < T[j]) {
                ++j;
            }
            if (i >= T[j - 1]) break;
            T[k - 1] = T[j - 1];
            index[k - 1] = index[j - 1];
            k = j;
        }
        T[k - 1] = i;
        index[k - 1] = ind;
    }

    public static int[] indexedHeapSort(double[] T) {
        int n = T.length;
        int[] index = new int[n];
        int i = 0;
        while (i < n) {
            index[i] = i;
            ++i;
        }
        int k = n / 2;
        while (k > 0) {
            Sort.indexedHeapRestore(T, index, k, n);
            --k;
        }
        do {
            double swapd = T[0];
            T[0] = T[n - 1];
            T[n - 1] = swapd;
            int swapi = index[0];
            index[0] = index[n - 1];
            index[n - 1] = swapi;
            Sort.indexedHeapRestore(T, index, 1, --n);
        } while (n > 1);
        return index;
    }

    public static double[] reorder(double[] T, int[] index) {
        int n = T.length;
        double[] ordered = new double[n];
        int i = 0;
        while (i < n) {
            ordered[i] = T[index[i]];
            ++i;
        }
        return ordered;
    }

    private static void indexedHeapRestore(int[] T, int[] index, int k, int n) {
        int i = T[k - 1];
        int ind = index[k - 1];
        while (k <= n / 2) {
            int j = 2 * k;
            if (j < n && T[j - 1] < T[j]) {
                ++j;
            }
            if (i >= T[j - 1]) break;
            T[k - 1] = T[j - 1];
            index[k - 1] = index[j - 1];
            k = j;
        }
        T[k - 1] = i;
        index[k - 1] = ind;
    }

    public static int[] indexedHeapSort(ResizableIntArrayList T) {
        int n = T.size();
        int[] index = new int[n];
        int i = 0;
        while (i < n) {
            index[i] = i;
            ++i;
        }
        int k = n / 2;
        while (k > 0) {
            Sort.indexedHeapRestore(T, index, k, n);
            --k;
        }
        do {
            int swap = T.get(0);
            T.set(0, T.get(n - 1));
            T.set(n - 1, swap);
            swap = index[0];
            index[0] = index[n - 1];
            index[n - 1] = swap;
            Sort.indexedHeapRestore(T, index, 1, --n);
        } while (n > 1);
        return index;
    }

    private static void indexedHeapRestore(ResizableIntArrayList T, int[] index, int k, int n) {
        int i = T.get(k - 1);
        int ind = index[k - 1];
        while (k <= n / 2) {
            int j = 2 * k;
            if (j < n && T.get(j - 1) < T.get(j)) {
                ++j;
            }
            if (i >= T.get(j - 1)) break;
            T.set(k - 1, T.get(j - 1));
            index[k - 1] = index[j - 1];
            k = j;
        }
        T.set(k - 1, i);
        index[k - 1] = ind;
    }

    public static ResizableIntArrayList reorder(ResizableIntArrayList T, int[] index) {
        int n = T.size();
        ResizableIntArrayList ordered = new ResizableIntArrayList(n);
        int i = 0;
        while (i < n) {
            ordered.add(T.get(index[i]));
            ++i;
        }
        return ordered;
    }

    public static ResizableArrayList reorder(ResizableArrayList T, int[] index) {
        int n = T.size();
        ResizableArrayList ordered = new ResizableArrayList(n);
        int i = 0;
        while (i < n) {
            ordered.add(T.get(index[i]));
            ++i;
        }
        return ordered;
    }

    public static ArrayList reorder(ArrayList T, int[] index) {
        int n = T.size();
        ArrayList ordered = new ArrayList(n);
        int i = 0;
        while (i < n) {
            ordered.add(T.get(index[i]));
            ++i;
        }
        return ordered;
    }

    public synchronized void heapSortTableMultithreaded(ResizableIntArrayList[] T, int cores) {
        int[] sizes = new int[T.length];
        int i = 0;
        while (i < T.length) {
            sizes[i] = T[i].size();
            ++i;
        }
        int[] indexes = Sort.indexedHeapSort(sizes);
        SortThread[] sortThread = new SortThread[cores];
        Thread[] thread = new Thread[cores];
        int threadCount = 0;
        int i2 = indexes.length - 1;
        while (i2 >= 0) {
            if (threadCount < cores) {
                sortThread[threadCount] = new SortThread(T[indexes[i2]]);
                thread[threadCount] = new Thread(sortThread[threadCount]);
                thread[threadCount].start();
                ++threadCount;
            } else {
                int j = 0;
                while (j < threadCount) {
                    try {
                        thread[j].join();
                    }
                    catch (Exception e) {
                        Logger.writeExceptionLog(e);
                    }
                    ++j;
                }
                threadCount = 0;
                sortThread[threadCount] = new SortThread(T[indexes[i2]]);
                thread[threadCount] = new Thread(sortThread[threadCount]);
                thread[threadCount].run();
                ++threadCount;
            }
            --i2;
        }
        i2 = 0;
        while (i2 < threadCount) {
            try {
                thread[i2].join();
            }
            catch (Exception e) {
                Logger.writeExceptionLog(e);
            }
            ++i2;
        }
    }

    class SortThread
    implements Runnable {
        private ResizableIntArrayList T;

        public SortThread(ResizableIntArrayList T) {
            this.T = T;
        }

        @Override
        public void run() {
            Sort.heapSort(this.T);
        }
    }
}

