/*
 * Decompiled with CFR 0.152.
 */
package math;

import java.util.Arrays;

public class ResizableIntArrayList {
    private int[] array;
    private int pointer;
    private int size;
    private int initialSize;

    public ResizableIntArrayList(int initialSize) {
        this.array = new int[initialSize];
        this.pointer = 0;
        this.size = initialSize;
        this.initialSize = initialSize;
    }

    public void add(int element) {
        if (this.pointer >= this.size) {
            if (this.size == 0) {
                int[] newArray = new int[this.initialSize];
                this.array = newArray;
                this.size = this.initialSize;
            } else {
                int[] newArray = new int[2 * this.size];
                int i = 0;
                while (i < this.size) {
                    newArray[i] = this.array[i];
                    ++i;
                }
                this.array = newArray;
                this.size *= 2;
            }
        }
        this.array[this.pointer] = element;
        ++this.pointer;
    }

    public void remove(int index) {
        int i = index + 1;
        while (i < this.size) {
            this.array[i - 1] = this.array[i];
            ++i;
        }
        --this.size;
        if (this.pointer > index) {
            --this.pointer;
        }
    }

    public void set(int index, int element) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.array[index] = element;
    }

    public int get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.array[index];
    }

    public void trim() {
        if (this.pointer < this.array.length) {
            int[] newArray = new int[this.pointer];
            int i = 0;
            while (i < this.pointer) {
                newArray[i] = this.array[i];
                ++i;
            }
            this.array = newArray;
            this.size = this.pointer;
        }
    }

    public void clear() {
        this.pointer = 0;
    }

    public int size() {
        return this.pointer;
    }

    public ResizableIntArrayList copy() {
        ResizableIntArrayList newList = new ResizableIntArrayList(this.size);
        int i = 0;
        while (i < this.size) {
            newList.add(this.array[i]);
            ++i;
        }
        return newList;
    }

    public String toString() {
        return Arrays.toString(this.array);
    }

    public static void main(String[] args) {
        ResizableIntArrayList array = new ResizableIntArrayList(5);
        int i = 0;
        while (i < 13) {
            array.add(i + 1);
            System.out.println(String.valueOf(i + 1) + " " + array);
            ++i;
        }
        array.trim();
        System.out.println(array);
        array.remove(5);
        array.remove(0);
        System.out.println(array);
        array.trim();
        System.out.println(array);
        array.add(14);
        System.out.println(array);
        array.trim();
        System.out.println(array);
        System.out.println("Speed test");
        ResizableIntArrayList a = new ResizableIntArrayList(1000);
        long time = System.currentTimeMillis();
        int i2 = 0;
        while (i2 < 10000000) {
            a.add(i2);
            ++i2;
        }
        time = System.currentTimeMillis() - time;
        System.out.println("inserting: " + time + "ms");
        time = System.currentTimeMillis();
        i2 = 0;
        while (i2 < 10000000) {
            a.get(i2);
            ++i2;
        }
        time = System.currentTimeMillis() - time;
        System.out.println("getting: " + time + "ms");
        time = System.currentTimeMillis();
        i2 = 0;
        while (i2 < 100000) {
            a.remove(i2);
            ++i2;
        }
        time = System.currentTimeMillis() - time;
        System.out.println("removing: " + time + "ms");
    }
}

