/*
 * Decompiled with CFR 0.152.
 */
package math;

import java.util.Arrays;

public class ResizableArrayList<T> {
    private T[] array;
    private int pointer;
    private int size;
    private int initialSize;

    public ResizableArrayList(int initialSize) {
        this.array = new Object[initialSize];
        this.pointer = 0;
        this.size = initialSize;
        this.initialSize = initialSize;
    }

    public void add(T element) {
        if (this.pointer >= this.size) {
            if (this.size == 0) {
                Object[] newArray = new Object[this.initialSize];
                this.array = newArray;
                this.size = this.initialSize;
            } else {
                Object[] newArray = new Object[2 * this.size];
                int i = 0;
                while (i < this.size) {
                    newArray[i] = this.array[i];
                    ++i;
                }
                this.array = newArray;
                this.size *= 2;
            }
        }
        this.array[this.pointer] = element;
        ++this.pointer;
    }

    public void remove(int index) {
        int i = index + 1;
        while (i < this.size) {
            this.array[i - 1] = this.array[i];
            ++i;
        }
        --this.size;
        if (this.pointer > index) {
            --this.pointer;
        }
    }

    public void set(int index, T element) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.array[index] = element;
    }

    public T get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.array[index];
    }

    public void trim() {
        if (this.pointer < this.array.length) {
            Object[] newArray = new Object[this.pointer];
            int i = 0;
            while (i < this.pointer) {
                newArray[i] = this.array[i];
                ++i;
            }
            this.array = newArray;
            this.size = this.pointer;
        }
    }

    public void clear() {
        this.pointer = 0;
    }

    public int size() {
        return this.pointer;
    }

    public ResizableArrayList copy() {
        ResizableArrayList<T> newList = new ResizableArrayList<T>(this.size);
        int i = 0;
        while (i < this.size) {
            newList.add(this.array[i]);
            ++i;
        }
        return newList;
    }

    public String toString() {
        return Arrays.toString(this.array);
    }

    public static void main(String[] args) {
        ResizableArrayList<String> array = new ResizableArrayList<String>(5);
        int i = 0;
        while (i < 13) {
            array.add("element" + i);
            System.out.println(String.valueOf(i + 1) + " " + array);
            ++i;
        }
        array.trim();
        System.out.println(array);
        array.remove(5);
        array.remove(0);
        System.out.println(array);
        array.trim();
        System.out.println(array);
        array.add("element14");
        System.out.println(array);
        array.trim();
        System.out.println(array);
    }
}

