/*
 * Decompiled with CFR 0.152.
 */
package math;

import java.util.Arrays;
import java.util.HashMap;
import math.LocusInfo;

public class FastResizableIntArrayList {
    private int[] array;
    private int[] index;
    private int pointer;
    private int size;
    private int numElements;
    private int initialSize;

    public FastResizableIntArrayList(int initialSize) {
        this.array = new int[initialSize];
        this.index = new int[initialSize];
        this.pointer = 0;
        this.numElements = 0;
        this.size = initialSize;
        this.initialSize = initialSize;
    }

    public void add(int element) {
        if (this.pointer >= this.size) {
            if (this.size == 0) {
                int[] newArray = new int[this.initialSize];
                int[] newIndex = new int[this.initialSize];
                this.array = newArray;
                this.index = newIndex;
                this.size = this.initialSize;
            } else {
                int[] newArray = new int[2 * this.size];
                int[] newIndex = new int[2 * this.size];
                int i = 0;
                while (i < this.size) {
                    newArray[i] = this.array[i];
                    newIndex[i] = this.index[i];
                    ++i;
                }
                this.array = newArray;
                this.index = newIndex;
                this.size *= 2;
            }
        }
        this.array[this.pointer] = element;
        this.index[this.pointer] = this.pointer;
        ++this.pointer;
        ++this.numElements;
    }

    public void remove(int index) {
        int i = index;
        while (i < this.pointer) {
            int n = i++;
            this.index[n] = this.index[n] + 1;
        }
        --this.numElements;
    }

    public void set(int index, int element) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.array[this.index[index]] = element;
    }

    public int get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.array[this.index[index]];
    }

    public void trim() {
        if (this.pointer < this.array.length) {
            int[] newArray = new int[this.pointer];
            int[] newIndex = new int[this.pointer];
            int i = 0;
            while (i < this.pointer) {
                newArray[i] = this.array[i];
                newIndex[i] = this.index[i];
                ++i;
            }
            this.array = newArray;
            this.index = newIndex;
            this.size = this.pointer;
        }
    }

    public void clear() {
        this.pointer = 0;
        this.numElements = 0;
    }

    public int size() {
        return this.numElements;
    }

    public FastResizableIntArrayList copy() {
        FastResizableIntArrayList newList = new FastResizableIntArrayList(this.numElements);
        int i = 0;
        while (i < this.numElements) {
            newList.add(this.array[this.index[i]]);
            ++i;
        }
        return newList;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("[");
        int i = 0;
        while (i < this.numElements - 1) {
            b.append(String.valueOf(this.array[this.index[i]]) + ", ");
            ++i;
        }
        b.append(String.valueOf(this.array[this.index[this.numElements - 1]]) + "]");
        return b.toString();
    }

    public static void main(String[] args) {
        HashMap<Integer, LocusInfo> m = new HashMap<Integer, LocusInfo>();
        LocusInfo i1 = new LocusInfo();
        LocusInfo i2 = new LocusInfo();
        LocusInfo i3 = new LocusInfo();
        LocusInfo i4 = new LocusInfo();
        i1.setCoordinate(11);
        i2.setCoordinate(2);
        i3.setCoordinate(56);
        i4.setCoordinate(16);
        m.put(i1.getCoordinate(), i1);
        m.put(i2.getCoordinate(), i2);
        m.put(i3.getCoordinate(), i3);
        m.put(i4.getCoordinate(), i4);
        System.out.println(((LocusInfo)m.get(11)).isFiltered());
        System.out.println(((LocusInfo)m.get(2)).isFiltered());
        System.out.println(((LocusInfo)m.get(56)).isFiltered());
        System.out.println(((LocusInfo)m.get(16)).isFiltered());
        System.out.println("*********************");
        Object[] array = m.values().toArray(new LocusInfo[0]);
        Arrays.sort(array);
        int i = 0;
        while (i < array.length) {
            System.out.println(((LocusInfo)array[i]).getCoordinate());
            ++i;
        }
        ((LocusInfo)array[0]).setFiltered(true);
        System.out.println("*********************");
        System.out.println(((LocusInfo)m.get(11)).isFiltered());
        System.out.println(((LocusInfo)m.get(2)).isFiltered());
        System.out.println(((LocusInfo)m.get(56)).isFiltered());
        System.out.println(((LocusInfo)m.get(16)).isFiltered());
    }
}

