/*
 * Decompiled with CFR 0.152.
 */
package io;

import biomart.SpeciesSettings;
import io.TagFileReader;
import io.TagFileReaderListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import math.ProfilerData;
import settings.ExperimentSettings;

public class SamFileReader
implements TagFileReader {
    private boolean forceStop = false;
    private ArrayList<TagFileReaderListener> listeners = new ArrayList();

    @Override
    public void readTags(ExperimentSettings settings, ProfilerData data) throws IOException {
        String line;
        long totalFileLen;
        File tagFile = new File(settings.getBowtieFile());
        BufferedReader reader = new BufferedReader(new FileReader(tagFile));
        int c = 0;
        int t = 0;
        long fileLen = totalFileLen = tagFile.length();
        while ((line = reader.readLine()) != null && line.charAt(0) == '@') {
        }
        if (line == null) {
            return;
        }
        do {
            if (this.forceStop) {
                return;
            }
            fileLen -= (long)line.length();
            int l = 0;
            while (l < this.listeners.size()) {
                this.listeners.get(l).lineRead((int)(fileLen * 100L / totalFileLen));
                ++l;
            }
            String[] lineTab = line.split("\\t");
            if (lineTab.length < 4 || lineTab[2].equals("*") || lineTab[3].equals("*")) continue;
            String cStr = lineTab[2].substring(3);
            c = SpeciesSettings.getChromosomeId(settings.getParams().getSpeciesId(), cStr);
            if (c < 0) continue;
            t = Integer.parseInt(lineTab[3]);
            data.addPosition(c, t);
        } while ((line = reader.readLine()) != null);
        reader.close();
    }

    @Override
    public void addListener(TagFileReaderListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void forceStopReading() {
        this.forceStop = true;
    }
}

