/*
 * Decompiled with CFR 0.152.
 */
package io;

import biomart.SpeciesSettings;
import io.TagFileReader;
import io.TagFileReaderListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import math.ProfilerData;
import settings.ExperimentSettings;

public class BedFileReader
implements TagFileReader {
    private boolean forceStop = false;
    private ArrayList<TagFileReaderListener> listeners = new ArrayList();

    @Override
    public void readTags(ExperimentSettings settings, ProfilerData data) throws IOException {
        String line;
        long totalFileLen;
        File tagFile = new File(settings.getBowtieFile());
        BufferedReader reader = new BufferedReader(new FileReader(tagFile));
        int chrom = -1;
        int startPos = -1;
        int endPos = -1;
        float score = 1.0f;
        long fileLen = totalFileLen = tagFile.length();
        while ((line = reader.readLine()) != null) {
            String[] lineTab = line.split("\t");
            fileLen -= (long)line.length();
            int l = 0;
            while (l < this.listeners.size()) {
                this.listeners.get(l).lineRead((int)(fileLen * 100L / totalFileLen));
                ++l;
            }
            if (lineTab.length < 5) continue;
            chrom = SpeciesSettings.getChromosomeId(settings.getParams().getSpeciesId(), lineTab[0].substring(3));
            startPos = Integer.parseInt(lineTab[1]);
            endPos = Integer.parseInt(lineTab[2]);
            try {
                score = (float)Double.parseDouble(lineTab[4]);
            }
            catch (Exception e) {
                score = Math.abs(startPos - endPos);
            }
            if (score == 0.0f) {
                score = Math.abs(startPos - endPos);
            }
            if (chrom <= -1) continue;
            data.addPosition(chrom, (startPos + endPos) / 2, score);
        }
        reader.close();
    }

    @Override
    public void addListener(TagFileReaderListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void forceStopReading() {
        this.forceStop = true;
    }
}

