/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.XYLociPlot;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import math.MathFun;

public class XYLociPlotInternalFrame
extends JInternalFrame {
    private XYLociPlot plot;

    public XYLociPlotInternalFrame(String name, String path, String title, HashMap<String, Double> profile1, HashMap<String, Double> profile2, String profile1Name, String profile2Name, boolean loglog) {
        super(title, true, true, true, false);
        double[] point;
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        HashMap<String, double[]> points = new HashMap<String, double[]>();
        for (String key : profile1.keySet()) {
            if (!profile2.containsKey(key) || points.containsKey(key)) continue;
            point = new double[]{profile1.get(key), profile2.get(key)};
            points.put(key, point);
        }
        for (String key : profile2.keySet()) {
            if (!profile1.containsKey(key) || points.containsKey(key)) continue;
            point = new double[]{profile1.get(key), profile2.get(key)};
            points.put(key, point);
        }
        double[] x = new double[points.values().size()];
        double[] y = new double[points.values().size()];
        int index = 0;
        Iterator itValues = points.values().iterator();
        HashMap<Point2D, Integer> pointMap = new HashMap<Point2D, Integer>();
        while (itValues.hasNext()) {
            double[] point2 = (double[])itValues.next();
            x[index] = point2[0];
            y[index] = point2[1];
            Point2D.Float p = new Point2D.Float((float)x[index], (float)y[index]);
            if (pointMap.containsKey(p)) {
                Integer i = pointMap.get(p);
                i = i + 1;
                pointMap.put(p, i);
            } else {
                pointMap.put(p, 1);
            }
            ++index;
        }
        this.plot = new XYLociPlot(750, 500, true, path, pointMap, profile1Name, profile2Name, name, loglog);
        this.getContentPane().add((Component)this.plot, c);
        double pearsonCorr = MathFun.corr(x, y);
        c.gridy = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.getContentPane().add((Component)new JLabel("Pearson correlation:  " + pearsonCorr), c);
        double[] xcopy = Arrays.copyOf(x, x.length);
        double[] xranks = new double[x.length];
        if (xcopy.length > 0) {
            Arrays.sort(xcopy);
            int rank = 1;
            HashMap<Double, Integer> ranks = new HashMap<Double, Integer>(x.length);
            ranks.put(xcopy[0], rank);
            int i = 1;
            while (i < xcopy.length) {
                if (xcopy[i] != xcopy[i - 1]) {
                    ranks.put(xcopy[i], ++rank);
                }
                ++i;
            }
            i = 0;
            while (i < x.length) {
                xranks[i] = ((Integer)ranks.get(x[i])).intValue();
                ++i;
            }
        }
        double[] ycopy = Arrays.copyOf(y, y.length);
        double[] yranks = new double[y.length];
        if (ycopy.length > 0) {
            Arrays.sort(ycopy);
            int rank = 1;
            HashMap<Double, Integer> ranks = new HashMap<Double, Integer>(y.length);
            ranks.clear();
            ranks.put(ycopy[0], rank);
            int i = 1;
            while (i < ycopy.length) {
                if (ycopy[i] != ycopy[i - 1]) {
                    ranks.put(ycopy[i], ++rank);
                }
                ++i;
            }
            i = 0;
            while (i < y.length) {
                yranks[i] = ((Integer)ranks.get(y[i])).intValue();
                ++i;
            }
        }
        double spearmanCorr = MathFun.corr(xranks, yranks);
        c.gridy = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.getContentPane().add((Component)new JLabel("Spearman correlation: " + spearmanCorr), c);
        this.pack();
    }
}

