/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.ExperimentDesktop;
import gui.TypesSelectionInternalFrameListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class TypesSelectionInternalFrame
extends JInternalFrame {
    private TypesSelectionInternalFrameListener listener;
    private ArrayList<JCheckBox> checkBoxes;

    public TypesSelectionInternalFrame(ExperimentDesktop parent, String title, HashSet<String> attributes, TypesSelectionInternalFrameListener listener, HashSet<String> filtered) {
        super(title, false, false, false, false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.listener = listener;
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.anchor = 17;
        this.checkBoxes = new ArrayList();
        JPanel typePanel = new JPanel();
        typePanel.setLayout(new GridBagLayout());
        Object[] attrs = attributes.toArray();
        Arrays.sort(attrs);
        int i = 0;
        while (i < attrs.length) {
            String attr = attrs[i].toString();
            JCheckBox box = new JCheckBox(attr);
            if (filtered.contains(attr)) {
                box.setSelected(true);
            }
            this.checkBoxes.add(box);
            typePanel.add((Component)box, c);
            ++c.gridy;
            ++i;
        }
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 4;
        JScrollPane scrollPane = new JScrollPane(typePanel);
        scrollPane.setPreferredSize(new Dimension(500, parent.getHeight() * 2 / 3));
        this.getContentPane().add((Component)scrollPane, c);
        c.anchor = 10;
        JButton selButton = new JButton("Select All");
        selButton.setPreferredSize(new Dimension(100, 25));
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        this.getContentPane().add((Component)selButton, c);
        selButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = 0;
                while (i < TypesSelectionInternalFrame.this.checkBoxes.size()) {
                    ((JCheckBox)TypesSelectionInternalFrame.this.checkBoxes.get(i)).setSelected(true);
                    ++i;
                }
            }
        });
        JButton deselButton = new JButton("Clear All");
        deselButton.setPreferredSize(new Dimension(100, 25));
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        this.getContentPane().add((Component)deselButton, c);
        deselButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = 0;
                while (i < TypesSelectionInternalFrame.this.checkBoxes.size()) {
                    ((JCheckBox)TypesSelectionInternalFrame.this.checkBoxes.get(i)).setSelected(false);
                    ++i;
                }
            }
        });
        JButton okButton = new JButton("OK");
        okButton.setPreferredSize(new Dimension(100, 25));
        c.gridx = 2;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        this.getContentPane().add((Component)okButton, c);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TypesSelectionInternalFrame.this.notifyListeners();
                TypesSelectionInternalFrame.this.setVisible(false);
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setPreferredSize(new Dimension(100, 25));
        c.gridx = 3;
        c.gridy = 1;
        c.gridwidth = 1;
        this.getContentPane().add((Component)cancelButton, c);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TypesSelectionInternalFrame.this.setVisible(false);
            }
        });
        this.pack();
        this.setLocation((parent.getWidth() - this.getWidth()) / 2, (parent.getHeight() - this.getHeight()) / 2);
    }

    public void notifyListeners() {
        ArrayList<String> selected = new ArrayList<String>();
        int i = 0;
        while (i < this.checkBoxes.size()) {
            if (this.checkBoxes.get(i).isSelected()) {
                selected.add(this.checkBoxes.get(i).getText());
            }
            ++i;
        }
        this.listener.attributeSelected(selected);
    }
}

