/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.ProfileScatterPlotListener;
import gui.TablePanel;
import java.util.ArrayList;
import javax.swing.JInternalFrame;
import math.Chi2Test;

public class TestTableInternalFrame
extends JInternalFrame
implements ProfileScatterPlotListener {
    private TablePanel table;
    private int[] types;
    private String[] labels;
    private int controlIndex;

    public TestTableInternalFrame(String[] labels, int[] types, double[][] data, int controlIndex) {
        super("Chi^2 test", false, true, false, false);
        this.controlIndex = controlIndex;
        this.labels = labels;
        this.types = types;
        this.table = new TablePanel(new String[]{"ID", "Name", "p-value"}, types);
        this.getContentPane().add(this.table);
        if (data != null) {
            this.profileChanged(data);
        }
    }

    @Override
    public void profileChanged(double[][] data) {
        double[] pValue = new double[data.length];
        int i = 0;
        while (i < pValue.length) {
            pValue[i] = Chi2Test.chi2TestWithHistogram(data[this.controlIndex], data[i]);
            ++i;
        }
        ArrayList<String[]> dataList = new ArrayList<String[]>();
        int i2 = 0;
        while (i2 < data.length) {
            String[] tab = new String[]{"" + (i2 + 1), this.labels[i2], "" + pValue[i2]};
            dataList.add(tab);
            ++i2;
        }
        this.table.setData(dataList);
        this.pack();
    }
}

