/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.PackableScatterPlot;
import java.awt.Color;
import java.awt.Cursor;
import java.io.File;
import java.util.ArrayList;
import math.MathFun;
import mscanlib.plots.MScanLinePlot;
import mscanlib.plots.MScanScatterPlot;
import mscanlib.plots.MScanTextLabel;
import mscanlib.plots.math.IndexedHSort;

public class TagHistogramScatterPlot
extends PackableScatterPlot {
    private String imageDir = null;
    private static final Color POINT_COLOR = Color.blue;
    private static final Color OUTLIER_COLOR = Color.red;
    private static final Color SELECTED_COLOR = Color.green;
    private boolean fitPlotVisible = false;
    private double[][] px;
    private double[][] py;
    private ArrayList<MScanScatterPlot> scatterPlots = null;
    private ArrayList<MScanLinePlot> fitPlots = null;
    private String[] labels = null;
    private String experimentName;
    private boolean setRange;
    private int minX;
    private int maxX;
    private boolean scale;

    public TagHistogramScatterPlot(String ID, int loci_len, String experimentPath, String experimentName, String[] profileNames, double[][] x, double[][] y, String axisXName, String axisYName, String title, boolean setRange, int minX, int maxX, boolean scale) {
        super(750, 500, true);
        int i;
        String name;
        this.setZoomable(true, true, true);
        this.setCursor(new Cursor(1));
        this.setCursorCoordinatesVisible(true);
        this.experimentName = experimentName;
        this.scale = scale;
        if (experimentPath == null) {
            this.imageDir = ".";
        } else {
            try {
                this.imageDir = new File(experimentPath).getParent();
            }
            catch (Exception e) {
                this.imageDir = experimentPath;
            }
        }
        this.setImageDir(this.imageDir);
        this.setRange = setRange;
        this.minX = minX;
        this.maxX = maxX;
        this.scatterPlots = new ArrayList();
        this.fitPlots = new ArrayList();
        if (profileNames.length == 1) {
            name = profileNames[0];
        } else {
            name = "common";
            this.labels = profileNames;
        }
        if (loci_len > 0) {
            this.setImageFile(String.valueOf(experimentName) + "_" + name + "_" + ID + "_len_" + loci_len);
        } else {
            this.setImageFile(String.valueOf(experimentName) + "_" + name + "_" + ID);
        }
        this.resetPlottables();
        this.setPlotTitle(title);
        int yPos = 35;
        if (profileNames.length > 1) {
            i = 0;
            while (i < profileNames.length) {
                String labelText = profileNames[i];
                MScanTextLabel label = new MScanTextLabel(this, labelText, 0.0, 0.0, false, 1);
                label.setAlpha(1.0f);
                label.setTextColor(this.mPlotColors[this.mPlotColorIndex]);
                this.nextPlotColor();
                label.setPosX(15.0);
                label.setPosY(yPos);
                yPos = (int)((double)yPos + (label.getRealHeight() + 5.0));
                this.addPlottable(label, false);
                ++i;
            }
            this.resetPlotColor();
        }
        this.px = x;
        this.py = y;
        i = 0;
        while (i < this.px.length) {
            int[] index = MathFun.setRange(0, this.px[i].length);
            IndexedHSort.sort(this.px[i], index);
            this.py[i] = MathFun.reorder(this.py[i], index, false);
            ++i;
        }
        if (profileNames.length > 1) {
            this.resetPlotColor();
        }
        this.xAxis.setAutoUpdate(false);
        this.xAxis.setBoxAxes(true);
        this.xAxis.setGrid(true);
        this.xAxis.setLabel(axisXName);
        this.yAxis.setBoxAxes(true);
        this.yAxis.setAutoUpdate(true);
        this.yAxis.setGrid(true);
        this.yAxis.setLabel(axisYName);
        int maxBins = this.px[0].length;
        int i2 = 1;
        while (i2 < this.px.length) {
            maxBins = Math.min(this.px[i2].length, maxBins);
            ++i2;
        }
        this.generateHistogram(maxBins);
        this.setFitPlotVisible(this.fitPlotVisible);
    }

    @Override
    public void setFitPlotVisible(boolean visible) {
        this.fitPlotVisible = visible;
        int i = 0;
        while (i < this.fitPlots.size()) {
            this.fitPlots.get(i).setVisible(visible);
            ++i;
        }
        this.updatePlot();
    }

    @Override
    public void binsCountChanged(int bins) {
        this.generateHistogram(bins);
    }

    private void generateHistogram(int bins) {
        this.removePlots();
        this.setPlotTitle(this.experimentName);
        this.setLabels(this.labels);
        int h = 0;
        while (h < this.py.length) {
            double pointsInBin;
            double[] x = new double[bins];
            double[] y = new double[bins];
            double pointsLeft = pointsInBin = 1.0 * (double)this.py[h].length / (double)bins;
            int binIndex = 0;
            int i = 0;
            while (i < this.py[h].length) {
                if (pointsLeft >= 1.0) {
                    int n = binIndex;
                    y[n] = y[n] + this.py[h][i];
                    int n2 = binIndex;
                    x[n2] = x[n2] + this.px[h][i];
                    pointsLeft -= 1.0;
                } else {
                    int n = binIndex;
                    y[n] = y[n] + pointsLeft * this.py[h][i];
                    int n3 = binIndex++;
                    x[n3] = x[n3] + pointsLeft * this.px[h][i];
                    pointsLeft = 1.0 - pointsLeft;
                    if (binIndex >= bins) break;
                    int n4 = binIndex;
                    y[n4] = y[n4] + pointsLeft * this.py[h][i];
                    int n5 = binIndex;
                    x[n5] = x[n5] + pointsLeft * this.px[h][i];
                    pointsLeft = pointsInBin - pointsLeft;
                }
                ++i;
            }
            i = 0;
            while (i < bins) {
                int n = i++;
                x[n] = x[n] / pointsInBin;
            }
            if (this.scale && x.length > 1) {
                double sum = 0.0;
                int i2 = 0;
                while (i2 < x.length - 1) {
                    sum += (y[i2] + y[i2 + 1]) * (x[i2 + 1] - x[i2]) / 2.0;
                    ++i2;
                }
                i2 = 0;
                while (i2 < x.length) {
                    int n = i2++;
                    y[n] = y[n] / sum;
                }
            }
            this.addPlot(x, y);
            ++h;
        }
    }

    public void addPlot(double[] x, double[] y) {
        MScanScatterPlot scatterPlot = new MScanScatterPlot(this, this.getScatterPlotType());
        scatterPlot.setPoints(x, y);
        scatterPlot.setSelectable(false);
        scatterPlot.setEdgeColor(Color.black);
        this.scatterPlots.add(scatterPlot);
        MScanLinePlot fitPlot = new MScanLinePlot(this);
        fitPlot.setLineWidth(2.0f);
        this.fitPlots.add(fitPlot);
        this.addPlottable(scatterPlot, false);
        this.addPlottable(fitPlot, false);
        fitPlot.setPoints(x, y);
        fitPlot.setVisible(this.fitPlotVisible);
        this.updateRanges();
        this.updatePlot();
        this.resetZoomLevel();
        if (this.setRange) {
            this.setRangeX(this.minX, this.maxX);
        } else {
            this.updateRanges();
        }
        this.updatePlot();
    }

    public void removePlots() {
        this.fitPlots.clear();
        this.scatterPlots.clear();
        this.resetPlottables();
    }

    public void setLabels(String[] labels) {
        if (labels == null) {
            return;
        }
        int yPos = 35;
        int i = 0;
        while (i < labels.length) {
            String labelText = labels[i];
            MScanTextLabel label = new MScanTextLabel(this, labelText, 0.0, 0.0, false, 1);
            label.setAlpha(1.0f);
            label.setTextColor(this.mPlotColors[this.mPlotColorIndex]);
            this.nextPlotColor();
            label.setPosX(15.0);
            label.setPosY(yPos);
            yPos = (int)((double)yPos + (label.getRealHeight() + 5.0));
            this.addPlottable(label, false);
            ++i;
        }
        this.resetPlotColor();
    }

    @Override
    public int getMaxBins() {
        int maxBins = this.px[0].length;
        int i = 1;
        while (i < this.px.length) {
            maxBins = Math.min(this.px[i].length, maxBins);
            ++i;
        }
        return maxBins;
    }
}

