/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;

public class TablePanel
extends JPanel
implements MouseListener {
    public static final int TABLE_TYPE_INT = 0;
    public static final int TABLE_TYPE_STRING = 1;
    public static final int TABLE_TYPE_DOUBLE = 2;
    public static final int TABLE_TYPE_MIXED = 3;
    private JTable table;
    private int[] columnTypes;
    private String[] labels;
    private JPopupMenu popupMenu;

    public TablePanel(String[] labels, int[] types) {
        this.columnTypes = types;
        this.labels = labels;
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.table = new JTable();
        this.table.getTableHeader().addMouseListener(this);
        this.table.addMouseListener(this);
        this.popupMenu = new JPopupMenu("tableMenu");
        this.add((Component)new JScrollPane(this.table), c);
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public JTable getTable() {
        return this.table;
    }

    public void setData(ArrayList<String[]> data) {
        Vector<String> columnNames = new Vector<String>();
        int i = 0;
        while (i < this.labels.length) {
            columnNames.add(this.labels[i]);
            ++i;
        }
        Vector rows = new Vector();
        int i2 = 0;
        while (i2 < data.size()) {
            Vector<String> row = new Vector<String>();
            int j = 0;
            while (j < data.get(i2).length) {
                row.add(data.get(i2)[j]);
                ++j;
            }
            rows.add(row);
            ++i2;
        }
        SortableTableModel model = new SortableTableModel(rows, columnNames);
        this.table.setModel(model);
    }

    public void sortTable(int column) {
        boolean ascending = true;
        SortableTableModel model = (SortableTableModel)this.table.getModel();
        if (column == model.getSortedColumn()) {
            ascending = !model.isAscending();
            model.setAscending(ascending);
        } else {
            model.setSortedColumn(column);
            model.setAscending(true);
        }
        Vector<Vector> values = model.getDataVector();
        Collections.sort(values, new SortableTableSorter(column, ascending, this.columnTypes));
        model.fireTableDataChanged();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (JTableHeader.class.isInstance(e.getSource())) {
            JTableHeader tableHeader = (JTableHeader)e.getSource();
            int columnIndex = tableHeader.getColumnModel().getColumnIndexAtX(e.getX());
            this.sortTable(columnIndex);
            return;
        }
        if (SwingUtilities.isRightMouseButton(e)) {
            int row;
            JTable table = (JTable)e.getSource();
            ListSelectionModel model = table.getSelectionModel();
            if (!model.isSelectedIndex(row = table.rowAtPoint(new Point(e.getX(), e.getY())))) {
                model.setSelectionInterval(row, row);
            }
            this.popupMenu.show((JTable)e.getSource(), e.getX(), e.getY());
            return;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    class SortableTableModel
    extends DefaultTableModel {
        private int sortedColumn;
        private boolean ascending;

        public SortableTableModel() {
            this.sortedColumn = -1;
            this.ascending = false;
        }

        public SortableTableModel(int rowCount, int columnCount) {
            super(rowCount, columnCount);
            this.sortedColumn = -1;
            this.ascending = false;
        }

        public SortableTableModel(Object[] columnNames, int rowCount) {
            super(columnNames, rowCount);
            this.sortedColumn = -1;
            this.ascending = false;
        }

        public SortableTableModel(Object[][] data, Object[] columnNames) {
            super(data, columnNames);
            this.sortedColumn = -1;
            this.ascending = false;
        }

        public SortableTableModel(Vector columnNames, int rowCount) {
            super(columnNames, rowCount);
            this.sortedColumn = -1;
            this.ascending = false;
        }

        public SortableTableModel(Vector data, Vector columnNames) {
            super(data, columnNames);
            this.sortedColumn = -1;
            this.ascending = false;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public int getSortedColumn() {
            return this.sortedColumn;
        }

        public void setSortedColumn(int sortedColumn) {
            this.sortedColumn = sortedColumn;
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public void setAscending(boolean ascending) {
            this.ascending = ascending;
        }
    }

    class SortableTableSorter
    implements Comparator<Vector<String>> {
        private int column;
        private boolean ascending;
        private int[] columnTypes;

        public SortableTableSorter(int column, boolean ascending, int[] columnTypes) {
            this.column = column;
            this.ascending = ascending;
            this.columnTypes = columnTypes;
        }

        @Override
        public int compare(Vector<String> o1, Vector<String> o2) {
            if (this.columnTypes[this.column] == 0) {
                Integer i1 = Integer.parseInt(o1.get(this.column));
                Integer i2 = Integer.parseInt(o2.get(this.column));
                if (this.ascending) {
                    return i1.compareTo(i2);
                }
                return -1 * i1.compareTo(i2);
            }
            if (this.columnTypes[this.column] == 1) {
                String s1 = o1.get(this.column);
                String s2 = o2.get(this.column);
                if (this.ascending) {
                    return s1.compareToIgnoreCase(s2);
                }
                return -1 * s1.compareToIgnoreCase(s2);
            }
            if (this.columnTypes[this.column] == 2) {
                Double i1 = Double.parseDouble(o1.get(this.column));
                Double i2 = Double.parseDouble(o2.get(this.column));
                if (this.ascending) {
                    return i1.compareTo(i2);
                }
                return -1 * i1.compareTo(i2);
            }
            try {
                Integer i1 = Integer.parseInt(o1.get(this.column));
                Integer i2 = Integer.parseInt(o2.get(this.column));
                if (this.ascending) {
                    return i1.compareTo(i2);
                }
                return -1 * i1.compareTo(i2);
            }
            catch (Exception e) {
                String s1 = o1.get(this.column);
                String s2 = o2.get(this.column);
                if (this.ascending) {
                    return s1.compareToIgnoreCase(s2);
                }
                return -1 * s1.compareToIgnoreCase(s2);
            }
        }
    }
}

