/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.PackableScatterPlot;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PackableScatterPlotInternalFrame
extends JInternalFrame
implements ChangeListener,
ActionListener {
    private PackableScatterPlot plot;

    public PackableScatterPlotInternalFrame(String name, PackableScatterPlot plot) {
        super(name, true, true, true, false);
        this.plot = plot;
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 3;
        this.getContentPane().add((Component)this.plot, c);
        JSpinner binsSpinner = new JSpinner(new SpinnerNumberModel(plot.getMaxBins(), 1, plot.getMaxBins(), 1));
        binsSpinner.addChangeListener(this);
        JLabel label = new JLabel("# bins: ");
        label.setLabelFor(binsSpinner);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        this.getContentPane().add((Component)label, c);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        this.getContentPane().add((Component)binsSpinner, c);
        JCheckBox lineCheck = new JCheckBox("Line");
        lineCheck.addActionListener(this);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 2;
        c.gridy = 1;
        c.gridwidth = 1;
        this.getContentPane().add((Component)lineCheck, c);
        this.pack();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSpinner spinner = (JSpinner)e.getSource();
        int bins = (Integer)spinner.getValue();
        this.plot.binsCountChanged(bins);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JCheckBox button = (JCheckBox)e.getSource();
        if (button.isSelected()) {
            this.plot.setFitPlotVisible(true);
        } else {
            this.plot.setFitPlotVisible(false);
        }
    }
}

