/*
 * Decompiled with CFR 0.152.
 */
package gui;

import biomart.SpeciesSettings;
import gui.BlockGlassPane;
import gui.BowtieSettingsInternalFrame;
import gui.BowtieSettingsInternalFrameListener;
import gui.CommonLociTableInternalFrame;
import gui.DoubleProfileChooserInternalFrame;
import gui.DoubleProfileChooserInternalFrameListener;
import gui.EmptyTreeCellEditor;
import gui.ExperimentDesktop;
import gui.HistogramChooserInternalFrame;
import gui.HistogramChooserInternalFrameListener;
import gui.Logger;
import gui.PackableScatterPlotInternalFrame;
import gui.ProfileChooserInternalFrame;
import gui.ProfileChooserInternalFrameListener;
import gui.ProfileScatterPlot;
import gui.TableChooserInternalFrame;
import gui.TableChooserInternalFrameListener;
import gui.TagHistogramScatterPlot;
import gui.TestTableInternalFrame;
import gui.XYLociPlotInternalFrame;
import gui.treeNodes.ChromosomeDataTreeNode;
import gui.treeNodes.ChromosomesTreeNode;
import gui.treeNodes.ExperimentTreeNode;
import gui.treeNodes.LociHistogramTreeNode;
import gui.treeNodes.LociTableTreeNode;
import gui.treeNodes.PositionsHistogramTreeNode;
import gui.treeNodes.ProfileFigureTreeNode;
import gui.treeNodes.ReportTreeNode;
import gui.treeNodes.ResultsCatalogTreeNode;
import gui.treeNodes.ResultsTreeNode;
import gui.treeNodes.SettingsTreeNode;
import io.TableFileReader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import math.ChromosomeData;
import math.ExperimentResults;
import math.FigureData;
import org.simplericity.macify.eawt.Application;
import org.simplericity.macify.eawt.ApplicationEvent;
import org.simplericity.macify.eawt.ApplicationListener;
import org.simplericity.macify.eawt.DefaultApplication;
import settings.AppSettings;
import settings.AppSettingsReader;
import settings.AppSettingsWriter;
import settings.ExperimentSettings;
import settings.ExperimentSettingsReader;
import settings.ExperimentSettingsWriter;
import settings.MScanSystemTools;

public class MenuFrame
extends JFrame
implements BowtieSettingsInternalFrameListener,
ProfileChooserInternalFrameListener,
DoubleProfileChooserInternalFrameListener,
TableChooserInternalFrameListener,
HistogramChooserInternalFrameListener,
ApplicationListener {
    private JTree experimentTree;
    private AppSettings appSettings;
    private JSplitPane splitPane;
    private ArrayList<ExperimentDesktop> desktopArray;
    private BowtieSettingsInternalFrame bowtieSettingsFrame;
    private int currentDesktop = -1;
    protected Application mMacifyApplication = null;
    static final String APP_NAME = "jChIP";
    static final String APP_VERSION = "1.2";
    static final String APP_DATE = "10.06.2013";
    static final String APP_INFO = "\n\nKrzysztof Chojnowski 2013\n\nInstitute of Radioelectronics\nWarsaw University of Technology";

    public MenuFrame() {
        if (MScanSystemTools.isMacOS()) {
            this.setMacifyApplication();
        }
        this.setLayout(new BorderLayout());
        this.setGlassPane(new BlockGlassPane());
        this.setTitle(APP_NAME);
        this.setExtendedState(6);
        CloseAppListener closeListener = new CloseAppListener();
        this.addWindowListener(closeListener);
        AppSettingsReader appSettingsReader = new AppSettingsReader(AppSettings.getSettingsFilePath());
        try {
            this.appSettings = appSettingsReader.readAppSettings();
        }
        catch (Exception e) {
            this.appSettings = new AppSettings();
            JOptionPane.showMessageDialog(this, "Error while reading application settings.\nEmpty settings created", "Settings error", 2);
        }
        this.desktopArray = new ArrayList();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        this.experimentTree = new JTree(root);
        JScrollPane scrollPane = new JScrollPane(this.experimentTree);
        scrollPane.setPreferredSize(new Dimension(150, 600));
        this.splitPane = new JSplitPane(1, scrollPane, new JPanel());
        this.add((Component)this.splitPane, "Center");
        int i = 0;
        while (i < this.appSettings.getExperiments().size()) {
            ExperimentSettings e = this.appSettings.getExperimentByIndex(i);
            if (e != null) {
                this.addExperiment(e);
            }
            ++i;
        }
        PopupMenu popup = new PopupMenu(this.experimentTree, this.appSettings, this);
        this.experimentTree.setComponentPopupMenu(popup);
        this.experimentTree.getSelectionModel().setSelectionMode(1);
        this.experimentTree.setCellEditor(new EmptyTreeCellEditor());
        this.experimentTree.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath tp;
                MenuFrame.this.changeDesktop();
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2 && (tp = MenuFrame.this.experimentTree.getPathForLocation(e.getX(), e.getY())) != null) {
                    MenuFrame.this.treeEventHandler();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.experimentTree.setRootVisible(false);
        this.experimentTree.setEditable(true);
        JMenu fileMenu = new JMenu("File");
        JMenuItem addExperimentItem = fileMenu.add(new AddExperimentAction());
        addExperimentItem.setAccelerator(KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        JMenuItem openExperimentItem = fileMenu.add(new OpenExperimentAction());
        openExperimentItem.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        fileMenu.addSeparator();
        if (!MScanSystemTools.isMacOS()) {
            fileMenu.add(new AbstractAction("Exit"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MenuFrame.this.exitApplication();
                }
            });
        }
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        menuBar.add(fileMenu);
        JMenu toolsMenu = new JMenu("Tools");
        JMenuItem showCommonProfileItem = toolsMenu.add(new ShowCommonProfileAction());
        showCommonProfileItem.setAccelerator(KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        JMenuItem showCommonTableItem = toolsMenu.add(new ShowCommonTableAction());
        showCommonTableItem.setAccelerator(KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        JMenuItem showCommonLociHistogramItem = toolsMenu.add(new ShowCommonLociHistogramAction());
        showCommonLociHistogramItem.setAccelerator(KeyStroke.getKeyStroke(73, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        JMenuItem showCommonPositionsHistogramItem = toolsMenu.add(new ShowCommonPositionsHistogramAction());
        showCommonPositionsHistogramItem.setAccelerator(KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        JMenuItem showXYLociPlotItem = toolsMenu.add(new ShowXYLociPlotAction());
        showXYLociPlotItem.setAccelerator(KeyStroke.getKeyStroke(76, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuBar.add(toolsMenu);
        if (!MScanSystemTools.isMacOS()) {
            JMenu helpMenu = new JMenu("Help");
            helpMenu.add(new AbstractAction("About"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MenuFrame.this.showAbout();
                }
            });
            menuBar.add(helpMenu);
        }
    }

    private void addExperiment(ExperimentSettings experimentSettings) {
        if (this.appSettings.getExperimentByName(experimentSettings.getName()) == null) {
            this.appSettings.addExperiment(experimentSettings);
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.experimentTree.getModel().getRoot();
        DefaultTreeModel model = (DefaultTreeModel)this.experimentTree.getModel();
        ExperimentTreeNode experimentNode = new ExperimentTreeNode(experimentSettings.getName(), experimentSettings.getPath(), experimentSettings);
        SettingsTreeNode settingsNode = new SettingsTreeNode();
        experimentNode.add(settingsNode);
        if (experimentSettings.getResults().size() > 0) {
            ResultsCatalogTreeNode resultsSetNode = new ResultsCatalogTreeNode();
            experimentNode.add(resultsSetNode);
            int j = 0;
            while (j < experimentSettings.getResults().size()) {
                ExperimentResults results = experimentSettings.getResults().get(j);
                ResultsTreeNode resultsNode = new ResultsTreeNode(results);
                resultsSetNode.add(resultsNode);
                ProfileFigureTreeNode figureNode = new ProfileFigureTreeNode(new FigureData());
                resultsNode.add(figureNode);
                ReportTreeNode reportNode = new ReportTreeNode();
                resultsNode.add(reportNode);
                LociTableTreeNode lociNode = new LociTableTreeNode();
                resultsNode.add(lociNode);
                LociHistogramTreeNode lociHistNode = new LociHistogramTreeNode();
                resultsNode.add(lociHistNode);
                PositionsHistogramTreeNode posHistNode = new PositionsHistogramTreeNode();
                resultsNode.add(posHistNode);
                if (results.getChromosomes().size() > 0) {
                    ChromosomesTreeNode chromsNode = new ChromosomesTreeNode();
                    resultsNode.add(chromsNode);
                    int k = 0;
                    while (k < results.getChromosomes().size()) {
                        ChromosomeDataTreeNode chromDataNode = new ChromosomeDataTreeNode(results.getChromosomes().get(k));
                        chromsNode.add(chromDataNode);
                        ++k;
                    }
                }
                ++j;
            }
        }
        model.insertNodeInto(experimentNode, root, root.getChildCount());
        if (root.getChildCount() == 1) {
            model.reload();
        }
        ExperimentDesktop desktop = new ExperimentDesktop(this, experimentSettings, experimentNode, model);
        this.desktopArray.add(desktop);
    }

    public void enableGlassPane(boolean enabled) {
        this.getGlassPane().setVisible(enabled);
    }

    public void attachToGlassPane(Component c) {
        ((BlockGlassPane)this.getGlassPane()).add(c);
    }

    public void removeCurrentExperiment() {
        ExperimentDesktop desktop = this.desktopArray.get(this.currentDesktop);
        String name = desktop.getExperimentName();
        ExperimentSettings settings = this.appSettings.getExperimentByName(name);
        ExperimentTreeNode selected = (ExperimentTreeNode)this.experimentTree.getLastSelectedPathComponent();
        try {
            ExperimentSettingsWriter.writeExperimentSettings(settings, String.valueOf(settings.getPath()) + "settings.xml");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
            Logger.writeExceptionLog(e);
        }
        ((DefaultTreeModel)this.experimentTree.getModel()).removeNodeFromParent(selected);
        this.splitPane.setRightComponent(new JPanel());
        this.desktopArray.remove(desktop);
        desktop = null;
        this.appSettings.removeExperiment(settings);
        this.currentDesktop = -1;
        this.repaint();
    }

    private void changeDesktop() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.experimentTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        TreeNode[] treePath = node.getPath();
        int len = treePath.length;
        if (len < 2) {
            return;
        }
        if (this.currentDesktop == -1) {
            int i = 0;
            while (i < this.desktopArray.size()) {
                if (treePath[1].toString().equals(this.desktopArray.get(i).getExperimentName())) {
                    this.currentDesktop = i;
                    int pos = this.splitPane.getDividerLocation();
                    this.splitPane.setRightComponent(this.desktopArray.get(this.currentDesktop));
                    this.splitPane.setDividerLocation(pos);
                    break;
                }
                ++i;
            }
            if (this.currentDesktop == -1) {
                this.splitPane.setRightComponent(new JPanel());
            }
        } else if (!treePath[1].toString().equals(this.desktopArray.get(this.currentDesktop).getExperimentName())) {
            int i = 0;
            while (i < this.desktopArray.size()) {
                this.desktopArray.get(this.currentDesktop).clearData(true);
                if (treePath[1].toString().equals(this.desktopArray.get(i).getExperimentName())) {
                    this.currentDesktop = i;
                    int pos = this.splitPane.getDividerLocation();
                    this.splitPane.setRightComponent(this.desktopArray.get(this.currentDesktop));
                    this.splitPane.setDividerLocation(pos);
                    break;
                }
                ++i;
            }
        }
    }

    private void treeEventHandler() {
        this.changeDesktop();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.experimentTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        TreeNode[] treePath = node.getPath();
        int len = treePath.length;
        if (len > 2) {
            if (node.getClass().getName().equals(SettingsTreeNode.class.getName())) {
                this.desktopArray.get(this.currentDesktop).showSettings();
            } else if (node.getClass().getName().equals(ProfileFigureTreeNode.class.getName())) {
                try {
                    this.desktopArray.get(this.currentDesktop).showFigure((FigureData)node.getUserObject(), (ExperimentResults)((ResultsTreeNode)node.getParent()).getUserObject());
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
                    Logger.writeExceptionLog(e);
                }
            } else if (node.getClass().getName().equals(ReportTreeNode.class.getName())) {
                try {
                    this.desktopArray.get(this.currentDesktop).showReport((ExperimentResults)((ResultsTreeNode)node.getParent()).getUserObject());
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
                    Logger.writeExceptionLog(e);
                }
            } else if (node.getClass().getName().equals(LociTableTreeNode.class.getName())) {
                try {
                    this.desktopArray.get(this.currentDesktop).showLociTable((ExperimentResults)((ResultsTreeNode)node.getParent()).getUserObject());
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
                    Logger.writeExceptionLog(e);
                }
            } else if (node.getClass().getName().equals(LociHistogramTreeNode.class.getName())) {
                try {
                    this.desktopArray.get(this.currentDesktop).showLociTagsHistogram((ExperimentResults)((ResultsTreeNode)node.getParent()).getUserObject());
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
                    Logger.writeExceptionLog(e);
                }
            } else if (node.getClass().getName().equals(PositionsHistogramTreeNode.class.getName())) {
                try {
                    this.desktopArray.get(this.currentDesktop).showPositionTagsHistogram((ExperimentResults)((ResultsTreeNode)node.getParent()).getUserObject());
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
                    Logger.writeExceptionLog(e);
                }
            } else if (node.getClass().getName().equals(ChromosomeDataTreeNode.class.getName())) {
                try {
                    this.desktopArray.get(this.currentDesktop).showChromosome((ChromosomeData)((ChromosomeDataTreeNode)node).getUserObject(), (ExperimentResults)((ResultsTreeNode)node.getParent().getParent()).getUserObject());
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
                    Logger.writeExceptionLog(e);
                }
            }
        }
    }

    private void exitApplication() {
        int answer = JOptionPane.showConfirmDialog(null, "Close application?", "Exit", 0);
        if (answer == 0) {
            try {
                AppSettingsWriter writer = new AppSettingsWriter(AppSettings.getSettingsFilePath());
                writer.writeAppSettings(this.appSettings);
                int i = 0;
                while (i < this.desktopArray.size()) {
                    this.desktopArray.get(i).saveSettings();
                    ++i;
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
                Logger.writeExceptionLog(e);
            }
            System.exit(0);
        }
    }

    private void showAbout() {
        JOptionPane.showMessageDialog(this.splitPane, "jChIP 1.2 (10.06.2013)\n\nKrzysztof Chojnowski 2013\n\nInstitute of Radioelectronics\nWarsaw University of Technology", "About", 1);
    }

    public void setMacifyApplication() {
        this.mMacifyApplication = new DefaultApplication();
        this.mMacifyApplication.addApplicationListener((ApplicationListener)this);
    }

    @Override
    public void frameClosed() {
        this.enableGlassPane(false);
    }

    @Override
    public void profilesChoosen(String ID, ArrayList<Integer> indices, int controlIndex) {
        this.enableGlassPane(false);
        if (indices == null || indices.size() == 0) {
            return;
        }
        ArrayList[] hist = new ArrayList[indices.size()];
        int[] offset = new int[indices.size()];
        String[] labels = new String[indices.size()];
        ExperimentSettings settings = this.desktopArray.get(this.currentDesktop).getExperimentSettings();
        int i = 0;
        while (i < indices.size()) {
            labels[i] = settings.getResults().get(indices.get(i)).getName();
            offset[i] = settings.getResults().get(indices.get(i)).getLocusOffset() - settings.getResults().get(indices.get(i)).getLocusLength() / 2;
            if (indices.get(i) == controlIndex) {
                int n = i;
                labels[n] = String.valueOf(labels[n]) + "_C";
            }
            File f = new File(String.valueOf(settings.getPath()) + settings.getResults().get(indices.get(i)).getFigureFile());
            hist[i] = new ArrayList();
            try {
                String line;
                BufferedReader reader = new BufferedReader(new FileReader(f));
                while ((line = reader.readLine()) != null) {
                    hist[i].add(Double.parseDouble(line));
                }
                reader.close();
            }
            catch (Exception e) {
                Logger.writeExceptionLog(e);
            }
            ++i;
        }
        i = 0;
        while (i < indices.size()) {
            if (controlIndex == indices.get(i)) {
                controlIndex = i;
                break;
            }
            ++i;
        }
        TestTableInternalFrame tableFrame = null;
        if (controlIndex > -1) {
            int[] nArray = new int[3];
            nArray[1] = 1;
            nArray[2] = 2;
            tableFrame = new TestTableInternalFrame(labels, nArray, null, controlIndex);
            this.desktopArray.get(this.currentDesktop).add(tableFrame);
            tableFrame.setBounds(2 * this.getWidth() / 3, 0, tableFrame.getWidth(), tableFrame.getHeight());
            tableFrame.setVisible(true);
        }
        ProfileScatterPlot plot = new ProfileScatterPlot(hist, offset, labels, settings.getName(), settings.getPath(), settings.getName());
        if (tableFrame != null) {
            plot.addListener(tableFrame);
        }
        PackableScatterPlotInternalFrame frame = new PackableScatterPlotInternalFrame(settings.getName(), plot);
        this.desktopArray.get(this.currentDesktop).add(frame);
        frame.setVisible(true);
    }

    @Override
    public void profilesSumChoosen(String ID, ArrayList<Integer> indices) {
        this.enableGlassPane(false);
        if (indices == null || indices.size() == 0) {
            return;
        }
        int[] offset = new int[indices.size()];
        ArrayList[] hist = new ArrayList[]{new ArrayList()};
        ExperimentSettings settings = this.desktopArray.get(this.currentDesktop).getExperimentSettings();
        String[] labels = new String[indices.size()];
        int i = 0;
        while (i < indices.size()) {
            labels[i] = settings.getResults().get(indices.get(i)).getName();
            offset[i] = settings.getResults().get(indices.get(i)).getLocusOffset() - settings.getResults().get(indices.get(i)).getLocusLength() / 2;
            File f = new File(String.valueOf(settings.getPath()) + settings.getResults().get(indices.get(i)).getFigureFile());
            try {
                String line;
                BufferedReader reader = new BufferedReader(new FileReader(f));
                if (i == 0) {
                    while ((line = reader.readLine()) != null) {
                        hist[0].add(Double.parseDouble(line));
                    }
                } else {
                    int index = 0;
                    while ((line = reader.readLine()) != null) {
                        hist[0].set(index, (Double)hist[0].get(index) + Double.parseDouble(line));
                        ++index;
                    }
                }
                reader.close();
            }
            catch (Exception e) {
                Logger.writeExceptionLog(e);
            }
            ++i;
        }
        ProfileScatterPlot plot = new ProfileScatterPlot(hist, offset, labels, settings.getName(), settings.getPath(), settings.getName());
        PackableScatterPlotInternalFrame frame = new PackableScatterPlotInternalFrame(String.valueOf(settings.getName()) + " sum", plot);
        this.desktopArray.get(this.currentDesktop).add(frame);
        frame.setVisible(true);
    }

    @Override
    public void profilesChoosen(String ID, int profile1, int profile2, boolean loglog) {
        this.enableGlassPane(false);
        if (profile1 == -1 || profile2 == -1) {
            return;
        }
        String path = this.desktopArray.get(this.currentDesktop).getExperimentSettings().getPath();
        String g1File = this.desktopArray.get(this.currentDesktop).getExperimentSettings().getResults().get(profile1).getGenesFile();
        String g2File = this.desktopArray.get(this.currentDesktop).getExperimentSettings().getResults().get(profile2).getGenesFile();
        String name1 = this.desktopArray.get(this.currentDesktop).getExperimentSettings().getResults().get(profile1).getName();
        String name2 = this.desktopArray.get(this.currentDesktop).getExperimentSettings().getResults().get(profile2).getName();
        try {
            ArrayList<String[]> g1 = TableFileReader.readTable(String.valueOf(path) + g1File);
            ArrayList<String[]> g2 = TableFileReader.readTable(String.valueOf(path) + g2File);
            HashMap<String, Double> p1 = new HashMap<String, Double>();
            HashMap<String, Double> p2 = new HashMap<String, Double>();
            int i = 0;
            while (i < g1.size()) {
                p1.put(g1.get(i)[1], Double.parseDouble(g1.get(i)[3]));
                ++i;
            }
            i = 0;
            while (i < g2.size()) {
                p2.put(g2.get(i)[1], Double.parseDouble(g2.get(i)[3]));
                ++i;
            }
            XYLociPlotInternalFrame frame = new XYLociPlotInternalFrame(this.desktopArray.get(this.currentDesktop).getExperimentName(), this.desktopArray.get(this.currentDesktop).getExperimentSettings().getPath(), "XY loci plot", p1, p2, name1, name2, loglog);
            this.desktopArray.get(this.currentDesktop).add(frame);
            frame.setVisible(true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void tablesChoosen(String ID, ArrayList<Integer> indices, boolean common) {
        this.enableGlassPane(false);
        if (indices == null || indices.size() == 0) {
            return;
        }
        HashMap<String, double[]> tagCountMap = new HashMap<String, double[]>();
        HashMap<String, String[]> dataMap = new HashMap<String, String[]>();
        ExperimentSettings settings = this.desktopArray.get(this.currentDesktop).getExperimentSettings();
        String[] labels = new String[indices.size()];
        int profiles = indices.size();
        int i = 0;
        while (i < indices.size()) {
            labels[i] = settings.getResults().get(indices.get(i)).getName();
            try {
                ArrayList<String[]> tab = TableFileReader.readTable(String.valueOf(settings.getPath()) + settings.getResults().get(indices.get(i)).getGenesFile());
                int j = 0;
                while (j < tab.size()) {
                    String[] data = tab.get(j);
                    String id = data[1];
                    if (dataMap.get(id) == null) {
                        int chromosomeNumber = Integer.parseInt(data[4]) - 1;
                        String chromosome = SpeciesSettings.getChromosomeName(settings.getParams().getSpeciesId(), chromosomeNumber);
                        dataMap.put(id, new String[]{chromosome, data[0], data[2], data[5]});
                        double[] tags = new double[profiles];
                        tags[i] = Double.parseDouble(data[3]);
                        tagCountMap.put(id, tags);
                    } else {
                        ((double[])tagCountMap.get((Object)id))[i] = Double.parseDouble(data[3]);
                    }
                    ++j;
                }
            }
            catch (Exception e) {
                JOptionPane.showInternalMessageDialog(this, "Error while loci file reading: " + e.getMessage(), "Error", 0);
                Logger.writeExceptionLog(e);
                return;
            }
            ++i;
        }
        ArrayList<String[]> tableData = new ArrayList<String[]>();
        Iterator it = dataMap.keySet().iterator();
        while (it.hasNext()) {
            boolean addRow = true;
            String key = (String)it.next();
            String[] row = new String[4 + profiles];
            String[] data = (String[])dataMap.get(key);
            double[] tags = (double[])tagCountMap.get(key);
            row[0] = data[0];
            row[1] = data[1];
            row[2] = data[2];
            row[3] = data[3];
            int j = 0;
            while (j < tags.length) {
                if (common && tags[j] == 0.0) {
                    addRow = false;
                    break;
                }
                row[j + 4] = String.valueOf(tags[j]);
                ++j;
            }
            if (!addRow) continue;
            tableData.add(row);
        }
        CommonLociTableInternalFrame frame = new CommonLociTableInternalFrame("Common loci table", this.desktopArray.get(this.currentDesktop).getExperimentSettings(), labels, tableData, this.desktopArray.get(this.currentDesktop));
        this.desktopArray.get(this.currentDesktop).add(frame);
        frame.setVisible(true);
    }

    @Override
    public void histogramsChoosen(String ID, ArrayList<Integer> indices, boolean scaling, boolean setRange, int min, int max) {
        this.enableGlassPane(false);
        if (indices == null || indices.size() == 0) {
            return;
        }
        if (ID.equals("CommonPositionsHistogram")) {
            this.showCommonPositionsHistogram(indices, scaling, setRange, min, max);
        } else {
            this.showCommonLociHistogram(indices, scaling, setRange, min, max);
        }
    }

    void showCommonPositionsHistogram(ArrayList<Integer> indices, boolean scaling, boolean setRange, int min, int max) {
        double[][] hX = new double[indices.size()][];
        double[][] hY = new double[indices.size()][];
        ExperimentSettings settings = this.desktopArray.get(this.currentDesktop).getExperimentSettings();
        String[] labels = new String[indices.size()];
        int h = 0;
        while (h < indices.size()) {
            ExperimentResults results = settings.getResults().get(indices.get(h));
            HashMap<Double, Integer> tags = new HashMap<Double, Integer>();
            int i = 0;
            while (i < results.getChromosomes().size()) {
                File ft = new File(results.getChromosomes().get(i).getTagFilePath());
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new FileReader(ft));
                    while ((line = reader.readLine()) != null) {
                        String[] tab = line.split("\t");
                        double tagCount = Double.parseDouble(tab[1]);
                        if (tags.get(tagCount) == null) {
                            tags.put(tagCount, 1);
                            continue;
                        }
                        int t = (Integer)tags.get(tagCount) + 1;
                        tags.put(tagCount, t);
                    }
                    reader.close();
                }
                catch (Exception e) {
                    Logger.writeExceptionLog(e);
                }
                ++i;
            }
            Double[] hXI = tags.keySet().toArray(new Double[0]);
            hX[h] = new double[hXI.length];
            hY[h] = new double[hXI.length];
            double sum = 0.0;
            int i2 = 0;
            while (i2 < hX[h].length) {
                hX[h][i2] = hXI[i2];
                hY[h][i2] = ((Integer)tags.get(hX[h][i2])).intValue();
                ++i2;
            }
            labels[h] = results.getName();
            ++h;
        }
        TagHistogramScatterPlot plot = new TagHistogramScatterPlot("histogram_loci", 0, settings.getPath(), settings.getName(), labels, hX, hY, "#tags", "#positions", "tags in positions histogram", setRange, min, max, scaling);
        PackableScatterPlotInternalFrame frame = new PackableScatterPlotInternalFrame("Common Positions Histogram", plot);
        this.desktopArray.get(this.currentDesktop).add(frame);
        frame.setVisible(true);
    }

    void showCommonLociHistogram(ArrayList<Integer> indices, boolean scaling, boolean setRange, int min, int max) {
        double[][] hX = new double[indices.size()][];
        double[][] hY = new double[indices.size()][];
        ExperimentSettings settings = this.desktopArray.get(this.currentDesktop).getExperimentSettings();
        String[] labels = new String[indices.size()];
        int h = 0;
        while (h < indices.size()) {
            ExperimentResults results = settings.getResults().get(indices.get(h));
            HashMap<Double, Integer> tags = new HashMap<Double, Integer>();
            int i = 0;
            while (i < results.getChromosomes().size()) {
                File ft = new File(results.getChromosomes().get(i).getPositionFilePath());
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new FileReader(ft));
                    while ((line = reader.readLine()) != null) {
                        String[] tab = line.split("\t");
                        double tagCount = Double.parseDouble(tab[1]);
                        if (tags.get(tagCount) == null) {
                            tags.put(tagCount, 1);
                            continue;
                        }
                        int t = (Integer)tags.get(tagCount) + 1;
                        tags.put(tagCount, t);
                    }
                    reader.close();
                }
                catch (Exception e) {
                    Logger.writeExceptionLog(e);
                }
                ++i;
            }
            Double[] hXI = tags.keySet().toArray(new Double[0]);
            hX[h] = new double[hXI.length];
            hY[h] = new double[hXI.length];
            double sum = 0.0;
            int i2 = 0;
            while (i2 < hX[h].length) {
                hX[h][i2] = hXI[i2];
                hY[h][i2] = ((Integer)tags.get(hX[h][i2])).intValue();
                ++i2;
            }
            labels[h] = results.getName();
            ++h;
        }
        TagHistogramScatterPlot plot = new TagHistogramScatterPlot("histogram_loci", settings.getParams().getLocusLength(), settings.getPath(), settings.getName(), labels, hX, hY, "#tags", "#loci", "tags in loci histogram", setRange, min, max, scaling);
        PackableScatterPlotInternalFrame frame = new PackableScatterPlotInternalFrame("Common Loci Histogram", plot);
        this.desktopArray.get(this.currentDesktop).add(frame);
        frame.setVisible(true);
    }

    public void handleAbout(ApplicationEvent event) {
        this.showAbout();
        event.setHandled(true);
    }

    public void handleOpenApplication(ApplicationEvent arg0) {
    }

    public void handleOpenFile(ApplicationEvent arg0) {
    }

    public void handlePreferences(ApplicationEvent arg0) {
    }

    public void handlePrintFile(ApplicationEvent arg0) {
    }

    public void handleQuit(ApplicationEvent arg0) {
        this.exitApplication();
    }

    public void handleReOpenApplication(ApplicationEvent arg0) {
    }

    class AddExperimentAction
    extends AbstractAction {
        public AddExperimentAction() {
            super("Add new working set");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser("Select working set directory");
            chooser.setFileSelectionMode(1);
            chooser.setCurrentDirectory(new File("."));
            if (chooser.showDialog(MenuFrame.this.experimentTree, "Select") != 0) {
                return;
            }
            File f = chooser.getSelectedFile();
            String s = JOptionPane.showInputDialog("Put new working set name:", (Object)f.getName());
            if (s == null) {
                return;
            }
            if (!f.exists()) {
                f.mkdir();
            }
            File dataDir = new File(String.valueOf(f.getAbsolutePath()) + System.getProperty("file.separator") + "data");
            dataDir.mkdir();
            ExperimentSettings settings = new ExperimentSettings();
            settings.setName(s);
            settings.setPath(String.valueOf(dataDir.getAbsolutePath()) + System.getProperty("file.separator"));
            if (MenuFrame.this.appSettings.getExperimentByName(settings.getName()) != null) {
                JOptionPane.showMessageDialog(MenuFrame.this.experimentTree, "Working set already opened", "Error", 0);
                return;
            }
            MenuFrame.this.addExperiment(settings);
        }
    }

    class CloseAppListener
    extends WindowAdapter {
        CloseAppListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            MenuFrame.this.exitApplication();
        }
    }

    class CloseExperimentAction
    extends AbstractAction {
        public CloseExperimentAction() {
            super("Close working set");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MenuFrame.this.removeCurrentExperiment();
        }
    }

    class CreateAssignmentAction
    extends AbstractAction {
        public CreateAssignmentAction() {
            super("Create new assignments file");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (MenuFrame.this.bowtieSettingsFrame == null) {
                MenuFrame.this.bowtieSettingsFrame = new BowtieSettingsInternalFrame(MenuFrame.this.appSettings, MenuFrame.this);
                MenuFrame.this.attachToGlassPane(MenuFrame.this.bowtieSettingsFrame);
            }
            MenuFrame.this.bowtieSettingsFrame.setVisible(true);
            MenuFrame.this.enableGlassPane(true);
        }
    }

    class DeleteAllResultsAction
    extends AbstractAction {
        public DeleteAllResultsAction() {
            super("Delete all results");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int n = JOptionPane.showOptionDialog((Component)MenuFrame.this.desktopArray.get(MenuFrame.this.currentDesktop), "This will delete all data from selected working set", "Warning", 0, 2, null, new String[]{"OK", "Cancel"}, "Cancel");
            if (n != 0) {
                return;
            }
            ResultsCatalogTreeNode node = (ResultsCatalogTreeNode)MenuFrame.this.experimentTree.getLastSelectedPathComponent();
            int childCount = node.getChildCount();
            int i = childCount - 1;
            while (i >= 0) {
                ResultsTreeNode ResultsTreeNode2 = (ResultsTreeNode)node.getChildAt(i);
                ExperimentResults results = (ExperimentResults)ResultsTreeNode2.getUserObject();
                ExperimentSettings settings = ((ExperimentDesktop)MenuFrame.this.desktopArray.get(MenuFrame.this.currentDesktop)).getExperimentSettings();
                File f = new File(String.valueOf(settings.getPath()) + results.getFigureFile());
                f.delete();
                f = new File(String.valueOf(settings.getPath()) + results.getReportFile());
                f.delete();
                f = new File(String.valueOf(settings.getPath()) + results.getGenesFile());
                f.delete();
                int j = 0;
                while (j < results.getChromosomes().size()) {
                    f = new File(results.getChromosomes().get(j).getPositionFilePath());
                    f.delete();
                    f = new File(results.getChromosomes().get(j).getTagFilePath());
                    f.delete();
                    ++j;
                }
                settings.removeResults(results);
                ((DefaultTreeModel)MenuFrame.this.experimentTree.getModel()).removeNodeFromParent(ResultsTreeNode2);
                --i;
            }
            ((DefaultTreeModel)MenuFrame.this.experimentTree.getModel()).removeNodeFromParent(node);
        }
    }

    class DeleteExperimentAction
    extends AbstractAction {
        public DeleteExperimentAction() {
            super("Delete working set");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int n = JOptionPane.showOptionDialog(MenuFrame.this.experimentTree, "This will delete all data in selected working set", "Warning", 0, 2, null, new String[]{"OK", "Cancel"}, "Cancel");
            if (n != 0) {
                return;
            }
            File f = new File(MenuFrame.this.appSettings.getExperimentByIndex(MenuFrame.this.currentDesktop).getPath());
            MenuFrame.this.removeCurrentExperiment();
            this.deleteDirectory(f);
        }

        private boolean deleteDirectory(File path) {
            if (path.exists()) {
                File[] files = path.listFiles();
                int i = 0;
                while (i < files.length) {
                    if (files[i].isDirectory()) {
                        this.deleteDirectory(files[i]);
                    } else {
                        files[i].delete();
                    }
                    ++i;
                }
            }
            return path.delete();
        }
    }

    class DeleteResultsAction
    extends AbstractAction {
        public DeleteResultsAction() {
            super("Delete results");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int n = JOptionPane.showOptionDialog((Component)MenuFrame.this.desktopArray.get(MenuFrame.this.currentDesktop), "This will delete all data from selected profile", "Warning", 0, 2, null, new String[]{"OK", "Cancel"}, "Cancel");
            if (n != 0) {
                return;
            }
            ExperimentResults results = (ExperimentResults)((ResultsTreeNode)MenuFrame.this.experimentTree.getLastSelectedPathComponent()).getUserObject();
            ExperimentSettings settings = ((ExperimentDesktop)MenuFrame.this.desktopArray.get(MenuFrame.this.currentDesktop)).getExperimentSettings();
            File f = new File(String.valueOf(settings.getPath()) + results.getFigureFile());
            f.delete();
            f = new File(String.valueOf(settings.getPath()) + results.getReportFile());
            f.delete();
            f = new File(String.valueOf(settings.getPath()) + results.getGenesFile());
            f.delete();
            int i = 0;
            while (i < results.getChromosomes().size()) {
                f = new File(results.getChromosomes().get(i).getPositionFilePath());
                f.delete();
                f = new File(results.getChromosomes().get(i).getTagFilePath());
                f.delete();
                ++i;
            }
            settings.removeResults(results);
            ((DefaultTreeModel)MenuFrame.this.experimentTree.getModel()).removeNodeFromParent((ResultsTreeNode)MenuFrame.this.experimentTree.getLastSelectedPathComponent());
        }
    }

    class OpenExperimentAction
    extends AbstractAction {
        public OpenExperimentAction() {
            super("Open working set");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ExperimentSettings settings;
            JFileChooser chooser = new JFileChooser("Select working set directory");
            chooser.setFileSelectionMode(1);
            chooser.setCurrentDirectory(new File("."));
            if (chooser.showDialog(MenuFrame.this.experimentTree, "Select") != 0) {
                return;
            }
            File f = chooser.getSelectedFile();
            ExperimentSettingsReader experimentSettingsReader = new ExperimentSettingsReader();
            try {
                settings = experimentSettingsReader.readExperimentSettings(String.valueOf(f.getAbsolutePath()) + System.getProperty("file.separator") + "data" + System.getProperty("file.separator") + "settings.xml");
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(MenuFrame.this.experimentTree, exception.getMessage(), "Error", 0);
                return;
            }
            if (settings == null) {
                JOptionPane.showMessageDialog(MenuFrame.this.experimentTree, "Error while opening working set settings.", "Error", 0);
                return;
            }
            if (MenuFrame.this.appSettings.getExperimentByName(settings.getName()) != null) {
                JOptionPane.showMessageDialog(MenuFrame.this.experimentTree, "Working set already opened.", "Error", 0);
                return;
            }
            settings.setPath(String.valueOf(f.getAbsolutePath()) + System.getProperty("file.separator") + "data" + System.getProperty("file.separator"));
            MenuFrame.this.addExperiment(settings);
        }
    }

    class OpenFigureAction
    extends AbstractAction {
        public OpenFigureAction() {
            super("Show");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ProfileFigureTreeNode figureNode = (ProfileFigureTreeNode)MenuFrame.this.experimentTree.getLastSelectedPathComponent();
            ResultsTreeNode resultsNode = (ResultsTreeNode)figureNode.getParent();
            FigureData figureData = (FigureData)figureNode.getUserObject();
            ExperimentResults results = (ExperimentResults)resultsNode.getUserObject();
            try {
                ((ExperimentDesktop)MenuFrame.this.desktopArray.get(MenuFrame.this.currentDesktop)).showFigure(figureData, results);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(MenuFrame.this, exception.getMessage(), "Error", 0);
                Logger.writeExceptionLog(exception);
            }
        }
    }

    class OpenLociHistogramAction
    extends AbstractAction {
        public OpenLociHistogramAction() {
            super("Show");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LociHistogramTreeNode lociTableNode = (LociHistogramTreeNode)MenuFrame.this.experimentTree.getLastSelectedPathComponent();
            ResultsTreeNode resultsNode = (ResultsTreeNode)lociTableNode.getParent();
            ExperimentResults results = (ExperimentResults)resultsNode.getUserObject();
            ((ExperimentDesktop)MenuFrame.this.desktopArray.get(MenuFrame.this.currentDesktop)).showLociTagsHistogram(results);
        }
    }

    class OpenLociTableAction
    extends AbstractAction {
        public OpenLociTableAction() {
            super("Show");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LociTableTreeNode lociTableNode = (LociTableTreeNode)MenuFrame.this.experimentTree.getLastSelectedPathComponent();
            ResultsTreeNode resultsNode = (ResultsTreeNode)lociTableNode.getParent();
            ExperimentResults results = (ExperimentResults)resultsNode.getUserObject();
            ((ExperimentDesktop)MenuFrame.this.desktopArray.get(MenuFrame.this.currentDesktop)).showLociTable(results);
        }
    }

    class OpenPositionsHistogramAction
    extends AbstractAction {
        public OpenPositionsHistogramAction() {
            super("Show");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PositionsHistogramTreeNode lociTableNode = (PositionsHistogramTreeNode)MenuFrame.this.experimentTree.getLastSelectedPathComponent();
            ResultsTreeNode resultsNode = (ResultsTreeNode)lociTableNode.getParent();
            ExperimentResults results = (ExperimentResults)resultsNode.getUserObject();
            ((ExperimentDesktop)MenuFrame.this.desktopArray.get(MenuFrame.this.currentDesktop)).showPositionTagsHistogram(results);
        }
    }

    class OpenReportAction
    extends AbstractAction {
        public OpenReportAction() {
            super("Show");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ReportTreeNode reportNode = (ReportTreeNode)MenuFrame.this.experimentTree.getLastSelectedPathComponent();
            ResultsTreeNode resultsNode = (ResultsTreeNode)reportNode.getParent();
            ExperimentResults results = (ExperimentResults)resultsNode.getUserObject();
            ((ExperimentDesktop)MenuFrame.this.desktopArray.get(MenuFrame.this.currentDesktop)).showReport(results);
        }
    }

    class OpenSettingsAction
    extends AbstractAction {
        public OpenSettingsAction() {
            super("Show");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((ExperimentDesktop)MenuFrame.this.desktopArray.get(MenuFrame.this.currentDesktop)).showSettings();
        }
    }

    class PopupMenu
    extends JPopupMenu {
        private JPopupMenu experimentMenu = new JPopupMenu("experimentMenu");
        private JPopupMenu resultsMenu;
        private JPopupMenu resultsCatalogMenu;
        private JPopupMenu figureMenu;
        private JPopupMenu reportMenu;
        private JPopupMenu settingsMenu;
        private JPopupMenu lociTable;
        private JPopupMenu lociHistogram;
        private JPopupMenu positionsHistogram;

        public PopupMenu(JTree experimentTree, AppSettings appSettings, JFrame menuFrame2) {
            this.experimentMenu.add(new AddExperimentAction());
            this.experimentMenu.add(new OpenExperimentAction());
            this.experimentMenu.addSeparator();
            this.experimentMenu.add(new RunExperimentAction());
            this.experimentMenu.add(new CloseExperimentAction());
            this.experimentMenu.add(new RenameExperimentAction());
            this.experimentMenu.add(new DeleteExperimentAction());
            this.resultsMenu = new JPopupMenu("resultsMenu");
            this.resultsMenu.add(new RenameResultsAction());
            this.resultsMenu.add(new DeleteResultsAction());
            this.resultsCatalogMenu = new JPopupMenu("resultsCatalogMenu");
            this.resultsCatalogMenu.add(new DeleteAllResultsAction());
            this.figureMenu = new JPopupMenu("figureMenu");
            this.figureMenu.add(new OpenFigureAction());
            this.reportMenu = new JPopupMenu("reportMenu");
            this.reportMenu.add(new OpenReportAction());
            this.settingsMenu = new JPopupMenu("settingsMenu");
            this.settingsMenu.add(new OpenSettingsAction());
            this.lociTable = new JPopupMenu("lociTableMenu");
            this.lociTable.add(new OpenLociTableAction());
            this.lociHistogram = new JPopupMenu("lociHistogramMenu");
            this.lociHistogram.add(new OpenLociHistogramAction());
            this.positionsHistogram = new JPopupMenu("positionsHistogramMenu");
            this.positionsHistogram.add(new OpenPositionsHistogramAction());
        }

        @Override
        public void show(Component c, int x, int y) {
            JTree t = (JTree)c;
            int row = t.getRowForLocation(x, y);
            if (row > -1) {
                t.setSelectionRow(row);
                Object selected = t.getLastSelectedPathComponent();
                MenuFrame.this.changeDesktop();
                if (selected.getClass().getName().equals(ExperimentTreeNode.class.getName())) {
                    this.experimentMenu.show(c, x, y);
                } else if (selected.getClass().getName().equals(ResultsTreeNode.class.getName())) {
                    this.resultsMenu.show(c, x, y);
                } else if (selected.getClass().getName().equals(ResultsCatalogTreeNode.class.getName())) {
                    this.resultsCatalogMenu.show(c, x, y);
                } else if (selected.getClass().getName().equals(ProfileFigureTreeNode.class.getName())) {
                    this.figureMenu.show(c, x, y);
                } else if (selected.getClass().getName().equals(ReportTreeNode.class.getName())) {
                    this.reportMenu.show(c, x, y);
                } else if (selected.getClass().getName().equals(SettingsTreeNode.class.getName())) {
                    this.settingsMenu.show(c, x, y);
                } else if (selected.getClass().getName().equals(LociTableTreeNode.class.getName())) {
                    this.lociTable.show(c, x, y);
                } else if (selected.getClass().getName().equals(LociHistogramTreeNode.class.getName())) {
                    this.lociHistogram.show(c, x, y);
                } else if (selected.getClass().getName().equals(PositionsHistogramTreeNode.class.getName())) {
                    this.positionsHistogram.show(c, x, y);
                }
            }
        }
    }

    class RenameExperimentAction
    extends AbstractAction {
        public RenameExperimentAction() {
            super("Rename working set");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ExperimentDesktop desktop = (ExperimentDesktop)MenuFrame.this.desktopArray.get(MenuFrame.this.currentDesktop);
            String name = desktop.getExperimentName();
            String newName = JOptionPane.showInputDialog("Put new name:", (Object)name);
            if (newName == null) {
                return;
            }
            ExperimentSettings settings = MenuFrame.this.appSettings.getExperimentByName(name);
            settings.setName(newName);
            ((ExperimentTreeNode)MenuFrame.this.experimentTree.getLastSelectedPathComponent()).rename(newName);
        }
    }

    class RenameResultsAction
    extends AbstractAction {
        public RenameResultsAction() {
            super("Rename results");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ExperimentResults results = (ExperimentResults)((ResultsTreeNode)MenuFrame.this.experimentTree.getLastSelectedPathComponent()).getUserObject();
            String oldName = results.getName();
            String newName = JOptionPane.showInputDialog("Put new name:", (Object)oldName);
            if (newName == null) {
                return;
            }
            results.setName(newName);
            ((DefaultTreeModel)MenuFrame.this.experimentTree.getModel()).nodeChanged((ResultsTreeNode)MenuFrame.this.experimentTree.getLastSelectedPathComponent());
        }
    }

    class RunExperimentAction
    extends AbstractAction {
        public RunExperimentAction() {
            super("Run experiment");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((ExperimentDesktop)MenuFrame.this.desktopArray.get(MenuFrame.this.currentDesktop)).runExperiment();
        }
    }

    class ShowCommonLociHistogramAction
    extends AbstractAction {
        public ShowCommonLociHistogramAction() {
            super("Show common loci histogram");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (MenuFrame.this.currentDesktop == -1) {
                JOptionPane.showMessageDialog(null, "Select working set.", "Error", 0);
                return;
            }
            HistogramChooserInternalFrame frame = new HistogramChooserInternalFrame((ExperimentDesktop)MenuFrame.this.desktopArray.get(MenuFrame.this.currentDesktop), "Common loci histogram settings", ((ExperimentDesktop)MenuFrame.this.desktopArray.get(MenuFrame.this.currentDesktop)).getExperimentSettings(), "CommonLociHistogram", MenuFrame.this);
            MenuFrame.this.attachToGlassPane(frame);
            frame.setVisible(true);
            MenuFrame.this.enableGlassPane(true);
        }
    }

    class ShowCommonPositionsHistogramAction
    extends AbstractAction {
        public ShowCommonPositionsHistogramAction() {
            super("Show common positions histogram");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (MenuFrame.this.currentDesktop == -1) {
                JOptionPane.showMessageDialog(null, "Select working set.", "Error", 0);
                return;
            }
            HistogramChooserInternalFrame frame = new HistogramChooserInternalFrame((ExperimentDesktop)MenuFrame.this.desktopArray.get(MenuFrame.this.currentDesktop), "Common positions histogram settings", ((ExperimentDesktop)MenuFrame.this.desktopArray.get(MenuFrame.this.currentDesktop)).getExperimentSettings(), "CommonPositionsHistogram", MenuFrame.this);
            MenuFrame.this.attachToGlassPane(frame);
            frame.setVisible(true);
            MenuFrame.this.enableGlassPane(true);
        }
    }

    class ShowCommonProfileAction
    extends AbstractAction {
        public ShowCommonProfileAction() {
            super("Show common loci profile");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (MenuFrame.this.currentDesktop == -1) {
                JOptionPane.showMessageDialog(null, "Select working set.", "Error", 0);
                return;
            }
            ProfileChooserInternalFrame frame = new ProfileChooserInternalFrame((ExperimentDesktop)MenuFrame.this.desktopArray.get(MenuFrame.this.currentDesktop), "Common profile settings", ((ExperimentDesktop)MenuFrame.this.desktopArray.get(MenuFrame.this.currentDesktop)).getExperimentSettings(), "CommonProfile", MenuFrame.this);
            MenuFrame.this.attachToGlassPane(frame);
            frame.setVisible(true);
            MenuFrame.this.enableGlassPane(true);
        }
    }

    class ShowCommonTableAction
    extends AbstractAction {
        public ShowCommonTableAction() {
            super("Show common loci table");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (MenuFrame.this.currentDesktop == -1) {
                JOptionPane.showMessageDialog(null, "Select working set.", "Error", 0);
                return;
            }
            TableChooserInternalFrame frame = new TableChooserInternalFrame((ExperimentDesktop)MenuFrame.this.desktopArray.get(MenuFrame.this.currentDesktop), "Common table settings", ((ExperimentDesktop)MenuFrame.this.desktopArray.get(MenuFrame.this.currentDesktop)).getExperimentSettings(), "CommonTable", MenuFrame.this);
            MenuFrame.this.attachToGlassPane(frame);
            frame.setVisible(true);
            MenuFrame.this.enableGlassPane(true);
        }
    }

    class ShowXYLociPlotAction
    extends AbstractAction {
        public ShowXYLociPlotAction() {
            super("Show XY loci plot");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (MenuFrame.this.currentDesktop == -1) {
                JOptionPane.showMessageDialog(null, "Select working set.", "Error", 0);
                return;
            }
            DoubleProfileChooserInternalFrame frame = new DoubleProfileChooserInternalFrame("XY loci plot settings", ((ExperimentDesktop)MenuFrame.this.desktopArray.get(MenuFrame.this.currentDesktop)).getExperimentSettings(), "XYPlot", MenuFrame.this);
            frame.setLocation(MenuFrame.this.getWidth() / 2 - frame.getWidth() / 2, MenuFrame.this.getHeight() / 3 - frame.getHeight() / 2);
            frame.setVisible(true);
        }
    }
}

