/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.ExperimentDesktop;
import gui.HistogramChooserInternalFrameListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import settings.ExperimentSettings;

public class HistogramChooserInternalFrame
extends JInternalFrame {
    private ExperimentSettings settings;
    private String ID;
    private ArrayList<JCheckBox> checkBoxes;
    private HistogramChooserInternalFrameListener listener;
    private JSpinner minSpinner;
    private JSpinner maxSpinner;

    public HistogramChooserInternalFrame(ExperimentDesktop parent, String title, ExperimentSettings _settings, String _ID, HistogramChooserInternalFrameListener _listener) {
        super(title, false, false, false, false);
        this.settings = _settings;
        this.ID = _ID;
        this.listener = _listener;
        JPanel selectionPanel = new JPanel();
        selectionPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.fill = 2;
        c.insets = new Insets(2, 2, 2, 2);
        this.checkBoxes = new ArrayList(this.settings.getResults().size());
        c.gridx = 0;
        selectionPanel.add((Component)new JLabel("Profiles:"), c);
        ++c.gridy;
        int i = 0;
        while (i < this.settings.getResults().size()) {
            c.gridx = 0;
            JCheckBox cb = new JCheckBox(this.settings.getResults().get(i).getName());
            this.checkBoxes.add(cb);
            selectionPanel.add((Component)cb, c);
            ++c.gridy;
            ++i;
        }
        this.getContentPane().setLayout(new GridBagLayout());
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)new JLabel("Select profiles:"), c);
        ++c.gridy;
        c.gridwidth = 2;
        this.getContentPane().add((Component)new JSeparator(0), c);
        ++c.gridy;
        JScrollPane scrollPane = new JScrollPane(selectionPanel);
        scrollPane.setPreferredSize(new Dimension(0, Math.min(parent.getHeight() * 2 / 3, (int)selectionPanel.getPreferredSize().getHeight())));
        this.getContentPane().add((Component)scrollPane, c);
        ++c.gridy;
        this.getContentPane().add((Component)new JSeparator(0), c);
        ++c.gridy;
        JCheckBox scaleCheckBox = new JCheckBox("scale");
        if (this.ID.equals("CommonLociHistogram")) {
            scaleCheckBox.setSelected(this.settings.isScaleLociHistogram());
        } else if (this.ID.equals("CommonPositionsHistogram")) {
            scaleCheckBox.setSelected(this.settings.isScalePositionHistogram());
        }
        scaleCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (HistogramChooserInternalFrame.this.ID.equals("CommonLociHistogram")) {
                    HistogramChooserInternalFrame.this.settings.setScaleLociHistogram(((JCheckBox)e.getSource()).isSelected());
                } else if (HistogramChooserInternalFrame.this.ID.equals("CommonPositionsHistogram")) {
                    HistogramChooserInternalFrame.this.settings.setScalePositionHistogram(((JCheckBox)e.getSource()).isSelected());
                }
            }
        });
        this.getContentPane().add((Component)scaleCheckBox, c);
        ++c.gridy;
        JCheckBox setRangeCheckBox = new JCheckBox("set range");
        if (this.ID.equals("CommonLociHistogram")) {
            setRangeCheckBox.setSelected(this.settings.isSetLociHistogramRange());
        } else if (this.ID.equals("CommonPositionsHistogram")) {
            setRangeCheckBox.setSelected(this.settings.isSetPositionHistogramRange());
        }
        setRangeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (HistogramChooserInternalFrame.this.ID.equals("CommonLociHistogram")) {
                    HistogramChooserInternalFrame.this.settings.setSetLociHistogramRange(((JCheckBox)e.getSource()).isSelected());
                } else if (HistogramChooserInternalFrame.this.ID.equals("CommonPositionsHistogram")) {
                    HistogramChooserInternalFrame.this.settings.setSetPositionHistogramRange(((JCheckBox)e.getSource()).isSelected());
                }
                HistogramChooserInternalFrame.this.minSpinner.setEnabled(((JCheckBox)e.getSource()).isSelected());
                HistogramChooserInternalFrame.this.maxSpinner.setEnabled(((JCheckBox)e.getSource()).isSelected());
            }
        });
        this.getContentPane().add((Component)setRangeCheckBox, c);
        c.gridwidth = 1;
        ++c.gridy;
        c.fill = 0;
        JLabel label = new JLabel("min");
        this.getContentPane().add((Component)label, c);
        c.fill = 2;
        c.gridx = 1;
        this.minSpinner = new JSpinner();
        SpinnerNumberModel model = null;
        if (this.ID.equals("CommonLociHistogram")) {
            model = new SpinnerNumberModel(this.settings.getLociHistogramRangeMin(), 0, Integer.MAX_VALUE, 1);
            this.minSpinner.setEnabled(this.settings.isSetLociHistogramRange());
        } else if (this.ID.equals("CommonPositionsHistogram")) {
            model = new SpinnerNumberModel(this.settings.getPositionHistogramRangeMin(), 0, Integer.MAX_VALUE, 1);
            this.minSpinner.setEnabled(this.settings.isSetPositionHistogramRange());
        }
        this.minSpinner.setModel(model);
        this.minSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (HistogramChooserInternalFrame.this.ID.equals("CommonLociHistogram")) {
                    HistogramChooserInternalFrame.this.settings.setLociHistogramRangeMin((Integer)((JSpinner)e.getSource()).getValue());
                } else if (HistogramChooserInternalFrame.this.ID.equals("CommonPositionsHistogram")) {
                    HistogramChooserInternalFrame.this.settings.setPositionHistogramRangeMin((Integer)((JSpinner)e.getSource()).getValue());
                }
            }
        });
        this.getContentPane().add((Component)this.minSpinner, c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 0;
        label = new JLabel("max");
        this.getContentPane().add((Component)label, c);
        c.fill = 2;
        c.gridx = 1;
        this.maxSpinner = new JSpinner();
        model = null;
        if (this.ID.equals("CommonLociHistogram")) {
            model = new SpinnerNumberModel(this.settings.getLociHistogramRangeMax(), 0, Integer.MAX_VALUE, 1);
            this.maxSpinner.setEnabled(this.settings.isSetLociHistogramRange());
        } else if (this.ID.equals("CommonPositionsHistogram")) {
            model = new SpinnerNumberModel(this.settings.getPositionHistogramRangeMax(), 0, Integer.MAX_VALUE, 1);
            this.maxSpinner.setEnabled(this.settings.isSetPositionHistogramRange());
        }
        this.maxSpinner.setModel(model);
        this.maxSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (HistogramChooserInternalFrame.this.ID.equals("CommonLociHistogram")) {
                    HistogramChooserInternalFrame.this.settings.setLociHistogramRangeMax((Integer)((JSpinner)e.getSource()).getValue());
                } else if (HistogramChooserInternalFrame.this.ID.equals("CommonPositionsHistogram")) {
                    HistogramChooserInternalFrame.this.settings.setPositionHistogramRangeMax((Integer)((JSpinner)e.getSource()).getValue());
                }
            }
        });
        this.getContentPane().add((Component)this.maxSpinner, c);
        c.gridx = 0;
        c.gridwidth = 2;
        ++c.gridy;
        this.getContentPane().add((Component)new JSeparator(0), c);
        JButton okButton = new JButton("Show");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ArrayList<Integer> selected = new ArrayList<Integer>();
                int i = 0;
                while (i < HistogramChooserInternalFrame.this.checkBoxes.size()) {
                    if (((JCheckBox)HistogramChooserInternalFrame.this.checkBoxes.get(i)).isSelected()) {
                        selected.add(i);
                    }
                    ++i;
                }
                boolean common = false;
                if (HistogramChooserInternalFrame.this.ID.equals("CommonPositionsHistogram")) {
                    HistogramChooserInternalFrame.this.listener.histogramsChoosen(HistogramChooserInternalFrame.this.ID, selected, HistogramChooserInternalFrame.this.settings.isScalePositionHistogram(), HistogramChooserInternalFrame.this.settings.isSetPositionHistogramRange(), HistogramChooserInternalFrame.this.settings.getPositionHistogramRangeMin(), HistogramChooserInternalFrame.this.settings.getPositionHistogramRangeMax());
                } else if (HistogramChooserInternalFrame.this.ID.equals("CommonLociHistogram")) {
                    HistogramChooserInternalFrame.this.listener.histogramsChoosen(HistogramChooserInternalFrame.this.ID, selected, HistogramChooserInternalFrame.this.settings.isScaleLociHistogram(), HistogramChooserInternalFrame.this.settings.isSetLociHistogramRange(), HistogramChooserInternalFrame.this.settings.getLociHistogramRangeMin(), HistogramChooserInternalFrame.this.settings.getLociHistogramRangeMax());
                }
                HistogramChooserInternalFrame.this.hide();
                HistogramChooserInternalFrame.this.dispose();
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (HistogramChooserInternalFrame.this.ID.equals("CommonPositionsHistogram")) {
                    HistogramChooserInternalFrame.this.listener.histogramsChoosen(HistogramChooserInternalFrame.this.ID, null, HistogramChooserInternalFrame.this.settings.isScalePositionHistogram(), HistogramChooserInternalFrame.this.settings.isSetPositionHistogramRange(), HistogramChooserInternalFrame.this.settings.getPositionHistogramRangeMin(), HistogramChooserInternalFrame.this.settings.getPositionHistogramRangeMax());
                } else if (HistogramChooserInternalFrame.this.ID.equals("CommonLociHistogram")) {
                    HistogramChooserInternalFrame.this.listener.histogramsChoosen(HistogramChooserInternalFrame.this.ID, null, HistogramChooserInternalFrame.this.settings.isScaleLociHistogram(), HistogramChooserInternalFrame.this.settings.isSetLociHistogramRange(), HistogramChooserInternalFrame.this.settings.getLociHistogramRangeMin(), HistogramChooserInternalFrame.this.settings.getLociHistogramRangeMax());
                }
                HistogramChooserInternalFrame.this.hide();
                HistogramChooserInternalFrame.this.dispose();
            }
        });
        ++c.gridy;
        c.gridwidth = 1;
        c.fill = 2;
        okButton.setPreferredSize(cancelButton.getPreferredSize());
        this.getContentPane().add((Component)okButton, c);
        c.gridx = 1;
        this.getContentPane().add((Component)cancelButton, c);
        this.pack();
    }
}

