/*
 * Decompiled with CFR 0.152.
 */
package gui;

import biomart.BiomartConnector;
import biomart.SpeciesSettings;
import gui.AttributeSelectionInternalFrame;
import gui.AttributeSelectionInternalFrameListener;
import gui.ExperimentDesktop;
import gui.Logger;
import gui.Resources;
import gui.TypesSelectionInternalFrame;
import gui.TypesSelectionInternalFrameListener;
import help.ToolTipMessage;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.ToolTipManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import settings.ExperimentParams;
import settings.ExperimentParamsReader;
import settings.ExperimentParamsWriter;
import settings.ExperimentSettings;

public class ExperimentSettingsInternalFrame
extends JInternalFrame {
    private ExperimentSettings settings;
    private JSpinner locusLengthSpinner;
    private JSpinner locusOffsetSpinner;
    private JTextField speciesTextField;
    private JTextField mainAttributeTextField;
    private JTextField secondaryAttributeTextField;
    private JCheckBox checkStrandCheckBox;
    private JCheckBox filterMultipleAssignmentsCheckBox;
    private JCheckBox saveLociListCheckBox;
    private JTextField saveLociListTextField;
    private JCheckBox loadLociListCheckBox;
    private JTextField loadLociListTextField;
    private JCheckBox filterLociTypesCheckBox;
    private JButton filterLociTypesSelectButton;
    private JCheckBox filterGOTermsCheckBox;
    private JTextField filterGOTermsTextField;
    private JCheckBox filterShortLociCheckBox;
    private JSpinner minLociLengthSpinner;
    private JCheckBox filterLociCheckBox;
    private JSpinner minLociDistanceSpinner;
    private JCheckBox prefilterLociCheckBox;
    private JSpinner minLociPrefilterLengthSpinner;
    private JSpinner minLociPrefilterOffsetSpinner;
    private JSpinner minLociPrefilterTagsSpinner;
    private JRadioButton leaveNoNearLociRadioButton;
    private JRadioButton leaveOneRandomLociRadioButton;
    private JRadioButton leaveOneMiddleLociRadioButton;
    private JCheckBox filterLowTagLociCheckBox;
    private JSpinner minLociTagCountSpinner;
    private JCheckBox filterLowTagPositionsCheckBox;
    private JSpinner minPositionsTagCountSpinner;
    private JCheckBox filterMultiTagLociCheckBox;
    private JSpinner maxLociTagCountSpinner;
    private JCheckBox filterMultiTagPositionsCheckBox;
    private JSpinner maxPositionsTagCountSpinner;
    private JList assignmentsFileList;
    private JCheckBox keepDataCheckBox;
    private JCheckBox assignmentsCountNormalizationCheckBox;
    private ExperimentDesktop parent;

    public ExperimentSettingsInternalFrame(ExperimentDesktop parent, ExperimentSettings settings) {
        super("Settings", false, true, false, false);
        this.parent = parent;
        this.setDefaultCloseOperation(1);
        this.getContentPane().setLayout(new GridBagLayout());
        this.settings = settings;
        ToolTipManager manager = ToolTipManager.sharedInstance();
        manager.setInitialDelay(500);
        manager.setReshowDelay(0);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        JPanel column1 = new JPanel();
        column1.setLayout(new GridBagLayout());
        column1.add((Component)this.createGeneralSettingsPanel(), c);
        c.gridx = 0;
        c.gridy = 1;
        column1.add((Component)this.createDataBaseSettingsPanel(), c);
        c.gridx = 0;
        c.gridy = 0;
        JPanel column2 = new JPanel();
        column2.setLayout(new GridBagLayout());
        column2.add((Component)this.createLociSettingsPanel(), c);
        c.gridx = 0;
        c.gridy = 1;
        column2.add((Component)this.createPositionsSettingsPanel(), c);
        c.gridx = 0;
        c.gridy = 0;
        this.getContentPane().add((Component)column1, c);
        c.gridx = 1;
        c.gridy = 0;
        this.getContentPane().add((Component)column2, c);
        this.setExperimentParams(settings.getParams());
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        JPanel buttonPanel = new JPanel();
        JButton applyButton = new JButton("        Run        ");
        applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExperimentSettingsInternalFrame.this.getParent().runExperiment();
            }
        });
        buttonPanel.add(applyButton);
        JButton exportButton = new JButton("Export Settings");
        exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String path = String.valueOf(new File(ExperimentSettingsInternalFrame.this.getSettings().getPath()).getParentFile().getPath()) + File.separator + ExperimentSettingsInternalFrame.this.getSettings().getName() + "_settings.xml";
                File f = ExperimentSettingsInternalFrame.this.selectExperimentFile(path);
                if (f == null) {
                    return;
                }
                try {
                    ExperimentParamsWriter.writeExperimentParams(ExperimentSettingsInternalFrame.this.getSettings().getParams(), f.getPath());
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(ExperimentSettingsInternalFrame.this.getParent(), exception.getMessage(), "Error", 0);
                    Logger.writeExceptionLog(exception);
                }
            }
        });
        buttonPanel.add(exportButton);
        JButton importButton = new JButton("Import Settings");
        importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File f = ExperimentSettingsInternalFrame.this.selectExperimentFile(ExperimentSettingsInternalFrame.this.getSettings().getPath());
                if (f != null) {
                    try {
                        ExperimentParams params = ExperimentParamsReader.readExperimentParams(f.getPath());
                        ExperimentSettingsInternalFrame.this.getSettings().setParams(params);
                        ExperimentSettingsInternalFrame.this.setExperimentParams(params);
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(ExperimentSettingsInternalFrame.this.getParent(), exception.getMessage(), "Error", 0);
                        Logger.writeExceptionLog(exception);
                    }
                }
            }
        });
        buttonPanel.add(importButton);
        this.getContentPane().add((Component)buttonPanel, c);
        this.pack();
    }

    private File selectExperimentFile(String fileName) {
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        chooser.setSelectedFile(new File(fileName));
        if (chooser.showDialog(this, "Select") == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    private File[] selectAssignmentFile() {
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(true);
        if (this.settings.getBowtieFile() != null) {
            chooser.setCurrentDirectory(new File(this.settings.getBowtieFile()));
        } else {
            chooser.setCurrentDirectory(new File("."));
        }
        if (chooser.showDialog(this, "Select") == 0) {
            return chooser.getSelectedFiles();
        }
        return null;
    }

    private File selectLociFile(String fileName) {
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        chooser.setCurrentDirectory(new File(fileName));
        if (chooser.showDialog(this, "Select") == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    private JPanel createGeneralSettingsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        panel.setBorder(new TitledBorder("General"));
        c.gridx = 0;
        c.gridwidth = 1;
        JLabel label = new JLabel("Locus length");
        label.setToolTipText(ToolTipMessage.locusLengthMessage);
        panel.add((Component)label, c);
        SpinnerNumberModel model = new SpinnerNumberModel(this.settings.getParams().getLocusLength(), 0, Integer.MAX_VALUE, 1);
        this.locusLengthSpinner = new JSpinner(model);
        this.locusLengthSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ExperimentSettingsInternalFrame.this.getSettings().getParams().setLocusLength((Integer)ExperimentSettingsInternalFrame.this.locusLengthSpinner.getValue());
            }
        });
        ((JSpinner.DefaultEditor)this.locusLengthSpinner.getEditor()).getTextField().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                try {
                    String valString = ((JSpinner.DefaultEditor)ExperimentSettingsInternalFrame.this.locusLengthSpinner.getEditor()).getTextField().getText();
                    String parsed = "";
                    int i = 0;
                    while (i < valString.length()) {
                        try {
                            int val = Integer.parseInt(String.valueOf(valString.charAt(i)));
                            parsed = String.valueOf(parsed) + val;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++i;
                    }
                    if (parsed.equals("")) {
                        parsed = "0";
                    }
                    int val = Integer.parseInt(parsed);
                    ExperimentSettingsInternalFrame.this.getSettings().getParams().setLocusLength(val);
                }
                catch (Exception exception) {
                    Logger.writeExceptionLog(exception);
                }
            }
        });
        c.gridx = 1;
        c.gridwidth = 2;
        panel.add((Component)this.locusLengthSpinner, c);
        ++c.gridy;
        label = new JLabel("Locus offset");
        label.setToolTipText(ToolTipMessage.locusOffsetMessage);
        c.gridx = 0;
        c.gridwidth = 1;
        panel.add((Component)label, c);
        model = new SpinnerNumberModel(this.settings.getParams().getLocusOffset(), Integer.MIN_VALUE, Integer.MAX_VALUE, 1);
        this.locusOffsetSpinner = new JSpinner(model);
        this.locusOffsetSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ExperimentSettingsInternalFrame.this.getSettings().getParams().setLocusOffset((Integer)ExperimentSettingsInternalFrame.this.locusOffsetSpinner.getValue());
            }
        });
        ((JSpinner.DefaultEditor)this.locusOffsetSpinner.getEditor()).getTextField().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                try {
                    String valString = ((JSpinner.DefaultEditor)ExperimentSettingsInternalFrame.this.locusOffsetSpinner.getEditor()).getTextField().getText();
                    String parsed = "";
                    int i = 0;
                    while (i < valString.length()) {
                        try {
                            int val = Integer.parseInt(String.valueOf(valString.charAt(i)));
                            parsed = String.valueOf(parsed) + val;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++i;
                    }
                    if (parsed.equals("")) {
                        parsed = "0";
                    }
                    int val = Integer.parseInt(parsed);
                    ExperimentSettingsInternalFrame.this.getSettings().getParams().setLocusOffset(val);
                }
                catch (Exception exception) {
                    Logger.writeExceptionLog(exception);
                }
            }
        });
        c.gridx = 1;
        c.gridwidth = 2;
        panel.add((Component)this.locusOffsetSpinner, c);
        ++c.gridy;
        label = new JLabel("Assignment files");
        label.setToolTipText(ToolTipMessage.assignmentFilesMessage);
        c.gridx = 0;
        c.gridwidth = 1;
        panel.add((Component)label, c);
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        this.assignmentsFileList = new JList(listModel);
        int i = 0;
        while (i < this.settings.getAssignmentFilesCount()) {
            File f = new File(this.settings.getAssignmentFile(i));
            String fileName = f.getName();
            listModel.addElement(fileName);
            ++i;
        }
        c.gridx = 1;
        c.gridwidth = 2;
        JScrollPane listPane = new JScrollPane(this.assignmentsFileList);
        listPane.setPreferredSize(new Dimension(100, 100));
        panel.add((Component)listPane, c);
        ++c.gridy;
        JPanel fileButtonsPanel = new JPanel();
        JButton addFileButton = new JButton("Add");
        addFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                File[] f = ExperimentSettingsInternalFrame.this.selectAssignmentFile();
                if (f != null) {
                    int i = 0;
                    while (i < f.length) {
                        String fileName = f[i].getName();
                        ExperimentSettingsInternalFrame.this.getSettings().addAssignmentFile(f[i].getAbsolutePath());
                        DefaultListModel listModel = (DefaultListModel)ExperimentSettingsInternalFrame.this.assignmentsFileList.getModel();
                        listModel.addElement(fileName);
                        ++i;
                    }
                }
            }
        });
        fileButtonsPanel.add(addFileButton);
        c.fill = 2;
        c.anchor = 10;
        JButton deleteFileButton = new JButton("Delete");
        deleteFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] indices = ExperimentSettingsInternalFrame.this.assignmentsFileList.getSelectedIndices();
                DefaultListModel listModel = (DefaultListModel)ExperimentSettingsInternalFrame.this.assignmentsFileList.getModel();
                int i = indices.length - 1;
                while (i >= 0) {
                    listModel.remove(indices[i]);
                    ExperimentSettingsInternalFrame.this.getSettings().removeAssignmentFile(indices[i]);
                    --i;
                }
            }
        });
        fileButtonsPanel.add(deleteFileButton);
        addFileButton.setPreferredSize(deleteFileButton.getPreferredSize());
        c.gridx = 1;
        ++c.gridy;
        c.gridwidth = 2;
        panel.add((Component)fileButtonsPanel, c);
        label = new JLabel("Keep data", Resources.getImageIcon(Resources.WARNING_ICON), 2);
        label.setToolTipText(ToolTipMessage.keepDataMessage);
        label.setHorizontalTextPosition(2);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        panel.add((Component)label, c);
        this.keepDataCheckBox = new JCheckBox();
        this.keepDataCheckBox.setSelected(this.settings.isKeepData());
        this.keepDataCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExperimentSettingsInternalFrame.this.getSettings().setKeepData(ExperimentSettingsInternalFrame.this.keepDataCheckBox.isSelected());
            }
        });
        c.gridx = 1;
        c.gridwidth = 1;
        panel.add((Component)this.keepDataCheckBox, c);
        label = new JLabel("<html><body>Filter multiple<br>assignments</body></html>");
        label.setToolTipText(ToolTipMessage.multipleAssignmentFilterMessage);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        panel.add((Component)label, c);
        this.filterMultipleAssignmentsCheckBox = new JCheckBox();
        this.filterMultipleAssignmentsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ExperimentSettingsInternalFrame.this.getSettings().getParams().setFilterMultipleAssignments(ExperimentSettingsInternalFrame.this.filterMultipleAssignmentsCheckBox.isSelected());
            }
        });
        c.gridx = 1;
        c.gridwidth = 1;
        panel.add((Component)this.filterMultipleAssignmentsCheckBox, c);
        ++c.gridy;
        label = new JLabel("<html><body>Assignments count<br>normalization</body></html>");
        label.setToolTipText(ToolTipMessage.assignmentCountNormalizationMessage);
        c.gridx = 0;
        c.gridwidth = 1;
        panel.add((Component)label, c);
        this.assignmentsCountNormalizationCheckBox = new JCheckBox();
        this.assignmentsCountNormalizationCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ExperimentSettingsInternalFrame.this.getSettings().getParams().setAssignmentsCountNormalisation(ExperimentSettingsInternalFrame.this.assignmentsCountNormalizationCheckBox.isSelected());
            }
        });
        c.gridx = 1;
        c.gridwidth = 2;
        panel.add((Component)this.assignmentsCountNormalizationCheckBox, c);
        return panel;
    }

    @Override
    public ExperimentDesktop getParent() {
        return this.parent;
    }

    private JPanel createDataBaseSettingsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        panel.setBorder(new TitledBorder("Database"));
        JLabel label = new JLabel("Database");
        panel.add((Component)label, c);
        c.gridx = 1;
        c.gridwidth = 2;
        label = new JLabel("ensembl");
        panel.add((Component)label, c);
        label = new JLabel("Species");
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        panel.add((Component)label, c);
        this.speciesTextField = new JTextField();
        this.speciesTextField.setText(this.settings.getParams().getSpeciesId());
        this.speciesTextField.setEditable(false);
        this.speciesTextField.addMouseListener(new SpeciesMouseAdapter());
        c.gridx = 1;
        c.gridwidth = 2;
        panel.add((Component)this.speciesTextField, c);
        label = new JLabel("Main attribute");
        label.setToolTipText(ToolTipMessage.mainAttributeMessage);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        panel.add((Component)label, c);
        this.mainAttributeTextField = new JTextField();
        this.mainAttributeTextField.setText(this.settings.getParams().getMainAttribute());
        this.mainAttributeTextField.setEditable(false);
        this.mainAttributeTextField.addMouseListener(new MainAttributeMouseAdapter());
        c.gridx = 1;
        c.gridwidth = 2;
        panel.add((Component)this.mainAttributeTextField, c);
        label = new JLabel("Check strand");
        label.setToolTipText(ToolTipMessage.checkStrandsMessage);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        panel.add((Component)label, c);
        this.checkStrandCheckBox = new JCheckBox();
        this.checkStrandCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ExperimentSettingsInternalFrame.this.secondaryAttributeTextField.setEnabled(ExperimentSettingsInternalFrame.this.checkStrandCheckBox.isSelected());
                ExperimentSettingsInternalFrame.this.getSettings().getParams().setCheckStrand(ExperimentSettingsInternalFrame.this.checkStrandCheckBox.isSelected());
                ExperimentSettingsInternalFrame.this.getParent().positionSettingsChanged();
                if (!ExperimentSettingsInternalFrame.this.checkStrandCheckBox.isSelected()) {
                    ExperimentSettingsInternalFrame.this.getSettings().getParams().setFilterShortLoci(ExperimentSettingsInternalFrame.this.checkStrandCheckBox.isSelected());
                    ExperimentSettingsInternalFrame.this.filterShortLociCheckBox.setSelected(ExperimentSettingsInternalFrame.this.checkStrandCheckBox.isSelected());
                }
                ExperimentSettingsInternalFrame.this.filterShortLociCheckBox.setEnabled(ExperimentSettingsInternalFrame.this.checkStrandCheckBox.isSelected());
                ExperimentSettingsInternalFrame.this.minLociLengthSpinner.setEnabled(ExperimentSettingsInternalFrame.this.getSettings().getParams().isFilterShortLoci() && ExperimentSettingsInternalFrame.this.checkStrandCheckBox.isSelected());
            }
        });
        c.gridx = 1;
        c.gridwidth = 1;
        panel.add((Component)this.checkStrandCheckBox, c);
        label = new JLabel("Secondary attribute");
        label.setToolTipText(ToolTipMessage.secondaryAttributeMessage);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        panel.add((Component)label, c);
        this.secondaryAttributeTextField = new JTextField();
        this.secondaryAttributeTextField.setText(this.settings.getParams().getSecondaryAttribute());
        this.secondaryAttributeTextField.setEditable(false);
        this.secondaryAttributeTextField.addMouseListener(new SecondaryAttributeMouseAdapter());
        c.gridx = 1;
        c.gridwidth = 2;
        panel.add((Component)this.secondaryAttributeTextField, c);
        label = new JLabel("Gene types");
        label.setToolTipText(ToolTipMessage.geneTypesMessage);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        panel.add((Component)label, c);
        this.filterLociTypesCheckBox = new JCheckBox();
        this.filterLociTypesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ExperimentSettingsInternalFrame.this.getSettings().getParams().setFilterLociTypes(ExperimentSettingsInternalFrame.this.filterLociTypesCheckBox.isSelected());
                ExperimentSettingsInternalFrame.this.filterLociTypesSelectButton.setEnabled(ExperimentSettingsInternalFrame.this.filterLociTypesCheckBox.isSelected());
                ExperimentSettingsInternalFrame.this.getParent().positionSettingsChanged();
            }
        });
        c.gridx = 1;
        c.gridwidth = 1;
        panel.add((Component)this.filterLociTypesCheckBox, c);
        this.filterLociTypesSelectButton = new JButton("Select");
        this.filterLociTypesSelectButton.addActionListener(new FilteredTypesButtonActionListener());
        c.gridx = 2;
        c.gridwidth = 2;
        panel.add((Component)this.filterLociTypesSelectButton, c);
        label = new JLabel("GO terms file");
        label.setToolTipText(ToolTipMessage.GOTermsMessage);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        panel.add((Component)label, c);
        this.filterGOTermsCheckBox = new JCheckBox();
        this.filterGOTermsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ExperimentSettingsInternalFrame.this.getSettings().getParams().setFilterGOTerm(ExperimentSettingsInternalFrame.this.filterGOTermsCheckBox.isSelected());
                ExperimentSettingsInternalFrame.this.filterGOTermsTextField.setEnabled(ExperimentSettingsInternalFrame.this.filterGOTermsCheckBox.isSelected());
                ExperimentSettingsInternalFrame.this.getParent().positionSettingsChanged();
            }
        });
        c.gridx = 1;
        c.gridwidth = 1;
        panel.add((Component)this.filterGOTermsCheckBox, c);
        c.gridx = 2;
        c.gridwidth = 2;
        this.filterGOTermsTextField = new JTextField();
        this.filterGOTermsTextField.setEditable(false);
        this.filterGOTermsTextField.setText(new File(this.settings.getParams().getGOTermsFile()).getName());
        this.filterGOTermsTextField.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!ExperimentSettingsInternalFrame.this.filterGOTermsCheckBox.isSelected() || !ExperimentSettingsInternalFrame.this.filterGOTermsTextField.isEnabled()) {
                    return;
                }
                File file = ExperimentSettingsInternalFrame.this.selectLociFile(ExperimentSettingsInternalFrame.this.getSettings().getParams().getGOTermsFile());
                if (file == null) {
                    return;
                }
                String newPath = file.getAbsolutePath();
                if (!newPath.equals(ExperimentSettingsInternalFrame.this.getSettings().getParams().getGOTermsFile())) {
                    ExperimentSettingsInternalFrame.this.getParent().positionSettingsChanged();
                }
                ExperimentSettingsInternalFrame.this.getSettings().getParams().setGOTermsFile(newPath);
                ExperimentSettingsInternalFrame.this.filterGOTermsTextField.setText(file.getName());
            }
        });
        panel.add((Component)this.filterGOTermsTextField, c);
        return panel;
    }

    private void enableDatabaseSettings(boolean enable) {
        this.speciesTextField.setEnabled(enable);
        this.mainAttributeTextField.setEnabled(enable);
        this.secondaryAttributeTextField.setEnabled(enable);
        this.checkStrandCheckBox.setEnabled(enable);
        this.filterLociTypesCheckBox.setEnabled(enable);
        this.filterGOTermsCheckBox.setEnabled(enable);
        if (enable && this.filterGOTermsCheckBox.isSelected()) {
            this.filterGOTermsTextField.setEnabled(true);
        } else {
            this.filterGOTermsTextField.setEnabled(false);
        }
        if (enable && this.filterLociTypesCheckBox.isSelected()) {
            this.filterLociTypesSelectButton.setEnabled(true);
        } else {
            this.filterLociTypesSelectButton.setEnabled(false);
        }
    }

    private JPanel createLociSettingsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        panel.setBorder(new TitledBorder("Loci"));
        JLabel label = new JLabel("Load loci list");
        label.setToolTipText(ToolTipMessage.loadLociMessage);
        panel.add((Component)label, c);
        c.gridx = 1;
        c.gridwidth = 1;
        this.loadLociListCheckBox = new JCheckBox();
        this.loadLociListCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isSelected = ExperimentSettingsInternalFrame.this.loadLociListCheckBox.isSelected();
                ExperimentSettingsInternalFrame.this.getSettings().getParams().setLociLoad(isSelected);
                ExperimentSettingsInternalFrame.this.enableDatabaseSettings(!isSelected);
                ExperimentSettingsInternalFrame.this.parent.positionSettingsChanged();
                ExperimentSettingsInternalFrame.this.loadLociListTextField.setEnabled(isSelected);
            }
        });
        panel.add((Component)this.loadLociListCheckBox, c);
        c.gridx = 2;
        c.gridwidth = 2;
        this.loadLociListTextField = new JTextField();
        this.loadLociListTextField.setEditable(false);
        this.loadLociListTextField.setText(new File(this.settings.getParams().getLociLoadFile()).getName());
        this.loadLociListTextField.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                File file;
                if (!ExperimentSettingsInternalFrame.this.loadLociListCheckBox.isSelected()) {
                    return;
                }
                String fileName = ExperimentSettingsInternalFrame.this.getSettings().getParams().getLociLoadFile();
                if (fileName.equals("")) {
                    fileName = new File(ExperimentSettingsInternalFrame.this.getSettings().getPath()).getParent();
                }
                if ((file = ExperimentSettingsInternalFrame.this.selectLociFile(fileName)) == null) {
                    return;
                }
                String newPath = file.getAbsolutePath();
                if (!newPath.equals(ExperimentSettingsInternalFrame.this.getSettings().getParams().getLociLoadFile())) {
                    ExperimentSettingsInternalFrame.this.getParent().positionSettingsChanged();
                }
                ExperimentSettingsInternalFrame.this.getSettings().getParams().setLociLoadFile(newPath);
                ExperimentSettingsInternalFrame.this.loadLociListTextField.setText(file.getName());
            }
        });
        panel.add((Component)this.loadLociListTextField, c);
        label = new JLabel("Save loci list");
        label.setToolTipText(ToolTipMessage.saveLociMessage);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        panel.add((Component)label, c);
        c.gridx = 1;
        c.gridwidth = 1;
        this.saveLociListCheckBox = new JCheckBox();
        this.saveLociListCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isSelected = ExperimentSettingsInternalFrame.this.saveLociListCheckBox.isSelected();
                ExperimentSettingsInternalFrame.this.getSettings().getParams().setLociSave(isSelected);
                ExperimentSettingsInternalFrame.this.saveLociListTextField.setEnabled(isSelected);
            }
        });
        panel.add((Component)this.saveLociListCheckBox, c);
        c.gridx = 2;
        c.gridwidth = 2;
        this.saveLociListTextField = new JTextField();
        this.saveLociListTextField.setEditable(false);
        this.saveLociListTextField.setText(new File(this.settings.getParams().getLociSaveFile()).getName());
        this.saveLociListTextField.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                File file;
                if (!ExperimentSettingsInternalFrame.this.saveLociListCheckBox.isSelected()) {
                    return;
                }
                String fileName = ExperimentSettingsInternalFrame.this.getSettings().getParams().getLociSaveFile();
                if (fileName.equals("")) {
                    fileName = new File(ExperimentSettingsInternalFrame.this.getSettings().getPath()).getParent();
                }
                if ((file = ExperimentSettingsInternalFrame.this.selectLociFile(fileName)) == null) {
                    return;
                }
                ExperimentSettingsInternalFrame.this.getSettings().getParams().setLociSaveFile(file.getAbsolutePath());
                ExperimentSettingsInternalFrame.this.saveLociListTextField.setText(file.getName());
            }
        });
        panel.add((Component)this.saveLociListTextField, c);
        label = new JLabel("Filter short loci");
        label.setToolTipText(ToolTipMessage.filterShortLociMessage);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        panel.add((Component)label, c);
        this.filterShortLociCheckBox = new JCheckBox();
        this.filterShortLociCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                boolean selected = ((JCheckBox)event.getSource()).isSelected();
                ExperimentSettingsInternalFrame.this.minLociLengthSpinner.setEnabled(selected);
                ExperimentSettingsInternalFrame.this.getSettings().getParams().setFilterShortLoci(selected);
            }
        });
        c.gridx = 1;
        c.gridwidth = 1;
        panel.add((Component)this.filterShortLociCheckBox, c);
        SpinnerNumberModel model = new SpinnerNumberModel(this.settings.getParams().getMinLociLength(), 0, Integer.MAX_VALUE, 1);
        this.minLociLengthSpinner = new JSpinner(model);
        this.minLociLengthSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ExperimentSettingsInternalFrame.this.getSettings().getParams().setMinLociLength((Integer)ExperimentSettingsInternalFrame.this.minLociLengthSpinner.getValue());
            }
        });
        ((JSpinner.DefaultEditor)this.minLociLengthSpinner.getEditor()).getTextField().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                try {
                    String valString = ((JSpinner.DefaultEditor)ExperimentSettingsInternalFrame.this.minLociLengthSpinner.getEditor()).getTextField().getText();
                    String parsed = "";
                    int i = 0;
                    while (i < valString.length()) {
                        try {
                            int val = Integer.parseInt(String.valueOf(valString.charAt(i)));
                            parsed = String.valueOf(parsed) + val;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++i;
                    }
                    if (parsed.equals("")) {
                        parsed = "0";
                    }
                    int val = Integer.parseInt(parsed);
                    ExperimentSettingsInternalFrame.this.getSettings().getParams().setMinLociLength(val);
                }
                catch (Exception exception) {
                    Logger.writeExceptionLog(exception);
                }
            }
        });
        c.gridx = 2;
        c.gridwidth = 1;
        panel.add((Component)this.minLociLengthSpinner, c);
        label = new JLabel("Filter near loci");
        label.setToolTipText(ToolTipMessage.filterNearLociMessage);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        panel.add((Component)label, c);
        this.filterLociCheckBox = new JCheckBox();
        this.filterLociCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ExperimentSettingsInternalFrame.this.minLociDistanceSpinner.setEnabled(ExperimentSettingsInternalFrame.this.filterLociCheckBox.isSelected());
                ExperimentSettingsInternalFrame.this.leaveNoNearLociRadioButton.setEnabled(ExperimentSettingsInternalFrame.this.filterLociCheckBox.isSelected());
                ExperimentSettingsInternalFrame.this.leaveOneRandomLociRadioButton.setEnabled(ExperimentSettingsInternalFrame.this.filterLociCheckBox.isSelected());
                ExperimentSettingsInternalFrame.this.leaveOneMiddleLociRadioButton.setEnabled(ExperimentSettingsInternalFrame.this.filterLociCheckBox.isSelected());
                if (!ExperimentSettingsInternalFrame.this.filterLociCheckBox.isSelected()) {
                    ExperimentSettingsInternalFrame.this.getSettings().getParams().setLeaveNoNearLoci(false);
                    ExperimentSettingsInternalFrame.this.getSettings().getParams().setLeaveRandomNearLoci(false);
                    ExperimentSettingsInternalFrame.this.getSettings().getParams().setLeaveMiddleNearLoci(false);
                } else {
                    ExperimentSettingsInternalFrame.this.getSettings().getParams().setMinLociDistance((Integer)ExperimentSettingsInternalFrame.this.minLociDistanceSpinner.getValue());
                    if (ExperimentSettingsInternalFrame.this.getSettings().getParams().isLeaveNoNearLoci() || ExperimentSettingsInternalFrame.this.getSettings().getParams().isLeaveRandomNearLoci() || ExperimentSettingsInternalFrame.this.getSettings().getParams().isLeaveMiddleNearLoci()) {
                        ExperimentSettingsInternalFrame.this.getSettings().getParams().setLeaveNoNearLoci(ExperimentSettingsInternalFrame.this.leaveNoNearLociRadioButton.isSelected());
                        ExperimentSettingsInternalFrame.this.getSettings().getParams().setLeaveRandomNearLoci(ExperimentSettingsInternalFrame.this.leaveOneRandomLociRadioButton.isSelected());
                        ExperimentSettingsInternalFrame.this.getSettings().getParams().setLeaveMiddleNearLoci(ExperimentSettingsInternalFrame.this.leaveOneMiddleLociRadioButton.isSelected());
                    } else {
                        ExperimentSettingsInternalFrame.this.getSettings().getParams().setLeaveNoNearLoci(true);
                        ExperimentSettingsInternalFrame.this.leaveNoNearLociRadioButton.setSelected(true);
                        ExperimentSettingsInternalFrame.this.getSettings().getParams().setLeaveRandomNearLoci(false);
                        ExperimentSettingsInternalFrame.this.getSettings().getParams().setLeaveMiddleNearLoci(false);
                    }
                }
            }
        });
        c.gridx = 1;
        c.gridwidth = 1;
        panel.add((Component)this.filterLociCheckBox, c);
        model = new SpinnerNumberModel(this.settings.getParams().getMinLociDistance(), 0, 10000, 1);
        this.minLociDistanceSpinner = new JSpinner(model);
        this.minLociDistanceSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ExperimentSettingsInternalFrame.this.getSettings().getParams().setMinLociDistance((Integer)ExperimentSettingsInternalFrame.this.minLociDistanceSpinner.getValue());
            }
        });
        ((JSpinner.DefaultEditor)this.minLociDistanceSpinner.getEditor()).getTextField().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                try {
                    String valString = ((JSpinner.DefaultEditor)ExperimentSettingsInternalFrame.this.minLociDistanceSpinner.getEditor()).getTextField().getText();
                    String parsed = "";
                    int i = 0;
                    while (i < valString.length()) {
                        try {
                            int val = Integer.parseInt(String.valueOf(valString.charAt(i)));
                            parsed = String.valueOf(parsed) + val;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++i;
                    }
                    if (parsed.equals("")) {
                        parsed = "0";
                    }
                    int val = Integer.parseInt(parsed);
                    ExperimentSettingsInternalFrame.this.getSettings().getParams().setMinLociDistance(val);
                }
                catch (Exception exception) {
                    Logger.writeExceptionLog(exception);
                }
            }
        });
        c.gridx = 2;
        c.gridwidth = 1;
        panel.add((Component)this.minLociDistanceSpinner, c);
        label = new JLabel("Filtering method");
        label.setToolTipText(ToolTipMessage.filterNearLociMessage);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        panel.add((Component)label, c);
        this.leaveNoNearLociRadioButton = new JRadioButton("remove all near loci");
        this.leaveNoNearLociRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExperimentSettingsInternalFrame.this.getSettings().getParams().setLeaveNoNearLoci(ExperimentSettingsInternalFrame.this.leaveNoNearLociRadioButton.isSelected());
                ExperimentSettingsInternalFrame.this.getSettings().getParams().setLeaveRandomNearLoci(ExperimentSettingsInternalFrame.this.leaveOneRandomLociRadioButton.isSelected());
                ExperimentSettingsInternalFrame.this.getSettings().getParams().setLeaveMiddleNearLoci(ExperimentSettingsInternalFrame.this.leaveOneMiddleLociRadioButton.isSelected());
            }
        });
        c.gridx = 1;
        c.gridwidth = 2;
        panel.add((Component)this.leaveNoNearLociRadioButton, c);
        ++c.gridy;
        this.leaveOneRandomLociRadioButton = new JRadioButton("leave one random loci");
        this.leaveOneRandomLociRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExperimentSettingsInternalFrame.this.getSettings().getParams().setLeaveNoNearLoci(ExperimentSettingsInternalFrame.this.leaveNoNearLociRadioButton.isSelected());
                ExperimentSettingsInternalFrame.this.getSettings().getParams().setLeaveRandomNearLoci(ExperimentSettingsInternalFrame.this.leaveOneRandomLociRadioButton.isSelected());
                ExperimentSettingsInternalFrame.this.getSettings().getParams().setLeaveMiddleNearLoci(ExperimentSettingsInternalFrame.this.leaveOneMiddleLociRadioButton.isSelected());
            }
        });
        panel.add((Component)this.leaveOneRandomLociRadioButton, c);
        ++c.gridy;
        this.leaveOneMiddleLociRadioButton = new JRadioButton("leave one loci");
        this.leaveOneMiddleLociRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExperimentSettingsInternalFrame.this.getSettings().getParams().setLeaveNoNearLoci(ExperimentSettingsInternalFrame.this.leaveNoNearLociRadioButton.isSelected());
                ExperimentSettingsInternalFrame.this.getSettings().getParams().setLeaveRandomNearLoci(ExperimentSettingsInternalFrame.this.leaveOneRandomLociRadioButton.isSelected());
                ExperimentSettingsInternalFrame.this.getSettings().getParams().setLeaveMiddleNearLoci(ExperimentSettingsInternalFrame.this.leaveOneMiddleLociRadioButton.isSelected());
            }
        });
        panel.add((Component)this.leaveOneMiddleLociRadioButton, c);
        ButtonGroup group = new ButtonGroup();
        group.add(this.leaveNoNearLociRadioButton);
        group.add(this.leaveOneRandomLociRadioButton);
        group.add(this.leaveOneMiddleLociRadioButton);
        label = new JLabel("Pre-Filter");
        label.setToolTipText(ToolTipMessage.preFilterMessage);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        panel.add((Component)label, c);
        this.prefilterLociCheckBox = new JCheckBox();
        this.prefilterLociCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ExperimentSettingsInternalFrame.this.minLociPrefilterLengthSpinner.setEnabled(ExperimentSettingsInternalFrame.this.prefilterLociCheckBox.isSelected());
                ExperimentSettingsInternalFrame.this.minLociPrefilterOffsetSpinner.setEnabled(ExperimentSettingsInternalFrame.this.prefilterLociCheckBox.isSelected());
                ExperimentSettingsInternalFrame.this.minLociPrefilterTagsSpinner.setEnabled(ExperimentSettingsInternalFrame.this.prefilterLociCheckBox.isSelected());
                ExperimentSettingsInternalFrame.this.getSettings().getParams().setPrefilterLoci(ExperimentSettingsInternalFrame.this.prefilterLociCheckBox.isSelected());
            }
        });
        c.gridx = 1;
        c.gridwidth = 1;
        panel.add((Component)this.prefilterLociCheckBox, c);
        label = new JLabel("Pre-Filter length");
        label.setToolTipText(ToolTipMessage.preFilterMessage);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        panel.add((Component)label, c);
        model = new SpinnerNumberModel(this.settings.getParams().getPrefilterLociLength(), 0, 10000, 1);
        this.minLociPrefilterLengthSpinner = new JSpinner(model);
        this.minLociPrefilterLengthSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ExperimentSettingsInternalFrame.this.getSettings().getParams().setPrefilterLociLength((Integer)ExperimentSettingsInternalFrame.this.minLociPrefilterLengthSpinner.getValue());
            }
        });
        ((JSpinner.DefaultEditor)this.minLociPrefilterLengthSpinner.getEditor()).getTextField().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                try {
                    String valString = ((JSpinner.DefaultEditor)ExperimentSettingsInternalFrame.this.minLociPrefilterLengthSpinner.getEditor()).getTextField().getText();
                    String parsed = "";
                    int i = 0;
                    while (i < valString.length()) {
                        try {
                            int val = Integer.parseInt(String.valueOf(valString.charAt(i)));
                            parsed = String.valueOf(parsed) + val;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++i;
                    }
                    if (parsed.equals("")) {
                        parsed = "0";
                    }
                    int val = Integer.parseInt(parsed);
                    ExperimentSettingsInternalFrame.this.getSettings().getParams().setPrefilterLociLength(val);
                }
                catch (Exception exception) {
                    Logger.writeExceptionLog(exception);
                }
            }
        });
        c.gridx = 2;
        c.gridwidth = 1;
        panel.add((Component)this.minLociPrefilterLengthSpinner, c);
        label = new JLabel("Pre-Filter offset");
        label.setToolTipText(ToolTipMessage.preFilterMessage);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        panel.add((Component)label, c);
        model = new SpinnerNumberModel(this.settings.getParams().getPrefilterLociOffset(), -10000, 10000, 1);
        this.minLociPrefilterOffsetSpinner = new JSpinner(model);
        this.minLociPrefilterOffsetSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ExperimentSettingsInternalFrame.this.getSettings().getParams().setPrefilterLociOffset((Integer)ExperimentSettingsInternalFrame.this.minLociPrefilterOffsetSpinner.getValue());
            }
        });
        ((JSpinner.DefaultEditor)this.minLociPrefilterOffsetSpinner.getEditor()).getTextField().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                try {
                    String valString = ((JSpinner.DefaultEditor)ExperimentSettingsInternalFrame.this.minLociPrefilterOffsetSpinner.getEditor()).getTextField().getText();
                    String parsed = "";
                    int i = 0;
                    while (i < valString.length()) {
                        try {
                            int val = Integer.parseInt(String.valueOf(valString.charAt(i)));
                            parsed = String.valueOf(parsed) + val;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++i;
                    }
                    if (parsed.equals("")) {
                        parsed = "0";
                    }
                    int val = Integer.parseInt(parsed);
                    ExperimentSettingsInternalFrame.this.getSettings().getParams().setPrefilterLociOffset(val);
                }
                catch (Exception exception) {
                    Logger.writeExceptionLog(exception);
                }
            }
        });
        c.gridx = 2;
        c.gridwidth = 1;
        panel.add((Component)this.minLociPrefilterOffsetSpinner, c);
        label = new JLabel("Pre-Filter tags");
        label.setToolTipText(ToolTipMessage.preFilterMessage);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        panel.add((Component)label, c);
        model = new SpinnerNumberModel(this.settings.getParams().getPrefilterLociTags(), 0, 10000, 1);
        this.minLociPrefilterTagsSpinner = new JSpinner(model);
        this.minLociPrefilterTagsSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ExperimentSettingsInternalFrame.this.getSettings().getParams().setPrefilterLociTags((Integer)ExperimentSettingsInternalFrame.this.minLociPrefilterTagsSpinner.getValue());
            }
        });
        ((JSpinner.DefaultEditor)this.minLociPrefilterTagsSpinner.getEditor()).getTextField().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                try {
                    String valString = ((JSpinner.DefaultEditor)ExperimentSettingsInternalFrame.this.minLociPrefilterTagsSpinner.getEditor()).getTextField().getText();
                    String parsed = "";
                    int i = 0;
                    while (i < valString.length()) {
                        try {
                            int val = Integer.parseInt(String.valueOf(valString.charAt(i)));
                            parsed = String.valueOf(parsed) + val;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++i;
                    }
                    if (parsed.equals("")) {
                        parsed = "0";
                    }
                    int val = Integer.parseInt(parsed);
                    ExperimentSettingsInternalFrame.this.getSettings().getParams().setPrefilterLociTags(val);
                }
                catch (Exception exception) {
                    Logger.writeExceptionLog(exception);
                }
            }
        });
        c.gridx = 2;
        c.gridwidth = 1;
        panel.add((Component)this.minLociPrefilterTagsSpinner, c);
        label = new JLabel("Filter low-tag loci: ");
        label.setToolTipText(ToolTipMessage.filterLowTagLociMessage);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        panel.add((Component)label, c);
        this.filterLowTagLociCheckBox = new JCheckBox();
        this.filterLowTagLociCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ExperimentSettingsInternalFrame.this.getSettings().getParams().setFilterLowTagLoci(ExperimentSettingsInternalFrame.this.filterLowTagLociCheckBox.isSelected());
                ExperimentSettingsInternalFrame.this.minLociTagCountSpinner.setEnabled(ExperimentSettingsInternalFrame.this.getSettings().getParams().isFilterLowTagLoci());
            }
        });
        c.gridx = 1;
        c.gridwidth = 1;
        panel.add((Component)this.filterLowTagLociCheckBox, c);
        model = new SpinnerNumberModel(this.settings.getParams().getMinLociTagCount(), 0, 1000000, 1);
        this.minLociTagCountSpinner = new JSpinner(model);
        this.minLociTagCountSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ExperimentSettingsInternalFrame.this.getSettings().getParams().setMinLociTagCount((Integer)ExperimentSettingsInternalFrame.this.minLociTagCountSpinner.getValue());
            }
        });
        ((JSpinner.DefaultEditor)this.minLociTagCountSpinner.getEditor()).getTextField().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                try {
                    String valString = ((JSpinner.DefaultEditor)ExperimentSettingsInternalFrame.this.minLociTagCountSpinner.getEditor()).getTextField().getText();
                    String parsed = "";
                    int i = 0;
                    while (i < valString.length()) {
                        try {
                            int val = Integer.parseInt(String.valueOf(valString.charAt(i)));
                            parsed = String.valueOf(parsed) + val;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++i;
                    }
                    if (parsed.equals("")) {
                        parsed = "0";
                    }
                    int val = Integer.parseInt(parsed);
                    ExperimentSettingsInternalFrame.this.getSettings().getParams().setMinLociTagCount(val);
                }
                catch (Exception exception) {
                    Logger.writeExceptionLog(exception);
                }
            }
        });
        c.gridx = 2;
        c.gridwidth = 1;
        panel.add((Component)this.minLociTagCountSpinner, c);
        label = new JLabel("Filter multi-tag loci: ");
        label.setToolTipText(ToolTipMessage.filterMultiTagLociMessage);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        panel.add((Component)label, c);
        this.filterMultiTagLociCheckBox = new JCheckBox();
        this.filterMultiTagLociCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ExperimentSettingsInternalFrame.this.getSettings().getParams().setFilterMultiTagLoci(ExperimentSettingsInternalFrame.this.filterMultiTagLociCheckBox.isSelected());
                ExperimentSettingsInternalFrame.this.maxLociTagCountSpinner.setEnabled(ExperimentSettingsInternalFrame.this.getSettings().getParams().isFilterMultiTagLoci());
            }
        });
        c.gridx = 1;
        c.gridwidth = 1;
        panel.add((Component)this.filterMultiTagLociCheckBox, c);
        model = new SpinnerNumberModel(this.settings.getParams().getMaxLociTagCount(), 0, 1000000000, 1);
        this.maxLociTagCountSpinner = new JSpinner(model);
        this.maxLociTagCountSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ExperimentSettingsInternalFrame.this.getSettings().getParams().setMaxLociTagCount((Integer)ExperimentSettingsInternalFrame.this.maxLociTagCountSpinner.getValue());
            }
        });
        ((JSpinner.DefaultEditor)this.maxLociTagCountSpinner.getEditor()).getTextField().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                try {
                    String valString = ((JSpinner.DefaultEditor)ExperimentSettingsInternalFrame.this.maxLociTagCountSpinner.getEditor()).getTextField().getText();
                    String parsed = "";
                    int i = 0;
                    while (i < valString.length()) {
                        try {
                            int val = Integer.parseInt(String.valueOf(valString.charAt(i)));
                            parsed = String.valueOf(parsed) + val;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++i;
                    }
                    if (parsed.equals("")) {
                        parsed = "0";
                    }
                    int val = Integer.parseInt(parsed);
                    ExperimentSettingsInternalFrame.this.getSettings().getParams().setMaxLociTagCount(val);
                }
                catch (Exception exception) {
                    Logger.writeExceptionLog(exception);
                }
            }
        });
        c.gridx = 2;
        c.gridwidth = 1;
        panel.add((Component)this.maxLociTagCountSpinner, c);
        return panel;
    }

    private JPanel createPositionsSettingsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        panel.setBorder(new TitledBorder("Positions"));
        JLabel label = new JLabel("Filter low-tag positions: ");
        label.setToolTipText(ToolTipMessage.filterLowTagPositionsLociMessage);
        panel.add((Component)label, c);
        this.filterLowTagPositionsCheckBox = new JCheckBox();
        this.filterLowTagPositionsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ExperimentSettingsInternalFrame.this.getSettings().getParams().setFilterLowTagPositions(ExperimentSettingsInternalFrame.this.filterLowTagPositionsCheckBox.isSelected());
                ExperimentSettingsInternalFrame.this.minPositionsTagCountSpinner.setEnabled(ExperimentSettingsInternalFrame.this.getSettings().getParams().isFilterLowTagPositions());
            }
        });
        c.gridx = 1;
        c.gridwidth = 1;
        panel.add((Component)this.filterLowTagPositionsCheckBox, c);
        SpinnerNumberModel model = new SpinnerNumberModel(this.settings.getParams().getMinPositionTagCount(), 0, 1000000, 1);
        this.minPositionsTagCountSpinner = new JSpinner(model);
        this.minPositionsTagCountSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ExperimentSettingsInternalFrame.this.getSettings().getParams().setMinPositionTagCount((Integer)ExperimentSettingsInternalFrame.this.minPositionsTagCountSpinner.getValue());
            }
        });
        ((JSpinner.DefaultEditor)this.minPositionsTagCountSpinner.getEditor()).getTextField().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                try {
                    String valString = ((JSpinner.DefaultEditor)ExperimentSettingsInternalFrame.this.minPositionsTagCountSpinner.getEditor()).getTextField().getText();
                    String parsed = "";
                    int i = 0;
                    while (i < valString.length()) {
                        try {
                            int val = Integer.parseInt(String.valueOf(valString.charAt(i)));
                            parsed = String.valueOf(parsed) + val;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++i;
                    }
                    if (parsed.equals("")) {
                        parsed = "0";
                    }
                    int val = Integer.parseInt(parsed);
                    ExperimentSettingsInternalFrame.this.getSettings().getParams().setMinPositionTagCount(val);
                }
                catch (Exception exception) {
                    Logger.writeExceptionLog(exception);
                }
            }
        });
        c.gridx = 2;
        c.gridwidth = 1;
        panel.add((Component)this.minPositionsTagCountSpinner, c);
        label = new JLabel("Filter multi-tag positions: ");
        label.setToolTipText(ToolTipMessage.filterMultiTagPositionsMessage);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        panel.add((Component)label, c);
        this.filterMultiTagPositionsCheckBox = new JCheckBox();
        this.filterMultiTagPositionsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ExperimentSettingsInternalFrame.this.getSettings().getParams().setFilterMultiTagPositions(ExperimentSettingsInternalFrame.this.filterMultiTagPositionsCheckBox.isSelected());
                ExperimentSettingsInternalFrame.this.maxPositionsTagCountSpinner.setEnabled(ExperimentSettingsInternalFrame.this.getSettings().getParams().isFilterMultiTagPositions());
            }
        });
        c.gridx = 1;
        c.gridwidth = 1;
        panel.add((Component)this.filterMultiTagPositionsCheckBox, c);
        model = new SpinnerNumberModel(this.settings.getParams().getMaxPositionTagCount(), 0, 1000000000, 1);
        this.maxPositionsTagCountSpinner = new JSpinner(model);
        this.maxPositionsTagCountSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ExperimentSettingsInternalFrame.this.getSettings().getParams().setMaxPositionTagCount((Integer)ExperimentSettingsInternalFrame.this.maxPositionsTagCountSpinner.getValue());
            }
        });
        ((JSpinner.DefaultEditor)this.maxPositionsTagCountSpinner.getEditor()).getTextField().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                try {
                    String valString = ((JSpinner.DefaultEditor)ExperimentSettingsInternalFrame.this.maxPositionsTagCountSpinner.getEditor()).getTextField().getText();
                    String parsed = "";
                    int i = 0;
                    while (i < valString.length()) {
                        try {
                            int val = Integer.parseInt(String.valueOf(valString.charAt(i)));
                            parsed = String.valueOf(parsed) + val;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++i;
                    }
                    if (parsed.equals("")) {
                        parsed = "0";
                    }
                    int val = Integer.parseInt(parsed);
                    ExperimentSettingsInternalFrame.this.getSettings().getParams().setMaxPositionTagCount(val);
                }
                catch (Exception exception) {
                    Logger.writeExceptionLog(exception);
                }
            }
        });
        c.gridx = 2;
        c.gridwidth = 1;
        panel.add((Component)this.maxPositionsTagCountSpinner, c);
        return panel;
    }

    public ExperimentSettings getSettings() {
        return this.settings;
    }

    protected void setExperimentParams(ExperimentParams params) {
        this.locusLengthSpinner.setValue(params.getLocusLength());
        this.locusOffsetSpinner.setValue(params.getLocusOffset());
        this.speciesTextField.setText(params.getSpeciesId());
        this.mainAttributeTextField.setText(params.getMainAttribute());
        this.secondaryAttributeTextField.setText(params.getSecondaryAttribute());
        this.secondaryAttributeTextField.setEnabled(params.isCheckStrand());
        this.checkStrandCheckBox.setSelected(params.isCheckStrand());
        this.checkStrandCheckBox.getActionListeners()[0].actionPerformed(null);
        this.filterMultipleAssignmentsCheckBox.setSelected(params.isFilterMultipleAssignments());
        this.saveLociListCheckBox.setSelected(params.isLociSave());
        this.saveLociListTextField.setText(new File(params.getLociSaveFile()).getName());
        this.saveLociListTextField.setEnabled(params.isLociSave());
        this.loadLociListCheckBox.setSelected(params.isLociLoad());
        this.loadLociListTextField.setText(new File(params.getLociLoadFile()).getName());
        this.loadLociListTextField.setEnabled(params.isLociLoad());
        this.filterLociTypesCheckBox.setSelected(params.isFilterLociTypes());
        this.filterLociTypesSelectButton.setEnabled(params.isFilterLociTypes());
        this.filterGOTermsCheckBox.setSelected(params.isFilterGOTerm());
        this.filterGOTermsTextField.setText(new File(params.getGOTermsFile()).getName());
        this.filterGOTermsTextField.setEnabled(params.isFilterGOTerm());
        this.filterShortLociCheckBox.setSelected(params.isFilterShortLoci());
        this.filterShortLociCheckBox.setEnabled(params.isCheckStrand());
        this.minLociLengthSpinner.setValue(params.getMinLociLength());
        this.minLociLengthSpinner.setEnabled(params.isFilterShortLoci() && params.isCheckStrand());
        this.filterLociCheckBox.setSelected(params.isLeaveNoNearLoci() || params.isLeaveRandomNearLoci() || params.isLeaveMiddleNearLoci());
        this.minLociDistanceSpinner.setValue(params.getMinLociDistance());
        this.minLociDistanceSpinner.setEnabled(params.isLeaveNoNearLoci() || params.isLeaveRandomNearLoci() || params.isLeaveMiddleNearLoci());
        this.prefilterLociCheckBox.setSelected(params.isPrefilterLoci());
        this.minLociPrefilterLengthSpinner.setValue(params.getPrefilterLociLength());
        this.minLociPrefilterLengthSpinner.setEnabled(params.isPrefilterLoci());
        this.minLociPrefilterOffsetSpinner.setValue(params.getPrefilterLociOffset());
        this.minLociPrefilterOffsetSpinner.setEnabled(params.isPrefilterLoci());
        this.minLociPrefilterTagsSpinner.setValue(params.getPrefilterLociTags());
        this.minLociPrefilterTagsSpinner.setEnabled(params.isPrefilterLoci());
        this.leaveNoNearLociRadioButton.setSelected(params.isLeaveNoNearLoci());
        this.leaveNoNearLociRadioButton.setEnabled(params.isLeaveNoNearLoci() || params.isLeaveRandomNearLoci() || params.isLeaveMiddleNearLoci());
        this.leaveOneRandomLociRadioButton.setSelected(params.isLeaveRandomNearLoci());
        this.leaveOneRandomLociRadioButton.setEnabled(params.isLeaveNoNearLoci() || params.isLeaveRandomNearLoci() || params.isLeaveMiddleNearLoci());
        this.leaveOneMiddleLociRadioButton.setSelected(params.isLeaveMiddleNearLoci());
        this.leaveOneMiddleLociRadioButton.setEnabled(params.isLeaveNoNearLoci() || params.isLeaveRandomNearLoci() || params.isLeaveMiddleNearLoci());
        this.filterLowTagLociCheckBox.setSelected(params.isFilterLowTagLoci());
        this.minLociTagCountSpinner.setValue(params.getMinLociTagCount());
        this.minLociTagCountSpinner.setEnabled(params.isFilterLowTagLoci());
        this.filterLowTagPositionsCheckBox.setSelected(params.isFilterLowTagPositions());
        this.minPositionsTagCountSpinner.setValue(params.getMinPositionTagCount());
        this.minPositionsTagCountSpinner.setEnabled(params.isFilterLowTagPositions());
        this.filterMultiTagLociCheckBox.setSelected(params.isFilterMultiTagLoci());
        this.maxLociTagCountSpinner.setValue(params.getMaxLociTagCount());
        this.maxLociTagCountSpinner.setEnabled(params.isFilterMultiTagLoci());
        this.filterMultiTagPositionsCheckBox.setSelected(params.isFilterMultiTagPositions());
        this.maxPositionsTagCountSpinner.setValue(params.getMaxPositionTagCount());
        this.maxPositionsTagCountSpinner.setEnabled(params.isFilterMultiTagPositions());
        this.assignmentsCountNormalizationCheckBox.setSelected(params.isAssignmentsCountNormalisation());
        this.enableDatabaseSettings(!params.isLociLoad());
    }

    public void changeSpecies(String species) {
        if (species == null) {
            return;
        }
        this.speciesTextField.setText(species);
        this.settings.getParams().setSpeciesId(species);
    }

    public void changeMainAttribute(String mainAttribute) {
        if (mainAttribute == null) {
            return;
        }
        this.mainAttributeTextField.setText(mainAttribute);
        this.settings.getParams().setMainAttribute(mainAttribute);
    }

    public void changeSecondaryAttribute(String secondaryAttribute) {
        if (secondaryAttribute == null) {
            return;
        }
        this.secondaryAttributeTextField.setText(secondaryAttribute);
        this.settings.getParams().setSecondaryAttribute(secondaryAttribute);
    }

    public void changeFilteredTypes(ArrayList<String> types) {
        this.settings.getParams().clearLociTypes();
        int i = 0;
        while (i < types.size()) {
            this.settings.getParams().addLociTypes(types.get(i));
            ++i;
        }
    }

    class FilteredTypesButtonActionListener
    implements ActionListener,
    TypesSelectionInternalFrameListener {
        private TypesSelectionInternalFrame frame;

        FilteredTypesButtonActionListener() {
        }

        @Override
        public void attributeSelected(ArrayList<String> attr) {
            ExperimentSettingsInternalFrame.this.changeFilteredTypes(attr);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.frame == null) {
                ExperimentSettingsInternalFrame.this.parent.enableGlassPane(true);
                HashSet<String> uniqueTypes = new HashSet<String>();
                HashSet<String> filteredTypes = new HashSet<String>();
                int i = 0;
                while (i < ExperimentSettingsInternalFrame.this.settings.getParams().getLociTypesCount()) {
                    filteredTypes.add(ExperimentSettingsInternalFrame.this.settings.getParams().getLociTypes(i));
                    ++i;
                }
                try {
                    ArrayList<String[]> types = BiomartConnector.getData(new String[]{"gene_biotype"}, ExperimentSettingsInternalFrame.this.settings.getParams().getSpeciesId(), null);
                    int i2 = 0;
                    while (i2 < types.size()) {
                        if (!uniqueTypes.contains(types.get(i2)[0])) {
                            uniqueTypes.add(types.get(i2)[0]);
                        }
                        ++i2;
                    }
                    Iterator it = uniqueTypes.iterator();
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(ExperimentSettingsInternalFrame.this.parent, e1.getMessage(), "Error", 0);
                    Logger.writeExceptionLog(e1);
                }
                this.frame = new TypesSelectionInternalFrame(ExperimentSettingsInternalFrame.this.parent, "Select filtered types", uniqueTypes, this, filteredTypes);
                ExperimentSettingsInternalFrame.this.parent.add(this.frame);
                ExperimentSettingsInternalFrame.this.parent.enableGlassPane(false);
            }
            this.frame.setVisible(true);
        }
    }

    class MainAttributeMouseAdapter
    extends MouseAdapter
    implements AttributeSelectionInternalFrameListener {
        private AttributeSelectionInternalFrame frame;

        MainAttributeMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1 && ExperimentSettingsInternalFrame.this.mainAttributeTextField.isEnabled()) {
                ExperimentSettingsInternalFrame.this.parent.positionSettingsChanged();
                if (this.frame == null) {
                    ExperimentSettingsInternalFrame.this.parent.enableGlassPane(true);
                    HashMap<String, String> attributes = null;
                    try {
                        attributes = BiomartConnector.getAttributes(ExperimentSettingsInternalFrame.this.settings.getParams().getSpeciesId());
                    }
                    catch (IOException e1) {
                        JOptionPane.showMessageDialog(ExperimentSettingsInternalFrame.this.parent, e1.getMessage(), "Error", 0);
                        Logger.writeExceptionLog(e1);
                    }
                    this.frame = new AttributeSelectionInternalFrame(ExperimentSettingsInternalFrame.this.parent, "Select main attribute", attributes, this);
                    ExperimentSettingsInternalFrame.this.parent.add(this.frame);
                    ExperimentSettingsInternalFrame.this.parent.enableGlassPane(false);
                }
                this.frame.setVisible(true);
            }
        }

        @Override
        public void attributeSelected(String attr) {
            ExperimentSettingsInternalFrame.this.changeMainAttribute(attr);
        }
    }

    class SecondaryAttributeMouseAdapter
    extends MouseAdapter
    implements AttributeSelectionInternalFrameListener {
        private AttributeSelectionInternalFrame frame;

        SecondaryAttributeMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1 && ExperimentSettingsInternalFrame.this.settings.getParams().isCheckStrand() && ExperimentSettingsInternalFrame.this.secondaryAttributeTextField.isEnabled()) {
                ExperimentSettingsInternalFrame.this.parent.positionSettingsChanged();
                if (this.frame == null) {
                    ExperimentSettingsInternalFrame.this.parent.enableGlassPane(true);
                    HashMap<String, String> attributes = null;
                    try {
                        attributes = BiomartConnector.getAttributes(ExperimentSettingsInternalFrame.this.settings.getParams().getSpeciesId());
                    }
                    catch (IOException e1) {
                        JOptionPane.showMessageDialog(ExperimentSettingsInternalFrame.this.parent, e1.getMessage(), "Error", 0);
                        Logger.writeExceptionLog(e1);
                    }
                    this.frame = new AttributeSelectionInternalFrame(ExperimentSettingsInternalFrame.this.parent, "Select secondary attribute", attributes, this);
                    ExperimentSettingsInternalFrame.this.parent.add(this.frame);
                    ExperimentSettingsInternalFrame.this.parent.enableGlassPane(false);
                }
                this.frame.setVisible(true);
            }
        }

        @Override
        public void attributeSelected(String attr) {
            ExperimentSettingsInternalFrame.this.changeSecondaryAttribute(attr);
        }
    }

    class SpeciesMouseAdapter
    extends MouseAdapter
    implements AttributeSelectionInternalFrameListener {
        private AttributeSelectionInternalFrame frame;

        SpeciesMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1 && ExperimentSettingsInternalFrame.this.speciesTextField.isEnabled()) {
                ExperimentSettingsInternalFrame.this.parent.positionSettingsChanged();
                HashMap<String, String> attributes = null;
                attributes = SpeciesSettings.getSpeciesHashMap();
                if (this.frame == null) {
                    ExperimentSettingsInternalFrame.this.parent.enableGlassPane(true);
                    this.frame = new AttributeSelectionInternalFrame(ExperimentSettingsInternalFrame.this.parent, "Select species", attributes, this);
                    ExperimentSettingsInternalFrame.this.parent.add(this.frame);
                    ExperimentSettingsInternalFrame.this.parent.enableGlassPane(false);
                }
                this.frame.setVisible(true);
            }
        }

        @Override
        public void attributeSelected(String attr) {
            ExperimentSettingsInternalFrame.this.changeSpecies(attr);
        }
    }
}

