/*
 * Decompiled with CFR 0.152.
 */
package gui;

import biomart.SpeciesSettings;
import gui.ChromosomeFigureInternalFrame;
import gui.ExperimentSettingsInternalFrame;
import gui.LociTableInternalFrame;
import gui.Logger;
import gui.MenuFrame;
import gui.PackableScatterPlotInternalFrame;
import gui.ProfileScatterPlot;
import gui.ProgressInternalFrame;
import gui.ProgressInternalFrameListener;
import gui.ReportInternalFrame;
import gui.TagHistogramScatterPlot;
import gui.treeNodes.ChromosomeDataTreeNode;
import gui.treeNodes.ChromosomesTreeNode;
import gui.treeNodes.ExperimentTreeNode;
import gui.treeNodes.LociHistogramTreeNode;
import gui.treeNodes.LociTableTreeNode;
import gui.treeNodes.PositionsHistogramTreeNode;
import gui.treeNodes.ProfileFigureTreeNode;
import gui.treeNodes.ReportTreeNode;
import gui.treeNodes.ResultsCatalogTreeNode;
import gui.treeNodes.ResultsTreeNode;
import io.TableFileReader;
import java.awt.Color;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import javax.swing.JDesktopPane;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import math.ChromosomeData;
import math.ExperimentReporter;
import math.ExperimentResults;
import math.FigureData;
import math.LocusInfo;
import math.PositionInfo;
import math.Profiler;
import math.ProfilerData;
import math.ProfilerListener;
import settings.ExperimentSettings;
import settings.ExperimentSettingsWriter;

public class ExperimentDesktop
extends JDesktopPane {
    private static final long serialVersionUID = 1L;
    private ExperimentSettings expSettings;
    private ExperimentTreeNode expNode;
    private DefaultTreeModel treeModel;
    private ExperimentSettingsInternalFrame settingsFrame;
    private HashMap<Integer, LocusInfo>[] loci;
    private HashMap<String, ProfilerData> profilerDataSet;
    private MenuFrame parent;
    private boolean positionSettingsChanged = true;
    private ExperimentReporter reporter;
    private ArrayList<String> experimentQueue;
    private String currentName;

    public ExperimentDesktop(MenuFrame parent, ExperimentSettings expSettings, ExperimentTreeNode expNode, DefaultTreeModel model) {
        this.expSettings = expSettings;
        this.expNode = expNode;
        this.treeModel = model;
        this.parent = parent;
        this.profilerDataSet = new HashMap();
        this.setBackground(Color.LIGHT_GRAY);
    }

    public String getExperimentName() {
        return this.expSettings.getName();
    }

    public ExperimentSettings getExperimentSettings() {
        return this.expSettings;
    }

    public void showSettings() {
        if (this.settingsFrame == null) {
            this.settingsFrame = new ExperimentSettingsInternalFrame(this, this.expSettings);
            this.settingsFrame.setLocation(Math.max(0, (this.getWidth() - this.settingsFrame.getWidth()) / 2), Math.max(0, (this.getHeight() - this.settingsFrame.getHeight()) / 2));
            this.add(this.settingsFrame);
        }
        this.settingsFrame.setVisible(true);
        this.settingsFrame.toFront();
        this.settingsFrame.requestFocus();
    }

    public void saveSettings() throws ParserConfigurationException, IOException, TransformerException {
        ExperimentSettingsWriter.writeExperimentSettings(this.expSettings, String.valueOf(this.expSettings.getPath()) + "settings.xml");
    }

    public void runExperiment() {
        int i;
        int chromosomesCount = SpeciesSettings.getChromosomesCount(this.expSettings.getParams().getSpeciesId());
        if (this.positionSettingsChanged) {
            this.loci = new HashMap[chromosomesCount];
            i = 0;
            while (i < chromosomesCount) {
                this.loci[i] = new HashMap(5000);
                ++i;
            }
        }
        if (this.expSettings.getAssignmentFilesCount() == 0) {
            JOptionPane.showInternalMessageDialog(this, "No assignment file specified.", "Error", 0);
            return;
        }
        this.experimentQueue = new ArrayList();
        i = 0;
        while (i < this.expSettings.getAssignmentFilesCount()) {
            this.experimentQueue.add(this.expSettings.getAssignmentFile(i));
            ++i;
        }
        ArrayList<String> dataToRemove = new ArrayList<String>();
        for (String name : this.profilerDataSet.keySet()) {
            if (this.experimentQueue.contains(name)) continue;
            dataToRemove.add(name);
        }
        int i2 = 0;
        while (i2 < dataToRemove.size()) {
            this.profilerDataSet.remove(dataToRemove.get(i2));
            ++i2;
        }
        this.reporter = new ExperimentReporter(chromosomesCount, this.expSettings);
        this.runExperimentForFile(this.experimentQueue.get(0));
        this.experimentQueue.remove(0);
    }

    public void positionSettingsChanged() {
        this.positionSettingsChanged = true;
    }

    private void runExperimentForFile(String assignmentFile) {
        int chromosomesCount = SpeciesSettings.getChromosomesCount(this.expSettings.getParams().getSpeciesId());
        boolean readData = false;
        if (!this.profilerDataSet.containsKey(assignmentFile)) {
            this.profilerDataSet.put(assignmentFile, new ProfilerData(chromosomesCount, this.loci));
            readData = true;
        }
        if (this.expSettings.getBowtieFile() == null || !this.expSettings.getBowtieFile().equals(assignmentFile)) {
            this.expSettings.setBowtieFile(assignmentFile);
        }
        ProfilerThread profilerThread = new ProfilerThread(this.profilerDataSet.get(assignmentFile), readData);
        Thread t = new Thread(profilerThread);
        t.start();
    }

    public void showFigure(FigureData data, ExperimentResults results) throws FileNotFoundException {
        ArrayList[] hist = new ArrayList[1];
        if (data.getHistogram() == null) {
            File f = new File(String.valueOf(this.expSettings.getPath()) + results.getFigureFile());
            hist[0] = new ArrayList();
            BufferedReader reader = new BufferedReader(new FileReader(f));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    hist[0].add(Double.parseDouble(line));
                }
                reader.close();
            }
            catch (Exception e) {
                Logger.writeExceptionLog(e);
            }
            data.setHistogram(hist[0]);
        } else {
            hist[0] = data.getHistogram();
        }
        ProfileScatterPlot plot = new ProfileScatterPlot(hist, new int[]{results.getLocusOffset() - results.getLocusLength() / 2}, null, this.expSettings.getName(), this.expSettings.getPath(), results.getName());
        PackableScatterPlotInternalFrame frame = new PackableScatterPlotInternalFrame(results.getName(), plot);
        this.add(frame);
        frame.setVisible(true);
    }

    public void showReport(ExperimentResults results) {
        ReportInternalFrame frame = new ReportInternalFrame(results.getName(), String.valueOf(this.expSettings.getPath()) + results.getReportFile());
        frame.setSize(this.getWidth() / 2, this.getHeight());
        this.add(frame);
        frame.setVisible(true);
    }

    public void showLociTable(ExperimentResults results) {
        ArrayList<String[]> tab;
        try {
            tab = TableFileReader.readTable(String.valueOf(this.expSettings.getPath()) + results.getGenesFile());
        }
        catch (IOException e) {
            JOptionPane.showInternalMessageDialog(this, "Error while loci file reading: " + e.getMessage(), "Error", 0);
            Logger.writeExceptionLog(e);
            return;
        }
        LociTableInternalFrame frame = new LociTableInternalFrame(this.expSettings, results.getName(), tab, this);
        this.add(frame);
        frame.setVisible(true);
    }

    public void showChromosome(ChromosomeData data, ExperimentResults results) throws FileNotFoundException {
        String line;
        File fp = new File(data.getPositionFilePath());
        File ft = new File(data.getTagFilePath());
        ArrayList<Integer> tagsx = new ArrayList<Integer>();
        ArrayList<Double> tagsy = new ArrayList<Double>();
        ArrayList<Integer> positions = new ArrayList<Integer>();
        ArrayList<String[]> genesId = null;
        BufferedReader reader = new BufferedReader(new FileReader(fp));
        try {
            while ((line = reader.readLine()) != null) {
                positions.add(Integer.parseInt(line.split("\t")[0]));
            }
            reader.close();
            genesId = TableFileReader.readTable(String.valueOf(this.expSettings.getPath()) + results.getGenesFile());
            int chrom = data.getChromosomeNumber();
            int i = genesId.size() - 1;
            while (i >= 0) {
                if (chrom != Integer.parseInt(genesId.get(i)[4])) {
                    genesId.remove(i);
                }
                --i;
            }
        }
        catch (Exception e) {
            Logger.writeExceptionLog(e);
        }
        reader = new BufferedReader(new FileReader(ft));
        try {
            while ((line = reader.readLine()) != null) {
                String[] tab = line.split("\t");
                tagsx.add(Integer.parseInt(tab[0]));
                tagsy.add(Double.parseDouble(tab[1]));
            }
            reader.close();
        }
        catch (Exception e) {
            Logger.writeExceptionLog(e);
        }
        ChromosomeFigureInternalFrame frame = new ChromosomeFigureInternalFrame(results.getName(), data.getChromosomeName(), tagsx, tagsy, positions, this.expSettings.getParams().getLocusLength(), genesId);
        this.add(frame);
        frame.setVisible(true);
    }

    public void showPositionTagsHistogram(ExperimentResults results) {
        HashMap<Double, Integer> tags = new HashMap<Double, Integer>();
        int i = 0;
        while (i < results.getChromosomes().size()) {
            File ft = new File(results.getChromosomes().get(i).getTagFilePath());
            try {
                String line;
                BufferedReader reader = new BufferedReader(new FileReader(ft));
                while ((line = reader.readLine()) != null) {
                    String[] tab = line.split("\t");
                    double tagCount = Double.parseDouble(tab[1]);
                    if (tags.get(tagCount) == null) {
                        tags.put(tagCount, 1);
                        continue;
                    }
                    int t = (Integer)tags.get(tagCount) + 1;
                    tags.put(tagCount, t);
                }
                reader.close();
            }
            catch (Exception e) {
                Logger.writeExceptionLog(e);
            }
            ++i;
        }
        Double[] hXI = tags.keySet().toArray(new Double[0]);
        double[][] hX = new double[1][];
        double[][] hY = new double[1][];
        hX[0] = new double[hXI.length];
        hY[0] = new double[hXI.length];
        int i2 = 0;
        while (i2 < hX[0].length) {
            hX[0][i2] = hXI[i2];
            hY[0][i2] = ((Integer)tags.get(hX[0][i2])).intValue();
            ++i2;
        }
        TagHistogramScatterPlot plot = new TagHistogramScatterPlot("histogram_pos", 0, this.expSettings.getPath(), this.expSettings.getName(), new String[]{results.getName()}, hX, hY, "#tags", "#positions", "tags in positions histogram", false, 0, 0, false);
        PackableScatterPlotInternalFrame frame = new PackableScatterPlotInternalFrame(results.getName(), plot);
        this.add(frame);
        frame.setVisible(true);
    }

    public void showLociTagsHistogram(ExperimentResults results) {
        HashMap<Double, Integer> tags = new HashMap<Double, Integer>();
        int i = 0;
        while (i < results.getChromosomes().size()) {
            File ft = new File(results.getChromosomes().get(i).getPositionFilePath());
            try {
                String line;
                BufferedReader reader = new BufferedReader(new FileReader(ft));
                while ((line = reader.readLine()) != null) {
                    String[] tab = line.split("\t");
                    double tagCount = Double.parseDouble(tab[1]);
                    if (tags.get(tagCount) == null) {
                        tags.put(tagCount, 1);
                        continue;
                    }
                    int t = (Integer)tags.get(tagCount) + 1;
                    tags.put(tagCount, t);
                }
                reader.close();
            }
            catch (Exception e) {
                Logger.writeExceptionLog(e);
            }
            ++i;
        }
        Double[] hXI = tags.keySet().toArray(new Double[0]);
        double[][] hX = new double[1][];
        double[][] hY = new double[1][];
        hX[0] = new double[hXI.length];
        hY[0] = new double[hXI.length];
        int i2 = 0;
        while (i2 < hX[0].length) {
            hX[0][i2] = hXI[i2];
            hY[0][i2] = ((Integer)tags.get(hX[0][i2])).intValue();
            ++i2;
        }
        TagHistogramScatterPlot plot = new TagHistogramScatterPlot("histogram_loci", results.getLocusLength(), this.expSettings.getPath(), this.expSettings.getName(), new String[]{results.getName()}, hX, hY, "#tags", "#loci", "tags in loci histogram", false, 0, 0, false);
        PackableScatterPlotInternalFrame frame = new PackableScatterPlotInternalFrame(results.getName(), plot);
        this.add(frame);
        frame.setVisible(true);
    }

    public void experimentStopped() {
        this.clearData(true);
    }

    public void clearData(boolean withProfiles) {
        this.positionSettingsChanged = true;
        if (withProfiles) {
            this.profilerDataSet.clear();
        }
        this.loci = null;
        this.reporter = null;
    }

    private void savePositionsLeft(String fileName, ProfilerData profilerData) {
        File f = new File(String.valueOf(this.expSettings.getPath()) + fileName);
        try {
            f.createNewFile();
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(f));
            int i = 0;
            while (i < profilerData.getChromosomes()) {
                LocusInfo[] loci = profilerData.getMatchedLoci(i);
                int j = 0;
                while (j < loci.length) {
                    int position = loci[j].getCoordinate();
                    float tags = loci[j].getTagCount();
                    String id = loci[j].getId();
                    String name = loci[j].getName();
                    String desc = loci[j].getDescription();
                    int length = loci[j].getLength();
                    bufferedWriter.write(String.valueOf(position) + "\t" + id + "\t" + name + "\t" + tags + "\t" + (i + 1) + "\t" + desc + "\t" + length);
                    bufferedWriter.newLine();
                    ++j;
                }
                ++i;
            }
            bufferedWriter.close();
        }
        catch (Exception e) {
            JOptionPane.showInternalMessageDialog(this, e.getMessage(), "Error", 0);
            Logger.writeExceptionLog(e);
            return;
        }
    }

    public void experimentDone(double[] histogram, ProfilerData profilerData) {
        this.reporter.setMaxPos(profilerData.getMaxTagsPerLoci());
        this.reporter.setMaxTags(profilerData.getMaxTagsPerPosition());
        this.reporter.setMeanPos(profilerData.getMeanTagsPerLocus());
        this.reporter.setMeanTags(profilerData.getMeanTagsPerPosition());
        int figNum = this.expSettings.getResults().size() + 1;
        String resName = "profile" + figNum;
        ExperimentResults results = new ExperimentResults(resName, this.expSettings.getParams().getLocusLength(), this.expSettings.getParams().getLocusOffset(), this.currentName);
        String figureName = results.getFigureFile();
        String reportName = results.getReportFile();
        this.reporter.saveReportToFile(String.valueOf(this.expSettings.getPath()) + reportName);
        this.reporter.clearCalculatedData();
        File figureFile = new File(String.valueOf(this.expSettings.getPath()) + figureName);
        try {
            figureFile.createNewFile();
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(figureFile));
            int i = 0;
            while (i < histogram.length) {
                bufferedWriter.write(String.valueOf(histogram[i]));
                bufferedWriter.newLine();
                ++i;
            }
            bufferedWriter.close();
        }
        catch (Exception e) {
            JOptionPane.showInternalMessageDialog(this, e.getMessage(), "Error", 0);
            Logger.writeExceptionLog(e);
            return;
        }
        this.expSettings.addResults(results);
        ResultsTreeNode resultsNode = new ResultsTreeNode(results);
        ProfileFigureTreeNode figureNode = new ProfileFigureTreeNode(new FigureData());
        ReportTreeNode reportNode = new ReportTreeNode();
        LociTableTreeNode lociTableNode = new LociTableTreeNode();
        LociHistogramTreeNode lociHistNode = new LociHistogramTreeNode();
        PositionsHistogramTreeNode posHistNode = new PositionsHistogramTreeNode();
        resultsNode.add(figureNode);
        resultsNode.add(reportNode);
        resultsNode.add(lociTableNode);
        resultsNode.add(lociHistNode);
        resultsNode.add(posHistNode);
        boolean inserted = false;
        ChromosomesTreeNode chroms = new ChromosomesTreeNode();
        resultsNode.add(chroms);
        int i = 0;
        while (i < profilerData.getChromosomes()) {
            String tagFileExt = ".t" + (i + 1);
            String posFileExt = ".p" + (i + 1);
            File tagFile = new File(String.valueOf(this.expSettings.getPath()) + this.currentName + tagFileExt);
            File posFile = new File(String.valueOf(this.expSettings.getPath()) + this.currentName + posFileExt);
            String chName = "chr" + SpeciesSettings.getChromosomeName(this.expSettings.getParams().getSpeciesId(), i);
            ChromosomeData chData = new ChromosomeData(chName, posFile.getPath(), tagFile.getPath(), i + 1);
            ChromosomeDataTreeNode chromData = new ChromosomeDataTreeNode(chData);
            chroms.add(chromData);
            results.addChromosomeData(chData);
            try {
                tagFile.createNewFile();
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(tagFile));
                PositionInfo[] positions = profilerData.getMatchedPositions(i);
                LocusInfo[] loci = profilerData.getMatchedLoci(i);
                int j = 0;
                while (j < positions.length) {
                    if (positions[j].isMatched()) {
                        bufferedWriter.write(String.valueOf(positions[j].getCoordinate()) + "\t" + positions[j].getTagCount());
                        bufferedWriter.newLine();
                    }
                    ++j;
                }
                bufferedWriter.close();
                posFile.createNewFile();
                bufferedWriter = new BufferedWriter(new FileWriter(posFile));
                j = 0;
                while (j < loci.length) {
                    if (loci[j].isMatched()) {
                        bufferedWriter.write(String.valueOf(loci[j].getCoordinate()) + "\t" + loci[j].getTagCount());
                        bufferedWriter.newLine();
                    }
                    ++j;
                }
                bufferedWriter.close();
            }
            catch (Exception e) {
                JOptionPane.showInternalMessageDialog(this, e.getMessage(), "Error", 0);
                Logger.writeExceptionLog(e);
                return;
            }
            ++i;
        }
        this.savePositionsLeft(results.getGenesFile(), profilerData);
        int childCount = this.treeModel.getChildCount(this.expNode);
        int i2 = 0;
        while (i2 < childCount) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)this.treeModel.getChild(this.expNode, i2);
            if (child.getClass().getName().equals(ResultsCatalogTreeNode.class.getName())) {
                this.treeModel.insertNodeInto(resultsNode, child, child.getChildCount());
                inserted = true;
            }
            ++i2;
        }
        if (!inserted) {
            ResultsCatalogTreeNode resultsSetNode = new ResultsCatalogTreeNode();
            this.treeModel.insertNodeInto(resultsSetNode, this.expNode, this.expNode.getChildCount());
            this.treeModel.insertNodeInto(resultsNode, resultsSetNode, resultsSetNode.getChildCount());
        }
        if (!this.expSettings.isKeepData()) {
            this.profilerDataSet.clear();
        }
        if (this.experimentQueue.size() > 0) {
            this.runExperimentForFile(this.experimentQueue.get(0));
            this.experimentQueue.remove(0);
        }
    }

    public void enableGlassPane(boolean enabled) {
        this.parent.enableGlassPane(enabled);
    }

    public void addToGlassPane(Component c) {
        this.parent.attachToGlassPane(c);
    }

    class ProfilerThread
    implements Runnable,
    ProfilerListener,
    ProgressInternalFrameListener {
        private Profiler p;
        private long tagFileLen;
        private ProgressInternalFrame progressFrame;
        private long time;
        private boolean forceStop;
        private boolean readTags;
        private long startTime;
        private ProfilerData profilerData;

        public ProfilerThread(ProfilerData pData, boolean readTags) {
            this.profilerData = pData;
            this.readTags = readTags;
        }

        @Override
        public void run() {
            ExperimentDesktop.this.enableGlassPane(true);
            this.progressFrame = new ProgressInternalFrame("Please wait", "", 100, true, true, this);
            ExperimentDesktop.this.addToGlassPane(this.progressFrame);
            this.progressFrame.setVisible(true);
            GregorianCalendar calendar = new GregorianCalendar();
            ExperimentDesktop.this.currentName = String.valueOf(calendar.get(5)) + "_" + (calendar.get(2) + 1) + "_" + calendar.get(1) + "_" + calendar.get(11) + "_" + calendar.get(12) + "_" + calendar.get(13) + "_" + calendar.get(14);
            this.p = new Profiler(ExperimentDesktop.this.expSettings, SpeciesSettings.getChromosomesCount(ExperimentDesktop.this.expSettings.getParams().getSpeciesId()));
            this.p.setProfilerData(this.profilerData);
            this.p.addListener(this);
            this.time = System.currentTimeMillis();
            try {
                this.profilerData.clearCalculatedData();
                if (ExperimentDesktop.this.positionSettingsChanged) {
                    this.progressFrame.updateLabel("Loading loci...");
                    ExperimentDesktop.this.positionSettingsChanged = false;
                    this.profilerData.removeLoci();
                    this.p.readPositionsData();
                } else {
                    this.dataFromDataBaseReceived(this.profilerData);
                }
                if (this.readTags) {
                    this.profilerData.removePositions();
                    this.p.readTagData();
                } else {
                    this.tagsReadingFinished(this.profilerData);
                }
                if (this.forceStop) {
                    return;
                }
                this.progressFrame.updateValue(0);
                this.progressFrame.updateLabel("Processing and matching tags...");
                this.p.buildBindingProfile();
            }
            catch (IOException e) {
                JOptionPane.showInternalMessageDialog(ExperimentDesktop.this, e.getMessage(), "Error", 0);
                Logger.writeExceptionLog(e);
            }
        }

        @Override
        public void dataFromDataBaseReceived(ProfilerData data) {
            int i = 0;
            while (i < data.getChromosomes()) {
                ((ExperimentDesktop)ExperimentDesktop.this).reporter.getLoci()[i] = data.getLociCount(i);
                ++i;
            }
        }

        @Override
        public void tagsReadingStart(long fileLen) {
            this.progressFrame.updateValue(0);
            this.progressFrame.updateLabel("Reading tag file: " + ExperimentDesktop.this.expSettings.getBowtieFile());
            this.tagFileLen = fileLen;
            this.startTime = System.currentTimeMillis();
        }

        @Override
        public void tagsReadingUpdate(long fileLenLeft) {
            int newValue = (int)(100L * (this.tagFileLen - fileLenLeft) / this.tagFileLen);
            this.progressFrame.updateValue(newValue);
            long currentTime = System.currentTimeMillis() - this.startTime;
            this.progressFrame.updateTime((long)(100 - newValue) * currentTime / (long)newValue);
        }

        @Override
        public void tagsReadingFinished(ProfilerData data) {
            int i = 0;
            while (i < data.getChromosomes()) {
                PositionInfo[] positions = data.getPositions(i);
                ((ExperimentDesktop)ExperimentDesktop.this).reporter.getTags()[i] = 0.0f;
                int j = 0;
                while (j < positions.length) {
                    float[] fArray = ExperimentDesktop.this.reporter.getTags();
                    int n = i;
                    fArray[n] = fArray[n] + positions[j].getTagCount();
                    ++j;
                }
                ++i;
            }
            this.progressFrame.updateTime(0L);
        }

        @Override
        public void filteringShortLociFinished(ProfilerData data, int[] removed) {
            this.progressFrame.updateValue(25);
            int i = 0;
            while (i < data.getChromosomes()) {
                ((ExperimentDesktop)ExperimentDesktop.this).reporter.getShortLociFiltered()[i] = removed[i];
                ++i;
            }
        }

        @Override
        public void prefilteringLociFinished(ProfilerData data, int[] removed) {
            this.progressFrame.updateValue(25);
            int i = 0;
            while (i < data.getChromosomes()) {
                ((ExperimentDesktop)ExperimentDesktop.this).reporter.getPrefilteredLoci()[i] = removed[i];
                ++i;
            }
        }

        @Override
        public void filteringNearLociFinished(ProfilerData data, int[] removed) {
            this.progressFrame.updateValue(25);
            int i = 0;
            while (i < data.getChromosomes()) {
                ((ExperimentDesktop)ExperimentDesktop.this).reporter.getNearLociFiltered()[i] = removed[i];
                ++i;
            }
        }

        @Override
        public void tagsMatchingFinished(ProfilerData data) {
            this.progressFrame.updateValue(50);
            int i = 0;
            while (i < data.getChromosomes()) {
                PositionInfo[] positions = data.getMatchedPositions(i);
                LocusInfo[] loci = data.getMatchedLoci(i);
                ((ExperimentDesktop)ExperimentDesktop.this).reporter.getTagsMatched()[i] = 0.0f;
                ((ExperimentDesktop)ExperimentDesktop.this).reporter.getPositionsMatched()[i] = 0;
                ((ExperimentDesktop)ExperimentDesktop.this).reporter.getLociMatched()[i] = 0;
                int j = 0;
                while (j < positions.length) {
                    float[] fArray = ExperimentDesktop.this.reporter.getTagsMatched();
                    int n = i;
                    fArray[n] = fArray[n] + positions[j].getTagCount();
                    int[] nArray = ExperimentDesktop.this.reporter.getPositionsMatched();
                    int n2 = i;
                    nArray[n2] = nArray[n2] + 1;
                    ++j;
                }
                j = 0;
                while (j < loci.length) {
                    int[] nArray = ExperimentDesktop.this.reporter.getLociMatched();
                    int n = i;
                    nArray[n] = nArray[n] + 1;
                    ++j;
                }
                ++i;
            }
        }

        @Override
        public void filteringAssignmentsFinished(ProfilerData data, float[] filtered) {
            this.progressFrame.updateValue(75);
            int i = 0;
            while (i < data.getChromosomes()) {
                ((ExperimentDesktop)ExperimentDesktop.this).reporter.getTagsFiltered()[i] = filtered[i];
                PositionInfo[] positions = data.getMatchedPositions(i);
                LocusInfo[] loci = data.getMatchedLoci(i);
                ((ExperimentDesktop)ExperimentDesktop.this).reporter.getPositionsMatched()[i] = 0;
                ((ExperimentDesktop)ExperimentDesktop.this).reporter.getLociMatched()[i] = 0;
                int j = 0;
                while (j < positions.length) {
                    int[] nArray = ExperimentDesktop.this.reporter.getPositionsMatched();
                    int n = i;
                    nArray[n] = nArray[n] + 1;
                    ++j;
                }
                j = 0;
                while (j < loci.length) {
                    int[] nArray = ExperimentDesktop.this.reporter.getLociMatched();
                    int n = i;
                    nArray[n] = nArray[n] + 1;
                    ++j;
                }
                ++i;
            }
        }

        @Override
        public void histogramGenerated(double[] histogram) {
            ExperimentDesktop.this.reporter.setElapsedTime(System.currentTimeMillis() - this.time);
            this.progressFrame.updateValue(100);
            this.progressFrame.dispose();
            this.progressFrame = null;
            ExperimentDesktop.this.enableGlassPane(false);
            this.p = null;
            ExperimentDesktop.this.experimentDone(histogram, this.profilerData);
            this.profilerData = null;
        }

        @Override
        public void stopButtonPressed() {
            this.p.forceStop();
            this.forceStop = true;
        }

        @Override
        public void forceStop() {
            this.progressFrame.hide();
            this.progressFrame.dispose();
            this.progressFrame = null;
            ExperimentDesktop.this.enableGlassPane(false);
            ExperimentDesktop.this.experimentStopped();
            this.p = null;
            this.profilerData = null;
        }

        @Override
        public void filteringMultiTagsLociFinished(ProfilerData data, float[][] filtered) {
            int i = 0;
            while (i < data.getChromosomes()) {
                ((ExperimentDesktop)ExperimentDesktop.this).reporter.getMultiTagInLociFiltered()[i] = filtered[i][0];
                ((ExperimentDesktop)ExperimentDesktop.this).reporter.getMultiTagLociFiltered()[i] = filtered[i][1];
                PositionInfo[] positions = data.getMatchedPositions(i);
                LocusInfo[] loci = data.getMatchedLoci(i);
                ((ExperimentDesktop)ExperimentDesktop.this).reporter.getPositionsMatched()[i] = 0;
                ((ExperimentDesktop)ExperimentDesktop.this).reporter.getLociMatched()[i] = 0;
                int j = 0;
                while (j < positions.length) {
                    int[] nArray = ExperimentDesktop.this.reporter.getPositionsMatched();
                    int n = i;
                    nArray[n] = nArray[n] + 1;
                    ++j;
                }
                j = 0;
                while (j < loci.length) {
                    int[] nArray = ExperimentDesktop.this.reporter.getLociMatched();
                    int n = i;
                    nArray[n] = nArray[n] + 1;
                    ++j;
                }
                ++i;
            }
        }

        @Override
        public void filteringMultiTagsPositionsFinished(ProfilerData data, float[][] filtered) {
            int i = 0;
            while (i < data.getChromosomes()) {
                ((ExperimentDesktop)ExperimentDesktop.this).reporter.getMultiTagInPositionsFiltered()[i] = filtered[i][0];
                ((ExperimentDesktop)ExperimentDesktop.this).reporter.getMultiTagPositionsFiltered()[i] = filtered[i][1];
                PositionInfo[] positions = data.getMatchedPositions(i);
                LocusInfo[] loci = data.getMatchedLoci(i);
                ((ExperimentDesktop)ExperimentDesktop.this).reporter.getPositionsMatched()[i] = 0;
                ((ExperimentDesktop)ExperimentDesktop.this).reporter.getLociMatched()[i] = 0;
                int j = 0;
                while (j < positions.length) {
                    int[] nArray = ExperimentDesktop.this.reporter.getPositionsMatched();
                    int n = i;
                    nArray[n] = nArray[n] + 1;
                    ++j;
                }
                j = 0;
                while (j < loci.length) {
                    int[] nArray = ExperimentDesktop.this.reporter.getLociMatched();
                    int n = i;
                    nArray[n] = nArray[n] + 1;
                    ++j;
                }
                ++i;
            }
        }

        @Override
        public void filteringLowTagsLociFinished(ProfilerData data, float[][] filtered) {
            int i = 0;
            while (i < data.getChromosomes()) {
                ((ExperimentDesktop)ExperimentDesktop.this).reporter.getLowTagInLociFiltered()[i] = filtered[i][0];
                ((ExperimentDesktop)ExperimentDesktop.this).reporter.getLowTagLociFiltered()[i] = filtered[i][1];
                PositionInfo[] positions = data.getMatchedPositions(i);
                LocusInfo[] loci = data.getMatchedLoci(i);
                ((ExperimentDesktop)ExperimentDesktop.this).reporter.getPositionsMatched()[i] = 0;
                ((ExperimentDesktop)ExperimentDesktop.this).reporter.getLociMatched()[i] = 0;
                int j = 0;
                while (j < positions.length) {
                    int[] nArray = ExperimentDesktop.this.reporter.getPositionsMatched();
                    int n = i;
                    nArray[n] = nArray[n] + 1;
                    ++j;
                }
                j = 0;
                while (j < loci.length) {
                    int[] nArray = ExperimentDesktop.this.reporter.getLociMatched();
                    int n = i;
                    nArray[n] = nArray[n] + 1;
                    ++j;
                }
                ++i;
            }
        }

        @Override
        public void filteringLowTagsPositionsFinished(ProfilerData data, float[][] filtered) {
            int i = 0;
            while (i < data.getChromosomes()) {
                ((ExperimentDesktop)ExperimentDesktop.this).reporter.getLowTagInPositionsFiltered()[i] = filtered[i][0];
                ((ExperimentDesktop)ExperimentDesktop.this).reporter.getLowTagPositionsFiltered()[i] = filtered[i][1];
                PositionInfo[] positions = data.getMatchedPositions(i);
                LocusInfo[] loci = data.getMatchedLoci(i);
                ((ExperimentDesktop)ExperimentDesktop.this).reporter.getPositionsMatched()[i] = 0;
                ((ExperimentDesktop)ExperimentDesktop.this).reporter.getLociMatched()[i] = 0;
                int j = 0;
                while (j < positions.length) {
                    int[] nArray = ExperimentDesktop.this.reporter.getPositionsMatched();
                    int n = i;
                    nArray[n] = nArray[n] + 1;
                    ++j;
                }
                j = 0;
                while (j < loci.length) {
                    int[] nArray = ExperimentDesktop.this.reporter.getLociMatched();
                    int n = i;
                    nArray[n] = nArray[n] + 1;
                    ++j;
                }
                ++i;
            }
        }
    }
}

