/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.Logger;
import gui.TablePanel;
import io.TableFileWriter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import settings.ExperimentSettings;

public class CommonLociTableInternalFrame
extends JInternalFrame
implements ActionListener {
    private TablePanel table;
    private ExperimentSettings settings;
    private JDesktopPane parent;

    public CommonLociTableInternalFrame(String name, ExperimentSettings settings, String[] profiles, ArrayList<String[]> data, JDesktopPane parent) {
        super(name, true, true, true, false);
        this.settings = settings;
        this.parent = parent;
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        String[] labels = new String[profiles.length + 4];
        int[] types = new int[profiles.length + 4];
        labels[0] = "Chromosome";
        types[0] = 3;
        labels[1] = "Position";
        types[1] = 0;
        labels[2] = "Gene ID";
        types[2] = 1;
        labels[3] = "Description";
        types[3] = 1;
        int i = 0;
        while (i < profiles.length) {
            labels[i + 4] = String.valueOf(profiles[i]) + " #Tags";
            types[i + 4] = 2;
            ++i;
        }
        this.table = new TablePanel(labels, types);
        this.table.setData(data);
        this.setPreferredSize(new Dimension(parent.getWidth() / 2, parent.getHeight()));
        this.getContentPane().add((Component)this.table, c);
        this.pack();
        JMenuItem exportMenu = new JMenuItem("Export");
        exportMenu.addActionListener(this);
        this.table.getPopupMenu().add(exportMenu);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Export")) {
            this.exportData();
        }
    }

    public void exportData() {
        Object[][] data = new Object[this.table.getTable().getRowCount() + 1][];
        data[0] = new Object[this.table.getTable().getColumnCount()];
        int i = 0;
        while (i < data[0].length) {
            data[0][i] = this.table.getTable().getTableHeader().getColumnModel().getColumn(i).getHeaderValue();
            ++i;
        }
        i = 1;
        while (i < data.length) {
            data[i] = new Object[this.table.getTable().getColumnCount()];
            int j = 0;
            while (j < data[i].length) {
                data[i][j] = this.table.getTable().getValueAt(i - 1, j);
                ++j;
            }
            ++i;
        }
        File f = null;
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new File(this.settings.getPath()).getParentFile());
        chooser.setSelectedFile(new File(String.valueOf(this.settings.getName()) + "_commonLociTable.txt"));
        chooser.setMultiSelectionEnabled(false);
        if (chooser.showDialog(this.parent, "Select") != 0) {
            return;
        }
        f = chooser.getSelectedFile();
        try {
            TableFileWriter.writeTable(f.getPath(), data);
        }
        catch (Exception e) {
            Logger.writeExceptionLog(e);
        }
    }
}

