/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.BowtieSettingsInternalFrameListener;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import settings.AppSettings;

public class BowtieSettingsInternalFrame
extends JInternalFrame {
    private BowtieSettingsInternalFrameListener listener;
    private AppSettings settings;
    private JTextArea bowieExecutablePathTextArea;
    private JTextArea indexPathTextArea;
    private JTextArea outputFileNameTextArea;
    private JTextArea outputFilePathTextArea;
    private JSpinner maximumMismatchesNumberSpinner;
    private JSpinner maximumAlignmentsNumberSpinner;
    private JList fastaqFilesList;
    private ArrayList<String> fastaqFilePath;

    public BowtieSettingsInternalFrame(AppSettings settings, BowtieSettingsInternalFrameListener listener) {
        super("Bowtie alligner settings", false, false, false, false);
        this.settings = settings;
        this.listener = listener;
        this.fastaqFilePath = new ArrayList();
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        int row = 0;
        JLabel label = new JLabel("Bowtie path");
        c.gridx = 0;
        c.gridy = row;
        c.gridwidth = 2;
        this.getContentPane().add((Component)label, c);
        c.gridx = 1;
        this.bowieExecutablePathTextArea = new JTextArea();
        if (this.settings.getBowtieExecutablePath() != null && !this.settings.getBowtieExecutablePath().equals("")) {
            this.bowieExecutablePathTextArea.setText(this.settings.getBowtieExecutablePath());
        } else {
            this.bowieExecutablePathTextArea.setText("select bowie executable path");
        }
        this.bowieExecutablePathTextArea.setEditable(false);
        this.bowieExecutablePathTextArea.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                File f = BowtieSettingsInternalFrame.this.selectFile(BowtieSettingsInternalFrame.this.getSettings().getBowtieExecutablePath());
                if (f != null) {
                    String filePath = f.getPath();
                    BowtieSettingsInternalFrame.this.getSettings().setBowtieExecutablePath(filePath);
                    BowtieSettingsInternalFrame.this.bowieExecutablePathTextArea.setText(filePath);
                }
                BowtieSettingsInternalFrame.this.pack();
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        });
        this.getContentPane().add((Component)this.bowieExecutablePathTextArea, c);
        ++row;
        label = new JLabel("Maximum number of mismatches (-n)");
        c.gridx = 0;
        c.gridy = row++;
        c.gridwidth = 1;
        this.getContentPane().add((Component)label, c);
        c.gridx = 1;
        this.maximumMismatchesNumberSpinner = new JSpinner(new SpinnerNumberModel(2, 0, 5, 1));
        ((JSpinner.DefaultEditor)this.maximumMismatchesNumberSpinner.getEditor()).getTextField().setEditable(false);
        this.getContentPane().add((Component)this.maximumMismatchesNumberSpinner, c);
        label = new JLabel("Maximum number of alignments (-m)");
        c.gridx = 0;
        c.gridy = row++;
        c.gridwidth = 1;
        this.getContentPane().add((Component)label, c);
        c.gridx = 1;
        this.maximumAlignmentsNumberSpinner = new JSpinner(new SpinnerNumberModel(5, 1, 10, 1));
        ((JSpinner.DefaultEditor)this.maximumAlignmentsNumberSpinner.getEditor()).getTextField().setEditable(false);
        this.getContentPane().add((Component)this.maximumAlignmentsNumberSpinner, c);
        label = new JLabel("Index path");
        c.gridx = 0;
        c.gridy = row;
        c.gridwidth = 2;
        this.getContentPane().add((Component)label, c);
        c.gridx = 1;
        this.indexPathTextArea = new JTextArea();
        if (this.settings.getBowtieIndexPath() != null && !this.settings.getBowtieIndexPath().equals("")) {
            this.indexPathTextArea.setText(this.settings.getBowtieIndexPath());
        } else {
            this.indexPathTextArea.setText("select bowie index path");
        }
        this.indexPathTextArea.setEditable(false);
        this.indexPathTextArea.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                String currentDir = BowtieSettingsInternalFrame.this.getSettings().getBowtieIndexPath();
                File f = BowtieSettingsInternalFrame.this.selectFile(currentDir = currentDir.substring(0, currentDir.lastIndexOf(File.separatorChar)));
                if (f != null) {
                    String filePath = f.getPath();
                    filePath = filePath.substring(0, filePath.indexOf(46));
                    BowtieSettingsInternalFrame.this.getSettings().setBowtieIndexPath(filePath);
                    BowtieSettingsInternalFrame.this.indexPathTextArea.setText(filePath);
                }
                BowtieSettingsInternalFrame.this.pack();
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        });
        this.getContentPane().add((Component)this.indexPathTextArea, c);
        label = new JLabel("Fastaq files");
        c.gridx = 0;
        c.gridy = ++row;
        c.gridwidth = 1;
        this.getContentPane().add((Component)label, c);
        this.fastaqFilesList = new JList(new DefaultListModel());
        c.gridx = 1;
        c.gridy = row++;
        c.gridwidth = 2;
        this.getContentPane().add((Component)this.fastaqFilesList, c);
        JButton addFileButton = new JButton("Add");
        addFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                File[] f = null;
                f = BowtieSettingsInternalFrame.this.fastaqFilePath.size() > 0 ? BowtieSettingsInternalFrame.this.selectFiles((String)BowtieSettingsInternalFrame.this.fastaqFilePath.get(BowtieSettingsInternalFrame.this.fastaqFilePath.size() - 1)) : BowtieSettingsInternalFrame.this.selectFiles(".");
                if (f != null) {
                    int i = 0;
                    while (i < f.length) {
                        String fileName = f[i].getName();
                        BowtieSettingsInternalFrame.this.fastaqFilePath.add(f[i].getAbsolutePath());
                        DefaultListModel listModel = (DefaultListModel)BowtieSettingsInternalFrame.this.fastaqFilesList.getModel();
                        listModel.addElement(fileName);
                        ++i;
                    }
                    BowtieSettingsInternalFrame.this.pack();
                }
            }
        });
        c.gridx = 1;
        c.gridy = row;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 10;
        this.getContentPane().add((Component)addFileButton, c);
        JButton deleteFileButton = new JButton("Delete");
        deleteFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] indices = BowtieSettingsInternalFrame.this.fastaqFilesList.getSelectedIndices();
                DefaultListModel listModel = (DefaultListModel)BowtieSettingsInternalFrame.this.fastaqFilesList.getModel();
                int i = indices.length - 1;
                while (i >= 0) {
                    listModel.remove(indices[i]);
                    BowtieSettingsInternalFrame.this.fastaqFilePath.remove(indices[i]);
                    --i;
                }
                BowtieSettingsInternalFrame.this.pack();
            }
        });
        c.gridx = 2;
        c.gridy = row++;
        c.gridwidth = 1;
        this.getContentPane().add((Component)deleteFileButton, c);
        label = new JLabel("Output file name");
        c.gridx = 0;
        c.gridy = row++;
        c.gridwidth = 2;
        this.getContentPane().add((Component)label, c);
        c.gridx = 1;
        this.outputFileNameTextArea = new JTextArea();
        this.outputFileNameTextArea.setText("out");
        this.getContentPane().add((Component)this.outputFileNameTextArea, c);
        label = new JLabel("Output file path");
        c.gridx = 0;
        c.gridy = row++;
        c.gridwidth = 2;
        this.getContentPane().add((Component)label, c);
        c.gridx = 1;
        this.outputFilePathTextArea = new JTextArea();
        this.outputFilePathTextArea.setText(new File(".").getPath());
        this.outputFilePathTextArea.setEditable(false);
        this.outputFilePathTextArea.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                File f = BowtieSettingsInternalFrame.this.selectDirectory(".");
                if (f != null) {
                    String filePath = f.getPath();
                    BowtieSettingsInternalFrame.this.outputFilePathTextArea.setText(filePath);
                }
                BowtieSettingsInternalFrame.this.pack();
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        });
        this.getContentPane().add((Component)this.outputFilePathTextArea, c);
        c.fill = 0;
        c.gridx = 1;
        c.gridy = row;
        c.gridwidth = 0;
        c.anchor = 17;
        JButton startButton = new JButton("Start");
        this.getContentPane().add((Component)startButton, c);
        c.fill = 0;
        c.gridx = 2;
        c.gridy = row;
        c.gridwidth = 0;
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                BowtieSettingsInternalFrame.this.listener.frameClosed();
                BowtieSettingsInternalFrame.this.hide();
            }
        });
        this.getContentPane().add((Component)cancelButton, c);
    }

    private AppSettings getSettings() {
        return this.settings;
    }

    private File selectFile(String currentDirectory) {
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        if (currentDirectory != null) {
            chooser.setCurrentDirectory(new File(currentDirectory));
        } else {
            chooser.setCurrentDirectory(new File("."));
        }
        if (chooser.showDialog(this, "Select") == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    private File selectDirectory(String currentDirectory) {
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(1);
        if (currentDirectory != null) {
            chooser.setCurrentDirectory(new File(currentDirectory));
        } else {
            chooser.setCurrentDirectory(new File("."));
        }
        if (chooser.showDialog(this, "Select") == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    private File[] selectFiles(String currentDirectory) {
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(true);
        if (currentDirectory != null) {
            chooser.setCurrentDirectory(new File(currentDirectory));
        } else {
            chooser.setCurrentDirectory(new File("."));
        }
        if (chooser.showDialog(this, "Select") == 0) {
            return chooser.getSelectedFiles();
        }
        return null;
    }
}

