/*
 * Decompiled with CFR 0.152.
 */
package biomart;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class SpeciesSettings {
    private static final String HOMO_SAPIENS_ID = "hsapiens_gene_ensembl";
    private static final String HOMO_SAPIENS_NAME = "Homo sapiens";
    private static final List<String> HOMO_SAPIENS_CHROMOSOMES = Arrays.asList("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "X", "Y");
    private static final String MUS_MUSCULUS_ID = "mmusculus_gene_ensembl";
    private static final String MUS_MUSCULUS_NAME = "Mus musculus";
    private static final List<String> MUS_MUSCULUS_CHROMOSOMES = Arrays.asList("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "X", "Y");
    private static final String SACCHAROMYCES_CEREVISIAE_ID = "scerevisiae_gene_ensembl";
    private static final String SACCHAROMYCES_CEREVISIAE_NAME = "Saccharomyces cerevisiae";
    private static final List<String> SACCHAROMYCES_CEREVISIAE_CHROMOSOMES = Arrays.asList("I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X", "XI", "XII", "XIII", "XIV", "XV", "XVI");
    private static final String RATTUS_NORVEGICUS_ID = "rnorvegicus_gene_ensembl";
    private static final String RATTUS_NORVEGICUS_NAME = "Rattus norvegicus";
    private static final List<String> RATTUS_NORVEGICUS_CHROMOSOMES = Arrays.asList("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "X");
    private static final String DROSOPHILIA_MELANOGASTER_ID = "dmelanogaster_gene_ensembl";
    private static final String DROSOPHILIA_MELANOGASTER_NAME = "Drosophila melanogaster";
    private static final List<String> DROSOPHILIA_MELANOGASTER_CHROMOSOMES = Arrays.asList("2L", "2LHet", "2R", "2RHet", "3L", "3LHet", "3R", "3RHet", "4", "U", "Uextra", "X", "XHet", "YHet");

    public static int getChromosomesCount(String speciesId) {
        if (speciesId.equals(HOMO_SAPIENS_ID)) {
            return HOMO_SAPIENS_CHROMOSOMES.size();
        }
        if (speciesId.equals(MUS_MUSCULUS_ID)) {
            return MUS_MUSCULUS_CHROMOSOMES.size();
        }
        if (speciesId.equals(SACCHAROMYCES_CEREVISIAE_ID)) {
            return SACCHAROMYCES_CEREVISIAE_CHROMOSOMES.size();
        }
        if (speciesId.equals(RATTUS_NORVEGICUS_ID)) {
            return RATTUS_NORVEGICUS_CHROMOSOMES.size();
        }
        if (speciesId.equals(DROSOPHILIA_MELANOGASTER_ID)) {
            return DROSOPHILIA_MELANOGASTER_CHROMOSOMES.size();
        }
        return -1;
    }

    public static int getChromosomeId(String speciesId, String name) {
        if (speciesId.equals(HOMO_SAPIENS_ID)) {
            return HOMO_SAPIENS_CHROMOSOMES.indexOf(name);
        }
        if (speciesId.equals(MUS_MUSCULUS_ID)) {
            return MUS_MUSCULUS_CHROMOSOMES.indexOf(name);
        }
        if (speciesId.equals(SACCHAROMYCES_CEREVISIAE_ID)) {
            return SACCHAROMYCES_CEREVISIAE_CHROMOSOMES.indexOf(name);
        }
        if (speciesId.equals(RATTUS_NORVEGICUS_ID)) {
            return RATTUS_NORVEGICUS_CHROMOSOMES.indexOf(name);
        }
        if (speciesId.equals(DROSOPHILIA_MELANOGASTER_ID)) {
            return DROSOPHILIA_MELANOGASTER_CHROMOSOMES.indexOf(name);
        }
        return -1;
    }

    public static String getChromosomeName(String speciesId, int id) {
        if (speciesId.equals(HOMO_SAPIENS_ID)) {
            return HOMO_SAPIENS_CHROMOSOMES.get(id);
        }
        if (speciesId.equals(MUS_MUSCULUS_ID)) {
            return MUS_MUSCULUS_CHROMOSOMES.get(id);
        }
        if (speciesId.equals(SACCHAROMYCES_CEREVISIAE_ID)) {
            return SACCHAROMYCES_CEREVISIAE_CHROMOSOMES.get(id);
        }
        if (speciesId.equals(RATTUS_NORVEGICUS_ID)) {
            return RATTUS_NORVEGICUS_CHROMOSOMES.get(id);
        }
        if (speciesId.equals(DROSOPHILIA_MELANOGASTER_ID)) {
            return DROSOPHILIA_MELANOGASTER_CHROMOSOMES.get(id);
        }
        return "";
    }

    public static HashMap<String, String> getSpeciesHashMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(HOMO_SAPIENS_ID, HOMO_SAPIENS_NAME);
        map.put(MUS_MUSCULUS_ID, MUS_MUSCULUS_NAME);
        map.put(SACCHAROMYCES_CEREVISIAE_ID, SACCHAROMYCES_CEREVISIAE_NAME);
        map.put(RATTUS_NORVEGICUS_ID, RATTUS_NORVEGICUS_NAME);
        map.put(DROSOPHILIA_MELANOGASTER_ID, DROSOPHILIA_MELANOGASTER_NAME);
        return map;
    }
}

