/*
 * Decompiled with CFR 0.152.
 */
package biomart;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;

public class BiomartConnector {
    public static HashMap<String, String> getSpecies() throws IOException {
        String response;
        String speciesUrl = "http://www.biomart.org/biomart/martservice?type=datasets&mart=ensembl";
        HashMap<String, String> map = new HashMap<String, String>();
        BufferedReader r = new BufferedReader(new InputStreamReader(new URL(speciesUrl).openStream()));
        while ((response = r.readLine()) != null) {
            int index1 = response.indexOf(9) + 1;
            int index2 = response.indexOf(9, index1 + 1);
            if (index1 == -1 || index2 == -1) continue;
            String key = response.substring(index1, index2);
            index1 = response.indexOf(9, index2) + 1;
            index2 = response.indexOf(9, index1 + 1);
            if (index1 == -1 || index2 == -1) continue;
            String value = response.substring(index1, index2);
            map.put(key, value);
        }
        return map;
    }

    public static HashMap<String, String> getAttributes(String speciesId) throws IOException {
        String response;
        String speciesUrl = "http://www.ensembl.org:80/biomart/martservice?type=attributes&dataset=" + speciesId;
        HashMap<String, String> map = new HashMap<String, String>();
        BufferedReader r = new BufferedReader(new InputStreamReader(new URL(speciesUrl).openStream()));
        while ((response = r.readLine()) != null) {
            int index1 = 0;
            int index2 = response.indexOf(9, index1 + 1);
            if (index1 == -1 || index2 == -1) continue;
            String key = response.substring(index1, index2);
            index1 = response.indexOf(9, index2) + 1;
            index2 = response.indexOf(9, index1 + 1);
            if (index1 == -1 || index2 == -1) continue;
            String value = response.substring(index1, index2);
            map.put(key, value);
        }
        return map;
    }

    public static ArrayList<String[]> getData(String[] attributes, String speciesId, HashMap<String, ArrayList<String>> filter) throws IOException {
        String response;
        String query = "http://www.ensembl.org:80/biomart/martservice?query=<?xml%20version=\"1.0\"%20encoding=\"UTF-8\"?><!DOCTYPE%20Query><Query%20%20virtualSchemaName%20=%20\"default\"%20formatter%20=%20\"TSV\"%20header%20=%20\"0\"%20uniqueRows%20=%20\"0\"%20count%20=%20\"\"%20datasetConfigVersion%20=%20\"0.6\"%20><Dataset%20name%20=%20\"" + speciesId + "\"%20interface%20=%20\"default\"%20>";
        if (filter != null) {
            for (String key : filter.keySet()) {
                ArrayList<String> list = filter.get(key);
                if (list == null || list.size() <= 0) continue;
                query = String.valueOf(query) + "<Filter%20name%20=%20\"" + key + "\"%20value%20=%20\"" + list.get(0);
                int i = 1;
                while (i < list.size()) {
                    query = String.valueOf(query) + "," + list.get(i);
                    ++i;
                }
                query = String.valueOf(query) + "\"%20/>";
            }
        }
        int i = 0;
        while (i < attributes.length) {
            query = String.valueOf(query) + "<Attribute%20name%20=%20\"" + attributes[i] + "\"%20/>";
            ++i;
        }
        query = String.valueOf(query) + "</Dataset></Query>";
        ArrayList<String[]> list = new ArrayList<String[]>();
        BufferedReader r = new BufferedReader(new InputStreamReader(new URL(query).openStream()));
        while ((response = r.readLine()) != null) {
            String[] entry = new String[attributes.length];
            int index1 = 0;
            int index2 = response.indexOf(9, index1 + 1);
            int i2 = 0;
            while (i2 < attributes.length - 1) {
                entry[i2] = response.substring(index1, index2);
                index1 = response.indexOf(9, index2) + 1;
                index2 = response.indexOf(9, index1 + 1);
                ++i2;
            }
            entry[i2] = response.substring(index1);
            list.add(entry);
        }
        return list;
    }
}

