/*
 * Decompiled with CFR 0.152.
 */
package settings;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import settings.FTPConfig;
import settings.StreamGobbler;

public final class MScanSystemTools {
    public static final String WINDOWS_STR = "windows";
    public static final String WINDOWS_95_STR = "windows 9";
    public static final String MACOS_STR = "mac";
    public static final String SUNOS_STR = "sunos";
    public static final String LINUX_STR = "linux";
    public static final String UNIX_STR = "unix";
    public static final int MULTI_DISPLAY_MIN_X = 0;
    public static final int MULTI_DISPLAY_MAX_X = 1;
    public static final int MEMORY_TOTAL = 0;
    public static final int MEMORY_MAX = 1;
    public static final int MEMORY_FREE = 2;

    public static int getCpuCount() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static long[] getMemoryInfo() {
        long[] memoryInfo = new long[]{Runtime.getRuntime().totalMemory() / 0x100000L, Runtime.getRuntime().maxMemory() / 0x100000L, Runtime.getRuntime().freeMemory() / 0x100000L};
        return memoryInfo;
    }

    public static void printMemoryInfo() {
        long[] memoryInfo = MScanSystemTools.getMemoryInfo();
        System.out.println("Total " + memoryInfo[0] + ", max " + memoryInfo[1] + ", free " + memoryInfo[2]);
    }

    public static boolean isMultiDisplay() {
        return MScanSystemTools.getDisplayCount() > 1;
    }

    public static int getDisplayCount() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices().length;
    }

    public static Point getMultiDisplayLocation() {
        return MScanSystemTools.getMultiDisplayLocation(0);
    }

    public static Point getMultiDisplayLocation(int mode) {
        GraphicsEnvironment gfxEnv = null;
        GraphicsDevice[] screenDevices = null;
        Rectangle selectedBounds = null;
        Rectangle bounds = null;
        gfxEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        screenDevices = gfxEnv.getScreenDevices();
        int i = 0;
        while (i < screenDevices.length) {
            bounds = screenDevices[i].getDefaultConfiguration().getBounds();
            if (selectedBounds == null || mode == 0 && bounds.x < selectedBounds.x || mode == 1 && bounds.x > selectedBounds.x) {
                selectedBounds = bounds;
            }
            ++i;
        }
        return new Point((int)selectedBounds.getX(), (int)selectedBounds.getY());
    }

    public static String getOsName(boolean lowerCase) {
        String os = null;
        os = System.getProperty("os.name");
        if (os != null && lowerCase) {
            os = os.toLowerCase();
        }
        return os;
    }

    public static String getOsName() {
        return MScanSystemTools.getOsName(false);
    }

    public static boolean isUnix() {
        String os = null;
        os = MScanSystemTools.getOsName(true);
        return os != null && os.startsWith(UNIX_STR);
    }

    public static boolean isLinux() {
        String os = null;
        os = MScanSystemTools.getOsName(true);
        return os != null && os.startsWith(LINUX_STR);
    }

    public static boolean isSunOS() {
        String os = null;
        os = MScanSystemTools.getOsName(true);
        return os != null && os.startsWith(SUNOS_STR);
    }

    public static boolean isMacOS() {
        String os = null;
        os = MScanSystemTools.getOsName(true);
        return os != null && os.startsWith(MACOS_STR);
    }

    public static boolean isWindows() {
        String os = null;
        os = MScanSystemTools.getOsName(true);
        return os != null && os.startsWith(WINDOWS_STR);
    }

    public static boolean isWindows95() {
        String os = null;
        os = MScanSystemTools.getOsName(true);
        return os != null && os.startsWith(WINDOWS_95_STR);
    }

    public static boolean isWindowsNt() {
        return MScanSystemTools.isWindows() && !MScanSystemTools.isWindows95();
    }

    public static String getArch() {
        return System.getProperty("os.arch");
    }

    public static String getJavaVersion() {
        return System.getProperty("java.version");
    }

    public static String getJavaHome() {
        return System.getProperty("java.home");
    }

    public static String getJavaClassPath() {
        return System.getProperty("java.class.path");
    }

    public static String getUserHome() {
        return System.getProperty("user.home");
    }

    public static String getUserDir() {
        return System.getProperty("user.dir");
    }

    public static String getUserName() {
        return System.getProperty("user.name");
    }

    public static String getFileName(String filepath, boolean withExt) {
        String filename = null;
        File file = null;
        int index = -1;
        if (filepath != null && filepath.length() > 0) {
            file = new File(filepath);
            filename = file.getName();
            if (!withExt && (index = filename.lastIndexOf(".")) != -1) {
                filename = filename.substring(0, index);
            }
        }
        return filename;
    }

    public static String getFileParent(String filepath) {
        String path = null;
        File file = null;
        if (filepath != null && filepath.length() > 0 && (file = new File(filepath)).exists()) {
            path = file.isDirectory() ? (file.getParent() != null ? file.getParentFile().getPath() : file.getPath()) : file.getParentFile().getPath();
        }
        return path;
    }

    public static String getFilePath(String dir, String filename) {
        return MScanSystemTools.getFilePath(dir, filename, false);
    }

    public static String getFilePath(String dir, String filename, boolean jarPath) {
        String filepath = null;
        File file = null;
        if (jarPath) {
            if (dir != null && dir.length() > 0) {
                filepath = dir;
                if (filepath.charAt(filepath.length() - 1) != '/' && filepath.charAt(filepath.length() - 1) != '\\') {
                    filepath = String.valueOf(filepath) + "/";
                }
                filepath = String.valueOf(filepath) + filename;
            } else {
                filepath = filename;
            }
            filepath.replace('\\', '/');
        } else {
            file = new File(dir, filename);
            filepath = file.getPath();
        }
        return filepath;
    }

    public static String getAbsolutePath(String filepath) {
        String path = null;
        File relativePath = null;
        relativePath = new File(filepath);
        path = relativePath.getAbsolutePath();
        return path;
    }

    public static String getExtension(String filepath) {
        String ext = null;
        int index = -1;
        index = filepath.lastIndexOf(".");
        if (index != -1) {
            ext = filepath.substring(index);
        }
        return ext;
    }

    public static String replaceExtension(String filepath, String ext) {
        String newFilepath = null;
        int index = -1;
        index = filepath.lastIndexOf(".");
        newFilepath = index != -1 ? String.valueOf(filepath.substring(0, index + 1)) + ext : String.valueOf(filepath) + "." + ext;
        return newFilepath;
    }

    public static URL getFileUrl(String path) {
        URL fileUrl = null;
        try {
            fileUrl = new URL("file:///" + path);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return fileUrl;
    }

    public static boolean checkDirectory(String dirpath) {
        boolean isValidDir = false;
        File dir = null;
        if (dirpath != null && dirpath.length() > 0 && (dir = new File(dirpath)).exists() && dir.isDirectory() && dir.canRead()) {
            isValidDir = true;
        }
        return isValidDir;
    }

    public static boolean checkDirectory(File dirpath) {
        return MScanSystemTools.checkDirectory(dirpath.getPath());
    }

    public static boolean createDir(File dirpath) {
        return dirpath.mkdirs();
    }

    public static boolean createDir(String dirpath) {
        File dir = null;
        dir = new File(dirpath);
        return MScanSystemTools.createDir(dir);
    }

    public static String getAppPath(Class app) {
        URL urlLocation = null;
        File fileLocation = null;
        urlLocation = app.getProtectionDomain().getCodeSource().getLocation();
        fileLocation = new File(urlLocation.getPath());
        return fileLocation.getPath();
    }

    public static String getAppDir(Class app) {
        URL urlLocation = null;
        File fileLocation = null;
        String appDir = null;
        urlLocation = app.getProtectionDomain().getCodeSource().getLocation();
        fileLocation = new File(urlLocation.getPath());
        appDir = fileLocation.getPath().indexOf(".jar") != -1 || fileLocation.getPath().indexOf(".exe") != -1 || fileLocation.getPath().indexOf(".app") != -1 ? fileLocation.getParentFile().getPath() : fileLocation.getPath();
        return appDir;
    }

    public static String getAppDir() {
        return MScanSystemTools.getAppDir(MScanSystemTools.class);
    }

    public static Properties getEnvVars() {
        Properties envVars = null;
        Process process = null;
        BufferedReader buffer = null;
        String line = null;
        Object key = null;
        Object value = null;
        int index = -1;
        try {
            if (MScanSystemTools.isWindows95()) {
                process = Runtime.getRuntime().exec("command.com /c set");
            } else if (MScanSystemTools.isWindows95()) {
                process = Runtime.getRuntime().exec("cmd.exe /c set");
            } else if (MScanSystemTools.isLinux() || MScanSystemTools.isMacOS() || MScanSystemTools.isSunOS() || MScanSystemTools.isUnix() || MScanSystemTools.isLinux()) {
                Runtime.getRuntime();
                process = Runtime.getRuntime().exec("env");
            }
            buffer = new BufferedReader(new InputStreamReader(process.getInputStream()));
            envVars = new Properties();
            while ((line = buffer.readLine()) != null) {
                index = line.indexOf(61);
                if (index < 0) continue;
                envVars.setProperty(line.substring(0, index), line.substring(index));
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return envVars;
    }

    public static String getEnvVar(String key) {
        String value = null;
        Properties envVars = null;
        envVars = MScanSystemTools.getEnvVars();
        if (envVars != null) {
            value = envVars.getProperty(key);
        }
        return value;
    }

    public static void openURL(String url, String browser) throws Exception {
        try {
            Runtime.getRuntime().exec(String.valueOf(browser) + " " + url);
        }
        catch (Exception e) {
            MScanSystemTools.openURL(url);
        }
    }

    public static void openURL(String url) throws Exception {
        Method openURL = null;
        Class<?> fileMgr = null;
        String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
        String browser = null;
        if (MScanSystemTools.isMacOS()) {
            fileMgr = Class.forName("com.apple.eio.FileManager");
            openURL = fileMgr.getDeclaredMethod("openURL", String.class);
            openURL.invoke(null, url);
        } else if (MScanSystemTools.isWindows()) {
            Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
        } else {
            int i = 0;
            while (i < browsers.length) {
                if (Runtime.getRuntime().exec(new String[]{"which", browsers[i]}).waitFor() == 0) {
                    browser = browsers[i];
                    break;
                }
                ++i;
            }
            if (browser == null) {
                throw new Exception("Error while running external browser");
            }
            Runtime.getRuntime().exec(String.valueOf(browser) + " " + url);
        }
    }

    public static boolean downloadFile(String host, String path, String filename, String user, String password, String commandsFilename, boolean verbose) throws IOException {
        FTPConfig ftpConfig = null;
        File ftpCommandsFile = null;
        Process process = null;
        StreamGobbler stderrGobbler = null;
        StreamGobbler stdoutGobbler = null;
        boolean result = false;
        ftpConfig = new FTPConfig(host, path, filename, user, password, commandsFilename);
        ftpCommandsFile = MScanSystemTools.createFTPCommandsFile(ftpConfig.mFtpCommands, ftpConfig);
        if (ftpCommandsFile != null) {
            try {
                process = Runtime.getRuntime().exec("ftp -v -s:" + ftpConfig.mFtpCommands);
                stderrGobbler = new StreamGobbler(process.getErrorStream(), "ERROR", verbose);
                stdoutGobbler = new StreamGobbler(process.getInputStream(), "FTP", verbose);
                stderrGobbler.start();
                stdoutGobbler.start();
                if (process.waitFor() == 0) {
                    result = true;
                }
                ftpCommandsFile.delete();
            }
            catch (SecurityException se) {
                throw new IOException("Error while downloading file");
            }
            catch (InterruptedException ie) {
                throw new IOException("Error while downloading file");
            }
        }
        return result;
    }

    public static File createFTPCommandsFile(String ftpCommandsFilename, FTPConfig ftpConfig) throws IOException {
        File ftpCommandsFile = null;
        BufferedWriter buffer = null;
        try {
            ftpCommandsFile = new File(ftpCommandsFilename);
            buffer = new BufferedWriter(new FileWriter(ftpCommandsFile));
        }
        catch (IOException ioe) {
            ftpCommandsFile = null;
            throw new IOException("Error while creating file " + ftpCommandsFilename);
        }
        try {
            try {
                buffer.write("verbose");
                buffer.newLine();
                buffer.write("open " + ftpConfig.mHost);
                buffer.newLine();
                buffer.write(ftpConfig.mUser);
                buffer.newLine();
                buffer.write(ftpConfig.mPassword);
                buffer.newLine();
                buffer.write("cd " + ftpConfig.mPath);
                buffer.newLine();
                buffer.write("binary");
                buffer.newLine();
                buffer.write("get " + ftpConfig.mFilename);
                buffer.newLine();
                buffer.write("close");
                buffer.newLine();
                buffer.write("quit");
                buffer.newLine();
            }
            catch (IOException ioe) {
                ftpCommandsFile = null;
                throw new IOException("Error while writing file " + ftpCommandsFilename);
            }
        }
        catch (Throwable throwable) {}
        buffer.close();
        return ftpCommandsFile;
    }

    public static File unGzip(String compFilename, String decompFilename, boolean delete) throws IOException {
        File compFile = null;
        File decompFile = null;
        GZIPInputStream in = null;
        BufferedOutputStream out = null;
        byte[] buffer = null;
        int len = 0;
        try {
            compFile = new File(compFilename);
            in = new GZIPInputStream(new BufferedInputStream(new FileInputStream(compFile)));
        }
        catch (IOException ioe) {
            throw new IOException("Error while opening file" + compFile);
        }
        try {
            decompFile = new File(decompFilename);
            out = new BufferedOutputStream(new FileOutputStream(decompFile));
        }
        catch (IOException ioe) {
            in.close();
            decompFile = null;
            throw new IOException("Error while creating file" + decompFile);
        }
        try {
            try {
                buffer = new byte[1024];
                while ((len = in.read(buffer, 0, buffer.length)) != -1) {
                    out.write(buffer, 0, len);
                }
            }
            catch (IOException ioe) {
                decompFile = null;
                throw new IOException("Error while decompressing file" + compFile);
            }
        }
        catch (Throwable throwable) {}
        in.close();
        out.close();
        if (decompFile != null && delete) {
            compFile.delete();
        }
        return decompFile;
    }
}

