/*
 * Decompiled with CFR 0.152.
 */
package settings;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import settings.ExperimentSettings;

public class ExperimentSettingsWriter {
    public static void writeExperimentSettings(ExperimentSettings settings, String filePath) throws ParserConfigurationException, TransformerException, IOException {
        String settingsFileName = filePath;
        File f = new File(settingsFileName);
        if (f.exists()) {
            f.delete();
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element rootElement = doc.createElement("settings");
        doc.appendChild(rootElement);
        Element experiment = doc.createElement("experiment");
        experiment.setAttribute("name", settings.getName());
        experiment.setAttribute("path", settings.getPath());
        rootElement.appendChild(experiment);
        Element results = doc.createElement("resultList");
        int i = 0;
        while (i < settings.getResults().size()) {
            Element figure = doc.createElement("result");
            figure.setAttribute("name", settings.getResults().get(i).getName());
            String filename = settings.getResults().get(i).getFigureFile();
            figure.setAttribute("filename", filename.substring(0, filename.length() - 3));
            figure.setAttribute("locus_length", "" + settings.getResults().get(i).getLocusLength());
            figure.setAttribute("locus_offset", "" + settings.getResults().get(i).getLocusOffset());
            int j = 0;
            while (j < settings.getResults().get(i).getChromosomes().size()) {
                Element chrom = doc.createElement("chromosome");
                chrom.setAttribute("name", settings.getResults().get(i).getChromosomes().get(j).getChromosomeName());
                chrom.setAttribute("number", String.valueOf(settings.getResults().get(i).getChromosomes().get(j).getChromosomeNumber()));
                String posFile = new File(settings.getResults().get(i).getChromosomes().get(j).getPositionFilePath()).getName();
                String tagFile = new File(settings.getResults().get(i).getChromosomes().get(j).getTagFilePath()).getName();
                chrom.setAttribute("positions_file", posFile);
                chrom.setAttribute("tag_file", tagFile);
                figure.appendChild(chrom);
                ++j;
            }
            results.appendChild(figure);
            ++i;
        }
        experiment.appendChild(results);
        Element tag = doc.createElement("positionLength");
        Text text = doc.createTextNode(String.valueOf(settings.getParams().getLocusLength()));
        tag.appendChild(text);
        experiment.appendChild(tag);
        tag = doc.createElement("locusOffset");
        text = doc.createTextNode(String.valueOf(settings.getParams().getLocusOffset()));
        tag.appendChild(text);
        experiment.appendChild(tag);
        tag = doc.createElement("dataBaseIndex");
        text = doc.createTextNode(String.valueOf(settings.getDataBaseIndex()));
        tag.appendChild(text);
        experiment.appendChild(tag);
        tag = doc.createElement("speciesId");
        text = doc.createTextNode(String.valueOf(settings.getParams().getSpeciesId()));
        tag.appendChild(text);
        experiment.appendChild(tag);
        tag = doc.createElement("mainAttribute");
        text = doc.createTextNode(settings.getParams().getMainAttribute());
        tag.appendChild(text);
        experiment.appendChild(tag);
        tag = doc.createElement("secondaryAttribute");
        text = doc.createTextNode(settings.getParams().getSecondaryAttribute());
        tag.appendChild(text);
        experiment.appendChild(tag);
        tag = doc.createElement("checkStrand");
        text = doc.createTextNode(String.valueOf(settings.getParams().isCheckStrand()));
        tag.appendChild(text);
        experiment.appendChild(tag);
        tag = doc.createElement("filterMultipleAssignments");
        text = doc.createTextNode(String.valueOf(settings.getParams().isFilterMultipleAssignments()));
        tag.appendChild(text);
        experiment.appendChild(tag);
        tag = doc.createElement("filterShortLoci");
        text = doc.createTextNode(String.valueOf(settings.getParams().isFilterShortLoci()));
        tag.appendChild(text);
        experiment.appendChild(tag);
        tag = doc.createElement("minLociLength");
        text = doc.createTextNode(String.valueOf(settings.getParams().getMinLociLength()));
        tag.appendChild(text);
        experiment.appendChild(tag);
        tag = doc.createElement("filterLociTypes");
        text = doc.createTextNode(String.valueOf(settings.getParams().isFilterLociTypes()));
        tag.appendChild(text);
        experiment.appendChild(tag);
        Element lociTypes = doc.createElement("filteredLociTypes");
        int i2 = 0;
        while (i2 < settings.getParams().getLociTypesCount()) {
            Element lociEntry = doc.createElement("filteredLoci");
            lociEntry.setAttribute("type", settings.getParams().getLociTypes(i2));
            lociTypes.appendChild(lociEntry);
            ++i2;
        }
        experiment.appendChild(lociTypes);
        tag = doc.createElement("filterGOTerms");
        text = doc.createTextNode(String.valueOf(settings.getParams().isFilterGOTerm()));
        tag.appendChild(text);
        experiment.appendChild(tag);
        tag = doc.createElement("GOTermsFile");
        text = doc.createTextNode(String.valueOf(settings.getParams().getGOTermsFile()));
        tag.appendChild(text);
        experiment.appendChild(tag);
        tag = doc.createElement("minPositionDistance");
        text = doc.createTextNode(String.valueOf(settings.getParams().getMinLociDistance()));
        tag.appendChild(text);
        experiment.appendChild(tag);
        tag = doc.createElement("leaveNoNearPositions");
        text = doc.createTextNode(String.valueOf(settings.getParams().isLeaveNoNearLoci()));
        tag.appendChild(text);
        experiment.appendChild(tag);
        tag = doc.createElement("leaveRandomNearPositions");
        text = doc.createTextNode(String.valueOf(settings.getParams().isLeaveRandomNearLoci()));
        tag.appendChild(text);
        experiment.appendChild(tag);
        tag = doc.createElement("leaveMiddleNearPositions");
        text = doc.createTextNode(String.valueOf(settings.getParams().isLeaveMiddleNearLoci()));
        tag.appendChild(text);
        experiment.appendChild(tag);
        tag = doc.createElement("prefilterLoci");
        text = doc.createTextNode(String.valueOf(settings.getParams().isPrefilterLoci()));
        tag.appendChild(text);
        experiment.appendChild(tag);
        tag = doc.createElement("prefilterLociLength");
        text = doc.createTextNode(String.valueOf(settings.getParams().getPrefilterLociLength()));
        tag.appendChild(text);
        experiment.appendChild(tag);
        tag = doc.createElement("prefilterLociOffset");
        text = doc.createTextNode(String.valueOf(settings.getParams().getPrefilterLociOffset()));
        tag.appendChild(text);
        experiment.appendChild(tag);
        tag = doc.createElement("prefilterLociTags");
        text = doc.createTextNode(String.valueOf(settings.getParams().getPrefilterLociTags()));
        tag.appendChild(text);
        experiment.appendChild(tag);
        tag = doc.createElement("filterLowTagLoci");
        text = doc.createTextNode(String.valueOf(settings.getParams().isFilterLowTagLoci()));
        tag.appendChild(text);
        experiment.appendChild(tag);
        tag = doc.createElement("minLociTagCount");
        text = doc.createTextNode(String.valueOf(settings.getParams().getMinLociTagCount()));
        tag.appendChild(text);
        experiment.appendChild(tag);
        tag = doc.createElement("filterLowTagPositions");
        text = doc.createTextNode(String.valueOf(settings.getParams().isFilterLowTagPositions()));
        tag.appendChild(text);
        experiment.appendChild(tag);
        tag = doc.createElement("minPositionsTagCount");
        text = doc.createTextNode(String.valueOf(settings.getParams().getMinPositionTagCount()));
        tag.appendChild(text);
        experiment.appendChild(tag);
        tag = doc.createElement("filterMultiTagLoci");
        text = doc.createTextNode(String.valueOf(settings.getParams().isFilterMultiTagLoci()));
        tag.appendChild(text);
        experiment.appendChild(tag);
        tag = doc.createElement("maxLociTagCount");
        text = doc.createTextNode(String.valueOf(settings.getParams().getMaxLociTagCount()));
        tag.appendChild(text);
        experiment.appendChild(tag);
        tag = doc.createElement("filterMultiTagPositions");
        text = doc.createTextNode(String.valueOf(settings.getParams().isFilterMultiTagPositions()));
        tag.appendChild(text);
        experiment.appendChild(tag);
        tag = doc.createElement("maxPositionsTagCount");
        text = doc.createTextNode(String.valueOf(settings.getParams().getMaxPositionTagCount()));
        tag.appendChild(text);
        experiment.appendChild(tag);
        tag = doc.createElement("assignmentsCountNormalisation");
        text = doc.createTextNode(String.valueOf(settings.getParams().isAssignmentsCountNormalisation()));
        tag.appendChild(text);
        experiment.appendChild(tag);
        Element assignmentFile = doc.createElement("assignmentFilesList");
        int i3 = 0;
        while (i3 < settings.getAssignmentFilesCount()) {
            Element assignmentFileEntry = doc.createElement("assignmentsFile");
            assignmentFileEntry.setAttribute("path", settings.getAssignmentFile(i3));
            assignmentFile.appendChild(assignmentFileEntry);
            ++i3;
        }
        experiment.appendChild(assignmentFile);
        tag = doc.createElement("scalePositionHistogram");
        text = doc.createTextNode(String.valueOf(settings.isScalePositionHistogram()));
        tag.appendChild(text);
        experiment.appendChild(tag);
        tag = doc.createElement("scaleLociHistogram");
        text = doc.createTextNode(String.valueOf(settings.isScaleLociHistogram()));
        tag.appendChild(text);
        experiment.appendChild(tag);
        tag = doc.createElement("setPositionHistogramRange");
        text = doc.createTextNode(String.valueOf(settings.isSetPositionHistogramRange()));
        tag.appendChild(text);
        experiment.appendChild(tag);
        tag = doc.createElement("positionHistogramRangeMin");
        text = doc.createTextNode(String.valueOf(settings.getPositionHistogramRangeMin()));
        tag.appendChild(text);
        experiment.appendChild(tag);
        tag = doc.createElement("positionHistogramRangeMax");
        text = doc.createTextNode(String.valueOf(settings.getPositionHistogramRangeMax()));
        tag.appendChild(text);
        experiment.appendChild(tag);
        tag = doc.createElement("setLociHistogramRange");
        text = doc.createTextNode(String.valueOf(settings.isSetLociHistogramRange()));
        tag.appendChild(text);
        experiment.appendChild(tag);
        tag = doc.createElement("lociHistogramRangeMin");
        text = doc.createTextNode(String.valueOf(settings.getLociHistogramRangeMin()));
        tag.appendChild(text);
        experiment.appendChild(tag);
        tag = doc.createElement("lociHistogramRangeMax");
        text = doc.createTextNode(String.valueOf(settings.getLociHistogramRangeMax()));
        tag.appendChild(text);
        experiment.appendChild(tag);
        tag = doc.createElement("lociLoadFile");
        text = doc.createTextNode(String.valueOf(settings.getParams().getLociLoadFile()));
        tag.appendChild(text);
        experiment.appendChild(tag);
        tag = doc.createElement("lociLoad");
        text = doc.createTextNode(String.valueOf(settings.getParams().isLociLoad()));
        tag.appendChild(text);
        experiment.appendChild(tag);
        tag = doc.createElement("lociSaveFile");
        text = doc.createTextNode(String.valueOf(settings.getParams().getLociSaveFile()));
        tag.appendChild(text);
        experiment.appendChild(tag);
        tag = doc.createElement("lociSave");
        text = doc.createTextNode(String.valueOf(settings.getParams().isLociSave()));
        tag.appendChild(text);
        experiment.appendChild(tag);
        Transformer t = TransformerFactory.newInstance().newTransformer();
        t.setOutputProperty("indent", "yes");
        t.setOutputProperty("method", "xml");
        FileOutputStream out = new FileOutputStream(f);
        t.transform(new DOMSource(doc), new StreamResult(out));
        out.close();
    }
}

