/*
 * Decompiled with CFR 0.152.
 */
package settings;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import settings.AppSettings;
import settings.ExperimentSettings;
import settings.ExperimentSettingsReader;

public class AppSettingsReader {
    private String settingsFileName;

    public AppSettingsReader(String settingsFileName) {
        this.settingsFileName = settingsFileName;
    }

    public AppSettings readAppSettings() throws IOException, SAXException, ParserConfigurationException, ClassNotFoundException {
        AppSettings appSettings = new AppSettings();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        File f = new File(this.settingsFileName);
        Document doc = builder.parse(f);
        Element root = doc.getDocumentElement();
        NodeList children = root.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            if (node instanceof Element) {
                if (node.getNodeName().equals("bowtie_settings")) {
                    appSettings.setBowtieExecutablePath(((Element)node).getAttribute("bowtie_path"));
                    appSettings.setBowtieIndexPath(((Element)node).getAttribute("bowtie_index_path"));
                } else if (node.getNodeName().equals("experiment")) {
                    ExperimentSettingsReader expReader = new ExperimentSettingsReader();
                    ExperimentSettings exp = expReader.readExperimentSettings(String.valueOf(((Element)node).getAttribute("path")) + "settings.xml");
                    appSettings.addExperiment(exp);
                }
            }
            ++i;
        }
        return appSettings;
    }
}

