/*
 * Decompiled with CFR 0.152.
 */
package mscanlib.plots.math;

import mscanlib.plots.math.IndexedSort;
import mscanlib.plots.math.MathFun;

public final class IndexedHSort
extends IndexedSort {
    private static int leftChild(int i) {
        return 2 * i + 1;
    }

    private static void percDown(int[] array, int[] index, int i, int n) {
        int tmp = array[i];
        int index_tmp = index[i];
        while (IndexedHSort.leftChild(i) < n) {
            int child = IndexedHSort.leftChild(i);
            if (child != n - 1 && array[child] < array[child + 1]) {
                ++child;
            }
            if (tmp >= array[child]) break;
            array[i] = array[child];
            index[i] = index[child];
            i = child;
        }
        array[i] = tmp;
        index[i] = index_tmp;
    }

    private static void percDown(char[] array, int[] index, int i, int n) {
        char tmp = array[i];
        int index_tmp = index[i];
        while (IndexedHSort.leftChild(i) < n) {
            int child = IndexedHSort.leftChild(i);
            if (child != n - 1 && array[child] < array[child + 1]) {
                ++child;
            }
            if (tmp >= array[child]) break;
            array[i] = array[child];
            index[i] = index[child];
            i = child;
        }
        array[i] = tmp;
        index[i] = index_tmp;
    }

    private static void percDown(double[] array, int[] index, int i, int n) {
        double tmp = array[i];
        int index_tmp = index[i];
        while (IndexedHSort.leftChild(i) < n) {
            int child = IndexedHSort.leftChild(i);
            if (child != n - 1 && array[child] < array[child + 1]) {
                ++child;
            }
            if (!(tmp < array[child])) break;
            array[i] = array[child];
            index[i] = index[child];
            i = child;
        }
        array[i] = tmp;
        index[i] = index_tmp;
    }

    private static void percDown(float[] array, int[] index, int i, int n) {
        float tmp = array[i];
        int index_tmp = index[i];
        while (IndexedHSort.leftChild(i) < n) {
            int child = IndexedHSort.leftChild(i);
            if (child != n - 1 && array[child] < array[child + 1]) {
                ++child;
            }
            if (!(tmp < array[child])) break;
            array[i] = array[child];
            index[i] = index[child];
            i = child;
        }
        array[i] = tmp;
        index[i] = index_tmp;
    }

    private static void percDown(String[] array, int[] index, int i, int n) {
        String tmp = array[i];
        int index_tmp = index[i];
        while (IndexedHSort.leftChild(i) < n) {
            int child = IndexedHSort.leftChild(i);
            if (child != n - 1 && array[child].compareTo(array[child + 1]) < 0) {
                ++child;
            }
            if (tmp.compareTo(array[child]) >= 0) break;
            array[i] = array[child];
            index[i] = index[child];
            i = child;
        }
        array[i] = tmp;
        index[i] = index_tmp;
    }

    private static void percDownIgnoreCase(String[] array, int[] index, int i, int n) {
        String tmp = array[i];
        int index_tmp = index[i];
        while (IndexedHSort.leftChild(i) < n) {
            int child = IndexedHSort.leftChild(i);
            if (child != n - 1 && array[child].compareToIgnoreCase(array[child + 1]) < 0) {
                ++child;
            }
            if (tmp.compareToIgnoreCase(array[child]) >= 0) break;
            array[i] = array[child];
            index[i] = index[child];
            i = child;
        }
        array[i] = tmp;
        index[i] = index_tmp;
    }

    public static void sort(int[] array, int[] index, int left, int right) {
        int i = array.length / 2;
        while (i >= 0) {
            IndexedHSort.percDown(array, index, i, array.length);
            --i;
        }
        i = array.length - 1;
        while (i > 0) {
            IndexedHSort.swap(array, index, 0, i);
            IndexedHSort.percDown(array, index, 0, i);
            --i;
        }
    }

    public static void sort(int[] array, int[] index) {
        IndexedHSort.sort(array, index, 0, array.length - 1);
    }

    public static void sort(char[] array, int[] index, int left, int right) {
        int i = array.length / 2;
        while (i >= 0) {
            IndexedHSort.percDown(array, index, i, array.length);
            --i;
        }
        i = array.length - 1;
        while (i > 0) {
            IndexedHSort.swap(array, index, 0, i);
            IndexedHSort.percDown(array, index, 0, i);
            --i;
        }
    }

    public static void sort(char[] array, int[] index) {
        IndexedHSort.sort(array, index, 0, array.length - 1);
    }

    public static void sort(double[] array, int[] index, int left, int right) {
        int i = array.length / 2;
        while (i >= 0) {
            IndexedHSort.percDown(array, index, i, array.length);
            --i;
        }
        i = array.length - 1;
        while (i > 0) {
            IndexedHSort.swap(array, index, 0, i);
            IndexedHSort.percDown(array, index, 0, i);
            --i;
        }
    }

    public static void sort(double[] array, int[] index) {
        IndexedHSort.sort(array, index, 0, array.length - 1);
    }

    public static void sort(float[] array, int[] index, int left, int right) {
        int i = array.length / 2;
        while (i >= 0) {
            IndexedHSort.percDown(array, index, i, array.length);
            --i;
        }
        i = array.length - 1;
        while (i > 0) {
            IndexedHSort.swap(array, index, 0, i);
            IndexedHSort.percDown(array, index, 0, i);
            --i;
        }
    }

    public static void sort(float[] array, int[] index) {
        IndexedHSort.sort(array, index, 0, array.length - 1);
    }

    public static void sort(String[] array, int[] index, int left, int right) {
        int i = array.length / 2;
        while (i >= 0) {
            IndexedHSort.percDown(array, index, i, array.length);
            --i;
        }
        i = array.length - 1;
        while (i > 0) {
            IndexedHSort.swap(array, index, 0, i);
            IndexedHSort.percDown(array, index, 0, i);
            --i;
        }
    }

    public static void sort(String[] array, int[] index) {
        IndexedHSort.sort(array, index, 0, array.length - 1);
    }

    public static void sortIgnoreCase(String[] array, int[] index, int left, int right) {
        int i = array.length / 2;
        while (i >= 0) {
            IndexedHSort.percDownIgnoreCase(array, index, i, array.length);
            --i;
        }
        i = array.length - 1;
        while (i > 0) {
            IndexedHSort.swap(array, index, 0, i);
            IndexedHSort.percDownIgnoreCase(array, index, 0, i);
            --i;
        }
    }

    public static void sortIgnoreCase(String[] array, int[] index) {
        IndexedHSort.sort(array, index, 0, array.length - 1);
    }

    public static void reorderIndex(double[] sortValues, int[] index, double[] reorderValues) {
        int start = 0;
        int stop = 0;
        int i = 0;
        while (i < sortValues.length - 1) {
            if (sortValues[i] == sortValues[i + 1]) {
                start = i;
                while (i < sortValues.length - 1 && sortValues[i] == sortValues[i + 1]) {
                    stop = ++i;
                }
                IndexedHSort.reorderIndex(index, reorderValues, start, stop);
            }
            ++i;
        }
    }

    public static void reorderIndex(String[] sortValues, int[] index, double[] reorderValues) {
        int start = 0;
        int stop = 0;
        int i = 0;
        while (i < sortValues.length - 1) {
            if (sortValues[i].equals(sortValues[i + 1])) {
                start = i;
                while (i < sortValues.length - 1 && sortValues[i].equals(sortValues[i + 1])) {
                    stop = ++i;
                }
                IndexedHSort.reorderIndex(index, reorderValues, start, stop);
            }
            ++i;
        }
    }

    private static void reorderIndex(int[] index, double[] reorderValues, int start, int stop) {
        int[] localReorderIndex = null;
        int[] tmpIndex = null;
        double[] localReorderValues = null;
        localReorderIndex = MathFun.setRange(0, stop - start + 1);
        localReorderValues = new double[localReorderIndex.length];
        int j = 0;
        while (j < localReorderIndex.length) {
            localReorderValues[j] = reorderValues[start + j];
            ++j;
        }
        IndexedHSort.sort(localReorderValues, localReorderIndex, 0, localReorderIndex.length - 1);
        tmpIndex = new int[localReorderIndex.length];
        j = 0;
        while (j < localReorderIndex.length) {
            tmpIndex[j] = index[start + localReorderIndex[j]];
            ++j;
        }
        j = 0;
        while (j < localReorderIndex.length) {
            index[start + j] = tmpIndex[j];
            ++j;
        }
    }
}

