/*
 * Decompiled with CFR 0.152.
 */
package mscanlib.plots.io;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import mscanlib.plots.MScanPlotArea;
import mscanlib.plots.MScanPlotException;
import mscanlib.plots.io.MScanPlotFileWriter;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class MScanPlotSVGFileWriter
extends MScanPlotFileWriter {
    Document mSvgDocument = null;
    OutputStream mSvgStream = null;
    Writer mSvgWriter = null;

    public MScanPlotSVGFileWriter(String filename) throws MScanPlotException {
        super(filename);
        try {
            this.openImageFile();
        }
        catch (Exception e) {
            throw new MScanPlotException("Error while opening file " + this.mFilename + " (" + e.getMessage() + ")");
        }
    }

    @Override
    protected void openImageFile() throws Exception {
        DOMImplementation domImpl = null;
        domImpl = GenericDOMImplementation.getDOMImplementation();
        this.mSvgDocument = domImpl.createDocument(null, "svg", null);
        this.mSvgStream = new FileOutputStream(this.mFilename);
        this.mSvgWriter = new OutputStreamWriter(this.mSvgStream, "UTF-8");
    }

    @Override
    protected void closeImageFile() throws Exception {
        if (this.isOpened()) {
            this.mSvgStream.close();
        }
    }

    @Override
    public boolean isOpened() {
        return this.mSvgDocument != null && this.mSvgStream != null && this.mSvgWriter != null;
    }

    @Override
    protected void saveImageFile(BufferedImage image) throws Exception {
        SVGGraphics2D g2d = null;
        g2d = this.getG2D(image.getWidth(), image.getHeight(), null);
        g2d.drawImage(image, null, 0, 0);
        g2d.stream(this.mSvgWriter, true);
        this.mSvgStream.flush();
    }

    @Override
    protected void saveImageFile(MScanPlotArea plotArea) throws Exception {
        SVGGraphics2D g2d = null;
        g2d = this.getG2D(plotArea.getWidth(), plotArea.getHeight(), plotArea.getAxisFont());
        plotArea.plotImage((Graphics2D)g2d);
        g2d.stream(this.mSvgWriter, true);
        this.mSvgStream.flush();
    }

    private SVGGraphics2D getG2D(int width, int height, Font font) {
        SVGGraphics2D g2d = null;
        g2d = new SVGGraphics2D(this.mSvgDocument);
        g2d.setColor(Color.white);
        g2d.fillRect(0, 0, width, height);
        if (font != null) {
            g2d.setFont(font);
        }
        return g2d;
    }
}

