/*
 * Decompiled with CFR 0.152.
 */
package mscanlib.plots.io;

import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.OutputStream;
import mscanlib.plots.MScanPlotArea;
import mscanlib.plots.MScanPlotException;
import mscanlib.plots.io.MScanPlotFileWriter;

public class MScanPlotPDFFileWriter
extends MScanPlotFileWriter {
    private Document mPdfDocument = null;
    private PdfWriter mPdfWriter = null;

    public MScanPlotPDFFileWriter(String filename) throws MScanPlotException {
        super(filename);
        try {
            this.openImageFile();
        }
        catch (Exception e) {
            throw new MScanPlotException("Error while opening file " + this.mFilename + " (" + e.getMessage() + ")");
        }
    }

    @Override
    protected void openImageFile() throws Exception {
        this.mPdfDocument = new Document();
        this.mPdfWriter = PdfWriter.getInstance((Document)this.mPdfDocument, (OutputStream)new FileOutputStream(this.mFilename));
        this.mPdfDocument.open();
    }

    @Override
    protected void closeImageFile() throws Exception {
        if (this.isOpened()) {
            this.mPdfDocument.close();
        }
    }

    @Override
    public boolean isOpened() {
        return this.mPdfDocument != null && this.mPdfWriter != null;
    }

    @Override
    protected void saveImageFile(BufferedImage image) throws Exception {
        com.lowagie.text.Image pdfImage = null;
        pdfImage = com.lowagie.text.Image.getInstance((PdfWriter)this.mPdfWriter, (Image)image, (float)1.0f);
        this.mPdfDocument.add((Element)pdfImage);
    }

    @Override
    protected void saveImageFile(MScanPlotArea plotArea) throws Exception {
        Graphics2D g2d = null;
        PdfContentByte pdfContentByte = null;
        PdfTemplate pdfTemplate = null;
        pdfContentByte = this.mPdfWriter.getDirectContent();
        pdfTemplate = pdfContentByte.createTemplate((float)plotArea.getWidth(), (float)plotArea.getHeight());
        g2d = pdfTemplate.createGraphics((float)plotArea.getWidth(), (float)plotArea.getHeight(), (FontMapper)new DefaultFontMapper());
        plotArea.plotImage(g2d);
        g2d.dispose();
        pdfContentByte.addTemplate(pdfTemplate, 0.0f, 0.0f);
    }
}

