/*
 * Decompiled with CFR 0.152.
 */
package mscanlib.plots;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import mscanlib.plots.MScanPlot;
import mscanlib.plots.MScanPlotArea;
import mscanlib.plots.MScanPlottable;
import mscanlib.plots.MScanPoint;

public class MScanScatterPlot
extends MScanPlot {
    protected Color mOutliersColor = this.mFaceColor;
    protected int[] mOutliers = null;
    protected int mType = 0;

    public MScanScatterPlot(MScanPlotArea plotArea, double[] x, double[] y, int[] outliers, int type) {
        this(plotArea, x, y, outliers);
        this.mType = type;
    }

    public MScanScatterPlot(MScanPlotArea plotArea, double[] x, double[] y, int type) {
        this(plotArea, x, y, null, type);
    }

    public MScanScatterPlot(MScanPlotArea plotArea, double[] x, double[] y, int[] outliers) {
        super(plotArea, 1001);
        this.setPoints(x, y, outliers);
    }

    public MScanScatterPlot(MScanPlotArea plotArea, double[] x, double[] y) {
        this(plotArea, x, y, null);
    }

    public MScanScatterPlot(MScanPlotArea plotArea, int type) {
        this(plotArea, null, null, null, type);
    }

    public MScanScatterPlot(MScanPlotArea plotArea) {
        this(plotArea, null, null, null);
    }

    public int[] getOutliers() {
        return this.mOutliers;
    }

    public Color getOutliersColor() {
        return this.mOutliersColor;
    }

    public void setPoints(double[] x, double[] y, int[] outliers) {
        MScanPoint point = null;
        if (x != null && y != null && x.length > 0 && x.length == y.length) {
            this.mPlotElements = new ArrayList(x.length);
            this.mOutliers = outliers;
            int i = 0;
            while (i < x.length) {
                point = new MScanPoint(this.mPlotArea, x[i], y[i], this.mType);
                this.addPlotElement(point, true);
                if (this.mOutliers != null && this.mOutliers[i] != 0) {
                    point.setFaceColor(this.mOutliersColor);
                }
                ++i;
            }
        } else {
            this.resetPlotElements();
        }
    }

    public void setPoints(Point2D.Double[] points, int[] outliers) {
        MScanPoint point = null;
        if (points != null && points.length > 0) {
            this.mPlotElements = new ArrayList(points.length);
            this.mOutliers = outliers;
            int i = 0;
            while (i < points.length) {
                point = new MScanPoint(this.mPlotArea, points[i].x, points[i].y, this.mType);
                this.addPlotElement(point, true);
                if (this.mOutliers != null && this.mOutliers[i] != 0) {
                    point.setFaceColor(this.mOutliersColor);
                }
                ++i;
            }
        } else {
            this.resetPlotElements();
        }
    }

    public void setPoints(double[] x, double[] y) {
        this.setPoints(x, y, null);
    }

    public void setOutliers(int[] outliers) {
        this.mOutliers = outliers;
        this.setOutliersColor(this.mOutliersColor);
    }

    public void setOutliersColor(Color color) {
        this.mOutliersColor = color;
        if (this.mOutliers != null) {
            int i = 0;
            while (i < this.mPlotElements.size()) {
                ((MScanPlottable)this.mPlotElements.get(i)).setFaceColor(this.mOutliers[i] == 0 ? this.mFaceColor : this.mOutliersColor);
                ++i;
            }
        }
    }
}

