/*
 * Decompiled with CFR 0.152.
 */
package mscanlib.plots;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import mscanlib.plots.MScanPlotArea;
import mscanlib.plots.MScanPlottable;

public class MScanPoint
extends MScanPlottable {
    private int mType = 0;
    private Shape mMarker = null;

    public MScanPoint(MScanPlotArea plotArea, double x, double y, int type) {
        super(plotArea, 0, true);
        this.mX = x;
        this.mY = y;
        this.mH = this.mW = 6.0;
        this.mType = type;
    }

    @Override
    public void draw(Graphics2D g2d) {
        if (this.mIsVisible && this.mPlotArea.checkVisible(this.mX, this.mY)) {
            int[] x = null;
            int[] y = null;
            double xPos = this.mPlotArea.getX(this.mX);
            double yPos = this.mPlotArea.getY(this.mY);
            switch (this.mType) {
                case 0: {
                    this.mMarker = new Ellipse2D.Double();
                    ((Ellipse2D.Double)this.mMarker).setFrame(this.mPlotArea.getX(this.mX) - this.mW / 2.0, this.mPlotArea.getY(this.mY) - this.mW / 2.0, this.mW, this.mW);
                    break;
                }
                case 2: {
                    x = new int[]{(int)(xPos - this.mW / 2.0), (int)(xPos + this.mW / 2.0), (int)(xPos + this.mW / 2.0), (int)(xPos - this.mW / 2.0)};
                    y = new int[]{(int)(yPos + this.mW / 2.0), (int)(yPos + this.mW / 2.0), (int)(yPos - this.mW / 2.0), (int)(yPos - this.mW / 2.0)};
                    this.mMarker = new Polygon(x, y, 4);
                    break;
                }
                case 1: {
                    x = new int[]{(int)(xPos - this.mW / 2.0), (int)xPos, (int)(xPos + this.mW / 2.0), (int)xPos};
                    y = new int[]{(int)yPos, (int)(yPos + this.mW / 2.0), (int)yPos, (int)(yPos - this.mW / 2.0)};
                    this.mMarker = new Polygon(x, y, 4);
                    break;
                }
                case 3: {
                    x = new int[]{(int)(xPos - this.mW / 2.0), (int)(xPos + this.mW / 2.0), (int)xPos};
                    y = new int[]{(int)(yPos + this.mW / 2.0), (int)(yPos + this.mW / 2.0), (int)(yPos - this.mW / 2.0)};
                    this.mMarker = new Polygon(x, y, 3);
                    break;
                }
                case 4: {
                    x = new int[]{(int)(xPos - this.mW / 2.0), (int)(xPos + this.mW / 2.0), (int)xPos};
                    y = new int[]{(int)(yPos - this.mW / 2.0), (int)(yPos - this.mW / 2.0), (int)(yPos + this.mW / 2.0)};
                    this.mMarker = new Polygon(x, y, 3);
                }
            }
            if (this.mAlpha != 1.0f) {
                g2d.setComposite(AlphaComposite.getInstance(3, this.mAlpha));
            }
            g2d.setColor(this.mIsSelected ? this.mSelectedColor : this.mFaceColor);
            g2d.fill(this.mMarker);
            if (this.mEdgeColor != null) {
                g2d.setStroke(new BasicStroke(this.mLineWidth, 1, 1));
                g2d.setColor(this.mEdgeColor);
                g2d.draw(this.mMarker);
            }
            if (this.mAlpha != 1.0f) {
                g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
            }
        }
    }

    @Override
    public double getMinX() {
        return this.mX;
    }

    @Override
    public double getMaxX() {
        return this.mX;
    }

    @Override
    public double getMinY() {
        return this.mY;
    }

    @Override
    public double getMaxY() {
        return this.mY;
    }

    @Override
    public boolean contains(double x, double y) {
        return this.mMarker.contains(this.mPlotArea.getX(x), this.mPlotArea.getY(y));
    }
}

