/*
 * Decompiled with CFR 0.152.
 */
package mscanlib.plots;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import mscanlib.plots.MScanPlotArea;
import mscanlib.plots.MScanPlottable;

public class MScanPlot
extends MScanPlottable {
    protected ArrayList<MScanPlottable> mPlotElements = new ArrayList();

    public MScanPlot(MScanPlotArea plotArea, int plotType) {
        super(plotArea, plotType);
    }

    @Override
    public void draw(Graphics2D g2d) {
        this.mPlotArea.redrawPlottables(this.mPlotElements, g2d);
    }

    @Override
    public boolean contains(double x, double y) {
        boolean result = false;
        int i = 0;
        while (i < this.mPlotElements.size()) {
            if (this.mPlotElements.get(i).contains(x, y)) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    @Override
    public MScanPlottable getClickedObject(double x, double y) {
        MScanPlottable clicked = null;
        int i = 0;
        while (i < this.mPlotElements.size()) {
            clicked = this.mPlotElements.get(i).getClickedObject(x, y);
            if (clicked != null) break;
            ++i;
        }
        return clicked;
    }

    @Override
    public double getMinX() {
        double x = -1.0;
        double result = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < this.mPlotElements.size()) {
            double d;
            x = this.mPlotElements.get(i).getMinX();
            if (d < result) {
                result = x;
            }
            ++i;
        }
        return result;
    }

    @Override
    public double getMaxX() {
        double x = -1.0;
        double result = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < this.mPlotElements.size()) {
            double d;
            x = this.mPlotElements.get(i).getMaxX();
            if (d > result) {
                result = x;
            }
            ++i;
        }
        return result;
    }

    @Override
    public double getMinY() {
        double y = -1.0;
        double result = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < this.mPlotElements.size()) {
            double d;
            y = this.mPlotElements.get(i).getMinY();
            if (d < result) {
                result = y;
            }
            ++i;
        }
        return result;
    }

    @Override
    public double getMaxY() {
        double y = -1.0;
        double result = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < this.mPlotElements.size()) {
            double d;
            y = this.mPlotElements.get(i).getMaxY();
            if (d > result) {
                result = y;
            }
            ++i;
        }
        return result;
    }

    public void setPlotElements(ArrayList<MScanPlottable> elements, boolean setProperties) {
        if (elements == null || elements.size() == 0) {
            this.resetPlotElements();
        } else {
            this.mPlotElements = new ArrayList(elements.size());
            int i = 0;
            while (i < elements.size()) {
                this.addPlotElement(elements.get(i), setProperties);
                ++i;
            }
        }
    }

    public void addPlotElement(MScanPlottable element, boolean setProperties) {
        element.setPlot(this);
        element.setIndex(this.mPlotElements.size());
        if (setProperties) {
            element.setProperties(this);
        }
        this.mPlotElements.add(element);
    }

    public void resetPlotElements() {
        this.mPlotElements = new ArrayList();
    }

    @Override
    public void setLineWidth(float width) {
        this.mLineWidth = width;
        int i = 0;
        while (i < this.mPlotElements.size()) {
            this.mPlotElements.get(i).setLineWidth(width);
            ++i;
        }
    }

    @Override
    public void setFaceColor(Color color) {
        this.mFaceColor = color;
        int i = 0;
        while (i < this.mPlotElements.size()) {
            this.mPlotElements.get(i).setFaceColor(color);
            ++i;
        }
    }

    @Override
    public void setEdgeColor(Color color) {
        this.mEdgeColor = color;
        int i = 0;
        while (i < this.mPlotElements.size()) {
            this.mPlotElements.get(i).setEdgeColor(color);
            ++i;
        }
    }

    @Override
    public void setSelectedColor(Color color) {
        this.mSelectedColor = color;
        int i = 0;
        while (i < this.mPlotElements.size()) {
            this.mPlotElements.get(i).setSelectedColor(color);
            ++i;
        }
    }

    @Override
    public void setVisible(boolean visible) {
        this.mIsVisible = visible;
        int i = 0;
        while (i < this.mPlotElements.size()) {
            this.mPlotElements.get(i).setVisible(visible);
            ++i;
        }
    }

    @Override
    public void setSelectable(boolean selectable) {
        this.mIsSelectable = selectable;
        int i = 0;
        while (i < this.mPlotElements.size()) {
            this.mPlotElements.get(i).setSelectable(selectable);
            ++i;
        }
    }

    @Override
    public void setSelected(boolean selected) {
        this.mIsSelected = selected;
        int i = 0;
        while (i < this.mPlotElements.size()) {
            this.mPlotElements.get(i).setSelected(selected);
            ++i;
        }
    }

    public void setSelected(MScanPlottable element, boolean selected) {
        if (this.mPlotElements.contains(element)) {
            element.setSelected(selected);
        }
    }

    public void setSelected(int[] selectedIndex) {
        this.setSelected(false);
        if (selectedIndex != null) {
            int i = 0;
            while (i < selectedIndex.length) {
                this.mPlotElements.get(selectedIndex[i]).setSelected(true);
                ++i;
            }
        }
    }

    public ArrayList<MScanPlottable> getPlotElements() {
        return this.mPlotElements;
    }

    public MScanPlottable getPlotElement(int index) {
        MScanPlottable element = null;
        if (index >= 0 && index < this.mPlotElements.size()) {
            element = this.mPlotElements.get(index);
        }
        return element;
    }

    public int getSelectedCount() {
        int selectedCount = 0;
        int i = 0;
        while (i < this.mPlotElements.size()) {
            if (this.mPlotElements.get(i).isSelected()) {
                ++selectedCount;
            }
            ++i;
        }
        return selectedCount;
    }

    public ArrayList<MScanPlottable> getSelected() {
        ArrayList<MScanPlottable> selectedList = null;
        int selectedCount = 0;
        MScanPlottable element = null;
        selectedCount = this.getSelectedCount();
        if (selectedCount > 0) {
            selectedList = new ArrayList<MScanPlottable>(selectedCount);
            int i = 0;
            while (i < this.mPlotElements.size()) {
                element = this.mPlotElements.get(i);
                if (element.isSelected()) {
                    selectedList.add(element);
                }
                ++i;
            }
        }
        return selectedList;
    }
}

