/*
 * Decompiled with CFR 0.152.
 */
package mscanlib.plots;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import mscanlib.plots.MScanLine;
import mscanlib.plots.MScanPlot;
import mscanlib.plots.MScanPlotArea;
import mscanlib.plots.math.IndexedHSort;
import mscanlib.plots.math.MathFun;

public class MScanLinePlot
extends MScanPlot {
    public MScanLinePlot(MScanPlotArea plotArea, double[] x, double[] y) {
        super(plotArea, 1000);
        this.mEdgeColor = null;
        this.setPoints(x, y, true);
    }

    public MScanLinePlot(MScanPlotArea plotArea) {
        this(plotArea, null, null);
    }

    public void setPoints(double[] x, double[] y, boolean sort) {
        double[] xSorted = null;
        double[] ySorted = null;
        int[] index = null;
        if (x != null && y != null && x.length > 0 && x.length == y.length) {
            if (sort) {
                xSorted = new double[x.length];
                System.arraycopy(x, 0, xSorted, 0, x.length);
                index = MathFun.setRange(0, x.length);
                IndexedHSort.sort(xSorted, index);
                ySorted = MathFun.reorder(y, index, false);
            } else {
                xSorted = x;
                ySorted = y;
            }
            this.setSortedPoints(xSorted, ySorted);
        } else {
            this.resetPlotElements();
        }
    }

    public void setPoints(double[] x, double[] y) {
        this.setPoints(x, y, true);
    }

    public void setPoints(Point2D.Double[] points, boolean sort) {
        double[] xSorted = null;
        double[] ySorted = null;
        int[] index = null;
        if (points != null && points.length > 0) {
            xSorted = new double[points.length];
            ySorted = new double[points.length];
            int i = 0;
            while (i < points.length) {
                xSorted[i] = points[i].x;
                ySorted[i] = points[i].y;
                ++i;
            }
            if (sort) {
                index = MathFun.setRange(0, xSorted.length);
                IndexedHSort.sort(xSorted, index);
                ySorted = MathFun.reorder(ySorted, index, false);
            }
            this.setSortedPoints(xSorted, ySorted);
        } else {
            this.resetPlotElements();
        }
    }

    public void setPoints(Point2D.Double[] points) {
        this.setPoints(points, true);
    }

    public void setSortedPoints(double[] xSorted, double[] ySorted) {
        if (xSorted != null && ySorted != null && xSorted.length > 0 && xSorted.length == ySorted.length) {
            this.mPlotElements = new ArrayList(xSorted.length);
            int i = 1;
            while (i < xSorted.length) {
                this.addPlotElement(new MScanLine(this.mPlotArea, xSorted[i - 1], ySorted[i - 1], xSorted[i], ySorted[i]), true);
                ++i;
            }
        } else {
            this.resetPlotElements();
        }
    }

    public void setCoeffs(double a, double b) {
        this.setPoints(this.getLinePoints(new double[]{a, b}));
    }

    public void setCoeffs(double[] coeffs) {
        this.setPoints(this.getLinePoints(coeffs));
    }

    private Point2D.Double[] getLinePoints(double[] coeffs) {
        Point2D.Double[] linePoints = null;
        linePoints = new Point2D.Double[2];
        linePoints[0] = new Point2D.Double(this.mPlotArea.getMinX(), coeffs[0] * this.mPlotArea.getMinX() + coeffs[1]);
        if (linePoints[0].y < this.mPlotArea.getMinY()) {
            linePoints[0].y = this.mPlotArea.getMinY();
            linePoints[0].x = (float)((this.mPlotArea.getMinY() - coeffs[1]) / coeffs[0]);
        } else if (linePoints[0].y > this.mPlotArea.getMaxY()) {
            linePoints[0].y = this.mPlotArea.getMaxY();
            linePoints[0].x = (float)((this.mPlotArea.getMaxY() - coeffs[1]) / coeffs[0]);
        }
        linePoints[1] = new Point2D.Double(this.mPlotArea.getMaxX(), (float)(coeffs[0] * this.mPlotArea.getMaxX() + coeffs[1]));
        if (linePoints[1].y > this.mPlotArea.getMaxY()) {
            linePoints[1].y = this.mPlotArea.getMaxY();
            linePoints[1].x = (float)((this.mPlotArea.getMaxY() - coeffs[1]) / coeffs[0]);
        } else if (linePoints[1].y < this.mPlotArea.getMinY()) {
            linePoints[1].y = this.mPlotArea.getMinY();
            linePoints[1].x = (float)((this.mPlotArea.getMinY() - coeffs[1]) / coeffs[0]);
        }
        return linePoints;
    }
}

