/*
 * Decompiled with CFR 0.152.
 */
package mscanlib.plots;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import mscanlib.plots.MScanPlotArea;
import mscanlib.plots.MScanPlottable;

public class MScanLine
extends MScanPlottable {
    private double mStartX = -1.0;
    private double mStartY = -1.0;
    private double mEndX = -1.0;
    private double mEndY = -1.0;
    private Line2D.Double mLine = null;

    public MScanLine(MScanPlotArea plotArea, double startX, double startY, double endX, double endY) {
        super(plotArea, 1, true);
        if (this.mStartX <= this.mEndX) {
            this.mStartX = startX;
            this.mStartY = startY;
            this.mEndX = endX;
            this.mEndY = endY;
        } else {
            this.mStartX = endX;
            this.mStartY = endY;
            this.mEndX = startX;
            this.mEndY = startY;
        }
        this.mFaceColor = this.mPlotArea.getPlotColor();
        this.mLine = new Line2D.Double();
    }

    @Override
    public void draw(Graphics2D g2d) {
        double[] visibleRangeX = new double[]{this.mStartX, this.mEndX};
        double[] visibleRangeY = new double[]{this.mStartY, this.mEndY};
        if (this.mIsVisible && this.checkVisible(visibleRangeX, visibleRangeY)) {
            this.mLine.setLine(this.mPlotArea.getX(visibleRangeX[0]), this.mPlotArea.getY(visibleRangeY[0]), this.mPlotArea.getX(visibleRangeX[1]), this.mPlotArea.getY(visibleRangeY[1]));
            if (this.mEdgeColor != null) {
                g2d.setStroke(new BasicStroke(this.mLineWidth + 1.0f, 1, 1));
                g2d.setColor(this.mEdgeColor);
                g2d.draw(this.mLine);
            }
            g2d.setStroke(new BasicStroke(this.mLineWidth, 1, 1));
            g2d.setColor(this.mIsSelected ? this.mSelectedColor : this.mFaceColor);
            if (this.mAlpha != 1.0f) {
                g2d.setComposite(AlphaComposite.getInstance(3, this.mAlpha));
            }
            g2d.draw(this.mLine);
            if (this.mAlpha != 1.0f) {
                g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
            }
        }
    }

    public boolean checkVisible(double[] x, double[] y) {
        boolean result = true;
        double minX = this.mPlotArea.getMinX();
        double maxX = this.mPlotArea.getMaxX();
        double minY = this.mPlotArea.getMinY();
        double maxY = this.mPlotArea.getMaxY();
        double a = -1.0;
        double b = -1.0;
        if (x[0] >= minX && x[1] <= maxX && y[0] >= minY && y[1] <= maxY) {
            result = true;
        } else if (x[0] > maxX && x[1] > maxX || x[0] < minX && x[1] < minX || y[0] > maxY && y[1] > maxY || y[0] < minY && y[1] < minY) {
            result = false;
        } else if (x[0] == x[1]) {
            y[0] = Math.max(y[0], minY);
            y[1] = Math.min(y[1], maxY);
        } else if (y[0] == y[1]) {
            x[0] = Math.max(x[0], minX);
            x[1] = Math.min(x[1], maxX);
        } else {
            a = (y[1] - y[0]) / (x[1] - x[0]);
            b = y[0] - a * x[0];
            x[0] = Math.max(x[0], minX);
            x[1] = Math.min(x[1], maxX);
            y[0] = a * x[0] + b;
            y[1] = a * x[1] + b;
            if (x[0] > maxX && x[1] > maxX || x[0] < minX && x[1] < minX || y[0] > maxY && y[1] > maxY || y[0] < minY && y[1] < minY) {
                result = false;
            } else {
                y[0] = Math.max(y[0], minY);
                y[1] = Math.min(y[1], maxY);
                x[0] = (y[0] - b) / a;
                x[1] = (y[1] - b) / a;
            }
        }
        return result;
    }

    @Override
    public boolean contains(double x, double y) {
        return this.mLine.contains(this.mPlotArea.getX(x), this.mPlotArea.getY(y));
    }

    @Override
    public double getMinX() {
        return this.mStartX;
    }

    @Override
    public double getMaxX() {
        return this.mEndX;
    }

    @Override
    public double getMinY() {
        return this.mStartY;
    }

    @Override
    public double getMaxY() {
        return this.mEndY;
    }
}

