/*
 * Decompiled with CFR 0.152.
 */
package mscanlib.plots;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import mscanlib.plots.MScanPlotArea;
import mscanlib.plots.MScanPlottable;

public class MScanBar
extends MScanPlottable {
    Rectangle2D.Double mRectangle = null;

    public MScanBar(MScanPlotArea plotArea, double x, double y, double w, double h) {
        super(plotArea, 2, true);
        this.mX = x;
        this.mY = y;
        this.mW = w;
        this.mH = h;
        this.mRectangle = new Rectangle2D.Double();
    }

    @Override
    public void draw(Graphics2D g2d) {
        double[] visibleRangeX = new double[]{this.mX, this.mX + this.mW};
        double[] visibleRangeY = new double[]{this.mY, this.mY + this.mH};
        if (this.mIsVisible && this.checkVisible(visibleRangeX, visibleRangeY)) {
            if (this.mAlpha != 1.0f) {
                g2d.setComposite(AlphaComposite.getInstance(3, this.mAlpha));
            }
            g2d.setColor(this.mIsSelected ? this.mSelectedColor : this.mFaceColor);
            this.mRectangle.setRect(this.mPlotArea.getX(visibleRangeX[0]), this.mPlotArea.getY(visibleRangeY[0] + (visibleRangeY[1] - visibleRangeY[0])), this.mPlotArea.getWidth(visibleRangeX[1] - visibleRangeX[0]), this.mPlotArea.getHeight(visibleRangeY[1] - visibleRangeY[0]));
            g2d.fill(this.mRectangle);
            if (this.mEdgeColor != null) {
                g2d.setStroke(new BasicStroke(this.mLineWidth, 1, 1));
                g2d.setColor(this.mEdgeColor);
                g2d.draw(this.mRectangle);
            }
            if (this.mAlpha != 1.0f) {
                g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
            }
        }
    }

    public boolean checkVisible(double[] visibleRangeX, double[] visibleRangeY) {
        return this.mPlotArea.checkVisibleRange(visibleRangeX, visibleRangeY);
    }

    @Override
    public double getMinX() {
        return this.mX;
    }

    @Override
    public double getMaxX() {
        return this.mX + this.mW;
    }

    @Override
    public double getMinY() {
        return this.mY;
    }

    @Override
    public double getMaxY() {
        return this.mX + this.mH;
    }

    @Override
    public boolean contains(double x, double y) {
        return this.mRectangle.contains(this.mPlotArea.getX(x), this.mPlotArea.getY(y));
    }
}

