/*
 * Decompiled with CFR 0.152.
 */
package math;

import math.LocusInfo;
import math.PositionInfo;
import math.ProfilerData;

public class ProfilerDataStatistics {
    public static void computeStatistics(ProfilerData data) {
        int i = 0;
        while (i < data.getChromosomes()) {
            LocusInfo[] loci = data.getMatchedLoci(i);
            PositionInfo[] positions = data.getMatchedPositions(i);
            float maxTags = 0.0f;
            double meanTags = 0.0;
            int j = 0;
            while (j < loci.length) {
                meanTags += (double)loci[j].getTagCount();
                if (loci[j].getTagCount() > maxTags) {
                    maxTags = loci[j].getTagCount();
                }
                ++j;
            }
            data.getMaxTagsPerLoci()[i] = maxTags;
            data.getMeanTagsPerLocus()[i] = meanTags /= (double)loci.length;
            maxTags = 0.0f;
            meanTags = 0.0;
            j = 0;
            while (j < positions.length) {
                meanTags += (double)positions[j].getTagCount();
                if (positions[j].getTagCount() > maxTags) {
                    maxTags = positions[j].getTagCount();
                }
                ++j;
            }
            data.getMaxTagsPerPosition()[i] = maxTags;
            data.getMeanTagsPerPosition()[i] = meanTags /= (double)positions.length;
            ++i;
        }
    }
}

