/*
 * Decompiled with CFR 0.152.
 */
package math;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import math.LocusInfo;
import math.PositionInfo;

public class ProfilerData {
    private int chromosomes;
    private HashMap<Integer, PositionInfo>[] positions;
    private HashMap<Integer, LocusInfo>[] loci;
    private double[] meanTagsPerPosition;
    private float[] maxTagsPerPosition;
    private double[] meanTagsPerLoci;
    private float[] maxTagsPerLoci;

    public ProfilerData(int chromosomes, HashMap<Integer, LocusInfo>[] loci) {
        this.chromosomes = chromosomes;
        this.positions = new HashMap[this.chromosomes];
        this.loci = loci;
        this.meanTagsPerPosition = new double[this.chromosomes];
        this.maxTagsPerPosition = new float[this.chromosomes];
        this.meanTagsPerLoci = new double[this.chromosomes];
        this.maxTagsPerLoci = new float[this.chromosomes];
        int i = 0;
        while (i < this.chromosomes) {
            this.positions[i] = new HashMap(100000);
            ++i;
        }
    }

    public ProfilerData(int chromosomes) {
        this.chromosomes = chromosomes;
        this.positions = new HashMap[this.chromosomes];
        this.loci = new HashMap[this.chromosomes];
        this.meanTagsPerPosition = new double[this.chromosomes];
        this.maxTagsPerPosition = new float[this.chromosomes];
        this.meanTagsPerLoci = new double[this.chromosomes];
        this.maxTagsPerLoci = new float[this.chromosomes];
        int i = 0;
        while (i < this.chromosomes) {
            this.positions[i] = new HashMap(100000);
            this.loci[i] = new HashMap(5000);
            ++i;
        }
    }

    public void clearCalculatedData() {
        int i = 0;
        while (i < this.chromosomes) {
            this.maxTagsPerPosition[i] = 0.0f;
            this.maxTagsPerLoci[i] = 0.0f;
            this.meanTagsPerPosition[i] = 0.0;
            this.meanTagsPerLoci[i] = 0.0;
            ++i;
        }
        this.restoreLoci();
        this.restorePositions();
    }

    public void setLoci(HashMap<Integer, LocusInfo>[] loci) {
        this.loci = loci;
    }

    public HashMap<Integer, LocusInfo>[] getLoci() {
        return this.loci;
    }

    public int getChromosomes() {
        return this.chromosomes;
    }

    public void setChromosomes(int chromosomes) {
        this.chromosomes = chromosomes;
    }

    public double[] getMeanTagsPerPosition() {
        return this.meanTagsPerPosition;
    }

    public void setMeanTagsPerPosition(double[] meanTagsPerPosition) {
        this.meanTagsPerPosition = meanTagsPerPosition;
    }

    public float[] getMaxTagsPerPosition() {
        return this.maxTagsPerPosition;
    }

    public void setMaxTagsPerPosition(float[] maxTagsPerPosition) {
        this.maxTagsPerPosition = maxTagsPerPosition;
    }

    public double[] getMeanTagsPerLocus() {
        return this.meanTagsPerLoci;
    }

    public void setMeanTagsPerLocus(double[] meanTagsPerPositionRange) {
        this.meanTagsPerLoci = meanTagsPerPositionRange;
    }

    public float[] getMaxTagsPerLoci() {
        return this.maxTagsPerLoci;
    }

    public void setMaxTagsPerLoci(float[] maxTagsPerPositionRange) {
        this.maxTagsPerLoci = maxTagsPerPositionRange;
    }

    public void addPosition(int chromosome, int coordinates) {
        PositionInfo info = this.positions[chromosome].get(coordinates);
        if (info == null) {
            info = new PositionInfo();
            info.setCoordinate(coordinates);
            this.positions[chromosome].put(coordinates, info);
        }
        info.addTag();
    }

    public void addPosition(int chromosome, int coordinates, float tags) {
        PositionInfo info = this.positions[chromosome].get(coordinates);
        if (info == null) {
            info = new PositionInfo();
            info.setCoordinate(coordinates);
            this.positions[chromosome].put(coordinates, info);
        }
        info.addTag(tags);
    }

    public void filterPosition(int chromosome, int coordinate) {
        this.positions[chromosome].get(coordinate).setFiltered(true);
    }

    public void addLocus(int chromosome, LocusInfo locus) {
        if (!this.loci[chromosome].containsKey(locus.getCoordinate())) {
            this.loci[chromosome].put(locus.getCoordinate(), locus);
        }
    }

    public void addLongestLocus(int chromosome, LocusInfo locus) {
        if (!this.loci[chromosome].containsKey(locus.getCoordinate())) {
            this.loci[chromosome].put(locus.getCoordinate(), locus);
        } else {
            LocusInfo info = this.loci[chromosome].get(locus.getCoordinate());
            if (info.getLength() < locus.getLength()) {
                this.loci[chromosome].put(locus.getCoordinate(), locus);
            }
        }
    }

    public void filterLocus(int chromosome, int coordinate) {
        this.loci[chromosome].get(coordinate).setFiltered(true);
    }

    public int getLociCount(int chromosome) {
        return this.loci[chromosome].size();
    }

    public int getPositionsCount(int chromosome) {
        return this.positions[chromosome].size();
    }

    public LocusInfo[] getAllLoci(int chromosome) {
        return this.loci[chromosome].values().toArray(new LocusInfo[this.loci[chromosome].values().size()]);
    }

    public LocusInfo[] getLoci(int chromosome) {
        ArrayList<LocusInfo> notFiltered = new ArrayList<LocusInfo>(this.getLociCount(chromosome));
        Iterator<LocusInfo> it = this.loci[chromosome].values().iterator();
        LocusInfo locus = null;
        while (it.hasNext()) {
            locus = it.next();
            if (locus.isFiltered()) continue;
            notFiltered.add(locus);
        }
        return notFiltered.toArray(new LocusInfo[0]);
    }

    public LocusInfo[] getMatchedLoci(int chromosome) {
        ArrayList<LocusInfo> notFiltered = new ArrayList<LocusInfo>(this.getLociCount(chromosome));
        Iterator<LocusInfo> it = this.loci[chromosome].values().iterator();
        LocusInfo locus = null;
        while (it.hasNext()) {
            locus = it.next();
            if (locus.isFiltered() || !locus.isMatched()) continue;
            notFiltered.add(locus);
        }
        return notFiltered.toArray(new LocusInfo[0]);
    }

    public LocusInfo getLocus(int chromosome, int coordinate) {
        return this.loci[chromosome].get(coordinate);
    }

    public PositionInfo[] getAllPositions(int chromosome) {
        return this.positions[chromosome].values().toArray(new PositionInfo[this.positions[chromosome].values().size()]);
    }

    public PositionInfo[] getPositions(int chromosome) {
        ArrayList<PositionInfo> notFiltered = new ArrayList<PositionInfo>(this.getPositionsCount(chromosome));
        Iterator<PositionInfo> it = this.positions[chromosome].values().iterator();
        PositionInfo position = null;
        while (it.hasNext()) {
            position = it.next();
            if (position.isFiltered()) continue;
            notFiltered.add(position);
        }
        return notFiltered.toArray(new PositionInfo[0]);
    }

    public PositionInfo[] getMatchedPositions(int chromosome) {
        ArrayList<PositionInfo> notFiltered = new ArrayList<PositionInfo>(this.getPositionsCount(chromosome));
        Iterator<PositionInfo> it = this.positions[chromosome].values().iterator();
        PositionInfo position = null;
        while (it.hasNext()) {
            position = it.next();
            if (position.isFiltered() || !position.isMatched()) continue;
            notFiltered.add(position);
        }
        return notFiltered.toArray(new PositionInfo[0]);
    }

    public void restoreLoci() {
        int i = 0;
        while (i < this.chromosomes) {
            Iterator<LocusInfo> it = this.loci[i].values().iterator();
            LocusInfo locus = null;
            while (it.hasNext()) {
                locus = it.next();
                locus.setFiltered(false);
                locus.setMatched(false);
                locus.setTagCount(0.0f);
            }
            ++i;
        }
    }

    public void removeLoci() {
        int i = 0;
        while (i < this.chromosomes) {
            this.loci[i].clear();
            ++i;
        }
    }

    public void restorePositions() {
        int i = 0;
        while (i < this.chromosomes) {
            Iterator<PositionInfo> it = this.positions[i].values().iterator();
            PositionInfo position = null;
            while (it.hasNext()) {
                position = it.next();
                position.setFiltered(false);
                position.setMatched(false);
                position.setLociCoordinate(-1);
                position.setLoci2Coordinate(-1);
                position.setLociDistance(-1);
            }
            ++i;
        }
    }

    public void removePositions() {
        int i = 0;
        while (i < this.chromosomes) {
            this.positions[i].clear();
            ++i;
        }
    }
}

