/*
 * Decompiled with CFR 0.152.
 */
package math;

import java.awt.geom.Point2D;
import java.util.Arrays;

public final class MathFun {
    public static double[] linSpace(double start, double stop, int pointsCount) {
        double[] linSpace = null;
        double step = -1.0;
        if (pointsCount > 1) {
            linSpace = new double[pointsCount];
            step = (stop - start) / (double)(pointsCount - 1);
            int i = 0;
            while (i < pointsCount - 1) {
                linSpace[i] = start + (double)i * step;
                ++i;
            }
            linSpace[pointsCount - 1] = stop;
        }
        return linSpace;
    }

    public static double toPrecision(double value, int digits) {
        double result = 0.0;
        double pow = 0.0;
        pow = Math.pow(10.0, digits);
        result = (double)Math.round(value * pow) / pow;
        return result;
    }

    public static float toPrecision(float value, int digits) {
        return (float)MathFun.toPrecision((double)value, digits);
    }

    public static void toPrecision(double[] array, int digits) {
        int i = 0;
        while (i < array.length) {
            array[i] = MathFun.toPrecision(array[i], digits);
            ++i;
        }
    }

    public static void toPrecision(float[] array, int digits) {
        int i = 0;
        while (i < array.length) {
            array[i] = MathFun.toPrecision(array[i], digits);
            ++i;
        }
    }

    public static String formatInt(int number, int length) {
        StringBuffer str = null;
        String numStr = null;
        int lenDiff = 0;
        str = new StringBuffer("");
        numStr = String.valueOf(number);
        lenDiff = length - numStr.length();
        int i = 0;
        while (i <= lenDiff) {
            str.append("0");
            ++i;
        }
        str.append(numStr);
        return str.toString();
    }

    public static boolean isEven(int value) {
        return value % 2 == 0;
    }

    public static int[] setRange(int minValue, int maxValue) {
        int[] range = null;
        int rangeLength = 0;
        rangeLength = maxValue - minValue;
        range = new int[rangeLength];
        int i = 0;
        while (i < rangeLength) {
            range[i] = i + minValue;
            ++i;
        }
        return range;
    }

    public static void set(double[] array, double value) {
        int i = 0;
        while (i < array.length) {
            array[i] = value;
            ++i;
        }
    }

    public static void set(float[] array, float value) {
        int i = 0;
        while (i < array.length) {
            array[i] = value;
            ++i;
        }
    }

    public static void set(int[] array, int value) {
        int i = 0;
        while (i < array.length) {
            array[i] = value;
            ++i;
        }
    }

    public static void set(double[][] array, double value) {
        int i = 0;
        while (i < array.length) {
            int j = 0;
            while (j < array[i].length) {
                array[i][j] = value;
                ++j;
            }
            ++i;
        }
    }

    public static void set(float[][] array, float value) {
        int i = 0;
        while (i < array.length) {
            int j = 0;
            while (j < array[i].length) {
                array[i][j] = value;
                ++j;
            }
            ++i;
        }
    }

    public static void set(int[][] array, int value) {
        int i = 0;
        while (i < array.length) {
            int j = 0;
            while (j < array[i].length) {
                array[i][j] = value;
                ++j;
            }
            ++i;
        }
    }

    public static void set(boolean[][] array, boolean value) {
        int i = 0;
        while (i < array.length) {
            int j = 0;
            while (j < array[i].length) {
                array[i][j] = value;
                ++j;
            }
            ++i;
        }
    }

    public static void set(boolean[] array, boolean value) {
        int i = 0;
        while (i < array.length) {
            array[i] = value;
            ++i;
        }
    }

    public static int notZeroCount(int[] array) {
        int result = 0;
        int i = 0;
        while (i < array.length) {
            if (array[i] != 0) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    public static int notZeroCount(double[] array) {
        int result = 0;
        int i = 0;
        while (i < array.length) {
            if (array[i] != 0.0) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    public static int zeroCount(int[] array) {
        int result = 0;
        int i = 0;
        while (i < array.length) {
            if (array[i] == 0) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    public static int zeroCount(double[] array) {
        int result = 0;
        int i = 0;
        while (i < array.length) {
            if (array[i] == 0.0) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    public static double[] getNotZeroMask(double[] array, int[] mask) {
        double[] result = null;
        int counter = 0;
        if (array.length == mask.length && (counter = MathFun.notZeroCount(mask)) != 0) {
            result = new double[counter];
            counter = 0;
            int i = 0;
            while (i < mask.length) {
                if (mask[i] != 0) {
                    result[counter++] = array[i];
                }
                ++i;
            }
        }
        return result;
    }

    public static double[] getZeroMask(double[] array, int[] mask) {
        double[] result = null;
        int counter = 0;
        if (array.length == mask.length && (counter = MathFun.zeroCount(mask)) != 0) {
            result = new double[counter];
            counter = 0;
            int i = 0;
            while (i < mask.length) {
                if (mask[i] == 0) {
                    result[counter++] = array[i];
                }
                ++i;
            }
        }
        return result;
    }

    public static Point2D.Float[] getZeroMask(Point2D.Float[] array, int[] mask) {
        Point2D.Float[] result = null;
        int counter = 0;
        if (array.length == mask.length && (counter = MathFun.zeroCount(mask)) != 0) {
            result = new Point2D.Float[counter];
            counter = 0;
            int i = 0;
            while (i < mask.length) {
                if (mask[i] == 0) {
                    result[counter++] = array[i];
                }
                ++i;
            }
        }
        return result;
    }

    public static Point2D.Double[] getZeroMask(Point2D.Double[] array, int[] mask) {
        Point2D.Double[] result = null;
        int counter = 0;
        if (array.length == mask.length && (counter = MathFun.zeroCount(mask)) != 0) {
            result = new Point2D.Double[counter];
            counter = 0;
            int i = 0;
            while (i < mask.length) {
                if (mask[i] == 0) {
                    result[counter++] = array[i];
                }
                ++i;
            }
        }
        return result;
    }

    public static double[] reverse(double[] array) {
        double[] result = null;
        if (array != null && array.length != 0) {
            result = new double[array.length];
            int i = 0;
            while (i < array.length) {
                result[i] = array[array.length - i - 1];
                ++i;
            }
        }
        return result;
    }

    public static float[] reverse(float[] array) {
        float[] result = null;
        if (array != null && array.length != 0) {
            result = new float[array.length];
            int i = 0;
            while (i < array.length) {
                result[i] = array[array.length - i - 1];
                ++i;
            }
        }
        return result;
    }

    public static int[] reverse(int[] array) {
        int[] result = null;
        if (array != null && array.length != 0) {
            result = new int[array.length];
            int i = 0;
            while (i < array.length) {
                result[i] = array[array.length - i - 1];
                ++i;
            }
        }
        return result;
    }

    public static double[] reorder(double[] array, int[] index, boolean reversed) {
        double[] result = null;
        if (array.length == index.length) {
            result = new double[array.length];
            int i = 0;
            while (i < array.length) {
                result[i] = !reversed ? array[index[i]] : array[index[array.length - i - 1]];
                ++i;
            }
        }
        return result;
    }

    public static float[] reorder(float[] array, int[] index, boolean reversed) {
        float[] result = null;
        if (array.length == index.length) {
            result = new float[array.length];
            int i = 0;
            while (i < array.length) {
                result[i] = !reversed ? array[index[i]] : array[index[array.length - i - 1]];
                ++i;
            }
        }
        return result;
    }

    public static int[] reorder(int[] array, int[] index, boolean reversed) {
        int[] result = null;
        if (array.length == index.length) {
            result = new int[array.length];
            int i = 0;
            while (i < array.length) {
                result[i] = !reversed ? array[index[i]] : array[index[array.length - i - 1]];
                ++i;
            }
        }
        return result;
    }

    public static long[] reorder(long[] array, int[] index, boolean reversed) {
        long[] result = null;
        if (array.length == index.length) {
            result = new long[array.length];
            int i = 0;
            while (i < array.length) {
                result[i] = !reversed ? array[index[i]] : array[index[array.length - i - 1]];
                ++i;
            }
        }
        return result;
    }

    public static double[] restoreOrder(double[] array, int[] index, boolean reversed) {
        double[] result = null;
        if (array.length == index.length) {
            result = new double[array.length];
            int i = 0;
            while (i < array.length) {
                result[!reversed ? index[i] : index[array.length - i - 1]] = array[i];
                ++i;
            }
        }
        return result;
    }

    public static double[][] reorderRows(double[][] array, int[] index, boolean reversed) {
        double[][] result = null;
        if (array[0].length == index.length) {
            result = new double[array.length][array[0].length];
            int k = 0;
            while (k < array.length) {
                int i = 0;
                while (i < array[0].length) {
                    result[k][i] = !reversed ? array[k][index[i]] : array[k][index[array.length - i - 1]];
                    ++i;
                }
                ++k;
            }
        }
        return result;
    }

    public static float[][] reorderRows(float[][] array, int[] index, boolean reversed) {
        float[][] result = null;
        if (array[0].length == index.length) {
            result = new float[array.length][array[0].length];
            int k = 0;
            while (k < array.length) {
                int i = 0;
                while (i < array[0].length) {
                    result[k][i] = !reversed ? array[k][index[i]] : array[k][index[array.length - i - 1]];
                    ++i;
                }
                ++k;
            }
        }
        return result;
    }

    public static int[][] reorderRows(int[][] array, int[] index, boolean reversed) {
        int[][] result = null;
        if (array[0].length == index.length) {
            result = new int[array.length][array[0].length];
            int k = 0;
            while (k < array.length) {
                int i = 0;
                while (i < array[0].length) {
                    result[k][i] = !reversed ? array[k][index[i]] : array[k][index[array.length - i - 1]];
                    ++i;
                }
                ++k;
            }
        }
        return result;
    }

    public static double[] abs(double[] array) {
        double[] result = null;
        result = new double[array.length];
        int i = 0;
        while (i < array.length) {
            result[i] = Math.abs(array[i]);
            ++i;
        }
        return result;
    }

    public static float[] abs(float[] array) {
        float[] result = null;
        result = new float[array.length];
        int i = 0;
        while (i < array.length) {
            result[i] = Math.abs(array[i]);
            ++i;
        }
        return result;
    }

    public static int[] abs(int[] array) {
        int[] result = null;
        result = new int[array.length];
        int i = 0;
        while (i < array.length) {
            result[i] = Math.abs(array[i]);
            ++i;
        }
        return result;
    }

    public static double log(double value, double base) {
        return Math.log(value) / Math.log(base);
    }

    public static double log10(double value) {
        return Math.log(value) / Math.log(10.0);
    }

    public static double log2(double value) {
        return Math.log(value) / Math.log(2.0);
    }

    public static double prod(double start, double stop) {
        double result = 1.0;
        int i = (int)start;
        while (i <= (int)stop) {
            result *= (double)i;
            ++i;
        }
        return result;
    }

    public static double sum(double[] array) {
        double result = 0.0;
        int i = 0;
        while (i < array.length) {
            result += array[i];
            ++i;
        }
        return result;
    }

    public static float sum(float[] array) {
        float result = 0.0f;
        int i = 0;
        while (i < array.length) {
            result += array[i];
            ++i;
        }
        return result;
    }

    public static int sum(int[] array) {
        int result = 0;
        int i = 0;
        while (i < array.length) {
            result += array[i];
            ++i;
        }
        return result;
    }

    public static double max(double[] array) {
        double result = array[0];
        int i = 0;
        while (i < array.length) {
            if (array[i] > result) {
                result = array[i];
            }
            ++i;
        }
        return result;
    }

    public static float max(float[] array) {
        float result = array[0];
        int i = 0;
        while (i < array.length) {
            if (array[i] > result) {
                result = array[i];
            }
            ++i;
        }
        return result;
    }

    public static int max(int[] array) {
        int result = array[0];
        int i = 0;
        while (i < array.length) {
            if (array[i] > result) {
                result = array[i];
            }
            ++i;
        }
        return result;
    }

    public static long max(long[] array) {
        long result = array[0];
        int i = 0;
        while (i < array.length) {
            if (array[i] > result) {
                result = array[i];
            }
            ++i;
        }
        return result;
    }

    public static double max(double[][] array) {
        double result = array[0][0];
        int i = 0;
        while (i < array.length) {
            int j = 0;
            while (j < array[i].length) {
                if (array[i][j] > result) {
                    result = array[i][j];
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static float max(float[][] array) {
        float result = array[0][0];
        int i = 0;
        while (i < array.length) {
            int j = 0;
            while (j < array[i].length) {
                if (array[i][j] > result) {
                    result = array[i][j];
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static int argmax(double[] array) {
        double maxValue = array[0];
        int index = 0;
        int i = 0;
        while (i < array.length) {
            if (array[i] > maxValue) {
                maxValue = array[i];
                index = i;
            }
            ++i;
        }
        return index;
    }

    public static int argmax(float[] array) {
        float maxValue = array[0];
        int index = 0;
        int i = 0;
        while (i < array.length) {
            if (array[i] > maxValue) {
                maxValue = array[i];
                index = i;
            }
            ++i;
        }
        return index;
    }

    public static int argmax(int[] array) {
        int maxValue = array[0];
        int index = 0;
        int i = 0;
        while (i < array.length) {
            if (array[i] > maxValue) {
                maxValue = array[i];
                index = i;
            }
            ++i;
        }
        return index;
    }

    public static int argmax(long[] array) {
        long maxValue = array[0];
        int index = 0;
        int i = 0;
        while (i < array.length) {
            if (array[i] > maxValue) {
                maxValue = array[i];
                index = i;
            }
            ++i;
        }
        return index;
    }

    public static double min(double[] array) {
        double result = array[0];
        int i = 0;
        while (i < array.length) {
            if (array[i] < result) {
                result = array[i];
            }
            ++i;
        }
        return result;
    }

    public static float min(float[] array) {
        float result = array[0];
        int i = 0;
        while (i < array.length) {
            if (array[i] < result) {
                result = array[i];
            }
            ++i;
        }
        return result;
    }

    public static int min(int[] array) {
        int result = array[0];
        int i = 0;
        while (i < array.length) {
            if (array[i] < result) {
                result = array[i];
            }
            ++i;
        }
        return result;
    }

    public static int argmin(double[] array) {
        double minValue = array[0];
        int index = 0;
        int i = 0;
        while (i < array.length) {
            if (array[i] < minValue) {
                minValue = array[i];
                index = i;
            }
            ++i;
        }
        return index;
    }

    public static int argmin(float[] array) {
        float minValue = array[0];
        int index = 0;
        int i = 0;
        while (i < array.length) {
            if (array[i] < minValue) {
                minValue = array[i];
                index = i;
            }
            ++i;
        }
        return index;
    }

    public static int argmin(int[] array) {
        int minValue = array[0];
        int index = 0;
        int i = 0;
        while (i < array.length) {
            if (array[i] < minValue) {
                minValue = array[i];
                index = i;
            }
            ++i;
        }
        return index;
    }

    public static double[] minmax(double[] array) {
        double minValue = array[0];
        double maxValue = array[0];
        int i = 0;
        while (i < array.length) {
            if (array[i] < minValue) {
                minValue = array[i];
            } else if (array[i] > maxValue) {
                maxValue = array[i];
            }
            ++i;
        }
        return new double[]{minValue, maxValue};
    }

    public static float[] minmax(float[] array) {
        float minValue = array[0];
        float maxValue = array[0];
        int i = 0;
        while (i < array.length) {
            if (array[i] < minValue) {
                minValue = array[i];
            } else if (array[i] > maxValue) {
                maxValue = array[i];
            }
            ++i;
        }
        return new float[]{minValue, maxValue};
    }

    public static double nonZeroMin(double[] array) {
        double result = Double.MAX_VALUE;
        int i = 0;
        while (i < array.length) {
            if (array[i] != 0.0 && array[i] < result) {
                result = array[i];
            }
            ++i;
        }
        return result;
    }

    public static float nonZeroMin(float[] array) {
        float result = Float.MAX_VALUE;
        int i = 0;
        while (i < array.length) {
            if (array[i] != 0.0f && array[i] < result) {
                result = array[i];
            }
            ++i;
        }
        return result;
    }

    public static double[] square(double[] array) {
        double[] result = null;
        result = new double[array.length];
        int i = 0;
        while (i < array.length) {
            result[i] = array[i] * array[i];
            ++i;
        }
        return result;
    }

    public static double mean(double[] array) {
        double result = 0.0;
        int i = 0;
        while (i < array.length) {
            result += array[i];
            ++i;
        }
        return result /= (double)array.length;
    }

    public static double wmean(double[] array, double[] weights) {
        double result = 0.0;
        double w = 0.0;
        int i = 0;
        while (i < array.length) {
            result += array[i] * weights[i];
            w += weights[i];
            ++i;
        }
        return result /= w;
    }

    public static double mean(double[] array, int minIndex, int maxIndex) {
        double result = 0.0;
        int i = minIndex;
        while (i < maxIndex) {
            result += array[i];
            ++i;
        }
        return result /= (double)(maxIndex - minIndex);
    }

    public static float mean(float[] array) {
        float result = 0.0f;
        int i = 0;
        while (i < array.length) {
            result += array[i];
            ++i;
        }
        return result /= (float)array.length;
    }

    public static float mean(float[] array, int minIndex, int maxIndex) {
        float result = 0.0f;
        int i = minIndex;
        while (i < maxIndex) {
            result += array[i];
            ++i;
        }
        return result /= (float)(maxIndex - minIndex);
    }

    public static double nonZeroMean(double[] array) {
        double result = 0.0;
        int counter = 0;
        int i = 0;
        while (i < array.length) {
            if (array[i] != 0.0) {
                ++counter;
                result += array[i];
            }
            ++i;
        }
        if (counter != 0) {
            result /= (double)counter;
        }
        return result;
    }

    public static float nonZeroMean(float[] array) {
        float result = 0.0f;
        int counter = 0;
        int i = 0;
        while (i < array.length) {
            if (array[i] != 0.0f) {
                ++counter;
                result += array[i];
            }
            ++i;
        }
        if (counter != 0) {
            result /= (float)counter;
        }
        return result;
    }

    public static double median(double[] array, boolean nd) {
        double[] tmpArray = null;
        int arrayLength = 0;
        double result = Double.NaN;
        if (array != null && (arrayLength = array.length) > 0) {
            if (nd) {
                tmpArray = new double[arrayLength];
                int i = 0;
                while (i < arrayLength) {
                    tmpArray[i] = array[i];
                    ++i;
                }
            } else {
                tmpArray = array;
            }
            Arrays.sort(tmpArray);
            result = MathFun.isEven(arrayLength) ? (tmpArray[(arrayLength /= 2) - 1] + tmpArray[arrayLength]) / 2.0 : tmpArray[arrayLength / 2];
        }
        return result;
    }

    public static double median(double[] array, int minIndex, int maxIndex, boolean nd) {
        double[] tmpArray = null;
        int arrayLength = 0;
        double result = Double.NaN;
        if (array != null && (arrayLength = maxIndex - minIndex) > 0) {
            if (nd) {
                tmpArray = new double[arrayLength];
                int i = 0;
                while (i < arrayLength) {
                    tmpArray[i] = array[i + minIndex];
                    ++i;
                }
                minIndex = 0;
                maxIndex = arrayLength;
            } else {
                tmpArray = array;
            }
            Arrays.sort(tmpArray, minIndex, maxIndex);
            result = MathFun.isEven(arrayLength) ? (tmpArray[minIndex + (arrayLength /= 2) - 1] + tmpArray[minIndex + arrayLength]) / 2.0 : tmpArray[minIndex + arrayLength / 2];
        }
        return result;
    }

    public static float median(float[] array, boolean nd) {
        float[] tmpArray = null;
        int arrayLength = 0;
        float result = Float.NaN;
        if (array != null && (arrayLength = array.length) > 0) {
            if (nd) {
                tmpArray = new float[arrayLength];
                int i = 0;
                while (i < arrayLength) {
                    tmpArray[i] = array[i];
                    ++i;
                }
            } else {
                tmpArray = array;
            }
            Arrays.sort(tmpArray);
            result = MathFun.isEven(arrayLength) ? (tmpArray[(arrayLength /= 2) - 1] + tmpArray[arrayLength]) / 2.0f : tmpArray[arrayLength / 2];
        }
        return result;
    }

    public static float median(float[] array, int minIndex, int maxIndex, boolean nd) {
        float[] tmpArray = null;
        int arrayLength = 0;
        float result = Float.NaN;
        if (array != null && (arrayLength = maxIndex - minIndex) > 0) {
            if (nd) {
                tmpArray = new float[arrayLength];
                int i = 0;
                while (i < arrayLength) {
                    tmpArray[i] = array[i + minIndex];
                    ++i;
                }
                minIndex = 0;
                maxIndex = arrayLength;
            } else {
                tmpArray = array;
            }
            Arrays.sort(tmpArray, minIndex, maxIndex);
            result = MathFun.isEven(arrayLength) ? (tmpArray[minIndex + (arrayLength /= 2) - 1] + tmpArray[minIndex + arrayLength]) / 2.0f : tmpArray[minIndex + arrayLength / 2];
        }
        return result;
    }

    public static float var(float[] array) {
        return MathFun.var(array, false);
    }

    public static float var(float[] array, boolean n) {
        return MathFun.var(array, n, 0, array.length);
    }

    public static float var(float[] array, boolean n, int minIndex, int maxIndex) {
        float result = 0.0f;
        float tmp = 0.0f;
        float m = 0.0f;
        m = MathFun.mean(array, minIndex, maxIndex);
        int i = minIndex;
        while (i < maxIndex) {
            tmp = array[i] - m;
            result += tmp * tmp;
            ++i;
        }
        result = n ? (result /= (float)(maxIndex - minIndex)) : (result /= (float)(maxIndex - minIndex - 1));
        return result;
    }

    public static double var(double[] array) {
        return MathFun.var(array, false);
    }

    public static double var(double[] array, boolean n) {
        return MathFun.var(array, n, 0, array.length);
    }

    public static double var(double[] array, boolean n, int minIndex, int maxIndex) {
        double result = 0.0;
        double tmp = 0.0;
        double m = 0.0;
        m = MathFun.mean(array, minIndex, maxIndex);
        int i = minIndex;
        while (i < maxIndex) {
            tmp = array[i] - m;
            result += tmp * tmp;
            ++i;
        }
        result = n ? (result /= (double)(maxIndex - minIndex)) : (result /= (double)(maxIndex - minIndex - 1));
        return result;
    }

    public static double mad(double[] array, boolean nd) {
        int i;
        double result = 0.0;
        double m = 0.0;
        double[] tmpArray = null;
        int arrayLength = 0;
        arrayLength = array.length;
        if (nd) {
            tmpArray = new double[arrayLength];
            i = 0;
            while (i < arrayLength) {
                tmpArray[i] = array[i];
                ++i;
            }
        } else {
            tmpArray = array;
        }
        m = MathFun.median(tmpArray, false);
        i = 0;
        while (i < arrayLength) {
            tmpArray[i] = Math.abs(tmpArray[i] - m);
            ++i;
        }
        result = MathFun.median(tmpArray, false);
        return result;
    }

    public static double mad(double[] array, int minIndex, int maxIndex, boolean nd) {
        int i;
        double result = 0.0;
        double m = 0.0;
        double[] tmpArray = null;
        int arrayLength = 0;
        arrayLength = maxIndex - minIndex;
        if (nd) {
            tmpArray = new double[arrayLength];
            i = 0;
            while (i < arrayLength) {
                tmpArray[i] = array[i + minIndex];
                ++i;
            }
            minIndex = 0;
            maxIndex = arrayLength;
        } else {
            tmpArray = array;
        }
        m = MathFun.median(tmpArray, minIndex, maxIndex, false);
        i = minIndex;
        while (i < maxIndex) {
            tmpArray[i] = Math.abs(tmpArray[i] - m);
            ++i;
        }
        result = MathFun.median(tmpArray, minIndex, maxIndex, false);
        return result;
    }

    public static float mad(float[] array, boolean nd) {
        int i;
        float result = 0.0f;
        float m = 0.0f;
        float[] tmpArray = null;
        int arrayLength = 0;
        arrayLength = array.length;
        if (nd) {
            tmpArray = new float[arrayLength];
            i = 0;
            while (i < arrayLength) {
                tmpArray[i] = array[i];
                ++i;
            }
        } else {
            tmpArray = array;
        }
        m = MathFun.median(tmpArray, false);
        i = 0;
        while (i < arrayLength) {
            tmpArray[i] = Math.abs(tmpArray[i] - m);
            ++i;
        }
        result = MathFun.median(tmpArray, false);
        return result;
    }

    public static float mad(float[] array, int minIndex, int maxIndex, boolean nd) {
        int i;
        float result = 0.0f;
        float m = 0.0f;
        float[] tmpArray = null;
        int arrayLength = 0;
        arrayLength = maxIndex - minIndex;
        if (nd) {
            tmpArray = new float[arrayLength];
            i = 0;
            while (i < arrayLength) {
                tmpArray[i] = array[i + minIndex];
                ++i;
            }
            minIndex = 0;
            maxIndex = arrayLength;
        } else {
            tmpArray = array;
        }
        m = MathFun.median(tmpArray, minIndex, maxIndex, false);
        i = minIndex;
        while (i < maxIndex) {
            tmpArray[i] = Math.abs(tmpArray[i] - m);
            ++i;
        }
        result = MathFun.median(tmpArray, minIndex, maxIndex, false);
        return result;
    }

    public static float SD(float[] array) {
        return (float)Math.sqrt(MathFun.var(array, false));
    }

    public static float SD(float[] array, boolean n) {
        return MathFun.var(array, n);
    }

    public static float SD(float[] array, boolean n, int minIndex, int maxIndex) {
        return MathFun.var(array, n, minIndex, maxIndex);
    }

    public static double SD(double[] array) {
        return Math.sqrt(MathFun.var(array, false));
    }

    public static double SD(double[] array, boolean n) {
        return MathFun.var(array, n);
    }

    public static double SD(double[] array, boolean n, int minIndex, int maxIndex) {
        return MathFun.var(array, n, minIndex, maxIndex);
    }

    public static double robustSD(double[] array, boolean nd) {
        return MathFun.mad(array, nd) / 0.6745;
    }

    public static double robustSD(double[] array, int minIndex, int maxIndex, boolean nd) {
        return MathFun.mad(array, minIndex, maxIndex, nd) / 0.6745;
    }

    public static float robustSD(float[] array, boolean nd) {
        return (float)((double)MathFun.mad(array, nd) / 0.6745);
    }

    public static float robustSD(float[] array, int minIndex, int maxIndex, boolean nd) {
        return (float)((double)MathFun.mad(array, minIndex, maxIndex, nd) / 0.6745);
    }

    public static float cov(float[] array1, float[] array2) {
        return MathFun.cov(array1, array2, false);
    }

    public static float cov(float[] array1, float[] array2, boolean n) {
        float result = 0.0f;
        float m1 = 0.0f;
        float m2 = 0.0f;
        m1 = MathFun.mean(array1);
        m2 = MathFun.mean(array2);
        int i = 0;
        while (i < array1.length) {
            result += (array1[i] - m1) * (array2[i] - m2);
            ++i;
        }
        result = n ? (result /= (float)array1.length) : (result /= (float)(array1.length - 1));
        return result;
    }

    public static double cov(double[] array1, double[] array2) {
        return MathFun.cov(array1, array2, false);
    }

    public static double cov(double[] array1, double[] array2, boolean n) {
        double result = 0.0;
        double m1 = 0.0;
        double m2 = 0.0;
        m1 = MathFun.mean(array1);
        m2 = MathFun.mean(array2);
        int i = 0;
        while (i < array1.length) {
            result += (array1[i] - m1) * (array2[i] - m2);
            ++i;
        }
        result = n ? (result /= (double)array1.length) : (result /= (double)(array1.length - 1));
        return result;
    }

    public static float corr(float[] array1, float[] array2) {
        float result = Float.NaN;
        float sd1 = 0.0f;
        float sd2 = 0.0f;
        sd1 = MathFun.SD(array1);
        if (sd1 != 0.0f && (sd2 = MathFun.SD(array2)) != 0.0f) {
            result = MathFun.cov(array1, array2) / (sd1 * sd2);
        }
        return result;
    }

    public static double corr(double[] array1, double[] array2) {
        double result = Double.NaN;
        double sd1 = 0.0;
        double sd2 = 0.0;
        sd1 = MathFun.SD(array1);
        if (sd1 != 0.0 && (sd2 = MathFun.SD(array2)) != 0.0) {
            result = MathFun.cov(array1, array2) / (sd1 * sd2);
        }
        return result;
    }

    public static double[] binomial(double a, double b, double n) {
        double[] result = null;
        result = new double[(int)n + 1];
        result[0] = Math.pow(a, n);
        int i = 1;
        while (i < (int)n) {
            result[i] = MathFun.prod(n - (double)i + 1.0, n) / MathFun.prod(1.0, i) * Math.pow(a, n - (double)i) * Math.pow(b, i);
            ++i;
        }
        result[result.length - 1] = Math.pow(b, n);
        return result;
    }

    public static double factorial(int n) {
        double result = 1.0;
        if (n < 0) {
            result = -1.0;
        } else {
            int i = 2;
            while (i <= n) {
                result *= (double)i;
                ++i;
            }
        }
        return result;
    }

    public static double logFactorial(int n) {
        double result = 0.0;
        if (n < 0) {
            result = -1.0;
        } else {
            int i = 1;
            while (i <= n) {
                result += Math.log(i);
                ++i;
            }
        }
        return result;
    }

    public static double binomialCoefficient(int n, int k) {
        double result = 1.0;
        if (k < 0 || k > n) {
            result = 0.0;
        } else if (k == n || k == 0) {
            result = 1.0;
        } else {
            if (k > n / 2) {
                k = n - k;
            }
            int i = n - k + 1;
            while (i <= n) {
                result *= (double)i / ((double)n - (double)i + 1.0);
                ++i;
            }
        }
        return Math.round(result);
    }

    public static double[] conv(double[] in1, double[] in2) {
        double[] out = null;
        int signalSize = -1;
        int filterSize = -1;
        int outSize = -1;
        int r = -1;
        signalSize = in1.length;
        filterSize = in2.length;
        outSize = signalSize + filterSize - 1;
        out = new double[outSize];
        int i = 0;
        while (i < outSize) {
            int j = 0;
            while (j < filterSize) {
                r = i - j;
                if (r >= 0 && r < signalSize) {
                    int n = i;
                    out[n] = out[n] + in1[r] * in2[j];
                }
                ++j;
            }
            ++i;
        }
        return out;
    }

    public static double[] tconv(double[] Distrib1, double[] Distrib2) {
        int y;
        int x;
        double[] Distrib = null;
        double[][] Table = null;
        Distrib = new double[Distrib1.length + Distrib2.length - 1];
        Table = new double[Distrib1.length][Distrib2.length];
        int i = 0;
        while (i < Distrib1.length) {
            int j = 0;
            while (j < Distrib2.length) {
                Table[i][j] = Distrib1[i] * Distrib2[j];
                ++j;
            }
            ++i;
        }
        int startx = 0;
        int starty = 0;
        i = 0;
        while (starty < Distrib1.length) {
            x = startx;
            y = starty;
            while (y >= 0 && x < Distrib2.length) {
                int n = i;
                Distrib[n] = Distrib[n] + Table[y--][x++];
            }
            ++starty;
            ++i;
        }
        --starty;
        ++startx;
        while (startx < Distrib2.length) {
            x = startx;
            y = starty;
            while (y >= 0 && x < Distrib2.length) {
                int n = i;
                Distrib[n] = Distrib[n] + Table[y--][x++];
            }
            ++startx;
            ++i;
        }
        return Distrib;
    }

    public static double entropy(double[] p) {
        double result = 0.0;
        int i = 0;
        while (i < p.length) {
            result += p[i] * MathFun.log2(p[i]);
            ++i;
        }
        return result *= -1.0;
    }

    public static double kullbackLeiber(double[] p, double[] q) {
        double result = 0.0;
        int i = 0;
        while (i < p.length) {
            result += p[i] * MathFun.log2(p[i] / q[i]);
            ++i;
        }
        return result;
    }

    public static float[] regress(float[] array1, float[] array2) {
        float[] coeffs = new float[2];
        float m1 = 0.0f;
        float m2 = 0.0f;
        m1 = MathFun.mean(array1);
        m2 = MathFun.mean(array2);
        coeffs[0] = MathFun.cov(array1, array2, false) / MathFun.var(array1, false);
        coeffs[1] = m2 - coeffs[0] * m1;
        return coeffs;
    }

    public static double[] regress(double[] array1, double[] array2) {
        double[] coeffs = new double[2];
        double m1 = 0.0;
        double m2 = 0.0;
        m1 = MathFun.mean(array1);
        m2 = MathFun.mean(array2);
        coeffs[0] = MathFun.cov(array1, array2, false) / MathFun.var(array1, false);
        coeffs[1] = m2 - coeffs[0] * m1;
        return coeffs;
    }

    public static float[] regress(Point2D.Float[] array) {
        float[] coeffs = null;
        float[] array1 = null;
        float[] array2 = null;
        float m1 = 0.0f;
        float m2 = 0.0f;
        coeffs = new float[2];
        array1 = new float[array.length];
        array2 = new float[array.length];
        int i = 0;
        while (i < array.length) {
            array1[i] = array[i].x;
            array2[i] = array[i].y;
            ++i;
        }
        m1 = MathFun.mean(array1);
        m2 = MathFun.mean(array2);
        coeffs[0] = MathFun.cov(array1, array2, false) / MathFun.var(array1, false);
        coeffs[1] = m2 - coeffs[0] * m1;
        return coeffs;
    }

    public static double linearInterpolation(double node1, double node2, double value1, double value2, double point) {
        double pointValue = Double.NaN;
        if (point >= node1 && point <= node2) {
            pointValue = node1 == node2 || value1 == value2 ? value1 : (node2 > node1 ? ((node2 - point) * value1 + (point - node1) * value2) / (node2 - node1) : ((node1 - point) * value2 + (point - node2) * value1) / (node1 - node2));
        }
        return pointValue;
    }

    public static float[][] nearestInterpolation(float[][] data, float xScale, float yScale) {
        float[][] iData = null;
        int xDataSize = -1;
        int yDataSize = -1;
        int xSize = -1;
        int ySize = -1;
        int xNode = -1;
        int yNode = -1;
        xDataSize = data[0].length;
        xSize = Math.round(xScale * (float)xDataSize);
        yDataSize = data.length;
        ySize = Math.round(yScale * (float)yDataSize);
        iData = new float[ySize][xSize];
        int y = 0;
        while (y < ySize) {
            yNode = Math.round((float)y / yScale);
            if (yNode >= yDataSize) {
                yNode = yDataSize - 1;
            }
            int x = 0;
            while (x < xSize) {
                xNode = Math.round((float)x / xScale);
                if (xNode >= xDataSize) {
                    xNode = xDataSize - 1;
                }
                iData[y][x] = data[yNode][xNode];
                ++x;
            }
            ++y;
        }
        return iData;
    }

    public static float[][] bilinearInterpolation(float[][] data, float xScale, float yScale) {
        float[][] iData = null;
        int xDataSize = -1;
        int yDataSize = -1;
        int xSize = -1;
        int ySize = -1;
        float xNode = -1.0f;
        float yNode = -1.0f;
        float xDiff = -1.0f;
        float yDiff = -1.0f;
        int xHigh = -1;
        int xLow = -1;
        int yHigh = -1;
        int yLow = -1;
        xDataSize = data[0].length;
        xSize = Math.round(xScale * (float)xDataSize);
        yDataSize = data.length;
        ySize = Math.round(yScale * (float)yDataSize);
        iData = new float[ySize][xSize];
        int y = 0;
        while (y < ySize) {
            yNode = (float)y / yScale;
            yLow = (int)Math.floor(yNode);
            yHigh = yLow + 1;
            if (yHigh >= yDataSize) {
                yHigh = yDataSize - 1;
            }
            yDiff = yNode - (float)yLow;
            int x = 0;
            while (x < xSize) {
                xNode = (float)x / xScale;
                xLow = (int)Math.floor(xNode);
                xHigh = xLow + 1;
                if (xHigh >= xDataSize) {
                    xHigh = xDataSize - 1;
                }
                xDiff = xNode - (float)xLow;
                iData[y][x] = data[yLow][xLow] * (1.0f - yDiff) * (1.0f - xDiff) + data[yLow][xHigh] * (1.0f - yDiff) * xDiff + data[yHigh][xLow] * yDiff * (1.0f - xDiff) + data[yHigh][xHigh] * yDiff * xDiff;
                ++x;
            }
            ++y;
        }
        return iData;
    }

    public static float soerensen(int count1, int count2, int common) {
        return 2.0f * (float)common / (float)(count1 + count2);
    }

    public static boolean solveLinearSimultaneousEquations(double[] A, double[] Y, double[] X) {
        int k;
        int n = Y.length;
        int i = 0;
        while (i < n) {
            int j = i + 1;
            while (j < n) {
                if (A[j * n + i] != 0.0) {
                    double fact = A[i * n + i] / A[j * n + i];
                    k = i + 1;
                    while (k < n) {
                        A[j * n + k] = A[j * n + k] * fact - A[i * n + k];
                        ++k;
                    }
                    Y[j] = Y[j] * fact - Y[i];
                }
                ++j;
            }
            ++i;
        }
        i = n - 1;
        while (i >= 0) {
            if (A[i * n + i] == 0.0) {
                return false;
            }
            double sum = Y[i];
            k = i + 1;
            while (k < n) {
                sum -= A[i * n + k] * X[k];
                ++k;
            }
            X[i] = sum / A[i * n + i];
            --i;
        }
        return true;
    }
}

